/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.internal;

import com.google.common.base.Supplier;
import com.netflix.governator.LifecycleAction;
import com.netflix.governator.LifecycleFeature;
import com.netflix.governator.internal.JSR250LifecycleAction;
import com.netflix.governator.internal.TypeInspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PreDestroyLifecycleFeature
implements LifecycleFeature {
    private static final Logger LOG = LoggerFactory.getLogger(PreDestroyLifecycleFeature.class);
    private final JSR250LifecycleAction.ValidationMode validationMode;

    public PreDestroyLifecycleFeature(JSR250LifecycleAction.ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    @Override
    public List<LifecycleAction> getActionsForType(Class<?> type) {
        return (List)TypeInspector.accept(type, new PreDestroyVisitor());
    }

    public String toString() {
        return "PreDestroy";
    }

    private static final class AutoCloseableLifecycleAction
    implements LifecycleAction {
        private final String description;

        private AutoCloseableLifecycleAction(Class<? extends AutoCloseable> clazz) {
            this.description = "AutoCloseable@" + System.identityHashCode(this) + "[" + clazz.getName() + "." + "close()" + "]";
        }

        @Override
        public void call(Object obj) throws Exception {
            LOG.info("calling action {}", (Object)this.description);
            ((AutoCloseable)AutoCloseable.class.cast(obj)).close();
        }

        public String toString() {
            return this.description;
        }
    }

    private class PreDestroyVisitor
    implements TypeInspector.TypeVisitor,
    Supplier<List<LifecycleAction>> {
        private Set<String> visitContext = new HashSet<String>();
        private List<LifecycleAction> typeActions = new ArrayList<LifecycleAction>();

        private PreDestroyVisitor() {
        }

        @Override
        public boolean visit(Class<?> clazz) {
            boolean continueVisit;
            boolean bl = continueVisit = !clazz.isInterface();
            if (continueVisit && AutoCloseable.class.isAssignableFrom(clazz)) {
                AutoCloseableLifecycleAction closeableAction = new AutoCloseableLifecycleAction(clazz.asSubclass(AutoCloseable.class));
                LOG.debug("adding action {}", (Object)closeableAction);
                this.typeActions.add(closeableAction);
                continueVisit = false;
            }
            return continueVisit;
        }

        @Override
        public boolean visit(Method method) {
            String methodName = method.getName();
            if (method.isAnnotationPresent(PreDestroy.class)) {
                if (!this.visitContext.contains(methodName)) {
                    try {
                        JSR250LifecycleAction destroyAction = new JSR250LifecycleAction(PreDestroy.class, method, PreDestroyLifecycleFeature.this.validationMode);
                        LOG.debug("adding action {}", (Object)destroyAction);
                        this.typeActions.add(destroyAction);
                        this.visitContext.add(methodName);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.info("ignoring @PreDestroy method {}.{}() - {}", new Object[]{method.getDeclaringClass().getName(), methodName, e.getMessage()});
                    }
                }
            } else if (method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 0 && !Modifier.isFinal(method.getModifiers())) {
                this.visitContext.add(methodName);
            }
            return true;
        }

        @Override
        public boolean visit(Field field) {
            return true;
        }

        public List<LifecycleAction> get() {
            return Collections.unmodifiableList(this.typeActions);
        }
    }
}

