/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.services.kms.model.MacAlgorithmSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateMacResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, GenerateMacResponse> {
    private static final SdkField<SdkBytes> MAC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Mac").getter(GenerateMacResponse.getter(GenerateMacResponse::mac)).setter(GenerateMacResponse.setter(Builder::mac)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mac").build()}).build();
    private static final SdkField<String> MAC_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAlgorithm").getter(GenerateMacResponse.getter(GenerateMacResponse::macAlgorithmAsString)).setter(GenerateMacResponse.setter(Builder::macAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAlgorithm").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(GenerateMacResponse.getter(GenerateMacResponse::keyId)).setter(GenerateMacResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAC_FIELD, MAC_ALGORITHM_FIELD, KEY_ID_FIELD));
    private final SdkBytes mac;
    private final String macAlgorithm;
    private final String keyId;

    private GenerateMacResponse(BuilderImpl builder) {
        super(builder);
        this.mac = builder.mac;
        this.macAlgorithm = builder.macAlgorithm;
        this.keyId = builder.keyId;
    }

    public final SdkBytes mac() {
        return this.mac;
    }

    public final MacAlgorithmSpec macAlgorithm() {
        return MacAlgorithmSpec.fromValue(this.macAlgorithm);
    }

    public final String macAlgorithmAsString() {
        return this.macAlgorithm;
    }

    public final String keyId() {
        return this.keyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mac());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMacResponse)) {
            return false;
        }
        GenerateMacResponse other = (GenerateMacResponse)((Object)obj);
        return Objects.equals(this.mac(), other.mac()) && Objects.equals(this.macAlgorithmAsString(), other.macAlgorithmAsString()) && Objects.equals(this.keyId(), other.keyId());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateMacResponse").add("Mac", (Object)this.mac()).add("MacAlgorithm", (Object)this.macAlgorithmAsString()).add("KeyId", (Object)this.keyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mac": {
                return Optional.ofNullable(clazz.cast(this.mac()));
            }
            case "MacAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.macAlgorithmAsString()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateMacResponse, T> g) {
        return obj -> g.apply((GenerateMacResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private SdkBytes mac;
        private String macAlgorithm;
        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMacResponse model) {
            super(model);
            this.mac(model.mac);
            this.macAlgorithm(model.macAlgorithm);
            this.keyId(model.keyId);
        }

        public final ByteBuffer getMac() {
            return this.mac == null ? null : this.mac.asByteBuffer();
        }

        public final void setMac(ByteBuffer mac) {
            this.mac(mac == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)mac));
        }

        @Override
        public final Builder mac(SdkBytes mac) {
            this.mac = mac;
            return this;
        }

        public final String getMacAlgorithm() {
            return this.macAlgorithm;
        }

        public final void setMacAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
        }

        @Override
        public final Builder macAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
            return this;
        }

        @Override
        public final Builder macAlgorithm(MacAlgorithmSpec macAlgorithm) {
            this.macAlgorithm(macAlgorithm == null ? null : macAlgorithm.toString());
            return this;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        @Override
        public GenerateMacResponse build() {
            return new GenerateMacResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateMacResponse> {
        public Builder mac(SdkBytes var1);

        public Builder macAlgorithm(String var1);

        public Builder macAlgorithm(MacAlgorithmSpec var1);

        public Builder keyId(String var1);
    }
}

