/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.tools.recovery.AutoCloseableIterator;
import io.confluent.kafka.tools.recovery.CheckpointRecord;
import io.confluent.kafka.tools.recovery.CommandException;
import io.confluent.kafka.tools.recovery.FreezableAppender;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentChoice;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotFooterRecordJsonConverter;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecordJsonConverter;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchMemoryPool;
import org.apache.kafka.raft.internals.RecordsIterator;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;

final class CheckpointConvertCommand {
    private static final String FROM_JSON_OPTION = "--from-json";
    private static final String FROM_CHECKPOINT_OPTION = "--from-checkpoint";
    private static final String TO_JSON_OPTION = "--to-json";
    private static final String TO_CHECKPOINT_OPTION = "--to-checkpoint";
    private static final String END_OFFSET_OPTION = "--end-offset";
    private static final String EPOCH_OPTION = "--epoch";
    private static final String OUT_DIRECTORY_OPTION = "--out-directory";
    static final String COMMAND = "checkpoint";
    private static final String CHECKPOINT_COMMAND_POSITIONAL = "checkpoint-command";
    private static final String CONVERT_COMMAND = "convert";

    CheckpointConvertCommand() {
    }

    static void addCommand(Subparsers subparsers) {
        Subparser convert = subparsers.addParser(COMMAND).help("commands specific to checkpoints").addSubparsers().dest(CHECKPOINT_COMMAND_POSITIONAL).addParser(CONVERT_COMMAND).help("convert metadata to and from different formats");
        MutuallyExclusiveGroup fromOptions = convert.addMutuallyExclusiveGroup("from arguments").required(true);
        fromOptions.addArgument(new String[]{FROM_JSON_OPTION}).dest(FROM_JSON_OPTION).metavar(new String[]{"<from-json>"}).help("path to the JSON checkpoint file").type((ArgumentType)Arguments.fileType().acceptSystemIn().verifyCanRead());
        fromOptions.addArgument(new String[]{FROM_CHECKPOINT_OPTION}).dest(FROM_CHECKPOINT_OPTION).metavar(new String[]{"<from-checkpoint>"}).help("path to the checkpoint file").type((ArgumentType)Arguments.fileType().verifyCanRead());
        MutuallyExclusiveGroup toOptions = convert.addMutuallyExclusiveGroup("to arguments").required(true);
        toOptions.addArgument(new String[]{TO_JSON_OPTION}).dest(TO_JSON_OPTION).help("convert the metadata checkpoint to JSON and print to standard out").action((ArgumentAction)Arguments.storeTrue());
        toOptions.addArgument(new String[]{TO_CHECKPOINT_OPTION}).dest(TO_CHECKPOINT_OPTION).help(String.format("convert to the Kafka checkpoint file named <end-offset>-<epoch>.checkpoint. If this option is used, the following options must be specifed: %s, %s", END_OFFSET_OPTION, EPOCH_OPTION)).action((ArgumentAction)Arguments.storeTrue());
        ArgumentGroup toCheckpointOptions = convert.addArgumentGroup("--to-checkpoint arguments");
        toCheckpointOptions.addArgument(new String[]{END_OFFSET_OPTION}).dest(END_OFFSET_OPTION).help("the end offset for the checkpoint id").choices((ArgumentChoice)Arguments.range((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(Long.MAX_VALUE))).type(Long.class);
        toCheckpointOptions.addArgument(new String[]{EPOCH_OPTION}).dest(EPOCH_OPTION).help("the epoch for the checkpoint id").choices((ArgumentChoice)Arguments.range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE))).type(Integer.class);
        toCheckpointOptions.addArgument(new String[]{OUT_DIRECTORY_OPTION}).dest(OUT_DIRECTORY_OPTION).metavar(new String[]{"<out-directory>"}).help("the path the directory where the checkpoint file will be written").type((ArgumentType)Arguments.fileType().verifyIsDirectory().verifyCanWrite());
    }

    static int execute(Namespace namespace) {
        if (namespace.getString(CHECKPOINT_COMMAND_POSITIONAL).equals(CONVERT_COMMAND)) {
            return CheckpointConvertCommand.convert(namespace);
        }
        throw new IllegalArgumentException(String.format("unknown command: %s", namespace));
    }

    static int convert(Namespace namespace) {
        try (AutoCloseableIterator<Batch<ApiMessageAndVersion>> source = CheckpointConvertCommand.metadataIterator(namespace);){
            long lastContainedLogTimestamp = Time.SYSTEM.milliseconds();
            try (FreezableAppender<ApiMessageAndVersion> sink = CheckpointConvertCommand.metadataAppender(namespace, lastContainedLogTimestamp);){
                while (source.hasNext()) {
                    Batch batch = (Batch)source.next();
                    if (batch.records().isEmpty()) continue;
                    sink.append(batch.records());
                }
                sink.freeze();
            }
        }
        return 0;
    }

    private static AutoCloseableIterator<Batch<ApiMessageAndVersion>> metadataIterator(Namespace namespace) {
        if (namespace.getString(FROM_CHECKPOINT_OPTION) != null) {
            Path path = Paths.get(namespace.getString(FROM_CHECKPOINT_OPTION), new String[0]);
            return CheckpointConvertCommand.checkpointIterator(path);
        }
        if (namespace.getString(FROM_JSON_OPTION) != null) {
            Optional<Path> path = Optional.empty();
            Optional<InputStream> stream = Optional.empty();
            if (namespace.getString(FROM_JSON_OPTION).equals("-")) {
                stream = Optional.of(System.in);
            } else {
                path = Optional.of(Paths.get(namespace.getString(FROM_JSON_OPTION), new String[0]));
            }
            return CheckpointConvertCommand.jsonIterator(path, stream);
        }
        throw new IllegalArgumentException("one 'from' option must be specified");
    }

    private static AutoCloseableIterator<Batch<ApiMessageAndVersion>> checkpointIterator(Path path) {
        FileRecords fileRecords;
        try {
            fileRecords = FileRecords.open((File)path.toFile(), (boolean)false, (boolean)true, (int)0, (boolean)false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("unable to open checkpoint file (%s)", path), e);
        }
        final RecordsIterator recordsIterator = new RecordsIterator((Records)fileRecords, (RecordSerde)MetadataRecordSerde.INSTANCE, BufferSupplier.create(), 0x800000, true);
        return new AutoCloseableIterator<Batch<ApiMessageAndVersion>>(){

            @Override
            public boolean hasNext() {
                return recordsIterator.hasNext();
            }

            @Override
            public Batch<ApiMessageAndVersion> next() {
                return recordsIterator.next();
            }

            @Override
            public void close() {
                Utils.closeQuietly((AutoCloseable)recordsIterator, (String)"records iterator");
                Utils.closeQuietly((AutoCloseable)fileRecords, (String)"file records");
            }
        };
    }

    private static AutoCloseableIterator<Batch<ApiMessageAndVersion>> jsonIterator(Optional<Path> path, Optional<InputStream> stream) {
        JsonParser parser;
        final ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getFactory();
        try {
            if (path.isPresent()) {
                parser = factory.createParser(path.get().toFile());
            } else if (stream.isPresent()) {
                parser = factory.createParser(stream.get());
            } else {
                throw new IllegalStateException("path or stream should have been set");
            }
            if (!JsonToken.START_ARRAY.equals((Object)parser.nextToken())) {
                throw new IllegalStateException(String.format("expected %s but got %s at %s", JsonToken.START_ARRAY, parser.currentToken(), parser.currentLocation()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("error in json parser", e);
        }
        return new AutoCloseableIterator<Batch<ApiMessageAndVersion>>(){
            private Optional<Batch<ApiMessageAndVersion>> nextValue = Optional.empty();

            private Optional<Batch<ApiMessageAndVersion>> nextValue() {
                try {
                    if (JsonToken.END_ARRAY.equals((Object)parser.currentToken())) {
                        return Optional.empty();
                    }
                    JsonToken token = parser.nextToken();
                    if (JsonToken.START_OBJECT.equals((Object)token)) {
                        CheckpointRecord record = (CheckpointRecord)mapper.readValue(parser, CheckpointRecord.class);
                        if (record.isControl()) {
                            return this.nextValue();
                        }
                        return Optional.of(CheckpointConvertCommand.createDataBatch(record));
                    }
                    if (JsonToken.END_ARRAY.equals((Object)token)) {
                        return Optional.empty();
                    }
                    throw new IllegalStateException(String.format("found unknown token %s at %s", parser.currentToken(), parser.currentLocation()));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(String.format("error in json parser at %s", parser.currentLocation()), e);
                }
            }

            @Override
            public boolean hasNext() {
                if (!this.nextValue.isPresent()) {
                    this.nextValue = this.nextValue();
                }
                return this.nextValue.isPresent();
            }

            @Override
            public Batch<ApiMessageAndVersion> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("json iterator doesn't have any more elements");
                }
                Batch<ApiMessageAndVersion> value = this.nextValue.get();
                this.nextValue = Optional.empty();
                return value;
            }

            @Override
            public void close() {
                Utils.closeQuietly((AutoCloseable)parser, (String)"json parser");
            }
        };
    }

    private static Batch<ApiMessageAndVersion> createDataBatch(CheckpointRecord record) {
        List<ApiMessageAndVersion> data = Collections.singletonList(new ApiMessageAndVersion(MetadataJsonConverters.readJson((JsonNode)record.message(), (short)record.apiKey(), (short)record.version()), record.version()));
        return Batch.data((long)0L, (int)0, (long)0L, (int)0, data);
    }

    private static FreezableAppender<ApiMessageAndVersion> metadataAppender(Namespace namespace, long lastContainedLogTimestamp) {
        if (namespace.getBoolean(TO_CHECKPOINT_OPTION).booleanValue()) {
            Long offset = namespace.getLong(END_OFFSET_OPTION);
            if (offset == null) {
                throw new CommandException(String.format("the option %s must be specified", END_OFFSET_OPTION), 1);
            }
            Integer epoch = namespace.getInt(EPOCH_OPTION);
            if (epoch == null) {
                throw new CommandException(String.format("the option %s must be specified", EPOCH_OPTION), 1);
            }
            Path outDirectory = Optional.ofNullable(namespace.getString(OUT_DIRECTORY_OPTION)).map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(() -> Paths.get("", new String[0]).toAbsolutePath());
            return CheckpointConvertCommand.checkpointAppender(offset, epoch, lastContainedLogTimestamp, outDirectory);
        }
        if (namespace.getBoolean(TO_JSON_OPTION).booleanValue()) {
            return CheckpointConvertCommand.jsonAppender(System.out, lastContainedLogTimestamp);
        }
        throw new IllegalArgumentException("one 'to' option must be specified");
    }

    private static FreezableAppender<ApiMessageAndVersion> checkpointAppender(long offset, int epoch, long lastContainedLogTimestamp, Path outDirectory) {
        RecordsSnapshotWriter snapshotWriter = RecordsSnapshotWriter.createWithHeader((RawSnapshotWriter)FileRawSnapshotWriter.create((Path)outDirectory, (OffsetAndEpoch)new OffsetAndEpoch(offset, epoch), Optional.empty()), (int)0x800000, (MemoryPool)new BatchMemoryPool(5, 0x800000), (Time)Time.SYSTEM, (long)lastContainedLogTimestamp, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE);
        return new FreezableAppender<ApiMessageAndVersion>((SnapshotWriter)snapshotWriter){
            final /* synthetic */ SnapshotWriter val$snapshotWriter;
            {
                this.val$snapshotWriter = snapshotWriter;
            }

            @Override
            public void append(List<ApiMessageAndVersion> records) {
                this.val$snapshotWriter.append(records);
            }

            @Override
            public void freeze() {
                this.val$snapshotWriter.freeze();
            }

            @Override
            public void close() {
                Utils.closeQuietly((AutoCloseable)this.val$snapshotWriter, (String)"snapshot writer");
            }
        };
    }

    private static FreezableAppender<ApiMessageAndVersion> jsonAppender(OutputStream out, long lastContainedLogTimestamp) {
        JsonGenerator generator;
        final ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getFactory();
        try {
            generator = factory.createGenerator(out);
            generator.writeStartArray();
            SnapshotHeaderRecord header = new SnapshotHeaderRecord().setVersion((short)0).setLastContainedLogTimestamp(lastContainedLogTimestamp);
            mapper.writeValue(generator, (Object)new CheckpointRecord(SnapshotHeaderRecordJsonConverter.write((SnapshotHeaderRecord)header, (short)header.version()), ControlRecordType.SNAPSHOT_HEADER.type(), header.version(), true));
        }
        catch (IOException e) {
            throw new UncheckedIOException("error in json generator", e);
        }
        return new FreezableAppender<ApiMessageAndVersion>(){

            @Override
            public void append(List<ApiMessageAndVersion> records) {
                try {
                    for (ApiMessageAndVersion record : records) {
                        mapper.writeValue(generator, (Object)new CheckpointRecord(MetadataJsonConverters.writeJson((ApiMessage)record.message(), (short)record.version()), record.message().apiKey(), record.version(), false));
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("error writing json node", e);
                }
            }

            @Override
            public void freeze() {
                try {
                    SnapshotFooterRecord footer = new SnapshotFooterRecord().setVersion((short)0);
                    mapper.writeValue(generator, (Object)new CheckpointRecord(SnapshotFooterRecordJsonConverter.write((SnapshotFooterRecord)footer, (short)footer.version()), ControlRecordType.SNAPSHOT_FOOTER.type(), footer.version(), true));
                    generator.writeEndArray();
                }
                catch (IOException e) {
                    throw new UncheckedIOException("error in json generator", e);
                }
            }

            @Override
            public void close() {
                Utils.closeQuietly((AutoCloseable)generator, (String)"json generator");
            }
        };
    }
}

