/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.PermissionType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;

public class AclRule {
    private final KafkaPrincipal principal;
    private final PermissionType permissionType;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private final String host;
    private final Operation operation;
    private final Set<Uuid> clusterLinkIds;

    @JsonCreator
    public AclRule(@JsonProperty(value="principal") KafkaPrincipal principal, @JsonProperty(value="permissionType") PermissionType permissionType, @JsonProperty(value="host") String host, @JsonProperty(value="operation") Operation operation, @JsonProperty(value="clusterLinkIds") Collection<Uuid> clusterLinkIds) {
        this.principal = principal;
        this.permissionType = permissionType;
        this.operation = operation;
        this.host = host;
        this.clusterLinkIds = clusterLinkIds == null ? Collections.emptySet() : new HashSet<Uuid>(clusterLinkIds);
    }

    public AclRule(KafkaPrincipal principal, PermissionType permissionType, String host, Operation operation) {
        this(principal, permissionType, host, operation, Collections.emptySet());
    }

    @JsonProperty
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @JsonProperty
    public PermissionType permissionType() {
        return this.permissionType;
    }

    @JsonProperty
    public String host() {
        return this.host;
    }

    @JsonProperty
    public Operation operation() {
        return this.operation;
    }

    @JsonProperty
    public Collection<Uuid> clusterLinkIds() {
        return this.clusterLinkIds;
    }

    public AccessControlEntry toAccessControlEntry() {
        return new AccessControlEntry(this.principal.toString(), this.host, SecurityUtils.operation((String)this.operation.name()), AclPermissionType.fromString((String)this.permissionType.name()), this.clusterLinkIds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AclRule)) {
            return false;
        }
        AclRule that = (AclRule)o;
        return Objects.equals(this.principal, that.principal) && Objects.equals((Object)this.permissionType, (Object)that.permissionType) && Objects.equals(this.host, that.host) && Objects.equals(this.operation, that.operation) && Objects.equals(this.clusterLinkIds, that.clusterLinkIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.principal, this.permissionType, this.host, this.operation, this.clusterLinkIds});
    }

    public String toString() {
        return String.format("%s has %s permission for operation %s from host %s%s", new Object[]{this.principal, this.permissionType, this.operation, this.host, SecurityUtils.clusterLinkDescription(this.clusterLinkIds)});
    }

    public static AclRule from(AclBinding aclBinding) {
        AccessControlEntry entry = aclBinding.entry();
        return new AclRule(SecurityUtils.parseKafkaPrincipal((String)entry.principal()), PermissionType.valueOf(entry.permissionType().name()), entry.host(), new Operation(SecurityUtils.toPascalCase((String)entry.operation().name())), entry.clusterLinkIds());
    }

    public static AclRule from(AccessRule rule) {
        return new AclRule(rule.principal(), rule.permissionType(), rule.host(), rule.operation(), rule.clusterLinkIds());
    }

    public static AclRule from(AccessControlEntryFilter filter) {
        return new AclRule(SecurityUtils.parseKafkaPrincipal((String)filter.principal()), PermissionType.valueOf(filter.permissionType().name()), filter.host(), new Operation(SecurityUtils.toPascalCase((String)filter.operation().name())), filter.clusterLinkIds());
    }

    public static AccessControlEntry accessControlEntry(AccessRule rule) {
        return AclRule.accessControlEntry(rule, rule.clusterLinkIds());
    }

    public static AccessControlEntry accessControlEntry(AccessRule rule, Collection<Uuid> clusterLinkIds) {
        return new AccessControlEntry(rule.principal().toString(), rule.host(), SecurityUtils.operation((String)rule.operation().name()), AclPermissionType.fromString((String)rule.permissionType().name()), clusterLinkIds);
    }
}

