/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth;

import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;

public class JwtPrincipal
implements Principal {
    private final OAuthBearerToken idToken;

    public JwtPrincipal(OAuthBearerToken idToken) {
        this.idToken = idToken;
    }

    @Override
    public String getName() {
        return this.idToken.principalName();
    }

    public Set<String> getScope() {
        return Collections.unmodifiableSet(this.idToken.scope());
    }

    public String getJwt() {
        return this.idToken.value();
    }

    public Map<String, Object> jwtClaims() {
        if (this.idToken instanceof OAuthBearerJwsToken) {
            return ((OAuthBearerJwsToken)this.idToken).jwtClaims();
        }
        return Collections.emptyMap();
    }
}

