/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules.cel;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import io.confluent.kafka.schemaregistry.rules.FieldRuleExecutor;
import io.confluent.kafka.schemaregistry.rules.FieldTransform;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.cel.CelExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CelFieldExecutor
extends FieldRuleExecutor {
    public static final String TYPE = "CEL_FIELD";
    private static final ObjectMapper mapper = new ObjectMapper();
    private CelExecutor celExecutor = new CelExecutor();

    public String type() {
        return TYPE;
    }

    public FieldTransform newTransform(RuleContext ruleContext) {
        return (ctx, fieldCtx, fieldValue) -> {
            if (!fieldCtx.getType().isPrimitive()) {
                return fieldValue;
            }
            Object message = fieldCtx.getContainingMessage();
            final Object inputMessage = message instanceof JsonNode ? mapper.convertValue(message, (TypeReference)new TypeReference<Map<String, Object>>(){}) : message;
            Object result = this.celExecutor.execute(ctx, fieldValue, (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("value", fieldValue != null ? fieldValue : NullValue.NULL_VALUE);
                    this.put("fullName", fieldCtx.getFullName());
                    this.put("name", fieldCtx.getName());
                    this.put("typeName", fieldCtx.getType().name());
                    this.put("tags", new ArrayList(fieldCtx.getTags()));
                    this.put("message", inputMessage);
                }
            });
            if (result instanceof ByteString) {
                result = ((ByteString)result).toByteArray();
            } else if (result instanceof Number) {
                Number num = (Number)result;
                switch (fieldCtx.getType()) {
                    case INT: {
                        result = num.intValue();
                        break;
                    }
                    case LONG: {
                        result = num.longValue();
                        break;
                    }
                    case FLOAT: {
                        result = Float.valueOf(num.floatValue());
                        break;
                    }
                    case DOUBLE: {
                        result = num.doubleValue();
                        break;
                    }
                }
            }
            return result;
        };
    }
}

