/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.avro.random.generator;

import io.confluent.avro.random.generator.Generator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;

public class Main {
    public static final String PROGRAM_NAME = "arg";
    public static final String SCHEMA_SHORT_FLAG = "-s";
    public static final String SCHEMA_LONG_FLAG = "--schema";
    public static final String SCHEMA_FILE_SHORT_FLAG = "-f";
    public static final String SCHEMA_FILE_LONG_FLAG = "--schema-file";
    public static final String PRETTY_SHORT_FLAG = "-p";
    public static final String PRETTY_LONG_FLAG = "--pretty";
    public static final String COMPACT_SHORT_FLAG = "-c";
    public static final String COMPACT_LONG_FLAG = "--compact";
    public static final String JSON_SHORT_FLAG = "-j";
    public static final String JSON_LONG_FLAG = "--json";
    public static final String BINARY_SHORT_FLAG = "-b";
    public static final String BINARY_LONG_FLAG = "--binary";
    public static final String ITERATIONS_SHORT_FLAG = "-i";
    public static final String ITERATIONS_LONG_FLAG = "--iterations";
    public static final String OUTPUT_FILE_SHORT_FLAG = "-o";
    public static final String OUTPUT_FILE_LONG_FLAG = "--output";
    public static final String HELP_SHORT_FLAG_1 = "-?";
    public static final String HELP_SHORT_FLAG_2 = "-h";
    public static final String HELP_LONG_FLAG = "--help";
    private static final boolean PRETTY_FORMAT = true;
    private static final boolean COMPACT_FORMAT = false;
    private static final boolean JSON_ENCODING = true;
    private static final boolean BINARY_ENCODING = false;

    public static void main(String[] args) {
        String schema = null;
        String schemaFile = "-";
        boolean jsonFormat = true;
        boolean encoding = true;
        long iterations = 1L;
        String outputFile = null;
        Iterator<String> argv = Arrays.asList(args).iterator();
        block56: while (argv.hasNext()) {
            String flag;
            switch (flag = argv.next()) {
                case "-s": 
                case "--schema": {
                    schemaFile = null;
                    schema = Main.nextArg(argv, flag);
                    continue block56;
                }
                case "-f": 
                case "--schema-file": {
                    schema = null;
                    schemaFile = Main.nextArg(argv, flag);
                    continue block56;
                }
                case "-p": 
                case "--pretty": {
                    jsonFormat = true;
                    continue block56;
                }
                case "-c": 
                case "--compact": {
                    jsonFormat = false;
                    continue block56;
                }
                case "-j": 
                case "--json": {
                    encoding = true;
                    continue block56;
                }
                case "-b": 
                case "--binary": {
                    encoding = false;
                    continue block56;
                }
                case "-i": 
                case "--iterations": {
                    iterations = Main.parseIterations(Main.nextArg(argv, flag), flag);
                    continue block56;
                }
                case "-o": 
                case "--output": {
                    outputFile = Main.nextArg(argv, flag);
                    continue block56;
                }
                case "-?": 
                case "-h": 
                case "--help": {
                    Main.usage();
                    continue block56;
                }
            }
            System.err.printf("%s: %s: unrecognized option%n%n", PROGRAM_NAME, flag);
            Main.usage(1);
        }
        Generator generator = null;
        try {
            generator = Main.getGenerator(schema, schemaFile);
        }
        catch (IOException ioe) {
            System.err.println("Error occurred while trying to read schema file");
            System.exit(1);
        }
        GenericDatumWriter dataWriter = new GenericDatumWriter(generator.schema());
        if (encoding) {
            try (OutputStream output = Main.getOutput(outputFile);){
                JsonEncoder encoder = EncoderFactory.get().jsonEncoder(generator.schema(), output, jsonFormat);
                int i = 0;
                while ((long)i < iterations) {
                    dataWriter.write(generator.generate(), (Encoder)encoder);
                    ++i;
                }
                encoder.flush();
                output.write(10);
            }
            catch (IOException ioe) {
                System.err.println("Error occurred while trying to write to output file: " + ioe.getLocalizedMessage());
                System.exit(1);
            }
        } else {
            try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)dataWriter).create(generator.schema(), Main.getOutput(outputFile));){
                int i = 0;
                while ((long)i < iterations) {
                    dataFileWriter.append(generator.generate());
                    ++i;
                }
            }
            catch (IOException ioe) {
                System.err.println("Error occurred while trying to write to output file: " + ioe.getLocalizedMessage());
                System.exit(1);
            }
        }
    }

    private static long parseIterations(String arg, String flag) {
        try {
            long result = Long.parseLong(arg);
            if (result < 0L) {
                System.err.printf("%s: %s: argument cannot be negative%n", PROGRAM_NAME, flag);
                Main.usage(1);
            }
            return result;
        }
        catch (NumberFormatException nfe) {
            System.err.printf("%s: %s: argument must be a number%n", PROGRAM_NAME, flag);
            Main.usage(1);
            System.err.println("This statement was put in to make the compiler happy. If you are seeing it, something has gone very wrong.");
            System.exit(1);
            return 0L;
        }
    }

    private static String nextArg(Iterator<String> argv, String flag) {
        if (!argv.hasNext()) {
            System.err.printf("%s: %s: argument required%n", PROGRAM_NAME, flag);
            Main.usage(1);
        }
        return argv.next();
    }

    private static void usage() {
        Main.usage(0);
    }

    private static void usage(int exitValue) {
        String header = String.format("%s: Generate random Avro data%n", PROGRAM_NAME);
        String summary = String.format("Usage: %s [%s <file> | %s <schema>] [%s | %s] [%s | %s] [%s <i>] [%s <file>]%n%n", PROGRAM_NAME, SCHEMA_FILE_SHORT_FLAG, SCHEMA_SHORT_FLAG, JSON_SHORT_FLAG, BINARY_SHORT_FLAG, PRETTY_SHORT_FLAG, COMPACT_SHORT_FLAG, ITERATIONS_SHORT_FLAG, OUTPUT_FILE_SHORT_FLAG);
        String indentation = "    ";
        String separation = "\t";
        String flags = "Flags:\n" + String.format("%s%s, %s, %s:%s%s%n", "    ", HELP_SHORT_FLAG_1, HELP_SHORT_FLAG_2, HELP_LONG_FLAG, "\t", "Print a brief usage summary and exit with status 0") + String.format("%s%s, %s:%s%s%n", "    ", BINARY_SHORT_FLAG, BINARY_LONG_FLAG, "\t", "Encode outputted data in binary format") + String.format("%s%s, %s:%s%s%n", "    ", COMPACT_SHORT_FLAG, COMPACT_LONG_FLAG, "\t", "Output each record on a single line of its own (has no effect if encoding is not JSON)") + String.format("%s%s <file>, %s <file>:%s%s%n", "    ", SCHEMA_FILE_SHORT_FLAG, SCHEMA_FILE_LONG_FLAG, "\t", "Read the schema to spoof from <file>, or stdin if <file> is '-' (default is '-')") + String.format("%s%s <i>, %s <i>:%s%s%n", "    ", ITERATIONS_SHORT_FLAG, ITERATIONS_LONG_FLAG, "\t", "Output <i> iterations of spoofed data (default is 1)") + String.format("%s%s, %s:%s%s%n", "    ", JSON_SHORT_FLAG, JSON_LONG_FLAG, "\t", "Encode outputted data in JSON format (default)") + String.format("%s%s <file>, %s <file>:%s%s%n", "    ", OUTPUT_FILE_SHORT_FLAG, OUTPUT_FILE_LONG_FLAG, "\t", "Write data to the file <file>, or stdout if <file> is '-' (default is '-')") + String.format("%s%s, %s:%s%s%n", "    ", PRETTY_SHORT_FLAG, PRETTY_LONG_FLAG, "\t", "Output each record in prettified format (has no effect if encoding is not JSON)(default)") + String.format("%s%s <schema>, %s <schema>:%s%s%n", "    ", SCHEMA_SHORT_FLAG, SCHEMA_LONG_FLAG, "\t", "Spoof the schema <schema>") + "\n";
        String footer = String.format("%s%n%s%n", "Source repository:", "https://github.com/confluentinc/avro-random-generator");
        System.err.printf(header + summary + flags + footer, new Object[0]);
        System.exit(exitValue);
    }

    private static Generator getGenerator(String schema, String schemaFile) throws IOException {
        Random random = new Random();
        if (schema != null) {
            return new Generator(schema, random);
        }
        if (!schemaFile.equals("-")) {
            return new Generator(new File(schemaFile), random);
        }
        System.err.println("Reading schema from stdin...");
        return new Generator(System.in, random);
    }

    private static OutputStream getOutput(String outputFile) throws IOException {
        if (outputFile != null && !outputFile.equals("-")) {
            return new FileOutputStream(outputFile);
        }
        return System.out;
    }
}

