/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metastore.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Immutable
abstract class StructuredDataSource<K>
implements DataSource {
    private final SourceName dataSourceName;
    private final DataSource.DataSourceType dataSourceType;
    private final LogicalSchema schema;
    private final Optional<TimestampColumn> timestampColumn;
    private final KsqlTopic ksqlTopic;
    private final String sqlExpression;
    private final boolean casTarget;
    private final boolean isSource;
    private static final ImmutableList<Property<?>> PROPERTIES = ImmutableList.of(new Property<SourceName>("name", DataSource::getName), new Property<DataSource.DataSourceType>("type", DataSource::getDataSourceType), new Property<KsqlTopic>("topic", DataSource::getKsqlTopic), new Property<Optional>("timestampColumn", DataSource::getTimestampColumn));
    private static final Property<LogicalSchema> SCHEMA_PROP = new Property<LogicalSchema>("schema", DataSource::getSchema);

    StructuredDataSource(String sqlExpression, SourceName dataSourceName, LogicalSchema schema, Optional<TimestampColumn> tsExtractionPolicy, DataSource.DataSourceType dataSourceType, boolean casTarget, KsqlTopic ksqlTopic, boolean isSource) {
        this.sqlExpression = Objects.requireNonNull(sqlExpression, "sqlExpression");
        this.dataSourceName = Objects.requireNonNull(dataSourceName, "dataSourceName");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.timestampColumn = Objects.requireNonNull(tsExtractionPolicy, "tsExtractionPolicy");
        this.dataSourceType = Objects.requireNonNull(dataSourceType, "dataSourceType");
        this.ksqlTopic = Objects.requireNonNull(ksqlTopic, "ksqlTopic");
        this.casTarget = casTarget;
        this.isSource = isSource;
        Set keyNames = schema.key().stream().map(Column::name).collect(Collectors.toSet());
        if (schema.valueContainsAny(keyNames)) {
            throw new IllegalArgumentException("Schema contains duplicate column names");
        }
    }

    @Override
    public SourceName getName() {
        return this.dataSourceName;
    }

    @Override
    public DataSource.DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    @Override
    public LogicalSchema getSchema() {
        return this.schema;
    }

    @Override
    public KsqlTopic getKsqlTopic() {
        return this.ksqlTopic;
    }

    @Override
    public boolean isCasTarget() {
        return this.casTarget;
    }

    @Override
    public Optional<TimestampColumn> getTimestampColumn() {
        return this.timestampColumn;
    }

    @Override
    public String getKafkaTopicName() {
        return this.ksqlTopic.getKafkaTopicName();
    }

    @Override
    public String getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public boolean isSource() {
        return this.isSource;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " name:" + this.getName();
    }

    @Override
    public Optional<String> canUpgradeTo(DataSource other) {
        List issues = PROPERTIES.stream().filter(prop -> !prop.isCompatible(this, other)).map(prop -> this.getCompatMessage(other, (Property<?>)prop)).collect(Collectors.toList());
        StructuredDataSource.checkSchemas(this.getSchema(), other.getSchema()).map(s -> this.getCompatMessage(other, SCHEMA_PROP) + ". (" + s + ")").ifPresent(issues::add);
        String err = String.join((CharSequence)"\n\tAND ", issues);
        return err.isEmpty() ? Optional.empty() : Optional.of(err);
    }

    private String getCompatMessage(DataSource other, Property<?> prop) {
        return String.format("DataSource '%s' has %s = %s which is not upgradeable to %s", this.getName(), prop.name, prop.getter.apply(this).toString(), prop.getter.apply(other).toString());
    }

    @VisibleForTesting
    static Optional<String> checkSchemas(LogicalSchema schema, LogicalSchema other) {
        Optional<String> keyError = StructuredDataSource.checkSchemas(schema.key(), other.key(), "key ").map(msg -> "Key columns must be identical. " + msg);
        if (keyError.isPresent()) {
            return keyError;
        }
        return StructuredDataSource.checkSchemas(schema.columns(), other.columns(), "");
    }

    private static Optional<String> checkSchemas(List<Column> cols, List<Column> otherCols, String colType) {
        ImmutableSet colB;
        ImmutableSet colA = ImmutableSet.copyOf(cols);
        Sets.SetView difference = Sets.difference((Set)colA, (Set)(colB = ImmutableSet.copyOf(otherCols)));
        if (!difference.isEmpty()) {
            return Optional.of("The following " + colType + "columns are changed, missing or reordered: " + difference);
        }
        return Optional.empty();
    }

    @Immutable
    private static class Property<T> {
        final String name;
        @EffectivelyImmutable
        final Function<DataSource, T> getter;

        Property(String name, Function<DataSource, T> getter) {
            this.name = Objects.requireNonNull(name, "name");
            this.getter = Objects.requireNonNull(getter, "getter");
        }

        public boolean isCompatible(DataSource source, DataSource other) {
            return this.getter.apply(source).equals(this.getter.apply(other));
        }
    }
}

