/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.utils;

import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.InvalidScopeException;
import io.confluent.security.rbac.InvalidRoleBindingException;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.rbac.Role;
import java.util.Collection;
import org.apache.kafka.common.errors.InvalidRequestException;

public class AuthWriterUtils {
    public static void validateRoleBindingUpdate(String role, Scope scope, Collection<?> resources, boolean expectResourcesForResourceLevel, Scope rootScope, RbacRoles rbacRoles) {
        AuthWriterUtils.validateScope(scope, rootScope);
        Role roleDefinition = rbacRoles.role(role);
        if (roleDefinition == null) {
            throw new InvalidRoleBindingException("Role not found " + role);
        }
        String roleDisplayName = roleDefinition.displayName();
        if (roleDefinition.bindWithResource()) {
            if (expectResourcesForResourceLevel && resources.isEmpty()) {
                throw new InvalidRequestException("Resources must be specified for role " + roleDisplayName);
            }
        } else {
            String mostSpecific = roleDefinition.mostSpecificBindingScope();
            if (!resources.isEmpty()) {
                throw new InvalidRequestException("Resources must not be specified for role " + roleDisplayName);
            }
            if (!mostSpecific.equals(scope.bindingScope())) {
                throw new InvalidRequestException("Role " + roleDisplayName + " must be bound at scope " + mostSpecific + ", but was bound at " + scope.bindingScope());
            }
            for (String bindingScope : roleDefinition.bindingScopes()) {
                if (scope.ancestorWithBindingScope(bindingScope) != null) continue;
                throw new InvalidRequestException("Role " + roleDisplayName + " must be bound in a scope with an enclosing scope of " + bindingScope);
            }
        }
    }

    public static void validateRoleResources(Collection<ResourcePattern> resources) {
        resources.forEach(resource -> {
            if (resource.name() == null || resource.name().isEmpty()) {
                throw new InvalidRequestException("Resource name for role binding must be non-empty");
            }
            if (resource.resourceType() == null || resource.resourceType().name() == null || resource.resourceType().name().isEmpty()) {
                throw new InvalidRequestException("Resource type for role binding must be non-empty");
            }
            if (resource.patternType() == null || !resource.patternType().isSpecific()) {
                throw new InvalidRequestException("Resource pattern type for role binding must be LITERAL or PREFIXED, got " + resource);
            }
        });
    }

    public static void validateScope(Scope scope, Scope rootScope) {
        scope.validate();
        if (!rootScope.containsScope(scope)) {
            throw new InvalidScopeException("This writer does not contain binding scope " + scope);
        }
    }
}

