/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.connect.replicator.KafkaConfigs;
import io.confluent.connect.replicator.NewTopicMonitorThread;
import io.confluent.connect.replicator.ReplicatorSourceConnectorConfig;
import io.confluent.connect.replicator.ReplicatorSourceTask;
import io.confluent.connect.replicator.ReplicatorSourceTaskConfig;
import io.confluent.connect.replicator.TopicMonitorThread;
import io.confluent.connect.replicator.config.ConnectConfigProvider;
import io.confluent.connect.replicator.util.Version;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.LicenseChanged;
import io.confluent.license.LicenseManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatorSourceConnector
extends SourceConnector {
    private static final Logger log = LoggerFactory.getLogger(ReplicatorSourceConnector.class);
    public static final String DEST_LICENSE_PRODUCER_PREFIX = "confluent.topic.producer.";
    public static final String DEST_LICENSE_CONSUMER_PREFIX = "confluent.topic.consumer.";
    public static final String DEST_LICENSE_PREFIX = "confluent.topic.";
    private TopicMonitorThread monitorThread;
    private ReplicatorSourceConnectorConfig config;
    private LicenseManager licenseManager;
    private ConnectConfigProvider connectConfigProvider = new ConnectConfigProvider();

    public ReplicatorSourceConnector() {
    }

    ReplicatorSourceConnector(ReplicatorSourceConnectorConfig config, TopicMonitorThread monitorThread, LicenseManager licenseManager) {
        this.config = config;
        this.monitorThread = monitorThread;
        this.licenseManager = licenseManager;
    }

    public String version() {
        return Version.getVersion();
    }

    public void start(Map<String, String> props) {
        log.debug("Gathering replicator connector's configs...");
        this.config = this.connectorConfig(props);
        if (!this.config.hasAlignedTopicPreservePartitionsAndOffsetTopicCommit()) {
            throw new ConnectException(String.format("%s cannot be true if %s is false", "offset.topic.commit", "topic.preserve.partitions"));
        }
        log.info("Starting replicator connector {}", (Object)this.config.getName());
        Map<String, Object> licenseConfig = this.getLicenseConfigs(this.config);
        String topic = this.config.getString("confluent.topic");
        this.validateLicense(topic, licenseConfig);
        log.debug("Creating topic monitor thread...");
        this.monitorThread = this.monitorThread();
        log.debug("Staring topic monitor thread...");
        this.monitorThread.start();
    }

    public Class<? extends Task> taskClass() {
        return ReplicatorSourceTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        log.info("Gathering task configs...");
        this.validateMaxTasks(maxTasks, this.config);
        ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>();
        Map<String, ConsumerPartitionAssignor.Assignment> assignments = this.monitorThread.assignments(maxTasks);
        for (Map.Entry<String, ConsumerPartitionAssignor.Assignment> assignment : assignments.entrySet()) {
            ReplicatorSourceTaskConfig taskConfig = ReplicatorSourceTaskConfig.builder(this.config).setTaskId(assignment.getKey()).setAssignment(assignment.getValue()).build();
            taskConfigs.add(taskConfig.originalsStrings());
        }
        return taskConfigs;
    }

    private void validateMaxTasks(int maxTasks, ReplicatorSourceConnectorConfig config) {
        log.debug("Validating max number of tasks in the Replicator configs");
        int maxTranslatorTasks = config.getOffsetTranslatorTasksMax();
        boolean translatorTasksSeparate = config.areOffsetTranslatorTasksSeparate();
        if (translatorTasksSeparate && maxTranslatorTasks >= maxTasks) {
            throw new ConfigException("The value of offset.translator.tasks.max must be less than the value of tasks.max if offsets.translator.tasks.separate = true");
        }
        if (translatorTasksSeparate && maxTranslatorTasks < 0) {
            throw new ConfigException("The value of offset.translator.tasks.max must be non-negative if offsets.translator.tasks.separate = true");
        }
        if (!translatorTasksSeparate && maxTranslatorTasks > maxTasks) {
            throw new ConfigException("The value of offset.translator.tasks.max must be less than or equal to the value of tasks.max if offsets.translator.tasks.separate = false");
        }
    }

    public void stop() {
        log.info("Shutting down replicator connector {}", (Object)this.config.getName());
        try {
            if (this.licenseManager != null) {
                this.licenseManager.stop();
            }
        }
        finally {
            this.licenseManager = null;
            if (this.monitorThread != null) {
                this.monitorThread.shutdown();
                this.monitorThread = null;
            }
        }
    }

    public ConfigDef config() {
        return ReplicatorSourceConnectorConfig.CONFIG_DEF;
    }

    private ReplicatorSourceConnectorConfig connectorConfig(Map<String, String> props) {
        HashMap<String, String> combinedProps = new HashMap<String, String>();
        if (!props.containsKey(KafkaConfigs.KafkaCluster.DESTINATION.prefix() + "bootstrap.servers")) {
            ReplicatorSourceConnector.filterOutInterceptorPropertiesInPlace(this.connectConfigProvider.getProducerConfig()).forEach((key, value) -> combinedProps.put(KafkaConfigs.KafkaCluster.DESTINATION.prefix() + key, (String)value));
        }
        combinedProps.putAll(props);
        return this.config != null ? this.config : new ReplicatorSourceConnectorConfig(combinedProps);
    }

    private TopicMonitorThread monitorThread() {
        return this.monitorThread != null ? this.monitorThread : new NewTopicMonitorThread(this.context, this.config);
    }

    private void validateLicense(String topic, Map<String, Object> licenseConfigs) {
        if (this.licenseManager == null) {
            this.licenseManager = new LicenseManager(topic, licenseConfigs, licenseConfigs, licenseConfigs);
        }
        this.licenseManager.addListener((Consumer)new Consumer<LicenseChanged>(){

            @Override
            public void accept(LicenseChanged licenseChanged) {
                License license = licenseChanged.license();
                if (!license.isValid() || license.isExpired()) {
                    ReplicatorSourceConnector.this.context.raiseError((Exception)new ConnectException("License expired or invalid: " + license));
                }
            }
        });
        this.licenseManager.start();
        try {
            log.info("Validating Confluent Replicator License...");
            this.licenseManager.registerOrValidateLicense(this.config.getPassword("confluent.license").value());
        }
        catch (InvalidLicenseException e) {
            throw new ConnectException("Error validating license", (Throwable)e);
        }
    }

    @VisibleForTesting
    protected Map<String, Object> getLicenseConfigs(ReplicatorSourceConnectorConfig config) {
        HashMap<String, Object> unifiedConfig = new HashMap<String, Object>();
        Map destKafkaConfigs = config.originalsWithPrefix(KafkaConfigs.KafkaCluster.DESTINATION.prefix());
        destKafkaConfigs.remove("replication.factor");
        destKafkaConfigs.remove("min.insync.replicas");
        unifiedConfig.putAll(ReplicatorSourceConnector.filterOutInterceptorPropertiesInPlace(destKafkaConfigs));
        unifiedConfig.putAll(ReplicatorSourceConnector.filterOutInterceptorPropertiesInPlace(config.originalsWithPrefix(DEST_LICENSE_PREFIX)));
        unifiedConfig.putAll(ReplicatorSourceConnector.filterOutInterceptorPropertiesInPlace(config.originalsWithPrefix(DEST_LICENSE_CONSUMER_PREFIX)));
        unifiedConfig.putAll(ReplicatorSourceConnector.filterOutInterceptorPropertiesInPlace(config.originalsWithPrefix(DEST_LICENSE_PRODUCER_PREFIX)));
        if (!unifiedConfig.containsKey("group.id")) {
            unifiedConfig.put("group.id", config.getSourceConsumerConfigs().get("group.id") + "-license");
        }
        return unifiedConfig;
    }

    public static <T> Map<String, T> filterOutInterceptorPropertiesInPlace(Map<String, T> originals) {
        Iterator<String> propIt = originals.keySet().iterator();
        while (propIt.hasNext()) {
            if (!propIt.next().contains("interceptor")) continue;
            propIt.remove();
        }
        return originals;
    }

    public void setConnectConfigProvider(ConnectConfigProvider connectConfigProvider) {
        this.connectConfigProvider = connectConfigProvider;
    }
}

