/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.metrics;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchEndOffsetService {
    private Consumer<byte[], byte[]> endOffsetsConsumer;
    private ConcurrentMap<TopicPartition, Long> endOffsetsMap;
    private Collection<TopicPartition> consumerSourceAssignment;
    private ScheduledExecutorService endOffsetService;
    private String taskId;
    private static final Logger log = LoggerFactory.getLogger(FetchEndOffsetService.class);

    FetchEndOffsetService(Consumer<byte[], byte[]> consumer, Collection<TopicPartition> sourceAssignment, String taskId, long fixedDelayMs) {
        this.endOffsetsConsumer = consumer;
        this.endOffsetsMap = new ConcurrentHashMap<TopicPartition, Long>();
        this.consumerSourceAssignment = sourceAssignment;
        this.taskId = taskId;
        long initialDelay = 0L;
        this.endOffsetService = Executors.newSingleThreadScheduledExecutor();
        this.endOffsetService.scheduleWithFixedDelay(() -> {
            this.endOffsetsMap = this.updateEndOffsets();
        }, initialDelay, fixedDelayMs, TimeUnit.MILLISECONDS);
    }

    public FetchEndOffsetService(Consumer<byte[], byte[]> consumer, Collection<TopicPartition> sourceAssignment, String taskId, ScheduledExecutorService endOffsetService) {
        this.endOffsetsConsumer = consumer;
        this.endOffsetsMap = new ConcurrentHashMap<TopicPartition, Long>();
        this.consumerSourceAssignment = sourceAssignment;
        this.taskId = taskId;
        this.endOffsetService = endOffsetService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentMap<TopicPartition, Long> updateEndOffsets() {
        Map endOffsets;
        Consumer<byte[], byte[]> consumer = this.endOffsetsConsumer;
        synchronized (consumer) {
            endOffsets = this.endOffsetsConsumer.endOffsets(this.consumerSourceAssignment);
        }
        this.endOffsetsMap.putAll(endOffsets);
        log.debug("Fetched new end offsets for task {}", (Object)this.taskId);
        return this.endOffsetsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.endOffsetService.shutdownNow();
        Consumer<byte[], byte[]> consumer = this.endOffsetsConsumer;
        synchronized (consumer) {
            this.endOffsetsConsumer.close();
        }
    }

    public long getEndOffset(TopicPartition tp) {
        return this.endOffsetsMap.get(tp) == null ? 0L : (Long)this.endOffsetsMap.get(tp);
    }
}

