/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.DeadlineManager;
import io.confluent.connect.replicator.ReplicatorSourceTask;
import io.confluent.connect.replicator.ReplicatorSourceTaskConfig;
import io.confluent.connect.replicator.Translator;
import io.confluent.connect.replicator.util.ReplicatorAdminClient;
import io.confluent.connect.replicator.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.source.SourceTaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetManager {
    private static final Logger log = LoggerFactory.getLogger(OffsetManager.class);
    private ReplicatorSourceTaskConfig config;
    private volatile Consumer<byte[], byte[]> consumer;
    private SourceTaskContext context;
    private DeadlineManager deadlineManager;

    public void setConfig(ReplicatorSourceTaskConfig config) {
        this.config = config;
    }

    public void setConsumer(Consumer<byte[], byte[]> consumer) {
        this.consumer = consumer;
    }

    public void setContext(SourceTaskContext context) {
        this.context = context;
    }

    public OffsetManager(ReplicatorSourceTaskConfig config, Consumer<byte[], byte[]> consumer, SourceTaskContext context, DeadlineManager deadlineManager) {
        this.config = config;
        this.consumer = consumer;
        this.context = context;
        this.deadlineManager = deadlineManager;
    }

    public void initializePartitionOffset(Collection<TopicPartition> sourceAssignment, Map<String, Translator> translators, ReplicatorAdminClient destAdminClient) {
        HashSet<TopicPartitionInfo> seekingSourcePartitions = new HashSet<TopicPartitionInfo>();
        ArrayList<TopicPartitionInfo> seekToBeginningAndPause = new ArrayList<TopicPartitionInfo>();
        for (TopicPartition sourcePartition : sourceAssignment) {
            boolean seekToBeginningOnPause;
            String destinationId;
            boolean isDestinationReady;
            Translator translator = translators.get(sourcePartition.topic());
            if (translator != null) {
                isDestinationReady = translator.isDestinationReady();
                destinationId = "translator for " + translator.topic();
                seekToBeginningOnPause = translator.seekToBeginningOnPause();
            } else {
                TopicPartition destPartition = ReplicatorSourceTask.toDestPartition(sourcePartition, this.config);
                isDestinationReady = !this.config.getTopicPreservePartitions() || destAdminClient.partitionExists(destPartition);
                destinationId = "partition " + destPartition;
                seekToBeginningOnPause = false;
            }
            if (isDestinationReady || !seekToBeginningOnPause) {
                seekingSourcePartitions.add(new TopicPartitionInfo(sourcePartition, destinationId, !isDestinationReady));
                continue;
            }
            seekToBeginningAndPause.add(new TopicPartitionInfo(sourcePartition, destinationId, true));
        }
        if (!seekToBeginningAndPause.isEmpty()) {
            seekToBeginningAndPause.forEach(item -> log.trace("Seeking to the beginning and pausing source partition {} since destination {} is not ready yet", (Object)item.getSourcePartition(), (Object)item.getDestinationId()));
            this.seekToBeginning(seekToBeginningAndPause.stream().map(item -> item.getSourcePartition()).collect(Collectors.toList()));
            this.pauseSourcePartitions(seekToBeginningAndPause);
        }
        this.seekSourcePartitions(seekingSourcePartitions);
    }

    public void pauseSourcePartitions(List<TopicPartitionInfo> sourcePartitionParams) {
        log.debug("Pausing the following topic partitions: {}", sourcePartitionParams);
        if (sourcePartitionParams.isEmpty()) {
            return;
        }
        this.consumer.pause((Collection)sourcePartitionParams.stream().map(item -> item.getSourcePartition()).collect(Collectors.toSet()));
        this.deadlineManager.set(DeadlineManager.DeadlineType.TRY_RESUME, this.deadlineManager.getMilliSeconds() + 5000L);
    }

    private void seekUsingConnectOffsets(Set<TopicPartition> topicPartitions) {
        log.debug("Seeking to the following partitions using connect offsets: {}", topicPartitions);
        if (topicPartitions.isEmpty()) {
            return;
        }
        Map<Map, TopicPartition> connectPartToSourcePart = topicPartitions.stream().collect(Collectors.toMap(topicPartition -> Utils.toConnectPartition((TopicPartition)topicPartition), topicPartition -> topicPartition));
        Map connectOffsets = this.context.offsetStorageReader().offsets(connectPartToSourcePart.keySet());
        Map<Map, TopicPartition> seekingConnectOffsets = connectPartToSourcePart.entrySet().stream().filter(e -> connectOffsets.get(e.getKey()) != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        seekingConnectOffsets.forEach((connectPartition, sourcePartition) -> this.seekToConnectOffset((TopicPartition)sourcePartition, (Map)connectOffsets.get(connectPartition)));
        topicPartitions.removeAll(seekingConnectOffsets.values());
    }

    private void seekUsingConsumerOffsets(Set<TopicPartition> topicPartitions) {
        if (topicPartitions.isEmpty()) {
            return;
        }
        Map offsetAndMetadata = this.consumer.committed(topicPartitions);
        Set<TopicPartition> seekingConsumerOffsets = topicPartitions.stream().filter(topicPartition -> offsetAndMetadata.get(topicPartition) != null).collect(Collectors.toSet());
        seekingConsumerOffsets.forEach(sourcePartition -> this.seekToConsumerOffset((TopicPartition)sourcePartition, (OffsetAndMetadata)offsetAndMetadata.get(sourcePartition)));
        topicPartitions.removeAll(seekingConsumerOffsets);
    }

    private void seekSourcePartitions(Collection<TopicPartitionInfo> seekingSourcePartitions) {
        log.debug("Seeking to appropriate offsets for the source partitions...");
        if (seekingSourcePartitions.isEmpty()) {
            return;
        }
        Set<TopicPartition> topicPartitions = seekingSourcePartitions.stream().map(param -> param.getSourcePartition()).collect(Collectors.toSet());
        switch (this.config.getOffsetStart()) {
            case CONNECT: {
                this.seekUsingConnectOffsets(topicPartitions);
                this.seekUsingConsumerOffsets(topicPartitions);
                break;
            }
            case CONSUMER: {
                this.seekUsingConsumerOffsets(topicPartitions);
                this.seekUsingConnectOffsets(topicPartitions);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported offset start type");
            }
        }
        if (!topicPartitions.isEmpty()) {
            this.seekToBeginning(topicPartitions);
        }
        seekingSourcePartitions.forEach(item -> log.trace("Pausing source partition {} since destination {} is not ready yet", (Object)item.getSourcePartition(), (Object)item.getDestinationId()));
        this.pauseSourcePartitions(seekingSourcePartitions.stream().filter(p -> p.isPaused()).collect(Collectors.toList()));
    }

    public void seekToBeginning(Collection<TopicPartition> sourcePartitions) {
        log.debug("Seeking to the beginning of source partition for the following topic partitions {}", sourcePartitions);
        this.consumer.seekToBeginning(sourcePartitions);
    }

    private void seekToConnectOffset(TopicPartition sourcePartition, Map<String, Object> connectSourceOffset) {
        long offset = (Long)connectSourceOffset.get("offset");
        log.debug("Seeking to offset {} committed by Connect for source partition {}", (Object)offset, (Object)sourcePartition);
        this.consumer.seek(sourcePartition, offset + 1L);
    }

    private void seekToConsumerOffset(TopicPartition sourcePartition, OffsetAndMetadata offsetAndMetadata) {
        log.debug("Using consumer committed offset {} for source partition {}", (Object)offsetAndMetadata.offset(), (Object)sourcePartition);
    }

    public static class TopicPartitionInfo {
        private TopicPartition sourcePartition;
        private String destinationId;
        private boolean pause;

        public TopicPartition getSourcePartition() {
            return this.sourcePartition;
        }

        public String getDestinationId() {
            return this.destinationId;
        }

        public boolean isPaused() {
            return this.pause;
        }

        public TopicPartitionInfo(TopicPartition topic, String id, boolean pause) {
            this.sourcePartition = topic;
            this.destinationId = id;
            this.pause = pause;
        }
    }
}

