/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generic.GenericGroup;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public class RecordHelpers {
    private RecordHelpers() {
    }

    public static Record newMemberSubscriptionRecord(String groupId, ConsumerGroupMember member) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataKey().setGroupId(groupId).setMemberId(member.memberId()), 5), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataValue().setRackId(member.rackId()).setInstanceId(member.instanceId()).setClientId(member.clientId()).setClientHost(member.clientHost()).setSubscribedTopicNames(member.subscribedTopicNames()).setSubscribedTopicRegex(member.subscribedTopicRegex()).setServerAssignor(member.serverAssignorName().orElse(null)).setRebalanceTimeoutMs(member.rebalanceTimeoutMs()).setAssignors(member.clientAssignors().stream().map(assignorState -> new ConsumerGroupMemberMetadataValue.Assignor().setName(assignorState.name()).setReason(assignorState.reason()).setMinimumVersion(assignorState.minimumVersion()).setMaximumVersion(assignorState.maximumVersion()).setVersion(assignorState.metadata().version()).setMetadata(assignorState.metadata().metadata().array())).collect(Collectors.toList())), 0));
    }

    public static Record newMemberSubscriptionTombstoneRecord(String groupId, String memberId) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataKey().setGroupId(groupId).setMemberId(memberId), 5), null);
    }

    public static Record newGroupSubscriptionMetadataRecord(String groupId, Map<String, TopicMetadata> newSubscriptionMetadata) {
        ConsumerGroupPartitionMetadataValue value = new ConsumerGroupPartitionMetadataValue();
        newSubscriptionMetadata.forEach((topicName, topicMetadata) -> value.topics().add(new ConsumerGroupPartitionMetadataValue.TopicMetadata().setTopicId(topicMetadata.id()).setTopicName(topicMetadata.name()).setNumPartitions(topicMetadata.numPartitions())));
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataKey().setGroupId(groupId), 4), new ApiMessageAndVersion((ApiMessage)value, 0));
    }

    public static Record newGroupSubscriptionMetadataTombstoneRecord(String groupId) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataKey().setGroupId(groupId), 4), null);
    }

    public static Record newGroupEpochRecord(String groupId, int newGroupEpoch) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId(groupId), 3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(newGroupEpoch), 0));
    }

    public static Record newGroupEpochTombstoneRecord(String groupId) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId(groupId), 3), null);
    }

    public static Record newTargetAssignmentRecord(String groupId, String memberId, Map<Uuid, Set<Integer>> partitions) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId), 7), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberValue().setTopicPartitions(partitions.entrySet().stream().map(keyValue -> new ConsumerGroupTargetAssignmentMemberValue.TopicPartition().setTopicId((Uuid)keyValue.getKey()).setPartitions(new ArrayList<Integer>((Collection)keyValue.getValue()))).collect(Collectors.toList())), 0));
    }

    public static Record newTargetAssignmentTombstoneRecord(String groupId, String memberId) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId), 7), null);
    }

    public static Record newTargetAssignmentEpochRecord(String groupId, int assignmentEpoch) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataKey().setGroupId(groupId), 6), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataValue().setAssignmentEpoch(assignmentEpoch), 0));
    }

    public static Record newTargetAssignmentEpochTombstoneRecord(String groupId) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataKey().setGroupId(groupId), 6), null);
    }

    public static Record newCurrentAssignmentRecord(String groupId, ConsumerGroupMember member) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(member.memberId()), 8), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentValue().setMemberEpoch(member.memberEpoch()).setPreviousMemberEpoch(member.previousMemberEpoch()).setTargetMemberEpoch(member.nextMemberEpoch()).setAssignedPartitions(RecordHelpers.toTopicPartitions(member.assignedPartitions())).setPartitionsPendingRevocation(RecordHelpers.toTopicPartitions(member.partitionsPendingRevocation())).setPartitionsPendingAssignment(RecordHelpers.toTopicPartitions(member.partitionsPendingAssignment())), 0));
    }

    public static Record newCurrentAssignmentTombstoneRecord(String groupId, String memberId) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(memberId), 8), null);
    }

    public static Record newGroupMetadataRecord(GenericGroup group, MetadataVersion metadataVersion) {
        ArrayList<GroupMetadataValue.MemberMetadata> members = new ArrayList<GroupMetadataValue.MemberMetadata>(group.allMembers().size());
        group.allMembers().forEach(member -> {
            byte[] subscription = group.protocolName().map(member::metadata).orElse(null);
            if (subscription == null) {
                throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol.");
            }
            byte[] assignment = member.assignment();
            if (assignment == null) {
                throw new IllegalStateException("Attempted to write member " + member.memberId() + " of group + " + group.groupId() + " with no assignment.");
            }
            members.add(new GroupMetadataValue.MemberMetadata().setMemberId(member.memberId()).setClientId(member.clientId()).setClientHost(member.clientHost()).setRebalanceTimeout(member.rebalanceTimeoutMs()).setSessionTimeout(member.sessionTimeoutMs()).setGroupInstanceId(member.groupInstanceId().orElse(null)).setSubscription(subscription).setAssignment(assignment));
        });
        return new Record(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup(group.groupId()), 2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocol(group.protocolName().orElse(null)).setProtocolType(group.protocolType().orElse("")).setGeneration(group.generationId()).setLeader(group.leaderOrNull()).setCurrentStateTimestamp(group.currentStateTimestampOrDefault()).setMembers(members), metadataVersion.groupMetadataValueVersion()));
    }

    public static Record newGroupMetadataTombstoneRecord(String groupId) {
        return new Record(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup(groupId), 2), null);
    }

    private static List<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions> toTopicPartitions(Map<Uuid, Set<Integer>> topicPartitions) {
        ArrayList<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions> topics = new ArrayList<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions>(topicPartitions.size());
        topicPartitions.forEach((topicId, partitions) -> topics.add(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId((Uuid)topicId).setPartitions(new ArrayList<Integer>((Collection<Integer>)partitions))));
        return topics;
    }
}

