/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.DefaultEventHandler;
import org.apache.kafka.clients.consumer.internals.PrototypeAsyncConsumer;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.EventHandler;
import org.apache.kafka.clients.consumer.internals.events.OffsetFetchApplicationEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class PrototypeAsyncConsumerTest {
    private Consumer<?, ?> consumer;
    private Map<String, Object> consumerProps = new HashMap<String, Object>();
    private final Time time = new MockTime();
    private LogContext logContext;
    private SubscriptionState subscriptions;
    private EventHandler eventHandler;
    private Metrics metrics;
    private ClusterResourceListeners clusterResourceListeners;
    private String groupId = "group.id";
    private String clientId = "client-1";
    private ConsumerConfig config;

    @BeforeEach
    public void setup() {
        this.injectConsumerConfigs();
        this.config = new ConsumerConfig(this.consumerProps);
        this.logContext = new LogContext();
        this.subscriptions = (SubscriptionState)Mockito.mock(SubscriptionState.class);
        this.eventHandler = (EventHandler)Mockito.mock(DefaultEventHandler.class);
        this.metrics = new Metrics(this.time);
        this.clusterResourceListeners = new ClusterResourceListeners();
    }

    @AfterEach
    public void cleanup() {
        if (this.consumer != null) {
            this.consumer.close(Duration.ZERO);
        }
    }

    @Test
    public void testSuccessfulStartupShutdown() {
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Assertions.assertDoesNotThrow(() -> this.consumer.close());
    }

    @Test
    public void testInvalidGroupId() {
        this.groupId = null;
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Assertions.assertThrows(InvalidGroupIdException.class, () -> this.consumer.committed(new HashSet()));
    }

    @Test
    public void testCommitAsync_NullCallback() throws InterruptedException {
        CompletableFuture future = new CompletableFuture();
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.put(new TopicPartition("my-topic", 0), new OffsetAndMetadata(100L));
        offsets.put(new TopicPartition("my-topic", 1), new OffsetAndMetadata(200L));
        PrototypeAsyncConsumer mockedConsumer = (PrototypeAsyncConsumer)Mockito.spy(this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer()));
        ((PrototypeAsyncConsumer)Mockito.doReturn(future).when((Object)mockedConsumer)).commit(offsets);
        mockedConsumer.commitAsync(offsets, null);
        future.complete(null);
        TestUtils.waitForCondition(() -> future.isDone(), 2000L, "commit future should complete");
        Assertions.assertFalse((boolean)future.isCompletedExceptionally());
    }

    @Test
    public void testCommitAsync_UserSuppliedCallback() {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.put(new TopicPartition("my-topic", 0), new OffsetAndMetadata(100L));
        offsets.put(new TopicPartition("my-topic", 1), new OffsetAndMetadata(200L));
        PrototypeAsyncConsumer<?, ?> consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        PrototypeAsyncConsumer mockedConsumer = (PrototypeAsyncConsumer)Mockito.spy(consumer);
        ((PrototypeAsyncConsumer)Mockito.doReturn(future).when((Object)mockedConsumer)).commit(offsets);
        OffsetCommitCallback customCallback = (OffsetCommitCallback)Mockito.mock(OffsetCommitCallback.class);
        mockedConsumer.commitAsync(offsets, customCallback);
        future.complete(null);
        ((OffsetCommitCallback)Mockito.verify((Object)customCallback)).onComplete(offsets, null);
    }

    @Test
    public void testCommitted() {
        Set<TopicPartition> mockTopicPartitions = this.mockTopicPartitionOffset().keySet();
        Mockito.mockConstruction(OffsetFetchApplicationEvent.class, (mock, ctx) -> Mockito.when((Object)mock.complete((Duration)ArgumentMatchers.any())).thenReturn(new HashMap()));
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Assertions.assertDoesNotThrow(() -> this.consumer.committed(mockTopicPartitions, Duration.ofMillis(1L)));
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(OffsetFetchApplicationEvent.class));
    }

    @Test
    public void testUnimplementedException() {
        this.consumer = this.newConsumer(this.time, (Deserializer<?>)new StringDeserializer(), (Deserializer<?>)new StringDeserializer());
        Assertions.assertThrows(KafkaException.class, () -> this.consumer.assignment(), (String)"not implemented exception");
    }

    private HashMap<TopicPartition, OffsetAndMetadata> mockTopicPartitionOffset() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        TopicPartition t1 = new TopicPartition("t0", 3);
        HashMap<TopicPartition, OffsetAndMetadata> topicPartitionOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        topicPartitionOffsets.put(t0, new OffsetAndMetadata(10L));
        topicPartitionOffsets.put(t1, new OffsetAndMetadata(20L));
        return topicPartitionOffsets;
    }

    private ConsumerMetadata createMetadata(SubscriptionState subscription) {
        return new ConsumerMetadata(0L, Long.MAX_VALUE, false, false, subscription, new LogContext(), new ClusterResourceListeners());
    }

    private void injectConsumerConfigs() {
        this.consumerProps.put("bootstrap.servers", "localhost:9999");
        this.consumerProps.put("default.api.timeout.ms", "60000");
        this.consumerProps.put("key.deserializer", StringDeserializer.class);
        this.consumerProps.put("value.deserializer", StringDeserializer.class);
    }

    private PrototypeAsyncConsumer<?, ?> newConsumer(Time time, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer) {
        this.consumerProps.put("key.deserializer", keyDeserializer.getClass());
        this.consumerProps.put("value.deserializer", valueDeserializer.getClass());
        return new PrototypeAsyncConsumer(time, this.logContext, this.config, this.subscriptions, this.eventHandler, this.metrics, this.clusterResourceListeners, Optional.ofNullable(this.groupId), this.clientId, this.config.getInt("default.api.timeout.ms").intValue());
    }
}

