/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import io.confluent.kafka.multitenant.InetAddressToTenantContext;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import javax.net.ssl.SNIHostName;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.AsyncAuthExecutor;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.MockAsyncAuthExecutor;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.PlaintextChannelBuilder;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.network.TestProxyProtocolEngine;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.interceptor.DefaultBrokerInterceptor;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KafkaChannelTest {
    public static final String CHANNEL_ID = "0";
    public static final int MAX_RECEIVE_SIZE = 1024;
    public static final ChannelMetadataRegistry METADATA_REGISTRY = (ChannelMetadataRegistry)Mockito.mock(ChannelMetadataRegistry.class);
    public static final MemoryPool POOL = (MemoryPool)Mockito.mock(MemoryPool.class);
    public static final TransportLayer TRANSPORT = (TransportLayer)Mockito.mock(TransportLayer.class);
    public static final Authenticator AUTHENTICATOR = (Authenticator)Mockito.mock(Authenticator.class);
    public static final SslTransportLayer SSL_TRANSPORT_LAYER = (SslTransportLayer)Mockito.mock(SslTransportLayer.class);
    public static final SaslServerAuthenticator SASL_SERVER_AUTHENTICATOR = (SaslServerAuthenticator)Mockito.mock(SaslServerAuthenticator.class);
    public static final Time MOCK_TIME = new MockTime();
    public static final KafkaChannel KAFKA_CHANNEL = new KafkaChannel("0", TRANSPORT, () -> AUTHENTICATOR, 1024, (AsyncAuthExecutor)new MockAsyncAuthExecutor(), POOL, METADATA_REGISTRY, (BrokerInterceptor)new DefaultBrokerInterceptor(), MOCK_TIME, false, false);
    public static final SNIHostName RAW_SNI_HOST_NAME = new SNIHostName("hostName");
    public static final PathAwareSniHostName SNI_HOST_NAME = new PathAwareSniHostName("hostName");
    public static final SNIHostName SNI_HOST_NAME_WITH_LKC = new SNIHostName("lkc-2v531-00aa-usw1-az1-lg1y3.us-west-1.aws.confluent.cloud");
    public static final InetAddress LOOPBACK_SOCKET_ADDRESS = InetAddress.getLoopbackAddress();

    @AfterEach
    public void tearDown() {
        Mockito.reset((Object[])new Object[]{TRANSPORT, AUTHENTICATOR, POOL, METADATA_REGISTRY, SSL_TRANSPORT_LAYER, SASL_SERVER_AUTHENTICATOR});
    }

    @Test
    public void testPrepareSetSniHostName() throws IOException {
        Mockito.when((Object)SSL_TRANSPORT_LAYER.proxyProtocolReady()).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.ready()).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.sniHostName()).thenReturn(Optional.of(RAW_SNI_HOST_NAME));
        Mockito.when((Object)SASL_SERVER_AUTHENTICATOR.complete()).thenReturn((Object)false).thenReturn((Object)true);
        KafkaChannel kafkaChannel = new KafkaChannel(CHANNEL_ID, (TransportLayer)SSL_TRANSPORT_LAYER, () -> SASL_SERVER_AUTHENTICATOR, 1024, (AsyncAuthExecutor)new MockAsyncAuthExecutor(), POOL, METADATA_REGISTRY, (BrokerInterceptor)new DefaultBrokerInterceptor(), MOCK_TIME, true, false, null);
        kafkaChannel.prepare();
        ((SslTransportLayer)Mockito.verify((Object)SSL_TRANSPORT_LAYER, (VerificationMode)Mockito.times((int)3))).ready();
        ((SslTransportLayer)Mockito.verify((Object)SSL_TRANSPORT_LAYER)).sniHostName();
        ((SaslServerAuthenticator)Mockito.verify((Object)SASL_SERVER_AUTHENTICATOR)).setSniHostName(SNI_HOST_NAME);
        ((SaslServerAuthenticator)Mockito.verify((Object)SASL_SERVER_AUTHENTICATOR)).authenticate();
        Assertions.assertEquals((int)1, (int)kafkaChannel.metrics().successfulAuthentications());
    }

    @Test
    public void testPrepareSetLkcId() throws IOException {
        Mockito.when((Object)SSL_TRANSPORT_LAYER.proxyProtocolReady()).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.ready()).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.lkcId()).thenReturn(Optional.of("lkc-id"));
        Mockito.when((Object)SASL_SERVER_AUTHENTICATOR.complete()).thenReturn((Object)false).thenReturn((Object)true);
        KafkaChannel kafkaChannel = new KafkaChannel(CHANNEL_ID, (TransportLayer)SSL_TRANSPORT_LAYER, () -> SASL_SERVER_AUTHENTICATOR, 1024, (AsyncAuthExecutor)new MockAsyncAuthExecutor(), POOL, METADATA_REGISTRY, (BrokerInterceptor)new DefaultBrokerInterceptor(), MOCK_TIME, false, true, null);
        kafkaChannel.prepare();
        ((SslTransportLayer)Mockito.verify((Object)SSL_TRANSPORT_LAYER, (VerificationMode)Mockito.times((int)3))).ready();
        ((SslTransportLayer)Mockito.verify((Object)SSL_TRANSPORT_LAYER)).lkcId();
        ((SaslServerAuthenticator)Mockito.verify((Object)SASL_SERVER_AUTHENTICATOR)).putSaslServerPropertyIfAbsent("__confluent_logical_cluster_id", (Object)"lkc-id");
        ((SaslServerAuthenticator)Mockito.verify((Object)SASL_SERVER_AUTHENTICATOR)).authenticate();
        Assertions.assertEquals((int)1, (int)kafkaChannel.metrics().successfulAuthentications());
    }

    @Test
    public void testChannelLkcIdFromProxyProtocol() throws IOException {
        Mockito.when((Object)SSL_TRANSPORT_LAYER.proxyProtocolReady()).thenReturn((Object)false).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.ready()).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.lkcId()).thenReturn(Optional.of("lkc-proxy"));
        Mockito.when((Object)SASL_SERVER_AUTHENTICATOR.complete()).thenReturn((Object)false).thenReturn((Object)true);
        KafkaChannel kafkaChannel = new KafkaChannel(CHANNEL_ID, (TransportLayer)SSL_TRANSPORT_LAYER, () -> SASL_SERVER_AUTHENTICATOR, 1024, (AsyncAuthExecutor)new MockAsyncAuthExecutor(), POOL, METADATA_REGISTRY, (BrokerInterceptor)new DefaultBrokerInterceptor(), MOCK_TIME, false, true, null);
        kafkaChannel.prepare();
        Assertions.assertEquals((Object)KafkaChannel.ChannelLkcState.LKC_READY, (Object)kafkaChannel.lkcState());
        Assertions.assertEquals((Object)KafkaChannel.ChannelProxyState.PROXY_READY, (Object)kafkaChannel.proxyState());
        Assertions.assertEquals((Object)"lkc-proxy", (Object)kafkaChannel.lkcId());
    }

    @Test
    public void testChannelLkcIdFromSniHeader() throws IOException {
        Mockito.when((Object)SSL_TRANSPORT_LAYER.proxyProtocolReady()).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.ready()).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.lkcId()).thenReturn(Optional.of("lkc-proxy"));
        Mockito.when((Object)SASL_SERVER_AUTHENTICATOR.complete()).thenReturn((Object)false).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.sniHostName()).thenReturn(Optional.of(SNI_HOST_NAME_WITH_LKC));
        KafkaChannel kafkaChannel = new KafkaChannel(CHANNEL_ID, (TransportLayer)SSL_TRANSPORT_LAYER, () -> SASL_SERVER_AUTHENTICATOR, 1024, (AsyncAuthExecutor)new MockAsyncAuthExecutor(), POOL, METADATA_REGISTRY, (BrokerInterceptor)new DefaultBrokerInterceptor(), MOCK_TIME, true, true, null);
        kafkaChannel.prepare();
        Assertions.assertEquals((Object)KafkaChannel.ChannelLkcState.LKC_READY, (Object)kafkaChannel.lkcState());
        Assertions.assertEquals((Object)KafkaChannel.ChannelSniState.SNI_READY, (Object)kafkaChannel.sniState());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)kafkaChannel.lkcId());
        Mockito.when((Object)SSL_TRANSPORT_LAYER.proxyProtocolReady()).thenReturn((Object)false);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.lkcId()).thenReturn(Optional.empty());
        Mockito.when((Object)SSL_TRANSPORT_LAYER.sniHostName()).thenReturn(Optional.of(SNI_HOST_NAME_WITH_LKC));
        kafkaChannel = new KafkaChannel(CHANNEL_ID, (TransportLayer)SSL_TRANSPORT_LAYER, () -> SASL_SERVER_AUTHENTICATOR, 1024, (AsyncAuthExecutor)new MockAsyncAuthExecutor(), POOL, METADATA_REGISTRY, (BrokerInterceptor)new DefaultBrokerInterceptor(), MOCK_TIME, true, false, null);
        kafkaChannel.prepare();
        Assertions.assertEquals((Object)KafkaChannel.ChannelLkcState.LKC_READY, (Object)kafkaChannel.lkcState());
        Assertions.assertEquals((Object)KafkaChannel.ChannelSniState.SNI_READY, (Object)kafkaChannel.sniState());
        Assertions.assertEquals((Object)"lkc-2v531", (Object)kafkaChannel.lkcId());
    }

    @Test
    public void testInetAddressToTenantMap() throws IOException {
        String username = "User:*";
        String tenant = "tenant";
        String clusterId = "clusterId";
        MultiTenantPrincipal localPrincipal = new MultiTenantPrincipal(username, new TenantMetadata(tenant, clusterId));
        Mockito.when((Object)SSL_TRANSPORT_LAYER.proxyProtocolReady()).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.ready()).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.sniHostName()).thenReturn(Optional.of(RAW_SNI_HOST_NAME));
        Mockito.when((Object)SASL_SERVER_AUTHENTICATOR.complete()).thenReturn((Object)false).thenReturn((Object)true);
        Mockito.when((Object)SASL_SERVER_AUTHENTICATOR.principal()).thenReturn((Object)localPrincipal);
        KafkaChannel kafkaChannel = new KafkaChannel(CHANNEL_ID, (TransportLayer)SSL_TRANSPORT_LAYER, () -> SASL_SERVER_AUTHENTICATOR, 1024, (AsyncAuthExecutor)new MockAsyncAuthExecutor(), POOL, METADATA_REGISTRY, (BrokerInterceptor)new DefaultBrokerInterceptor(), MOCK_TIME, true, false, null);
        InetAddressToTenantContext inetAddressToTenantContext = new InetAddressToTenantContext();
        inetAddressToTenantContext.setTrackInetAddressToTenantEnabled(true);
        kafkaChannel.setInetAddressToTenantContext(inetAddressToTenantContext);
        Mockito.when((Object)kafkaChannel.socketAddress()).thenReturn((Object)LOOPBACK_SOCKET_ADDRESS);
        kafkaChannel.maybeTrackInetAddressToTenant();
        ((SaslServerAuthenticator)Mockito.verify((Object)SASL_SERVER_AUTHENTICATOR)).principal();
        Assertions.assertEquals((int)1, (int)kafkaChannel.getInetAddressToTenantContext().getInetAddressToTenant().size());
        Assertions.assertEquals((Object)"clusterId", kafkaChannel.getInetAddressToTenantContext().getInetAddressToTenant().get(LOOPBACK_SOCKET_ADDRESS));
    }

    @Test
    public void testInetAddressToAPIKeyMap() throws IOException {
        AuthenticationErrorInfo authenticationErrorInfo = new AuthenticationErrorInfo(AuditEventStatus.FAILURE, "error Message", "identifier", "clusterId");
        SaslAuthenticationException saslAuthenticationException = new SaslAuthenticationException("Fail Auth", authenticationErrorInfo);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.proxyProtocolReady()).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.ready()).thenReturn((Object)true);
        Mockito.when((Object)SSL_TRANSPORT_LAYER.sniHostName()).thenReturn(Optional.of(RAW_SNI_HOST_NAME));
        Mockito.when((Object)SASL_SERVER_AUTHENTICATOR.complete()).thenReturn((Object)false).thenReturn((Object)true);
        ((SaslServerAuthenticator)Mockito.doAnswer(invocation -> {
            throw saslAuthenticationException;
        }).when((Object)SASL_SERVER_AUTHENTICATOR)).authenticate();
        KafkaChannel kafkaChannel = new KafkaChannel(CHANNEL_ID, (TransportLayer)SSL_TRANSPORT_LAYER, () -> SASL_SERVER_AUTHENTICATOR, 1024, (AsyncAuthExecutor)new MockAsyncAuthExecutor(), POOL, METADATA_REGISTRY, (BrokerInterceptor)new DefaultBrokerInterceptor(), MOCK_TIME, true, false, null);
        InetAddressToTenantContext inetAddressToTenantContext = new InetAddressToTenantContext();
        inetAddressToTenantContext.setTrackInetAddressToAPIKeyEnabled(true);
        kafkaChannel.setInetAddressToTenantContext(inetAddressToTenantContext);
        Mockito.when((Object)kafkaChannel.socketAddress()).thenReturn((Object)LOOPBACK_SOCKET_ADDRESS);
        Assertions.assertThrows(AuthenticationException.class, () -> ((KafkaChannel)kafkaChannel).prepare());
        ((SaslServerAuthenticator)Mockito.verify((Object)SASL_SERVER_AUTHENTICATOR)).authenticate();
        Assertions.assertEquals((int)1, (int)kafkaChannel.getInetAddressToTenantContext().getInetAddressToAPIKey().size());
        Assertions.assertEquals((Object)"identifier", kafkaChannel.getInetAddressToTenantContext().getInetAddressToAPIKey().get(LOOPBACK_SOCKET_ADDRESS));
    }

    @Test
    public void testSending() throws IOException {
        ByteBufferSend send = ByteBufferSend.sizePrefixed((ByteBuffer)ByteBuffer.wrap(TestUtils.randomBytes(128)));
        NetworkSend networkSend = new NetworkSend(CHANNEL_ID, (Send)send);
        KAFKA_CHANNEL.setSend(networkSend);
        Assertions.assertTrue((boolean)KAFKA_CHANNEL.hasSend());
        Assertions.assertThrows(IllegalStateException.class, () -> KAFKA_CHANNEL.setSend(networkSend));
        Mockito.when((Object)TRANSPORT.write((ByteBuffer[])Mockito.any(ByteBuffer[].class))).thenReturn((Object)4L);
        Assertions.assertEquals((long)4L, (long)KAFKA_CHANNEL.write());
        Assertions.assertEquals((long)128L, (long)send.remaining());
        Assertions.assertNull((Object)KAFKA_CHANNEL.maybeCompleteSend());
        Mockito.when((Object)TRANSPORT.write((ByteBuffer[])Mockito.any(ByteBuffer[].class))).thenReturn((Object)64L);
        Assertions.assertEquals((long)64L, (long)KAFKA_CHANNEL.write());
        Assertions.assertEquals((long)64L, (long)send.remaining());
        Assertions.assertNull((Object)KAFKA_CHANNEL.maybeCompleteSend());
        Mockito.when((Object)TRANSPORT.write((ByteBuffer[])Mockito.any(ByteBuffer[].class))).thenReturn((Object)64L);
        Assertions.assertEquals((long)64L, (long)KAFKA_CHANNEL.write());
        Assertions.assertEquals((long)0L, (long)send.remaining());
        Assertions.assertEquals((Object)networkSend, (Object)KAFKA_CHANNEL.maybeCompleteSend());
    }

    @Test
    public void testReceiving() throws IOException {
        ArgumentCaptor sizeCaptor = ArgumentCaptor.forClass(Integer.class);
        Mockito.when((Object)POOL.tryAllocate(((Integer)sizeCaptor.capture()).intValue())).thenAnswer(invocation -> ByteBuffer.allocate((Integer)sizeCaptor.getValue()));
        ArgumentCaptor bufferCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
        Mockito.when((Object)TRANSPORT.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).putInt(128);
            return 4;
        }).thenReturn((Object)0);
        Assertions.assertEquals((long)4L, (long)KAFKA_CHANNEL.read());
        Assertions.assertEquals((int)4, (int)KAFKA_CHANNEL.currentReceive().bytesRead());
        Assertions.assertNull((Object)KAFKA_CHANNEL.maybeCompleteReceive());
        Mockito.reset((Object[])new TransportLayer[]{TRANSPORT});
        Mockito.when((Object)TRANSPORT.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).put(TestUtils.randomBytes(64));
            return 64;
        });
        Assertions.assertEquals((long)64L, (long)KAFKA_CHANNEL.read());
        Assertions.assertEquals((int)68, (int)KAFKA_CHANNEL.currentReceive().bytesRead());
        Assertions.assertNull((Object)KAFKA_CHANNEL.maybeCompleteReceive());
        Mockito.reset((Object[])new TransportLayer[]{TRANSPORT});
        Mockito.when((Object)TRANSPORT.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).put(TestUtils.randomBytes(64));
            return 64;
        });
        Assertions.assertEquals((long)64L, (long)KAFKA_CHANNEL.read());
        Assertions.assertEquals((int)132, (int)KAFKA_CHANNEL.currentReceive().bytesRead());
        Assertions.assertNotNull((Object)KAFKA_CHANNEL.maybeCompleteReceive());
        Assertions.assertNull((Object)KAFKA_CHANNEL.currentReceive());
    }

    @Test
    public void testChannelTotalServiceTimeMetrics() throws IOException {
        TransportLayer sslTransportLayer = (TransportLayer)Mockito.mock(SslTransportLayer.class);
        SaslServerAuthenticator saslServerAuthenticator = (SaslServerAuthenticator)Mockito.mock(SaslServerAuthenticator.class);
        ChannelReadinessMock mockProperties = new ChannelReadinessMock();
        mockProperties.shouldHandshake = true;
        mockProperties.shouldAuthenticate = true;
        mockProperties.shouldHandleProxy = true;
        ((SaslServerAuthenticator)Mockito.doAnswer(invocation -> {
            if (mockProperties.shouldAuthenticate && !mockProperties.authenticationCompleted) {
                MOCK_TIME.sleep(mockProperties.authenticationTime.toMillis());
                mockProperties.authenticationCompleted = true;
            }
            return null;
        }).when((Object)saslServerAuthenticator)).authenticate();
        ((SaslServerAuthenticator)Mockito.doAnswer(invocation -> mockProperties.authenticationCompleted).when((Object)saslServerAuthenticator)).complete();
        ((TransportLayer)Mockito.doAnswer(invocation -> {
            if (mockProperties.shouldHandleProxy && !mockProperties.proxyHandlingCompleted) {
                mockProperties.proxyHandlingCompleted = true;
            }
            return null;
        }).when((Object)sslTransportLayer)).handleProxyProtocol();
        ((TransportLayer)Mockito.doAnswer(invocation -> mockProperties.proxyHandlingCompleted).when((Object)sslTransportLayer)).proxyProtocolReady();
        ((TransportLayer)Mockito.doAnswer(invocation -> {
            if (mockProperties.shouldHandshake && !mockProperties.handshakeCompleted) {
                MOCK_TIME.sleep(mockProperties.handshakeTime.toMillis());
                mockProperties.handshakeCompleted = true;
            }
            return null;
        }).when((Object)sslTransportLayer)).handshake();
        ((TransportLayer)Mockito.doAnswer(invocation -> mockProperties.handshakeCompleted && mockProperties.proxyHandlingCompleted).when((Object)sslTransportLayer)).ready();
        KafkaChannel kafkaChannel = new KafkaChannel(CHANNEL_ID, sslTransportLayer, () -> saslServerAuthenticator, 1024, (AsyncAuthExecutor)new MockAsyncAuthExecutor(), POOL, METADATA_REGISTRY, (BrokerInterceptor)new DefaultBrokerInterceptor(), MOCK_TIME, true, false, null);
        kafkaChannel.setConnectionRegistrationTime(mockProperties.registrationTime.toNanos());
        kafkaChannel.prepare();
        ((SaslServerAuthenticator)Mockito.verify((Object)saslServerAuthenticator, (VerificationMode)Mockito.times((int)1))).authenticate();
        ((SaslServerAuthenticator)Mockito.verify((Object)saslServerAuthenticator, (VerificationMode)Mockito.times((int)2))).complete();
        ((TransportLayer)Mockito.verify((Object)sslTransportLayer, (VerificationMode)Mockito.times((int)1))).handshake();
        ((TransportLayer)Mockito.verify((Object)sslTransportLayer, (VerificationMode)Mockito.times((int)3))).ready();
        Assertions.assertEquals((long)mockProperties.handshakeTime.toNanos(), (long)kafkaChannel.metrics().transportHandshakeTimeNanos());
        Assertions.assertEquals((long)mockProperties.authenticationTime.toNanos(), (long)kafkaChannel.metrics().authenticationTimeNanos());
        Assertions.assertEquals((long)(mockProperties.registrationTime.toNanos() + mockProperties.handshakeTime.toNanos() + mockProperties.authenticationTime.toNanos()), (long)kafkaChannel.metrics().computeConnectionLocalServiceTimeNanos());
    }

    private Duration randomTimeDuration() {
        Random random = new Random(System.nanoTime());
        return Duration.ofMillis(1 + random.nextInt(10));
    }

    @Test
    public void testSocketAddressWithoutProxyProtocol() throws IOException {
        KafkaChannel channel = this.createKafkaChannel(new ProxyProtocolEngineFactory(ProxyProtocol.NONE));
        Assertions.assertEquals((Object)KafkaChannel.ChannelProxyState.PROXY_PROCESSED, (Object)channel.proxyState());
        channel.prepare();
        Assertions.assertEquals((Object)LOOPBACK_SOCKET_ADDRESS, (Object)channel.socketAddress());
        Assertions.assertEquals((Object)KafkaChannel.ChannelProxyState.PROXY_PROCESSED, (Object)channel.proxyState());
    }

    @Test
    public void testSocketAddressWithProxyProtocol() throws IOException {
        InetAddress clientAddress = InetAddress.getByName("10.10.10.10");
        this.testSocketAddress(new ProxyProtocolEngineFactory(() -> new TestProxyProtocolEngine(clientAddress, 9092)), clientAddress);
    }

    @Test
    public void testUnreadableSocket() throws IOException {
        SelectionKey key = (SelectionKey)Mockito.mock(SelectionKey.class);
        Mockito.when((Object)key.isReadable()).thenReturn((Object)false).thenReturn((Object)true);
        SocketChannel socketChannel = (SocketChannel)Mockito.mock(SocketChannel.class);
        Mockito.when((Object)socketChannel.read((ByteBuffer)Mockito.any(ByteBuffer.class))).thenReturn((Object)-1);
        KafkaChannel channel = this.createKafkaChannel(new ProxyProtocolEngineFactory(ProxyProtocol.V1), key, socketChannel);
        Assertions.assertEquals((Object)KafkaChannel.ChannelProxyState.PROXY_PENDING, (Object)channel.proxyState());
        channel.prepare();
        Assertions.assertEquals((Object)KafkaChannel.ChannelProxyState.PROXY_PENDING, (Object)channel.proxyState());
        Assertions.assertFalse((boolean)channel.hasBytesBuffered());
        Assertions.assertThrows(EOFException.class, () -> ((KafkaChannel)channel).prepare());
    }

    @Test
    public void testRequestSequenceId() throws IOException {
        ArgumentCaptor sizeCaptor = ArgumentCaptor.forClass(Integer.class);
        Mockito.when((Object)POOL.tryAllocate(((Integer)sizeCaptor.capture()).intValue())).thenAnswer(invocation -> ByteBuffer.allocate((Integer)sizeCaptor.getValue()));
        ArgumentCaptor bufferCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
        Mockito.when((Object)TRANSPORT.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).putInt(4);
            return 4;
        });
        Assertions.assertNull((Object)KAFKA_CHANNEL.currentReceive());
        for (int i = 1; i < 5; ++i) {
            KAFKA_CHANNEL.read();
            Assertions.assertEquals((long)i, (long)KAFKA_CHANNEL.currentReceive().sequenceId());
            KAFKA_CHANNEL.maybeCompleteReceive();
        }
    }

    private void testSocketAddress(ProxyProtocolEngineFactory proxyProtocolEngineFactory, InetAddress expectedAddress) throws IOException {
        KafkaChannel channel = this.createKafkaChannel(proxyProtocolEngineFactory);
        Assertions.assertEquals((Object)KafkaChannel.ChannelProxyState.PROXY_PENDING, (Object)channel.proxyState());
        channel.prepare();
        Assertions.assertEquals((Object)KafkaChannel.ChannelProxyState.PROXY_READY, (Object)channel.proxyState());
        channel.proxyState(KafkaChannel.ChannelProxyState.PROXY_PROCESSED);
        channel.prepare();
        Assertions.assertEquals((Object)KafkaChannel.ChannelProxyState.PROXY_PROCESSED, (Object)channel.proxyState());
        Assertions.assertEquals((Object)expectedAddress, (Object)channel.socketAddress());
    }

    private KafkaChannel createKafkaChannel(ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        return this.createKafkaChannel(proxyProtocolEngineFactory, null, null);
    }

    private KafkaChannel createKafkaChannel(ProxyProtocolEngineFactory proxyProtocolEngineFactory, SelectionKey key, SocketChannel channel) {
        PlaintextChannelBuilder channelBuilder = new PlaintextChannelBuilder(Mode.SERVER, new ListenerName("EXTERNAL"), proxyProtocolEngineFactory);
        channelBuilder.configure(Collections.emptyMap());
        if (key == null) {
            key = (SelectionKey)Mockito.mock(SelectionKey.class);
            Mockito.when((Object)key.isReadable()).thenReturn((Object)true);
        }
        if (channel == null) {
            channel = (SocketChannel)Mockito.mock(SocketChannel.class);
        }
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)key.channel()).thenReturn((Object)channel);
        Mockito.when((Object)channel.socket()).thenReturn((Object)socket);
        Mockito.when((Object)socket.getInetAddress()).thenReturn((Object)LOOPBACK_SOCKET_ADDRESS);
        return channelBuilder.buildChannel(CHANNEL_ID, key, 1024, (AsyncAuthExecutor)new MockAsyncAuthExecutor(), POOL, METADATA_REGISTRY, MOCK_TIME);
    }

    private class ChannelReadinessMock {
        Duration registrationTime;
        Duration handshakeTime;
        Duration authenticationTime;
        boolean shouldHandleProxy;
        boolean shouldHandshake;
        boolean shouldAuthenticate;
        boolean proxyHandlingCompleted;
        boolean handshakeCompleted;
        boolean authenticationCompleted;

        public ChannelReadinessMock() {
            this.registrationTime = KafkaChannelTest.this.randomTimeDuration();
            this.handshakeTime = KafkaChannelTest.this.randomTimeDuration();
            this.authenticationTime = KafkaChannelTest.this.randomTimeDuration();
        }
    }
}

