/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.interceptor;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.interceptor.ConfluentCloudBrokerInterceptor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConfluentCloudBrokerInterceptorTest {
    private Metrics metrics;
    private BrokerInterceptor interceptor;

    @BeforeEach
    public void setUp() {
        this.setUp((BrokerInterceptor)new ConfluentCloudBrokerInterceptor());
    }

    protected void setUp(BrokerInterceptor brokerInterceptor) {
        this.metrics = new Metrics();
        this.interceptor = brokerInterceptor;
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testClusterLinkRequests() {
        Uuid linkId = Uuid.randomUuid();
        RequestHeaderData headerData = new RequestHeaderData().setClusterLinkId(linkId).setClientId("clientId").setCorrelationId(1).setRequestApiKey(ApiKeys.API_VERSIONS.id).setRequestApiVersion(ApiKeys.API_VERSIONS.latestVersion());
        RequestContext context = this.requestContext(headerData, SecurityProtocol.PLAINTEXT);
        ApiVersionsRequest apiVersionsRequestequest = new ApiVersionsRequest(new ApiVersionsRequestData(), ApiKeys.API_VERSIONS.latestVersion());
        context.parseRequest(apiVersionsRequestequest.serialize());
        Assertions.assertEquals((Object)false, (Object)context.shouldIntercept());
        headerData = new RequestHeaderData().setClusterLinkId(linkId).setClientId("clientId").setCorrelationId(1).setRequestApiKey(ApiKeys.METADATA.id).setRequestApiVersion(ApiKeys.METADATA.latestVersion());
        context = this.requestContext(headerData, SecurityProtocol.PLAINTEXT);
        MetadataRequest metadataRequest = new MetadataRequest(new MetadataRequestData(), ApiKeys.METADATA.latestVersion());
        context.parseRequest(metadataRequest.serialize());
        Assertions.assertEquals((Object)false, (Object)context.shouldIntercept());
        metadataRequest = new MetadataRequest(new MetadataRequestData().setTopics(null), ApiKeys.METADATA.latestVersion());
        context.parseRequest(metadataRequest.serialize());
        Assertions.assertEquals((Object)true, (Object)context.shouldIntercept());
        metadataRequest = new MetadataRequest(new MetadataRequestData().setTopics(Collections.emptyList()), 0);
        context.parseRequest(metadataRequest.serialize());
        Assertions.assertEquals((Object)true, (Object)context.shouldIntercept());
        MetadataRequestData.MetadataRequestTopic topic = new MetadataRequestData.MetadataRequestTopic().setName("test-topic");
        metadataRequest = new MetadataRequest(new MetadataRequestData().setTopics(Collections.singletonList(topic)), ApiKeys.METADATA.latestVersion());
        context.parseRequest(metadataRequest.serialize());
        Assertions.assertEquals((Object)true, (Object)context.shouldIntercept());
        headerData = new RequestHeaderData().setClusterLinkId(linkId).setClientId("clientId").setCorrelationId(1).setRequestApiKey(ApiKeys.DESCRIBE_CLUSTER.id).setRequestApiVersion(ApiKeys.DESCRIBE_CLUSTER.latestVersion());
        context = this.requestContext(headerData, SecurityProtocol.PLAINTEXT);
        DescribeClusterRequest describeClusterRequest = new DescribeClusterRequest(new DescribeClusterRequestData(), ApiKeys.DESCRIBE_CLUSTER.latestVersion());
        context.parseRequest(describeClusterRequest.serialize());
        Assertions.assertEquals((Object)true, (Object)context.shouldIntercept());
        context = this.requestContext(headerData, SecurityProtocol.SSL);
        context.parseRequest(describeClusterRequest.serialize());
        Assertions.assertEquals((Object)true, (Object)context.shouldIntercept());
        context = this.requestContext(headerData, SecurityProtocol.SASL_PLAINTEXT);
        context.parseRequest(describeClusterRequest.serialize());
        Assertions.assertEquals((Object)true, (Object)context.shouldIntercept());
        context = this.requestContext(headerData, SecurityProtocol.SASL_SSL);
        context.parseRequest(describeClusterRequest.serialize());
        Assertions.assertEquals((Object)false, (Object)context.shouldIntercept());
    }

    private RequestContext requestContext(RequestHeaderData headerData, SecurityProtocol securityProtocol) {
        return this.interceptor.newContext(new RequestHeader(headerData, 2), "0", -1L, InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, null, this.metrics, null, false, Optional.empty(), null, null);
    }
}

