/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.datagen;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.datagen.DataGenProducer;
import io.confluent.ksql.datagen.SchemaRegistryClientFactory;
import io.confluent.ksql.datagen.SerializerFactory;
import io.confluent.ksql.logging.processing.NoopProcessingLogContext;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.GenericKeySerDe;
import io.confluent.ksql.serde.GenericRowSerDe;
import io.confluent.ksql.serde.delimited.DelimitedFormat;
import io.confluent.ksql.util.KsqlConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serializer;

final class ProducerFactory {
    private static final GenericKeySerDe KEY_SERDE_FACTORY = new GenericKeySerDe();
    private static final GenericRowSerDe VALUE_SERDE_FACTORY = new GenericRowSerDe();

    private ProducerFactory() {
    }

    static DataGenProducer getProducer(Format keyFormat, Format valueFormat, String valueDelimiter, Properties props) {
        KsqlConfig ksqlConfig = new KsqlConfig((Map)props);
        Optional<SchemaRegistryClient> srClient = SchemaRegistryClientFactory.getSrClient(keyFormat, valueFormat, ksqlConfig);
        SerializerFactory<GenericKey> keySerializerFactory = ProducerFactory.keySerializerFactory(keyFormat, ksqlConfig, srClient);
        HashMap<String, String> formatInfoProperties = new HashMap<String, String>();
        if (valueDelimiter != null) {
            if (!(valueFormat instanceof DelimitedFormat)) {
                throw new IllegalArgumentException("valueDelimiter can only be specified with delimited format");
            }
            formatInfoProperties.put("delimiter", valueDelimiter);
        }
        SerializerFactory<GenericRow> valueSerializerFactory = ProducerFactory.valueSerializerFactory(valueFormat, ksqlConfig, srClient, formatInfoProperties);
        return new DataGenProducer(keySerializerFactory, valueSerializerFactory);
    }

    private static SerializerFactory<GenericKey> keySerializerFactory(final Format keyFormat, final KsqlConfig ksqlConfig, final Optional<SchemaRegistryClient> srClient) {
        return new SerializerFactory<GenericKey>(){

            @Override
            public Format format() {
                return keyFormat;
            }

            @Override
            public Serializer<GenericKey> create(PersistenceSchema schema) {
                return KEY_SERDE_FACTORY.create(FormatInfo.of((String)keyFormat.name()), schema, ksqlConfig, srClient::get, "", NoopProcessingLogContext.INSTANCE, Optional.empty()).serializer();
            }
        };
    }

    private static SerializerFactory<GenericRow> valueSerializerFactory(final Format valueFormat, final KsqlConfig ksqlConfig, final Optional<SchemaRegistryClient> srClient, final Map<String, String> formatInfoProperties) {
        return new SerializerFactory<GenericRow>(){

            @Override
            public Format format() {
                return valueFormat;
            }

            @Override
            public Serializer<GenericRow> create(PersistenceSchema schema) {
                return VALUE_SERDE_FACTORY.create(FormatInfo.of((String)valueFormat.name(), (Map)formatInfoProperties), schema, ksqlConfig, srClient::get, "", NoopProcessingLogContext.INSTANCE, Optional.empty()).serializer();
            }
        };
    }
}

