/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.datagen;

import io.confluent.avro.random.generator.Generator;
import io.confluent.connect.avro.AvroData;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.datagen.DataGenSchemaUtil;
import io.confluent.ksql.datagen.SessionManager;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.serde.connect.ConnectSchemas;
import io.confluent.ksql.util.Pair;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class RowGenerator {
    private static final ColumnName KEY_COL_NAME = ColumnName.of((String)"Key");
    private final Set<String> allTokens = new HashSet<String>();
    private final Map<String, Integer> sessionMap = new HashMap<String, Integer>();
    private final Set<Integer> allocatedIds = new HashSet<Integer>();
    private final Generator generator;
    private final AvroData avroData;
    private final SessionManager sessionManager = new SessionManager();
    private final ConnectSchema valueSchema;
    private final LogicalSchema schema;
    private final int keyFieldIndex;
    private final Optional<Integer> timestampFieldIndex;

    public RowGenerator(Generator generator, String keyFieldName, Optional<String> timestampFieldName) {
        this.generator = Objects.requireNonNull(generator, "generator");
        this.avroData = new AvroData(1);
        this.schema = RowGenerator.buildLogicalSchema(generator, this.avroData, keyFieldName);
        this.valueSchema = ConnectSchemas.columnsToConnectSchema((List)this.schema.value());
        this.keyFieldIndex = this.schema.findValueColumn(ColumnName.of((String)keyFieldName)).map(Column::index).orElseThrow(IllegalStateException::new);
        this.timestampFieldIndex = timestampFieldName.isPresent() ? this.schema.findValueColumn(ColumnName.of((String)timestampFieldName.get())).map(column -> Optional.of(column.index())).orElseThrow(IllegalStateException::new) : Optional.empty();
    }

    public LogicalSchema schema() {
        return this.schema;
    }

    public Optional<Integer> getTimestampFieldIndex() {
        return this.timestampFieldIndex;
    }

    public Pair<GenericKey, GenericRow> generateRow() {
        Object generatedObject = this.generator.generate();
        if (!(generatedObject instanceof GenericRecord)) {
            throw new RuntimeException(String.format("Expected Avro Random Generator to return instance of GenericRecord, found %s instead", generatedObject.getClass().getName()));
        }
        GenericRecord randomAvroMessage = (GenericRecord)generatedObject;
        GenericRow row = new GenericRow(this.generator.schema().getFields().size());
        DateFormat timeformatter = null;
        String sessionisationValue = null;
        for (Schema.Field field : this.generator.schema().getFields()) {
            boolean isSession = field.schema().getProp("session") != null;
            boolean isSessionSiblingIntHash = field.schema().getProp("session-sibling-int-hash") != null;
            String timeFormatFromLong = field.schema().getProp("format_as_time");
            if (isSession) {
                String newCurrentValue;
                String currentValue = (String)randomAvroMessage.get(field.name());
                sessionisationValue = newCurrentValue = this.handleSessionisationOfValue(this.sessionManager, currentValue);
                row.append((Object)newCurrentValue);
                continue;
            }
            if (isSessionSiblingIntHash && sessionisationValue != null) {
                this.handleSessionSiblingField(randomAvroMessage, row, sessionisationValue, field);
                continue;
            }
            if (timeFormatFromLong != null) {
                Date date = new Date(System.currentTimeMillis());
                if (timeFormatFromLong.equals("unix_long")) {
                    row.append((Object)date.getTime());
                    continue;
                }
                if (timeformatter == null) {
                    timeformatter = new SimpleDateFormat(timeFormatFromLong);
                }
                row.append((Object)timeformatter.format(date));
                continue;
            }
            Object value = randomAvroMessage.get(field.name());
            if (value instanceof GenericData.Record) {
                Field ksqlField = this.valueSchema.field(field.name());
                GenericData.Record record = (GenericData.Record)value;
                Object ksqlValue = this.avroData.toConnectData(record.getSchema(), (Object)record).value();
                row.append(DataGenSchemaUtil.getOptionalValue(ksqlField.schema(), ksqlValue));
                continue;
            }
            row.append(value);
        }
        GenericKey key = GenericKey.genericKey((Object[])new Object[]{row.get(this.keyFieldIndex)});
        return Pair.of((Object)key, (Object)row);
    }

    private String handleSessionisationOfValue(SessionManager sessionManager, String currentValue) {
        this.allTokens.add(currentValue);
        if (sessionManager.isActive(currentValue)) {
            sessionManager.isActiveAndExpire(currentValue);
            return currentValue;
        }
        if (sessionManager.getActiveSessionCount() > sessionManager.getMaxSessions()) {
            return sessionManager.getRandomActiveToken();
        }
        String expired = sessionManager.getActiveSessionThatHasExpired();
        if (expired != null) {
            return expired;
        }
        String value = null;
        for (String token : this.allTokens) {
            if (value != null || sessionManager.isActive(token) || sessionManager.isExpired(token)) continue;
            value = token;
        }
        if (value == null) {
            value = sessionManager.recycleOldestExpired();
            if (value == null) {
                throw new RuntimeException("Ran out of tokens to rejuice - increase session-duration (300s), reduce-number of sessions(5), number of tokens in the avro template");
            }
            sessionManager.newSession(value);
            return value;
        }
        sessionManager.newSession(value);
        return currentValue;
    }

    private void handleSessionSiblingField(GenericRecord randomAvroMessage, GenericRow row, String sessionisationValue, Schema.Field field) {
        try {
            Schema.Type type = field.schema().getType();
            if (type == Schema.Type.INT) {
                row.append((Object)this.mapSessionValueToSibling(sessionisationValue, field));
            } else {
                row.append(randomAvroMessage.get(field.name()));
            }
        }
        catch (Exception err) {
            row.append(randomAvroMessage.get(field.name()));
        }
    }

    private int mapSessionValueToSibling(String sessionisationValue, Schema.Field field) {
        if (!this.sessionMap.containsKey(sessionisationValue)) {
            LinkedHashMap properties = (LinkedHashMap)field.schema().getObjectProps().get("arg.properties");
            Integer max = (Integer)((LinkedHashMap)properties.get("range")).get("max");
            int vvalue = Math.abs(sessionisationValue.hashCode() % max);
            int foundValue = -1;
            if (this.allocatedIds.contains(vvalue)) {
                for (int i = 0; i < max; ++i) {
                    if (this.allocatedIds.contains(i)) continue;
                    foundValue = i;
                }
                if (foundValue == -1) {
                    System.out.println("Failed to allocate Id :" + sessionisationValue + ", reusing " + vvalue);
                    foundValue = vvalue;
                }
                vvalue = foundValue;
            }
            this.allocatedIds.add(vvalue);
            this.sessionMap.put(sessionisationValue, vvalue);
        }
        return this.sessionMap.get(sessionisationValue);
    }

    private static LogicalSchema buildLogicalSchema(Generator generator, AvroData avroData, String keyFieldName) {
        Schema connectSchema = avroData.toConnectSchema(generator.schema());
        Field keyField = connectSchema.field(keyFieldName);
        if (keyField == null) {
            throw new IllegalArgumentException("key field does not exist in schema: " + keyFieldName);
        }
        LogicalSchema.Builder schemaBuilder = LogicalSchema.builder();
        SchemaConverters.ConnectToSqlTypeConverter converter = SchemaConverters.connectToSqlConverter();
        schemaBuilder.keyColumn(KEY_COL_NAME, converter.toSqlType(keyField.schema()));
        connectSchema.fields().forEach(f -> schemaBuilder.valueColumn(ColumnName.of((String)f.name()), converter.toSqlType(f.schema())));
        return schemaBuilder.build();
    }
}

