/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.datagen;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SessionManager {
    private Duration maxSessionDuration = Duration.ofSeconds(30L);
    private int maxSessions = 5;
    Map<String, SessionObject> expiredSessions = new HashMap<String, SessionObject>();
    Map<String, SessionObject> activeSessions = new HashMap<String, SessionObject>();

    public void setMaxSessionDurationSeconds(int maxSessionDurationSeconds) {
        this.maxSessionDuration = Duration.ofSeconds(maxSessionDurationSeconds);
    }

    public void setMaxSessionDuration(Duration duration) {
        this.maxSessionDuration = Objects.requireNonNull(duration, "duration");
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public boolean isActive(String sessionId) {
        return this.activeSessions.containsKey(sessionId);
    }

    public boolean isExpired(String sessionId) {
        if (this.activeSessions.containsKey(sessionId)) {
            SessionObject sessionObject = this.activeSessions.get(sessionId);
            return sessionObject.isExpired();
        }
        return this.expiredSessions.containsKey(sessionId);
    }

    public boolean isActiveAndExpire(String sessionId) {
        SessionObject sessionObject;
        boolean b = this.isActive(sessionId);
        if (b && (sessionObject = this.activeSessions.get(sessionId)).isExpired()) {
            SessionObject removed = this.activeSessions.remove(sessionId);
            this.expiredSessions.put(sessionId, removed);
            return false;
        }
        return b;
    }

    public void newSession(String sessionToken) {
        if (this.activeSessions.containsKey(sessionToken)) {
            throw new RuntimeException("Session" + sessionToken + " already exists");
        }
        this.activeSessions.putIfAbsent(sessionToken, new SessionObject(this.maxSessionDuration));
    }

    public boolean isExpiredSession(String sessionId) {
        return this.expiredSessions.containsKey(sessionId);
    }

    public String recycleOldestExpired() {
        Map.Entry<String, SessionObject> oldest = null;
        for (Map.Entry<String, SessionObject> entry : this.expiredSessions.entrySet()) {
            if (oldest != null && entry.getValue().createdMs >= oldest.getValue().createdMs) continue;
            oldest = entry;
        }
        if (oldest != null) {
            this.expiredSessions.remove(oldest.getKey());
            return oldest.getKey();
        }
        return null;
    }

    public String getRandomActiveToken() {
        int randomIndex = (int)(Math.random() * (double)this.activeSessions.size());
        return new ArrayList<String>(this.activeSessions.keySet()).get(randomIndex);
    }

    public String getActiveSessionThatHasExpired() {
        return this.activeSessions.entrySet().stream().filter(entry -> ((SessionObject)entry.getValue()).isExpired()).findFirst().map(entry -> {
            this.expiredSessions.put((String)entry.getKey(), this.activeSessions.remove(entry.getKey()));
            return (String)entry.getKey();
        }).orElse(null);
    }

    public String getToken(String s) {
        if (this.activeSessions.containsKey(s)) {
            return s;
        }
        if (this.activeSessions.size() == this.maxSessions) {
            int randomIndex = (int)(Math.random() * (double)this.activeSessions.size());
            return new ArrayList<String>(this.activeSessions.keySet()).get(randomIndex);
        }
        if (this.expiredSessions.containsKey(s)) {
            this.expiredSessions.remove(s);
            return s;
        }
        return s;
    }

    public int getActiveSessionCount() {
        return this.activeSessions.size();
    }

    public String randomActiveSession() {
        if (this.activeSessions.size() == 0) {
            return null;
        }
        return this.activeSessions.keySet().iterator().next();
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public static class SessionObject {
        private final long createdMs = System.currentTimeMillis();
        private final Duration sessionDuration;

        public SessionObject(Duration duration) {
            this.sessionDuration = Duration.ofMillis(duration.toMillis());
        }

        public boolean isExpired() {
            return this.age().toMillis() > this.sessionDuration.toMillis();
        }

        private Duration age() {
            return Duration.ofMillis(System.currentTimeMillis() - this.createdMs);
        }

        public String toString() {
            return "Session:" + new Date(this.createdMs);
        }
    }
}

