/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.yammer.metrics.core.Gauge;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.common.InterBrokerSendThread;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.PendingCompleteTxnAndMarkerEntry;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\u001du!\u0002\u0015*\u0011\u0003\u0001d!\u0002\u001a*\u0011\u0003\u0019\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\"\u0002\u001f\u0002\t\u0003id\u0001\u0002\u001a*\u0001}B\u0001\u0002\u0014\u0003\u0003\u0002\u0003\u0006I!\u0014\u0005\t'\u0012\u0011\t\u0011)A\u0005)\"Aq\u000b\u0002B\u0001B\u0003%\u0001\f\u0003\u0005d\t\t\u0005\t\u0015!\u0003e\u0011!9GA!A!\u0002\u0013A\u0007\"\u0002\u001e\u0005\t\u0003q\u0007b\u0002;\u0005\u0005\u0004%I!\u001e\u0005\u0007{\u0012\u0001\u000b\u0011\u0002<\t\u000fy$!\u0019!C\u0005\u007f\"A\u0011Q\u0002\u0003!\u0002\u0013\t\t\u0001C\u0005\u0002\u0010\u0011\u0011\r\u0011\"\u0003\u0002\u0012!A\u0011q\u0006\u0003!\u0002\u0013\t\u0019\u0002C\u0005\u00022\u0011\u0011\r\u0011\"\u0003\u00024!A\u0011Q\u0007\u0003!\u0002\u0013\tI\u0003C\u0005\u00028\u0011\u0011\r\u0011\"\u0003\u0002:!A\u00111\u000b\u0003!\u0002\u0013\tY\u0004C\u0005\u0002V\u0011\u0011\r\u0011\"\u0003\u0002X!A\u0011Q\u000f\u0003!\u0002\u0013\tI\u0006C\u0005\u0002x\u0011\u0011\r\u0011\"\u0001\u0002z!A\u0011\u0011\u0011\u0003!\u0002\u0013\tY\bC\u0004\u0002\u0004\u0012!\t%!\"\t\u0011\u00055E\u0001\"\u0001*\u0003\u001fC\u0001\"a'\u0005\t\u0003I\u00131\u0007\u0005\t\u0003;#A\u0011A\u0015\u0002 \"9\u00111\u0018\u0003\u0005\u0002\u0005\u0015\u0005bBA_\t\u0011\u0005\u0013q\u0018\u0005\b\u00033$A\u0011BAn\u0011\u001d\t\t\u000f\u0002C\u0001\u0003GDqA!\u0004\u0005\t\u0003\u0011y\u0001C\u0004\u0003\u0012\u0011!IAa\u0005\t\u000f\tuA\u0001\"\u0001\u0003 !9!Q\u0005\u0003\u0005\n\t\u001d\u0002b\u0002B\u0017\t\u0011\u0005!q\u0006\u0005\b\u00057\"A\u0011\u0001B/\u0011\u001d\u0011\u0019\u0007\u0002C\u0001\u0005K\nq\u0004\u0016:b]N\f7\r^5p]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0015\tQ3&A\u0006ue\u0006t7/Y2uS>t'B\u0001\u0017.\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u00039\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u00022\u00035\t\u0011FA\u0010Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\u001c\"!\u0001\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001'A\u0003baBd\u0017\u0010F\u0007?\u0005S\u0012YGa\u001e\u0003z\tm$Q\u0010\t\u0003c\u0011\u00192\u0001\u0002!G!\t\tE)D\u0001C\u0015\t\u0019U&\u0001\u0004d_6lwN\\\u0005\u0003\u000b\n\u0013Q#\u00138uKJ\u0014%o\\6feN+g\u000e\u001a+ie\u0016\fG\r\u0005\u0002H\u00156\t\u0001J\u0003\u0002J[\u0005)Q\u000f^5mg&\u00111\n\u0013\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u0011a*U\u0007\u0002\u001f*\u0011\u0001+L\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005I{%aC&bM.\f7i\u001c8gS\u001e\fQ\"\\3uC\u0012\fG/Y\"bG\",\u0007C\u0001(V\u0013\t1vJA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000e]\u0016$xo\u001c:l\u00072LWM\u001c;\u0011\u0005e\u000bW\"\u0001.\u000b\u0005mc\u0016aB2mS\u0016tGo\u001d\u0006\u0003]uS!AX0\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0017aA8sO&\u0011!M\u0017\u0002\u000e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0002\u001fQDhn\u0015;bi\u0016l\u0015M\\1hKJ\u0004\"!M3\n\u0005\u0019L#a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003\u0011!\u0018.\\3\u0011\u0005%dW\"\u00016\u000b\u0005%['BA\"]\u0013\ti'N\u0001\u0003US6,GC\u0002 paF\u00148\u000fC\u0003M\u0015\u0001\u0007Q\nC\u0003T\u0015\u0001\u0007A\u000bC\u0003X\u0015\u0001\u0007\u0001\fC\u0003d\u0015\u0001\u0007A\rC\u0003h\u0015\u0001\u0007\u0001.\u0001\u0007nKR\u0014\u0018nY:He>,\b/F\u0001w!\t980D\u0001y\u0015\tI(0A\u0004nKR\u0014\u0018nY:\u000b\u0005Ac\u0016B\u0001?y\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u000e[\u0016$(/[2t\u000fJ|W\u000f\u001d\u0011\u0002/%tG/\u001a:Ce>\\WM\u001d'jgR,g.\u001a:OC6,WCAA\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004W\u00069a.\u001a;x_J\\\u0017\u0002BA\u0006\u0003\u000b\u0011A\u0002T5ti\u0016tWM\u001d(b[\u0016\f\u0001$\u001b8uKJ\u0014%o\\6fe2K7\u000f^3oKJt\u0015-\\3!\u0003Ui\u0017M]6feN\fV/Z;f!\u0016\u0014(I]8lKJ,\"!a\u0005\u0011\u0011\u0005U\u0011qDA\u0012\u0003Si!!a\u0006\u000b\t\u0005e\u00111D\u0001\u000bG>t7-\u001e:sK:$(bAA\u000fm\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u0012q\u0003\u0002\u0004\u001b\u0006\u0004\bcA\u001b\u0002&%\u0019\u0011q\u0005\u001c\u0003\u0007%sG\u000fE\u00022\u0003WI1!!\f*\u00059!\u0006P\\'be.,'/U;fk\u0016\fa#\\1sW\u0016\u00148/U;fk\u0016\u0004VM\u001d\"s_.,'\u000fI\u0001\u001d[\u0006\u00148.\u001a:t#V,W/\u001a$peVs7N\\8x]\n\u0013xn[3s+\t\tI#A\u000fnCJ\\WM]:Rk\u0016,XMR8s+:\\gn\\<o\u0005J|7.\u001a:!\u0003Y!\bP\u001c'pO\u0006\u0003\b/\u001a8e%\u0016$(/_)vKV,WCAA\u001e!\u0019\ti$!\u0013\u0002N5\u0011\u0011q\b\u0006\u0005\u00033\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013\u0001B;uS2T!!a\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\nyDA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4Rk\u0016,X\rE\u00022\u0003\u001fJ1!!\u0015*\u0005I\u0001VM\u001c3j]\u001e\u001cu.\u001c9mKR,G\u000b\u001f8\u0002/QDh\u000eT8h\u0003B\u0004XM\u001c3SKR\u0014\u00180U;fk\u0016\u0004\u0013A\b;sC:\u001c\u0018m\u0019;j_:\u001cx+\u001b;i!\u0016tG-\u001b8h\u001b\u0006\u00148.\u001a:t+\t\tI\u0006\u0005\u0005\u0002>\u0005m\u0013qLA'\u0013\u0011\ti&a\u0010\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002b\u0005=d\u0002BA2\u0003W\u00022!!\u001a7\u001b\t\t9GC\u0002\u0002j=\na\u0001\u0010:p_Rt\u0014bAA7m\u00051\u0001K]3eK\u001aLA!!\u001d\u0002t\t11\u000b\u001e:j]\u001eT1!!\u001c7\u0003}!(/\u00198tC\u000e$\u0018n\u001c8t/&$\b\u000eU3oI&tw-T1sW\u0016\u00148\u000fI\u0001\u001eoJLG/\u001a+y]6\u000b'o[3sgJ+\u0017/^3tiZ+'o]5p]V\u0011\u00111\u0010\t\u0004k\u0005u\u0014bAA@m\t)1\u000b[8si\u0006qrO]5uKRCh.T1sW\u0016\u00148OU3rk\u0016\u001cHOV3sg&|g\u000eI\u0001\tg\",H\u000fZ8x]R\u0011\u0011q\u0011\t\u0004k\u0005%\u0015bAAFm\t!QK\\5u\u00039\tX/Z;f\r>\u0014(I]8lKJ$B!!%\u0002\u0018B)Q'a%\u0002*%\u0019\u0011Q\u0013\u001c\u0003\r=\u0003H/[8o\u0011\u001d\tIJ\u0007a\u0001\u0003G\t\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u0016cV,W/\u001a$peVs7N\\8x]\n\u0013xn[3s\u0003M\tG\rZ'be.,'o\u001d$pe\n\u0013xn[3s)!\t9)!)\u0002.\u0006E\u0006bBAR9\u0001\u0007\u0011QU\u0001\u0007EJ|7.\u001a:\u0011\t\u0005\u001d\u0016\u0011V\u0007\u0002W&\u0019\u00111V6\u0003\t9{G-\u001a\u0005\b\u0003_c\u0002\u0019AA\u0012\u0003E!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003gc\u0002\u0019AA[\u0003m\u0001XM\u001c3j]\u001e\u001cu.\u001c9mKR,G\u000b\u001f8B]\u0012l\u0015M]6feB\u0019\u0011'a.\n\u0007\u0005e\u0016F\u0001\u0011QK:$\u0017N\\4D_6\u0004H.\u001a;f)bt\u0017I\u001c3NCJ\\WM]#oiJL\u0018a\u0004:fiJLHj\\4BaB,g\u000eZ:\u0002!\u001d,g.\u001a:bi\u0016\u0014V-];fgR\u001cHCAAa!\u0019\t\u0019-!4\u0002T:!\u0011QYAe\u001d\u0011\t)'a2\n\u0003]J1!a37\u0003\u001d\u0001\u0018mY6bO\u0016LA!a4\u0002R\nA\u0011\n^3sC\ndWMC\u0002\u0002LZ\u00022!QAk\u0013\r\t9N\u0011\u0002\u001c%\u0016\fX/Z:u\u0003:$7i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\u0002%]\u0014\u0018\u000e^3Uq:\u001cu.\u001c9mKRLwN\u001c\u000b\u0005\u0003\u000f\u000bi\u000eC\u0004\u0002`~\u0001\r!!\u0014\u0002%A,g\u000eZ5oO\u000e{W\u000e\u001d7fi\u0016$\u0006P\\\u0001\u0014C\u0012$G\u000b\u001f8NCJ\\WM]:U_N+g\u000e\u001a\u000b\u000b\u0003\u000f\u000b)/!;\u0002z\n\r\u0001bBAtA\u0001\u0007\u00111E\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"Dq!a;!\u0001\u0004\ti/A\u0005uq:\u0014Vm];miB!\u0011q^A{\u001b\t\t\tPC\u0002\u0002t.\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003o\f\tPA\tUe\u0006t7/Y2uS>t'+Z:vYRDq!a?!\u0001\u0004\ti0A\u0006uq:lU\r^1eCR\f\u0007cA\u0019\u0002\u0000&\u0019!\u0011A\u0015\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\t\u000f\t\u0015\u0001\u00051\u0001\u0003\b\u0005Ya.Z<NKR\fG-\u0019;b!\r\t$\u0011B\u0005\u0004\u0005\u0017I#A\u0005+y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006\f\u0011D\\;n)bt7oV5uQB+g\u000eZ5oO6\u000b'o[3sgV\u0011\u00111E\u0001\u0019Q\u0006\u001c\b+\u001a8eS:<W*\u0019:lKJ\u001cHk\\,sSR,G\u0003\u0002B\u000b\u00057\u00012!\u000eB\f\u0013\r\u0011IB\u000e\u0002\b\u0005>|G.Z1o\u0011\u001d\tYP\ta\u0001\u0003{\fq#\\1zE\u0016<&/\u001b;f)bt7i\\7qY\u0016$\u0018n\u001c8\u0015\t\u0005\u001d%\u0011\u0005\u0005\b\u0005G\u0019\u0003\u0019AA0\u0003=!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017A\u0004;ss\u0006\u0003\b/\u001a8e)>dun\u001a\u000b\u0005\u0003\u000f\u0013I\u0003C\u0004\u0003,\u0011\u0002\r!!\u0014\u0002\u0019QDh\u000eT8h\u0003B\u0004XM\u001c3\u00025\u0005$G\r\u0016=o\u001b\u0006\u00148.\u001a:t)>\u0014%o\\6feF+X-^3\u0015\u0019\u0005\u001d%\u0011\u0007B\u001e\u0005\u007f\u0011\u0019E!\u0012\t\u000f\tMR\u00051\u0001\u00036\u0005Q\u0001O]8ek\u000e,'/\u00133\u0011\u0007U\u00129$C\u0002\u0003:Y\u0012A\u0001T8oO\"9!QH\u0013A\u0002\u0005m\u0014!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eC\u0004\u0003B\u0015\u0002\r!!<\u0002\rI,7/\u001e7u\u0011\u001d\ty.\na\u0001\u0003\u001bBqAa\u0012&\u0001\u0004\u0011I%A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0019\u0011YE!\u0015\u0003V5\u0011!Q\n\u0006\u0005\u0005\u001f\nY\"A\u0005j[6,H/\u00192mK&!!1\u000bB'\u0005\r\u0019V\r\u001e\t\u0005\u0003O\u00139&C\u0002\u0003Z-\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0011sK6|g/Z'be.,'o\u001d$peRCh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002\b\n}\u0003b\u0002B1M\u0001\u0007\u00111E\u0001\u0014ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0017\nZ\u0001\u0014e\u0016lwN^3NCJ\\WM]:G_J$\u0006P\u001c\u000b\u0005\u0003\u000f\u00139\u0007C\u0004\u0002`\u001e\u0002\r!!\u0014\t\u000b1\u001b\u0001\u0019A'\t\re\u001c\u0001\u0019\u0001B7!\u0011\u0011yGa\u001d\u000e\u0005\tE$BA=l\u0013\u0011\u0011)H!\u001d\u0003\u000f5+GO]5dg\")1k\u0001a\u0001)\")1m\u0001a\u0001I\")qm\u0001a\u0001Q\"9!qP\u0002A\u0002\t\u0005\u0015A\u00037pO\u000e{g\u000e^3yiB\u0019\u0011Na!\n\u0007\t\u0015%N\u0001\u0006M_\u001e\u001cuN\u001c;fqR\u0004")
public class TransactionMarkerChannelManager
extends InterBrokerSendThread {
    private final MetadataCache metadataCache;
    private final TransactionStateManager txnStateManager;
    private final Time time;
    private final KafkaMetricsGroup metricsGroup;
    private final ListenerName interBrokerListenerName;
    private final scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker;
    private final TxnMarkerQueue markersQueueForUnknownBroker;
    private final LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue;
    private final ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers;
    private final short writeTxnMarkersRequestVersion;

    public static TransactionMarkerChannelManager apply(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, TransactionStateManager txnStateManager, Time time, LogContext logContext) {
        return TransactionMarkerChannelManager$.MODULE$.apply(config, metrics, metadataCache, txnStateManager, time, logContext);
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    private scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker() {
        return this.markersQueuePerBroker;
    }

    private TxnMarkerQueue markersQueueForUnknownBroker() {
        return this.markersQueueForUnknownBroker;
    }

    private LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue() {
        return this.txnLogAppendRetryQueue;
    }

    private ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers;
    }

    public short writeTxnMarkersRequestVersion() {
        return this.writeTxnMarkersRequestVersion;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.markersQueuePerBroker().clear();
    }

    public Option<TxnMarkerQueue> queueForBroker(int brokerId) {
        return this.markersQueuePerBroker().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
    }

    public TxnMarkerQueue queueForUnknownBroker() {
        return this.markersQueueForUnknownBroker();
    }

    /*
     * WARNING - void declaration
     */
    public void addMarkersForBroker(Node broker, int txnTopicPartition, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        Object object;
        void atomicGetOrUpdate_key;
        int brokerId = broker.id();
        Integer n = BoxesRunTime.boxToInteger((int)brokerId);
        scala.collection.concurrent.Map<Object, TxnMarkerQueue> atomicGetOrUpdate_map = this.markersQueuePerBroker();
        Option option = atomicGetOrUpdate_map.get((Object)atomicGetOrUpdate_key);
        if (option instanceof Some) {
            object = ((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnMarkerQueue atomicGetOrUpdate_value = TransactionMarkerChannelManager.$anonfun$addMarkersForBroker$1(this, brokerId, broker);
            object = atomicGetOrUpdate_map.putIfAbsent((Object)atomicGetOrUpdate_key, (Object)atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1(atomicGetOrUpdate_value));
        } else {
            throw new MatchError((Object)option);
        }
        Object var6_6 = null;
        n = null;
        option = null;
        Object var9_8 = null;
        TxnMarkerQueue brokerRequestQueue = (TxnMarkerQueue)object;
        brokerRequestQueue.destination_$eq(broker);
        brokerRequestQueue.addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Added marker ").append(pendingCompleteTxnAndMarker.txnMarkerEntry()).append(" for transactional id").append(" ").append(pendingCompleteTxnAndMarker.pendingCompleteTxn().transactionalId()).append(" to destination broker ").append(brokerId).toString());
    }

    public void retryLogAppends() {
        ArrayList txnLogAppendRetries = new ArrayList();
        this.txnLogAppendRetryQueue().drainTo(txnLogAppendRetries);
        txnLogAppendRetries.forEach(txnLogAppend -> {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Retry appending ").append(txnLogAppend).append(" transaction log").toString());
            this.tryAppendToLog((PendingCompleteTxn)txnLogAppend);
        });
    }

    @Override
    public Iterable<RequestAndCompletionHandler> generateRequests() {
        this.retryLogAppends();
        ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
        this.markersQueueForUnknownBroker().forEachTxnTopicPartition((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)x1$1.drainTo(pendingCompleteTxnAndMarkerEntries)));
        CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarkerEntries).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$2(check$ifrefutable$1))).foreach((Function1 & Serializable)pendingCompleteTxnAndMarker -> {
            TransactionMarkerChannelManager.$anonfun$generateRequests$3(this, pendingCompleteTxnAndMarker);
            return BoxedUnit.UNIT;
        });
        long currentTimeMs = this.time.milliseconds();
        return (Iterable)((IterableOps)((IterableOps)((IterableOps)this.markersQueuePerBroker().values().filter((Function1 & Serializable)brokerRequestQueue -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$4(this, brokerRequestQueue)))).map((Function1 & Serializable)brokerRequestQueue -> {
            ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
            brokerRequestQueue.forEachTxnTopicPartition((Function2 & Serializable)(x0$2, x1$2) -> BoxesRunTime.boxToInteger((int)x1$2.drainTo(pendingCompleteTxnAndMarkerEntries)));
            return new Tuple2((Object)brokerRequestQueue.destination(), pendingCompleteTxnAndMarkerEntries);
        })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$7(x0$3)))).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                Node node = (Node)x0$4._1();
                ArrayList entries = (ArrayList)x0$4._2();
                List markersToSend = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala((List)entries).asScala().map((Function1 & Serializable)x$4 -> x$4.txnMarkerEntry())).asJava();
                TransactionMarkerRequestCompletionHandler requestCompletionHandler = new TransactionMarkerRequestCompletionHandler(node.id(), $this.txnStateManager, this, entries);
                WriteTxnMarkersRequest.Builder request = new WriteTxnMarkersRequest.Builder(this.writeTxnMarkersRequestVersion(), markersToSend);
                return new RequestAndCompletionHandler(currentTimeMs, node, (AbstractRequest.Builder<? extends AbstractRequest>)request, requestCompletionHandler);
            }
            throw new MatchError(null);
        });
    }

    private void writeTxnCompletion(PendingCompleteTxn pendingCompleteTxn) {
        Option option;
        Errors errors;
        String transactionalId = pendingCompleteTxn.transactionalId();
        TransactionMetadata txnMetadata = pendingCompleteTxn.txnMetadata();
        TxnTransitMetadata newMetadata = pendingCompleteTxn.newMetadata();
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Completed sending transaction markers for ").append(transactionalId).append("; begin transition ").append("to ").append(newMetadata.txnState()).toString());
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors2)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("No longer the coordinator for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel appending ").append(newMetadata).append(" to transaction log").toString());
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(187).append("Loading the transaction partition that contains ").append(transactionalId).append(" while my ").append("current coordinator epoch is ").append(coordinatorEpoch).append("; so cancel appending ").append(newMetadata).append(" to ").append("transaction log since the loading process will continue the remaining work").toString());
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append(unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(116).append("Sending ").append(transactionalId).append("'s transaction markers for ").append(txnMetadata).append(" with ").append("coordinator epoch ").append(coordinatorEpoch).append(" succeeded, trying to append complete transaction log now").toString());
                    this.tryAppendToLog(new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata));
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(178).append("The cached metadata ").append(txnMetadata).append(" has changed to ").append(epochAndMetadata).append(" after ").append("completed sending the markers with coordinator epoch ").append(coordinatorEpoch).append("; abort ").append("transiting the metadata to ").append(newMetadata).append(" as it may have been updated by another process").toString());
                return;
            }
        }
        if (bl2 && None$.MODULE$.equals(option = (Option)right.value())) {
            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", ").append("but there is no metadata in the cache; this is not expected").toString();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(either);
    }

    public void addTxnMarkersToSend(int coordinatorEpoch, TransactionResult txnResult, TransactionMetadata txnMetadata, TxnTransitMetadata newMetadata) {
        String transactionalId = txnMetadata.transactionalId();
        PendingCompleteTxn pendingCompleteTxn = new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata);
        PendingCompleteTxn prev = this.transactionsWithPendingMarkers().put(transactionalId, pendingCompleteTxn);
        if (prev != null) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Replaced an existing pending complete txn ").append(prev).append(" with ").append(pendingCompleteTxn).append(" while adding markers to send.").toString());
        }
        this.addTxnMarkersToBrokerQueue(txnMetadata.producerId(), txnMetadata.producerEpoch(), txnResult, pendingCompleteTxn, (Set<TopicPartition>)txnMetadata.topicPartitions().toSet());
        this.maybeWriteTxnCompletion(transactionalId);
    }

    public int numTxnsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers().size();
    }

    private boolean hasPendingMarkersToWrite(TransactionMetadata txnMetadata) {
        return BoxesRunTime.unboxToBoolean(txnMetadata.inLock((JFunction0.mcZ.sp & Serializable)() -> txnMetadata.topicPartitions().nonEmpty()));
    }

    public void maybeWriteTxnCompletion(String transactionalId) {
        Option$.MODULE$.apply((Object)this.transactionsWithPendingMarkers().get(transactionalId)).foreach((Function1 & Serializable)pendingCompleteTxn -> {
            TransactionMarkerChannelManager.$anonfun$maybeWriteTxnCompletion$1(this, transactionalId, pendingCompleteTxn);
            return BoxedUnit.UNIT;
        });
    }

    private void tryAppendToLog(PendingCompleteTxn txnLogAppend) {
        this.txnStateManager.appendTransactionToLog(txnLogAppend.transactionalId(), txnLogAppend.coordinatorEpoch(), txnLogAppend.newMetadata(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
            this.appendCallback$1(error, txnLogAppend);
            return BoxedUnit.UNIT;
        }, (Function1<Errors, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$tryAppendToLog$7(x$5)), RequestLocal$.MODULE$.NoCaching());
    }

    public void addTxnMarkersToBrokerQueue(long producerId, short producerEpoch, TransactionResult result, PendingCompleteTxn pendingCompleteTxn, Set<TopicPartition> topicPartitions) {
        int txnTopicPartition = this.txnStateManager.partitionFor(pendingCompleteTxn.transactionalId());
        Map partitionsByDestination = topicPartitions.groupBy((Function1 & Serializable)topicPartition -> $this.metadataCache.getPartitionLeaderEndpoint(topicPartition.topic(), topicPartition.partition(), this.interBrokerListenerName()));
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        partitionsByDestination.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$addTxnMarkersToBrokerQueue$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$6 -> {
            if (x$6 != null) {
                Option broker = (Option)x$6._1();
                Set topicPartitions = (Set)x$6._2();
                if (broker != null && topicPartitions != null) {
                    if (broker instanceof Some) {
                        Node brokerNode = (Node)((Some)broker).value();
                        WriteTxnMarkersRequest.TxnMarkerEntry marker = new WriteTxnMarkersRequest.TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topicPartitions.toList()).asJava());
                        PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker = new PendingCompleteTxnAndMarkerEntry(pendingCompleteTxn, marker);
                        Node node = brokerNode;
                        Node node2 = Node.noNode();
                        if (!(node != null ? !node.equals(node2) : node2 != null)) {
                            this.markersQueueForUnknownBroker().addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
                            return BoxedUnit.UNIT;
                        }
                        this.addMarkersForBroker(brokerNode, txnTopicPartition, pendingCompleteTxnAndMarker);
                        return BoxedUnit.UNIT;
                    }
                    if (None$.MODULE$.equals(broker)) {
                        Option option;
                        String transactionalId = pendingCompleteTxn.transactionalId();
                        boolean bl = false;
                        Right right = null;
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
                        if (either instanceof Left) {
                            Errors error = (Errors)((Left)either).value();
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(127).append("Encountered ").append(error).append(" trying to fetch transaction metadata for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel sending markers to its partition leaders").toString());
                            return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                        }
                        if (either instanceof Right) {
                            bl = true;
                            right = (Right)either;
                            Option option2 = (Option)right.value();
                            if (option2 instanceof Some) {
                                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(144).append("The cached metadata has changed to ").append(epochAndMetadata).append(" (old coordinator epoch is ").append(coordinatorEpoch).append(") since preparing to send markers; cancel sending markers to its partition leaders").toString());
                                    return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                                }
                                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(161).append("Couldn't find leader endpoint for partitions ").append(topicPartitions).append(" while trying to send transaction markers for ").append(transactionalId).append(", these partitions are likely deleted already and hence can be skipped").toString());
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                txnMetadata.inLock((JFunction0.mcV.sp & Serializable)() -> topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
                                    txnMetadata.removePartition(topicPartition);
                                    return BoxedUnit.UNIT;
                                }));
                                this.maybeWriteTxnCompletion(transactionalId);
                                return BoxedUnit.UNIT;
                            }
                        }
                        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError(either);
                    }
                    throw new MatchError((Object)broker);
                }
            }
            throw new MatchError(x$6);
        });
        this.wakeup();
    }

    public void removeMarkersForTxnTopicPartition(int txnTopicPartitionId) {
        this.markersQueueForUnknownBroker().removeMarkersForTxnTopicPartition(txnTopicPartitionId).foreach((Function1 & Serializable)queue -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$1(this, txnTopicPartitionId, queue);
            return BoxedUnit.UNIT;
        });
        this.markersQueuePerBroker().foreach((Function1 & Serializable)x0$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$4(this, txnTopicPartitionId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void removeMarkersForTxn(PendingCompleteTxn pendingCompleteTxn) {
        String transactionalId = pendingCompleteTxn.transactionalId();
        if (!this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn)) {
            PendingCompleteTxn current = this.transactionsWithPendingMarkers().get(transactionalId);
            if (current != null) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Failed to remove pending marker entry ").append(current).append(" trying to remove ").append(pendingCompleteTxn).toString());
                return;
            }
            return;
        }
    }

    public final /* synthetic */ int kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$1() {
        return this.markersQueueForUnknownBroker().totalNumMarkers();
    }

    public final /* synthetic */ int kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$2() {
        return this.txnLogAppendRetryQueue().size();
    }

    public static final /* synthetic */ TxnMarkerQueue $anonfun$addMarkersForBroker$1(TransactionMarkerChannelManager $this, int brokerId$1, Node broker$1) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Creating new marker queue map to destination broker ").append(brokerId$1).toString());
        return new TxnMarkerQueue(broker$1);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(PendingCompleteTxnAndMarkerEntry check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$generateRequests$3(TransactionMarkerChannelManager $this, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        long producerId = pendingCompleteTxnAndMarker.txnMarkerEntry().producerId();
        short producerEpoch = pendingCompleteTxnAndMarker.txnMarkerEntry().producerEpoch();
        TransactionResult txnResult = pendingCompleteTxnAndMarker.txnMarkerEntry().transactionResult();
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        Set topicPartitions = CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarker.txnMarkerEntry().partitions()).asScala().toSet();
        $this.addTxnMarkersToBrokerQueue(producerId, producerEpoch, txnResult, pendingCompleteTxn, (Set<TopicPartition>)topicPartitions);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$4(TransactionMarkerChannelManager $this, TxnMarkerQueue brokerRequestQueue) {
        return !$this.hasInFlightRequests(brokerRequestQueue.destination());
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$7(Tuple2 x0$3) {
        if (x0$3 != null) {
            return !((ArrayList)x0$3._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeWriteTxnCompletion$1(TransactionMarkerChannelManager $this, String transactionalId$2, PendingCompleteTxn pendingCompleteTxn) {
        if (!$this.hasPendingMarkersToWrite(pendingCompleteTxn.txnMetadata()) && $this.transactionsWithPendingMarkers().remove(transactionalId$2, pendingCompleteTxn)) {
            $this.writeTxnCompletion(pendingCompleteTxn);
            return;
        }
    }

    private final void appendCallback$1(Errors error, PendingCompleteTxn txnLogAppend$2) {
        if (Errors.NONE.equals(error)) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Completed transaction for ").append(txnLogAppend$2.transactionalId()).append(" with coordinator epoch ").append(txnLogAppend$2.coordinatorEpoch()).append(", final state after commit: ").append(txnLogAppend$2.txnMetadata().state()).toString());
            return;
        }
        if (Errors.NOT_COORDINATOR.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(122).append("No longer the coordinator for transactionalId: ").append(txnLogAppend$2.transactionalId()).append(" while trying to append to transaction log, skip writing to transaction log").toString());
            return;
        }
        if (Errors.COORDINATOR_NOT_AVAILABLE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(76).append("Not available to append ").append(txnLogAppend$2).append(": possible causes include ").append(Errors.UNKNOWN_TOPIC_OR_PARTITION).append(", ").append(Errors.NOT_ENOUGH_REPLICAS).append(", ").append(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND).append(" and ").append(Errors.REQUEST_TIMED_OUT).append("; retry appending").toString());
            this.txnLogAppendRetryQueue().add(txnLogAppend$2);
            return;
        }
        if (Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(149).append("Coordinator is loading the partition ").append($this.txnStateManager.partitionFor(txnLogAppend$2.transactionalId())).append(" and hence cannot complete append of ").append(txnLogAppend$2).append("; ").append("skip writing to transaction log as the loading process should complete it").toString());
            return;
        }
        if (error != null) {
            String errorMsg = new StringBuilder(57).append("Unexpected error ").append(error.exceptionName()).append(" while appending to transaction log for ").append(txnLogAppend$2.transactionalId()).toString();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$tryAppendToLog$7(Errors x$5) {
        Errors errors = x$5;
        Errors errors2 = Errors.COORDINATOR_NOT_AVAILABLE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$addTxnMarkersToBrokerQueue$2(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            Option broker = (Option)check$ifrefutable$2._1();
            Set topicPartitions = (Set)check$ifrefutable$2._2();
            if (broker != null && topicPartitions != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$2(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Removing ").append(entry).append(" for txn partition ").append(txnTopicPartitionId$1).append(" to destination broker -1").toString());
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$1(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().foreach((Function1 & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$2($this, txnTopicPartitionId$1, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$6(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Removing ").append(entry).append(" for txn partition ").append(txnTopicPartitionId$1).append(" to destination broker ").append(brokerId$2).toString());
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$5(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().foreach((Function1 & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$6($this, txnTopicPartitionId$1, brokerId$2, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$4(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int brokerId = x0$1._1$mcI$sp();
            ((TxnMarkerQueue)x0$1._2()).removeMarkersForTxnTopicPartition(txnTopicPartitionId$1).foreach((Function1 & Serializable)queue -> {
                TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$5($this, txnTopicPartitionId$1, brokerId, queue);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public TransactionMarkerChannelManager(KafkaConfig config, MetadataCache metadataCache, NetworkClient networkClient, TransactionStateManager txnStateManager, Time time) {
        this.metadataCache = metadataCache;
        this.txnStateManager = txnStateManager;
        this.time = time;
        super(new StringBuilder(22).append("TxnMarkerSenderThread-").append(config.brokerId()).toString(), (KafkaClient)networkClient, Predef$.MODULE$.Integer2int(config.requestTimeoutMs()), time, true);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.logIdent_$eq(new StringBuilder(39).append("[Transaction Marker Channel Manager ").append(config.brokerId()).append("]: ").toString());
        this.interBrokerListenerName = config.interBrokerListenerName();
        this.markersQueuePerBroker = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.markersQueueForUnknownBroker = new TxnMarkerQueue(Node.noNode());
        this.txnLogAppendRetryQueue = new LinkedBlockingQueue();
        this.transactionsWithPendingMarkers = new ConcurrentHashMap();
        this.writeTxnMarkersRequestVersion = config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_8_IV0) ? (short)1 : 0;
        this.metricsGroup().newGauge("UnknownDestinationQueueSize", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("LogAppendRetryQueueSize", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

