/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import kafka.restore.operators.ResetPartitionOperator;
import kafka.tier.tools.RecoveryUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.TopicPartition;

public class ResetTierPartitionState {
    public static final String TOPIC_CONFIG = "topic";
    public static final String PARTITION_CONFIG = "partition";
    public static final String FTPS_FILE_CONFIG = "ftps";
    public static final String OUTPUT_FTPS_FILE_PREFIX = "cleared.";
    private static final String TOPIC_DOC = "Name of the topic to reset";
    private static final String PARTITION_DOC = "Name of the partition to reset";
    private static final String FTPS_FILE_DOC = "Path of the tier partition state file";

    public static void main(String[] args) throws Exception {
        System.out.println("Received cmdline args: " + Arrays.toString(args));
        ArgumentParser cliParser = ResetTierPartitionState.createArgumentParser();
        Namespace res = cliParser.parseArgs(args);
        String topic = res.getString(TOPIC_CONFIG);
        Integer partition = res.getInt(PARTITION_CONFIG);
        String ftps = res.getString(FTPS_FILE_CONFIG);
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        String outputFtps = ResetTierPartitionState.outputFilePath(ftps);
        File inputFile = new File(ftps);
        File outputFile = new File(outputFtps);
        Files.copy(inputFile.toPath(), outputFile.toPath(), new CopyOption[0]);
        ResetPartitionOperator resetPartitionOperator = new ResetPartitionOperator(topicPartition, outputFtps);
        Map<UUID, String> segmentPathMap = resetPartitionOperator.execute();
        System.out.println("Changed " + segmentPathMap.size() + " segments from SEGMENT_UPLOAD_INITIATE/SEGMENT_UPLOAD_COMPLETE/SEGMENT_DELETE_INITIATE to SEGMENT_FENCED state: ");
        segmentPathMap.forEach((k, v) -> System.out.println("\t" + v));
        System.out.println("Generated new ftps file: " + outputFile.getAbsolutePath());
    }

    public static String outputFilePath(String inputFilePath) {
        Path ipath = Paths.get(inputFilePath, new String[0]);
        Path opath = ipath.getParent().resolve(OUTPUT_FTPS_FILE_PREFIX + ipath.getFileName());
        return opath.toString();
    }

    private static ArgumentParser createArgumentParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)ResetTierPartitionState.class.getName()).defaultHelp(true).description("Reset the tier partition state file");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(TOPIC_CONFIG)}).dest(TOPIC_CONFIG).type(String.class).required(true).help(TOPIC_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(PARTITION_CONFIG)}).dest(PARTITION_CONFIG).type(Integer.class).required(true).help(PARTITION_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(FTPS_FILE_CONFIG)}).dest(FTPS_FILE_CONFIG).type(String.class).required(true).help(FTPS_FILE_DOC);
        return parser;
    }
}

