/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.server.AlterPartitionItem;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001\u0002\u000e\u001c\u0001\u0001B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003:\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011A\u0003!Q1A\u0005\u0002EC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t-\u0002\u0011)\u0019!C\u0001/\"Aa\f\u0001B\u0001B\u0003%\u0001\f\u0003\u0005`\u0001\t\u0015\r\u0011\"\u0001a\u0011!9\u0007A!A!\u0002\u0013\t\u0007\"\u00025\u0001\t\u0003I\u0007\u0002C9\u0001\u0005\u0004%\ta\u0007:\t\u000f\u0005\r\u0001\u0001)A\u0005g\"I\u0011Q\u0001\u0001C\u0002\u0013%\u0011q\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\n!9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA\u0013\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011!\tY\u0006\u0001C\u00017\u0005u\u0001\u0002CA/\u0001\u0011\u00051$!\b\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0005bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0002\u001d\t\u00164\u0017-\u001e7u\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\"O-\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015*\u001b\u0005Y\u0012B\u0001\u0016\u001c\u0005U\tE\u000e^3s!\u0006\u0014H/\u001b;j_:l\u0015M\\1hKJ\u0004\"\u0001L\u0018\u000e\u00035R!AL\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005Aj#a\u0002'pO\u001eLgnZ\u0001\u0019G>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014X#A\u001a\u0011\u0005!\"\u0014BA\u001b\u001c\u0005\u0001\u0012%o\\6feR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u00023\r|g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'\u000fI\u0001\ng\u000eDW\rZ;mKJ,\u0012!\u000f\t\u0003u\rk\u0011a\u000f\u0006\u0003yu\nA!\u001e;jY*\u0011AD\u0010\u0006\u0003=}R!\u0001Q!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0015aA8sO&\u0011Ai\u000f\u0002\n'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003\u0011!\u0018.\\3\u0016\u0003!\u0003\"!S'\u000e\u0003)S!AL&\u000b\u00051s\u0014AB2p[6|g.\u0003\u0002O\u0015\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003!\u0011'o\\6fe&#W#\u0001*\u0011\u0005\t\u001a\u0016B\u0001+$\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\n1C\u0019:pW\u0016\u0014X\t]8dQN+\b\u000f\u001d7jKJ,\u0012\u0001\u0017\t\u0004Ee[\u0016B\u0001.$\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002#9&\u0011Ql\t\u0002\u0005\u0019>tw-\u0001\u000bce>\\WM]#q_\u000eD7+\u001e9qY&,'\u000fI\u0001\u0018[\u0016$\u0018\rZ1uCZ+'o]5p]N+\b\u000f\u001d7jKJ,\u0012!\u0019\t\u0004Ee\u0013\u0007CA2f\u001b\u0005!'B\u0001'>\u0013\t1GMA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003aiW\r^1eCR\fg+\u001a:tS>t7+\u001e9qY&,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f)\\G.\u001c8paB\u0011\u0001\u0006\u0001\u0005\u0006c5\u0001\ra\r\u0005\u0006o5\u0001\r!\u000f\u0005\u0006\r6\u0001\r\u0001\u0013\u0005\u0006!6\u0001\rA\u0015\u0005\u0006-6\u0001\r\u0001\u0017\u0005\u0006?6\u0001\r!Y\u0001\u0011k:\u001cXM\u001c;JgJ,\u0006\u000fZ1uKN,\u0012a\u001d\t\u0005ibTh0D\u0001v\u0015\tadOC\u0001x\u0003\u0011Q\u0017M^1\n\u0005e,(aA'baB\u00111\u0010`\u0007\u0002\u0017&\u0011Qp\u0013\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\tAs0C\u0002\u0002\u0002m\u0011!#\u00117uKJ\u0004\u0016M\u001d;ji&|g.\u0013;f[\u0006\tRO\\:f]RL5O]+qI\u0006$Xm\u001d\u0011\u0002\u001f%tg\r\\5hQR\u0014V-];fgR,\"!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u00051\u0011\r^8nS\u000eT1!a\u0005v\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003/\tiAA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0011S:4G.[4iiJ+\u0017/^3ti\u0002\nQa\u001d;beR$\"!a\b\u0011\u0007\t\n\t#C\u0002\u0002$\r\u0012A!\u00168ji\u0006A1\u000f[;uI><h.\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u000b\u0003W\ty$!\u0013\u0002N\u0005E\u0003CBA\u0017\u0003_\t\u0019$\u0004\u0002\u0002\u0012%!\u0011\u0011GA\t\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011H\u000f\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002>\u0005]\"\u0001\u0004'fC\u0012,'/\u00118e\u0013N\u0014\bbBA!)\u0001\u0007\u00111I\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u00042a_A#\u0013\r\t9e\u0013\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:Dq!a\u0013\u0015\u0001\u0004\t\u0019$\u0001\u0007mK\u0006$WM]!oI&\u001b(\u000f\u0003\u0004\u0002PQ\u0001\rAU\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\"9\u00111\u000b\u000bA\u0002\u0005U\u0013\u0001\u00069s_B\fw-\u0019;f\u00136lW\rZ5bi\u0016d\u0017\u0010E\u0002#\u0003/J1!!\u0017$\u0005\u001d\u0011un\u001c7fC:\f\u0001$\\1zE\u0016\u0004&o\u001c9bO\u0006$X-S:s\u0007\"\fgnZ3t\u0003Q\u0019G.Z1s\u0013:4E.[4iiJ+\u0017/^3ti\u0006Y1/\u001a8e%\u0016\fX/Z:u)\u0011\ty\"a\u0019\t\u000f\u0005\u0015t\u00031\u0001\u0002h\u0005Y\u0012N\u001c4mS\u001eDG/\u00117uKJ\u0004\u0016M\u001d;ji&|g.\u0013;f[N\u0004R!!\u001b\u0002zytA!a\u001b\u0002v9!\u0011QNA:\u001b\t\tyGC\u0002\u0002r}\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0007\u0005]4%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0014Q\u0010\u0002\u0004'\u0016\f(bAA<G\u0005a!-^5mIJ+\u0017/^3tiR1\u00111QAa\u0003\u0007\u0004rAIAC\u0003\u0013\u000bi*C\u0002\u0002\b\u000e\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BAF\u0003/sA!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003#[\u0015\u0001\u0003:fcV,7\u000f^:\n\t\u0005U\u0015qR\u0001\u0016\u00032$XM\u001d)beRLG/[8o%\u0016\fX/Z:u\u0013\u0011\tI*a'\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011QSAH!!\ty*!+\u0002,\u0006EVBAAQ\u0015\u0011\t\u0019+!*\u0002\u000f5,H/\u00192mK*\u0019\u0011qU\u0012\u0002\u0015\r|G\u000e\\3di&|g.C\u0002z\u0003C\u00032a_AW\u0013\r\tyk\u0013\u0002\u0005+VLG\r\u0005\u0003\u00024\u0006mf\u0002BA[\u0003o\u00032!!\u001c$\u0013\r\tIlI\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0016q\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005e6\u0005C\u0004\u0002fa\u0001\r!a\u001a\t\r\u0005\u0015\u0007\u00041\u0001\\\u0003-\u0011'o\\6fe\u0016\u0003xn\u00195\u00029!\fg\u000e\u001a7f\u00032$XM\u001d)beRLG/[8o%\u0016\u001c\bo\u001c8tKRa\u00111ZAl\u0003C\fY/a<\u0002rB!\u0011QZAj\u001b\t\tyMC\u0002\u0002R.\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003+\fyM\u0001\u0004FeJ|'o\u001d\u0005\b\u00033L\u0002\u0019AAn\u00035\u0011X-];fgRDU-\u00193feB!\u0011QRAo\u0013\u0011\ty.a$\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011\u001d\t\u0019/\u0007a\u0001\u0003K\f!#\u00197uKJ\u0004\u0016M\u001d;ji&|gNU3taB!\u0011QRAt\u0013\u0011\tI/a$\u0003-\u0005cG/\u001a:QCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016Da!!<\u001a\u0001\u0004Y\u0016aD:f]R\u0014%o\\6fe\u0016\u0003xn\u00195\t\u000f\u0005\u0015\u0014\u00041\u0001\u0002h!9\u00111_\rA\u0002\u0005u\u0015a\u0004;pa&\u001cg*Y7fg\nK\u0018\nZ:")
public class DefaultAlterPartitionManager
implements AlterPartitionManager,
Logging {
    private final BrokerToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public BrokerToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    public Function0<MetadataVersion> metadataVersionSupplier() {
        return this.metadataVersionSupplier;
    }

    public Map<TopicPartition, AlterPartitionItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    @Override
    public void start() {
        this.controllerChannelManager().start();
    }

    @Override
    public void shutdown() {
        this.controllerChannelManager().shutdown();
    }

    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch, boolean propagateImmediately) {
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        AlterPartitionItem alterPartitionItem = new AlterPartitionItem(topicIdPartition, leaderAndIsr, future, controllerEpoch);
        if (this.unsentIsrUpdates().putIfAbsent(alterPartitionItem.topicIdPartition().topicPartition(), alterPartitionItem) == null) {
            this.maybePropagateIsrChanges();
        } else {
            future.completeExceptionally((Throwable)new OperationNotAttemptedException(new StringBuilder(50).append("Failed to enqueue ISR change state ").append(leaderAndIsr).append(" for partition ").append(topicIdPartition).toString()));
        }
        return future;
    }

    public void maybePropagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterPartitionItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterPartitionItems.append(item));
            this.sendRequest((Seq<AlterPartitionItem>)inflightAlterPartitionItems.toSeq());
            return;
        }
    }

    public void clearInFlightRequest() {
        if (!this.inflightRequest().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Attempting to clear AlterPartition in-flight flag when no apparent request is in-flight");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems) {
        void var6_5;
        void var5_4;
        long brokerEpoch = this.brokerEpochSupplier().apply$mcJ$sp();
        Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> tuple2 = this.buildRequest(inflightAlterPartitionItems, brokerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AlterPartitionRequest.Builder request = (AlterPartitionRequest.Builder)tuple2._1();
        scala.collection.mutable.Map topicNamesByIds = (scala.collection.mutable.Map)tuple2._2();
        this.debug((Function0<String>)((Function0 & Serializable)() -> DefaultAlterPartitionManager.$anonfun$sendRequest$1((AlterPartitionRequest.Builder)var5_4)));
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)var5_4, new ControllerRequestCompletionHandler(this, brokerEpoch, inflightAlterPartitionItems, (scala.collection.mutable.Map)var6_5){
            private final /* synthetic */ DefaultAlterPartitionManager $outer;
            private final long brokerEpoch$1;
            private final Seq inflightAlterPartitionItems$2;
            private final scala.collection.mutable.Map topicNamesByIds$1;

            public void onComplete(ClientResponse response) {
                Errors errors;
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Received AlterPartition response ").append(response).toString());
                try {
                    if (response.authenticationException() != null) {
                        errors = Errors.NETWORK_EXCEPTION;
                    } else if (response.versionMismatch() != null) {
                        errors = Errors.UNSUPPORTED_VERSION;
                    } else {
                        AlterPartitionResponse body = (AlterPartitionResponse)response.responseBody();
                        errors = this.$outer.handleAlterPartitionResponse(response.requestHeader(), body, this.brokerEpoch$1, (Seq<AlterPartitionItem>)this.inflightAlterPartitionItems$2, (scala.collection.mutable.Map<Uuid, String>)this.topicNamesByIds$1);
                    }
                }
                finally {
                    this.$outer.clearInFlightRequest();
                }
                Errors error = errors;
                if (Errors.NONE.equals(error)) {
                    this.$outer.maybePropagateIsrChanges();
                    return;
                }
                this.$outer.scheduler().scheduleOnce("send-alter-partition", () -> $this.$outer.maybePropagateIsrChanges(), 50L);
            }

            public void onTimeout() {
                throw new IllegalStateException("Encountered unexpected timeout when sending AlterPartition to the controller");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerEpoch$1 = brokerEpoch$1;
                this.inflightAlterPartitionItems$2 = inflightAlterPartitionItems$2;
                this.topicNamesByIds$1 = topicNamesByIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse )}, serializedLambda);
            }
        });
    }

    private Tuple2<AlterPartitionRequest.Builder, scala.collection.mutable.Map<Uuid, String>> buildRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems, long brokerEpoch) {
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier().apply();
        HashMap topicNamesByIds = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef canUseTopicIds = BooleanRef.create((boolean)metadataVersion.isTopicIdsSupported());
        AlterPartitionRequestData message = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(brokerEpoch);
        inflightAlterPartitionItems.groupBy((Function1 & Serializable)x$2 -> x$2.topicIdPartition().topic()).foreach((Function1 & Serializable)x0$1 -> {
            DefaultAlterPartitionManager.$anonfun$buildRequest$2(canUseTopicIds, topicNamesByIds, message, metadataVersion, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)new AlterPartitionRequest.Builder(message, canUseTopicIds.elem), (Object)topicNamesByIds);
    }

    public Errors handleAlterPartitionResponse(RequestHeader requestHeader, AlterPartitionResponse alterPartitionResp, long sentBrokerEpoch, Seq<AlterPartitionItem> inflightAlterPartitionItems, scala.collection.mutable.Map<Uuid, String> topicNamesByIds) {
        AlterPartitionResponseData data = alterPartitionResp.data();
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Broker had a stale broker epoch (").append(sentBrokerEpoch).append("), retrying.").toString());
        } else if (Errors.CLUSTER_AUTHORIZATION_FAILED.equals(errors)) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Broker is not authorized to send AlterPartition to controller", (Function0<Throwable>)(Function0 & Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterPartition to controller"));
        } else if (Errors.NONE.equals(errors)) {
            HashMap partitionResponses = HashMap$.MODULE$.empty();
            data.topics().forEach(topic -> {
                String topicName;
                String string = topicName = requestHeader.apiVersion() > 1 ? (String)topicNamesByIds.get((Object)topic.topicId()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()) : topic.topicName();
                if (topicName == null || topicName.isEmpty()) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Received an unexpected topic ").append(topic).append(" in the alter partition response, ignoring it.").toString());
                    return;
                }
                topic.partitions().forEach(partition -> {
                    TopicPartition tp = new TopicPartition(topicName, partition.partitionIndex());
                    partitionResponses.update((Object)tp, partition);
                });
            });
            inflightAlterPartitionItems.foreach((Function1 & Serializable)inflightAlterPartition -> {
                Option option = partitionResponses.get((Object)inflightAlterPartition.topicIdPartition().topicPartition());
                if (option instanceof Some) {
                    AlterPartitionResponseData.PartitionData response = (AlterPartitionResponseData.PartitionData)((Some)option).value();
                    this.unsentIsrUpdates().remove(inflightAlterPartition.topicIdPartition().topicPartition());
                    Errors error = Errors.forCode((short)response.errorCode());
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Controller response returned for AlterIsr request for ").append(inflightAlterPartition.topicIdPartition()).append(": ").append(response).toString());
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        return BoxesRunTime.boxToBoolean((boolean)inflightAlterPartition.future().complete(LeaderAndIsr$.MODULE$.apply(response.leaderId(), response.leaderEpoch(), (List<Object>)CollectionConverters$.MODULE$.ListHasAsScala(response.isr()).asScala().toList().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3))), inflightAlterPartition.leaderAndIsr().leaderRecoveryState(), response.partitionEpoch(), inflightAlterPartition.leaderAndIsr().clusterLinkState())));
                    }
                    return BoxesRunTime.boxToBoolean((boolean)inflightAlterPartition.future().completeExceptionally(error.exception()));
                }
                if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Partition ").append(inflightAlterPartition.topicIdPartition()).append(" was sent but not included in the response").toString());
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            });
        } else {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(88).append("Controller returned an unexpected top-level error when handling AlterPartition request: ").append(errors).toString());
        }
        return Errors.forCode((short)data.errorCode());
    }

    public static final /* synthetic */ String $anonfun$sendRequest$1(AlterPartitionRequest.Builder request$1) {
        return new StringBuilder(37).append("Sending AlterPartition to controller ").append(request$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(MetadataVersion metadataVersion$1, AlterPartitionRequestData.TopicData topicData$1, AlterPartitionItem item) {
        LeaderRecoveryState leaderRecoveryState = item.leaderAndIsr().leaderRecoveryState();
        LeaderRecoveryState leaderRecoveryState2 = LeaderRecoveryState.RECOVERING;
        AlterPartitionRequestData.PartitionData partitionData = new AlterPartitionRequestData.PartitionData().setPartitionIndex(item.topicIdPartition().partition()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch()).setNewIsrWithEpochs(CollectionConverters$.MODULE$.SeqHasAsJava(item.leaderAndIsr().isrWithBrokerEpoch()).asJava()).setPartitionEpoch(item.leaderAndIsr().partitionEpoch()).setIsUnclean(!(leaderRecoveryState != null ? !leaderRecoveryState.equals(leaderRecoveryState2) : leaderRecoveryState2 != null));
        if (metadataVersion$1.isLeaderRecoverySupported()) {
            partitionData.setLeaderRecoveryState(item.leaderAndIsr().leaderRecoveryState().value());
        }
        item.leaderAndIsr().clusterLinkState().foreach((Function1 & Serializable)linkState -> {
            partitionData.setClusterLinkState(new AlterPartitionRequestData.ClusterLinkState().setLinkedLeaderEpoch(linkState.linkedLeaderEpoch()).setLinkFailed(linkState.linkFailed()));
            if (linkState.linkFailed()) {
                return partitionData.setMirrorTopicError(linkState.error().code());
            }
            return BoxedUnit.UNIT;
        });
        return topicData$1.partitions().add(partitionData);
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(BooleanRef canUseTopicIds$1, HashMap topicNamesByIds$2, AlterPartitionRequestData message$1, MetadataVersion metadataVersion$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topicName = (String)x0$1._1();
            Seq items = (Seq)x0$1._2();
            Uuid topicId = ((AlterPartitionItem)items.head()).topicIdPartition().topicId();
            Uuid uuid = topicId;
            Uuid uuid2 = Uuid.ZERO_UUID;
            canUseTopicIds$1.elem = canUseTopicIds$1.elem & (uuid == null ? uuid2 != null : !uuid.equals(uuid2));
            topicNamesByIds$2.update((Object)topicId, (Object)topicName);
            AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicName(topicName).setTopicId(topicId);
            message$1.topics().add(topicData);
            items.foreach((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DefaultAlterPartitionManager.$anonfun$buildRequest$3(metadataVersion$1, topicData, item)));
            return;
        }
        throw new MatchError(null);
    }

    public DefaultAlterPartitionManager(BrokerToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier, Function0<MetadataVersion> metadataVersionSupplier) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.metadataVersionSupplier = metadataVersionSupplier;
        this.unsentIsrUpdates = new ConcurrentHashMap<TopicPartition, AlterPartitionItem>();
        this.inflightRequest = new AtomicBoolean(false);
    }
}

