/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.server.ConfigType$;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.ClusterLinkZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.migration.ClusterLinkMetadata;
import org.apache.kafka.metadata.migration.ClusterLinkMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001\u0002\u0006\f\u0001IA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!)1\b\u0001C\u0001y!)\u0011\t\u0001C!\u0005\")!\u000b\u0001C!'\")a\f\u0001C!?\")\u0011\u000e\u0001C\u0005U\")\u0011\u000e\u0001C\u0005}\"9\u0011\u0011\u0003\u0001\u0005B\u0005M!\u0001\b.l\u00072,8\u000f^3s\u0019&t7.T5he\u0006$\u0018n\u001c8DY&,g\u000e\u001e\u0006\u0003\u00195\t\u0011\"\\5he\u0006$\u0018n\u001c8\u000b\u00059y\u0011A\u0001>l\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0005\u0001MYr\u0005\u0005\u0002\u001535\tQC\u0003\u0002\u0017/\u0005!A.\u00198h\u0015\u0005A\u0012\u0001\u00026bm\u0006L!AG\u000b\u0003\r=\u0013'.Z2u!\taR%D\u0001\u001e\u0015\taaD\u0003\u0002 A\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u0011C)\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0013\t1SD\u0001\u000eDYV\u001cH/\u001a:MS:\\W*[4sCRLwN\\\"mS\u0016tG\u000f\u0005\u0002)W5\t\u0011F\u0003\u0002+\u001f\u0005)Q\u000f^5mg&\u0011A&\u000b\u0002\b\u0019><w-\u001b8h\u0003!Q8n\u00117jK:$\bCA\u00181\u001b\u0005i\u0011BA\u0019\u000e\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006YA.\u001b8l\u000b:\u001cw\u000eZ3s!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003mS:\\'B\u0001\u001d\u0010\u0003\u0019\u0019XM\u001d<fe&\u0011!(\u000e\u0002\u0019\u00072,8\u000f^3s\u0019&t7nQ8oM&<WI\\2pI\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0002>\u007f\u0001\u0003\"A\u0010\u0001\u000e\u0003-AQ!L\u0002A\u00029BQAM\u0002A\u0002M\n1#\u001b;fe\u0006$Xm\u00117vgR,'\u000fT5oWN$\"aQ%\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0015\u0012\u0001\raS\u0001\bm&\u001c\u0018\u000e^8s!\tauJ\u0004\u0002\u001d\u001b&\u0011a*H\u0001\u001b\u00072,8\u000f^3s\u0019&t7.T5he\u0006$\u0018n\u001c8DY&,g\u000e^\u0005\u0003!F\u0013!c\u00117vgR,'\u000fT5oWZK7/\u001b;pe*\u0011a*H\u0001\u0012GJ,\u0017\r^3DYV\u001cH/\u001a:MS:\\Gc\u0001+X9B\u0011A$V\u0005\u0003-v\u0011!DW6NS\u001e\u0014\u0018\r^5p]2+\u0017\rZ3sg\"L\u0007o\u0015;bi\u0016DQ\u0001W\u0003A\u0002e\u000b1c\u00197vgR,'\u000fT5oW6+G/\u00193bi\u0006\u0004\"\u0001\b.\n\u0005mk\"aE\"mkN$XM\u001d'j].lU\r^1eCR\f\u0007\"B/\u0006\u0001\u0004!\u0016\u0001G7jOJ\fG/[8o\u0019\u0016\fG-\u001a:tQ&\u00048\u000b^1uK\u0006\tB-\u001a7fi\u0016\u001cE.^:uKJd\u0015N\\6\u0015\u0007Q\u0003\u0007\u000eC\u0003b\r\u0001\u0007!-\u0001\u0004mS:\\\u0017\n\u001a\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\u0002\naaY8n[>t\u0017BA4e\u0005\u0011)V/\u001b3\t\u000bu3\u0001\u0019\u0001+\u0002#I,7-\u001e:tSZ,7\t[5mIJ,g\u000e\u0006\u0002lyB\u0019An\\9\u000e\u00035T!A\\#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002q[\n\u00191+Z9\u0011\u0005ILhBA:x!\t!X)D\u0001v\u0015\t1\u0018#\u0001\u0004=e>|GOP\u0005\u0003q\u0016\u000ba\u0001\u0015:fI\u00164\u0017B\u0001>|\u0005\u0019\u0019FO]5oO*\u0011\u00010\u0012\u0005\u0006{\u001e\u0001\r!]\u0001\u0005a\u0006$\b\u000e\u0006\u0003D\u007f\u0006\u0005\u0001\"B?\t\u0001\u0004\t\bbBA\u0002\u0011\u0001\u0007\u0011QA\u0001\u0004C\u000e\u001c\u0007#BA\u0004\u0003\u001b\tXBAA\u0005\u0015\r\tY!\\\u0001\b[V$\u0018M\u00197f\u0013\u0011\ty!!\u0003\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM]\u0001$GJ,\u0017\r^3DYV\u001cH/\u001a:MS:\\7\t[1oO\u0016tu\u000e^5gS\u000e\fG/[8o)\r\u0019\u0015Q\u0003\u0005\u0006C&\u0001\rA\u0019")
public class ZkClusterLinkMigrationClient
implements ClusterLinkMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private final ClusterLinkConfigEncoder linkEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void iterateClusterLinks(ClusterLinkMigrationClient.ClusterLinkVisitor visitor) {
        try {
            ZkClusterLinkMigrationClient.$anonfun$iterateClusterLinks$1(this, visitor);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState createClusterLink(ClusterLinkMetadata clusterLinkMetadata, ZkMigrationLeadershipState migrationLeadershipState) {
        void var8_8;
        String path = ClusterLinkZNode$.MODULE$.path(CoreUtils$.MODULE$.toJavaUUID(clusterLinkMetadata.linkId()));
        ClusterLinkData data = new ClusterLinkData(clusterLinkMetadata.linkName(), clusterLinkMetadata.linkId(), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLinkMetadata.clusterId())), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLinkMetadata.tenantPrefix())), false);
        CreateRequest createClusterLinkZNode = new CreateRequest(path, ClusterLinkZNode$.MODULE$.encode(data), this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)createClusterLinkZNode, (List)Nil$.MODULE$), migrationLeadershipState);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        Map resultCodes = ((IterableOnceOps)var8_8.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (((Enum)resultCodes.apply((Object)path)).equals(KeeperException.Code.NODEEXISTS)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Cluster link ").append(clusterLinkMetadata.linkName()).append("already exists in Zookeeper. Skipping ").append("the create request.").toString());
            return migrationLeadershipState;
        }
        if (resultCodes.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkClusterLinkMigrationClient.$anonfun$createClusterLink$3(x0$1)))) {
            void var7_7;
            return migrationLeadershipState.withMigrationZkVersion((int)var7_7);
        }
        throw new MigrationClientException(new StringBuilder(58).append("Failed to create cluster link ").append(clusterLinkMetadata.linkName()).append(". ").append("ZK operations had results ").append(resultCodes).toString());
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState deleteClusterLink(Uuid linkId, ZkMigrationLeadershipState migrationLeadershipState) {
        void var7_7;
        String path = ClusterLinkZNode$.MODULE$.path(CoreUtils$.MODULE$.toJavaUUID(linkId));
        Seq deleteRequests = (Seq)((IterableOps)this.recursiveChildren(path).map((Function1 & Serializable)child -> new DeleteRequest((String)child, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$));
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(deleteRequests, migrationLeadershipState);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        Map resultCodes = ((IterableOnceOps)var7_7.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (((DeleteResponse)var7_7.last()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var6_6;
            return migrationLeadershipState.withMigrationZkVersion((int)var6_6);
        }
        throw new MigrationClientException(new StringBuilder(50).append("Failed to delete link ").append(linkId).append(". ZK operations had results ").append(resultCodes).toString());
    }

    private Seq<String> recursiveChildren(String path) {
        ArrayBuffer buffer = new ArrayBuffer();
        this.recursiveChildren(path, (ArrayBuffer<String>)buffer);
        return buffer.toSeq();
    }

    private void recursiveChildren(String path, ArrayBuffer<String> acc) {
        ((GetChildrenResponse)this.zkClient.retryRequestUntilConnected(new GetChildrenRequest(path, false, (Option<Object>)None$.MODULE$), this.zkClient.retryRequestUntilConnected$default$2())).children().foreach((Function1 & Serializable)child -> {
            this.recursiveChildren(new StringBuilder(1).append(path).append("/").append((String)child).toString(), acc);
            return (ArrayBuffer)acc.append((Object)new StringBuilder(1).append(path).append("/").append((String)child).toString());
        });
    }

    public void createClusterLinkChangeNotification(Uuid linkId) {
        this.zkClient.createConfigChangeNotification(new StringBuilder(11).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(CoreUtils$.MODULE$.toJavaUUID(linkId).toString()).toString());
    }

    public static final /* synthetic */ void $anonfun$iterateClusterLinks$6(scala.collection.mutable.Map linkConfigs$1, ClusterLinkMigrationClient.ClusterLinkVisitor visitor$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            Uuid linkId = (Uuid)x0$2._1();
            ClusterLinkData cld = (ClusterLinkData)x0$2._2();
            Properties linkConfig = (Properties)linkConfigs$1.apply((Object)linkId);
            ClusterLinkMetadata linkMetadata = new ClusterLinkMetadata(cld.linkName(), cld.linkId(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(cld.clusterId())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(cld.tenantPrefix())), Optional.ofNullable(linkConfig.getProperty("cluster.link.prefix")), linkConfig);
            visitor$1.visitClusterLink(linkMetadata, cld.isDeleted());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateClusterLinks$1(ZkClusterLinkMigrationClient $this, ClusterLinkMigrationClient.ClusterLinkVisitor visitor$1) {
        Map clusterLinks = ((IterableOnceOps)$this.zkClient.getAllClusterLinks().map((Function1 & Serializable)cld -> new Tuple2((Object)cld.linkId(), cld))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map linkConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        $this.zkClient.getEntitiesConfigs(ConfigType$.MODULE$.ClusterLink(), (scala.collection.immutable.Set<String>)$this.zkClient.getAllEntitiesWithConfig(ConfigType$.MODULE$.ClusterLink()).toSet()).foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String linkJavaUuidStr = (String)x0$1._1();
                Properties props = (Properties)x0$1._2();
                Uuid linkId = CoreUtils$.MODULE$.toKafkaUuidFromJavaUUIDString(linkJavaUuidStr);
                if (clusterLinks.contains((Object)linkId)) {
                    return linkConfigs.put((Object)linkId, (Object)$this.linkEncoder.decode(props));
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError(null);
        });
        scala.collection.immutable.Set linksWithoutConfig = (scala.collection.immutable.Set)clusterLinks.keys().toSet().diff((Set)linkConfigs.keys().toSet());
        if (linksWithoutConfig.nonEmpty()) {
            throw new MigrationClientException(new StringBuilder(49).append("Unable to find cluster link properties for links ").append(((IterableOps)clusterLinks.filter((Function1 & Serializable)keyVal -> BoxesRunTime.boxToBoolean((boolean)linksWithoutConfig.contains(keyVal._1())))).map((Function1 & Serializable)x$1 -> ((ClusterLinkData)x$1._2()).linkName())).toString());
        }
        clusterLinks.foreach((Function1 & Serializable)x0$2 -> {
            ZkClusterLinkMigrationClient.$anonfun$iterateClusterLinks$6(linkConfigs, visitor$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$createClusterLink$3(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((KeeperException.Code)x0$1._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    public ZkClusterLinkMigrationClient(KafkaZkClient zkClient, ClusterLinkConfigEncoder linkEncoder) {
        this.zkClient = zkClient;
        this.linkEncoder = linkEncoder;
    }
}

