/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.AbstractRuleBuilder;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.RetryDecision;
import com.linecorp.armeria.client.retry.RetryRule;
import com.linecorp.armeria.client.retry.RetryRuleUtil;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.client.RuleFilter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class RetryRuleBuilder
extends AbstractRuleBuilder<RetryRuleBuilder> {
    RetryRuleBuilder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        super(requestHeadersFilter);
    }

    public RetryRule thenBackoff() {
        return this.thenBackoff(Backoff.ofDefault());
    }

    public RetryRule thenBackoff(Backoff backoff) {
        Objects.requireNonNull(backoff, "backoff");
        return this.build(RetryDecision.retry(backoff));
    }

    public RetryRule thenNoRetry() {
        return this.build(RetryDecision.noRetry());
    }

    private RetryRule build(RetryDecision decision) {
        if (decision != RetryDecision.noRetry() && this.exceptionFilter() == null && this.responseHeadersFilter() == null && this.responseTrailersFilter() == null && this.grpcTrailersFilter() == null && this.totalDurationFilter() == null) {
            throw new IllegalStateException("Should set at least one retry rule if a backoff was set.");
        }
        RuleFilter ruleFilter = RuleFilter.of(this.requestHeadersFilter(), this.responseHeadersFilter(), this.responseTrailersFilter(), this.grpcTrailersFilter(), this.exceptionFilter(), this.totalDurationFilter(), false);
        return RetryRuleBuilder.build(ruleFilter, decision, this.requiresResponseTrailers());
    }

    static RetryRule build(final BiFunction<? super ClientRequestContext, ? super Throwable, Boolean> ruleFilter, RetryDecision decision, final boolean requiresResponseTrailers) {
        final CompletableFuture<RetryDecision> decisionFuture = decision == RetryDecision.DEFAULT ? RetryRuleUtil.DEFAULT_DECISION : UnmodifiableFuture.completedFuture(decision);
        return new RetryRule(){

            @Override
            public CompletionStage<RetryDecision> shouldRetry(ClientRequestContext ctx, @Nullable Throwable cause) {
                return (Boolean)ruleFilter.apply(ctx, cause) != false ? decisionFuture : RetryRuleUtil.NEXT_DECISION;
            }

            @Override
            public boolean requiresResponseTrailers() {
                return requiresResponseTrailers;
            }
        };
    }
}

