/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.healthcheck;

import com.linecorp.armeria.common.util.AbstractListenable;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.server.healthcheck.ListenableHealthChecker;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

public final class SettableHealthChecker
extends AbstractListenable<HealthChecker>
implements ListenableHealthChecker {
    private final AtomicBoolean isHealthy;

    public SettableHealthChecker() {
        this(true);
    }

    public SettableHealthChecker(boolean isHealthy) {
        this.isHealthy = new AtomicBoolean(isHealthy);
    }

    @Override
    public boolean isHealthy() {
        return this.isHealthy.get();
    }

    public SettableHealthChecker setHealthy(boolean isHealthy) {
        boolean oldValue = this.isHealthy.getAndSet(isHealthy);
        if (oldValue != isHealthy) {
            this.notifyListeners(this);
        }
        return this;
    }

    @Override
    @Nonnull
    protected HealthChecker latestValue() {
        return this;
    }

    public String toString() {
        return "SettableHealthChecker: " + (this.isHealthy.get() ? "healthy" : "not healthy");
    }
}

