/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.ArrayList;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.queue.EventQueue;

public class SnapshotEvent
extends MetadataCollectorEvent {
    public SnapshotEvent(ZKMetadataCollector collector, Time time) {
        super(collector, time);
    }

    public void run() throws Exception {
        ZKMetadataCollectorContext context = this.context();
        for (String logicalCluster : context.localStore().logicalClusters()) {
            MetadataChange metadataChange;
            Set<String> topics = context.localStore().topics(logicalCluster);
            Set<String> clusterLinks = context.localStore().clusterLinks(logicalCluster);
            int maxEntitiesPerPage = Math.min(topics.size() + clusterLinks.size(), context.config().maxTopicsInSnapshot);
            int numberOfPages = MetadataEventUtils.getNumberOfSnapshotPages(topics.size() + clusterLinks.size(), maxEntitiesPerPage);
            int page = 0;
            ArrayList<Object> metadataEvents = new ArrayList<MetadataEvent>(maxEntitiesPerPage);
            LOG.debug("Creating Snapshot for tenant {} with {} topics, {} cluster links, {} pages and {} total", new Object[]{logicalCluster, topics.size(), clusterLinks.size(), page, numberOfPages});
            for (String topic : topics) {
                if (metadataEvents.size() >= maxEntitiesPerPage) {
                    metadataChange = MetadataEventUtils.snapshotEvent(logicalCluster, metadataEvents);
                    this.emitSnapshotEvent(context, metadataChange, page, numberOfPages);
                    metadataEvents = new ArrayList(maxEntitiesPerPage);
                    ++page;
                }
                metadataEvents.add(context.localStore().topicMetadataEvent(topic));
            }
            for (String clusterLink : clusterLinks) {
                if (metadataEvents.size() >= maxEntitiesPerPage) {
                    metadataChange = MetadataEventUtils.snapshotEvent(logicalCluster, metadataEvents);
                    this.emitSnapshotEvent(context, metadataChange, page, numberOfPages);
                    metadataEvents = new ArrayList(maxEntitiesPerPage);
                    ++page;
                }
                metadataEvents.add(context.localStore().clusterLinkMetadataEvent(clusterLink));
            }
            MetadataChange metadataChange2 = MetadataEventUtils.snapshotEvent(logicalCluster, metadataEvents);
            this.emitSnapshotEvent(context, metadataChange2, page, numberOfPages);
        }
        long currNs = this.time.nanoseconds();
        context.catalogMetrics().snapshotEmittingDelayMsMetric.update(TimeUnit.MILLISECONDS.convert(currNs - context.lastSnapshotNs(), TimeUnit.NANOSECONDS));
        context.setLastSnapshotNs(currNs);
        context.eventQueue().scheduleDeferred("SNAPSHOT_EVENT", (Function<OptionalLong, OptionalLong>)new EventQueue.DeadlineFunction(currNs + TimeUnit.NANOSECONDS.convert(context.config().snapshotIntervalSec, TimeUnit.SECONDS)), new SnapshotEvent(this.collector, this.time));
    }
}

