/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class State {
    public static final State START = new State("Start");
    public static final State PRE_CONDITION_READY = new State("PreConditionReady");
    public static final State FENCE_EVENT_SENT = new State("FenceEventSent");
    public static final State PARTITION_FENCED = new State("PartitionFenced");
    public static final State FTPS_FETCHED = new State("FtpsFetched");
    public static final State FTPS_REPAIRED = new State("FtpsRepaired");
    public static final State SEGMENTS_REPAIRED = new State("SegmentsRepaired");
    public static final State FTPS_RECONCILED = new State("FtpsReconciled");
    public static final State FTPS_UPLOADED = new State("FtpsUploaded");
    public static final State FORCE_RESTORE_EVENT_SENT = new State("ForceRestoreEventSent");
    public static final State PARTITION_RESTORED = new State("PartitionRestored");
    public static final State RESTORE_START_OFFSET_EVENT_SENT = new State("RestoreStartOffsetEventSent");
    public static final State LOG_START_OFFSET_RESTORED;
    public static final State END_STATE;
    public static final State FAILED;
    private final String name;

    public State(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        return this.name.equals(state.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static final Set<State> allStates() {
        return new HashSet<State>(Arrays.asList(START, PRE_CONDITION_READY, FENCE_EVENT_SENT, PARTITION_FENCED, FTPS_FETCHED, FTPS_REPAIRED, SEGMENTS_REPAIRED, FTPS_RECONCILED, FTPS_UPLOADED, FORCE_RESTORE_EVENT_SENT, PARTITION_RESTORED, RESTORE_START_OFFSET_EVENT_SENT, LOG_START_OFFSET_RESTORED, FAILED));
    }

    static {
        END_STATE = LOG_START_OFFSET_RESTORED = new State("LogStartOffsetRestored");
        FAILED = new State("Failed");
    }
}

