/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kafka.server.FetchContext;
import kafka.server.FetchSessionCache;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.PartitionFetchMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\t\u0012\u0001YA\u0001\"\t\u0001\u0003\u0006\u0004%IA\t\u0005\ta\u0001\u0011\t\u0011)A\u0005G!A\u0011\u0007\u0001BC\u0002\u0013%!\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00034\u0011!9\u0004A!b\u0001\n\u0013A\u0004\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011%\u0003!Q1A\u0005\n)C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t\u001f\u0002\u0011)\u0019!C\u0005\u0015\"A\u0001\u000b\u0001B\u0001B\u0003%1\nC\u0003R\u0001\u0011\u0005!\u000bC\u0003Z\u0001\u0011\u0005#\fC\u0003d\u0001\u0011\u0005C\rC\u0003n\u0001\u0011\u0005c\u000eC\u0004\u0002\u0002\u0001!\t%a\u0001\u0003!\u0019+H\u000e\u001c$fi\u000eD7i\u001c8uKb$(B\u0001\n\u0014\u0003\u0019\u0019XM\u001d<fe*\tA#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=}i\u0011!E\u0005\u0003AE\u0011ABR3uG\"\u001cuN\u001c;fqR\fA\u0001^5nKV\t1\u0005\u0005\u0002%]5\tQE\u0003\u0002'O\u0005)Q\u000f^5mg*\u0011\u0001&K\u0001\u0007G>lWn\u001c8\u000b\u0005QQ#BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001eL!aL\u0013\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0002gA\u0011a\u0004N\u0005\u0003kE\u0011\u0011CR3uG\"\u001cVm]:j_:\u001c\u0015m\u00195f\u0003\u0019\u0019\u0017m\u00195fA\u0005Ia-\u001a;dQ\u0012\u000bG/Y\u000b\u0002sA!!hP!F\u001b\u0005Y$B\u0001\u001f>\u0003\u0011)H/\u001b7\u000b\u0003y\nAA[1wC&\u0011\u0001i\u000f\u0002\u0004\u001b\u0006\u0004\bC\u0001\"D\u001b\u00059\u0013B\u0001#(\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\u001f\r&\u0011q)\u0005\u0002\u0017!\u0006\u0014H/\u001b;j_:4U\r^2i\u001b\u0016$\u0018\rZ1uC\u0006Qa-\u001a;dQ\u0012\u000bG/\u0019\u0011\u0002\u0019U\u001cXm\u001d+pa&\u001c\u0017\nZ:\u0016\u0003-\u0003\"\u0001\u0007'\n\u00055K\"a\u0002\"p_2,\u0017M\\\u0001\u000ekN,7\u000fV8qS\u000eLEm\u001d\u0011\u0002\u001d%\u001chI]8n\r>dGn\\<fe\u0006y\u0011n\u001d$s_64u\u000e\u001c7po\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0007'R+fk\u0016-\u0011\u0005y\u0001\u0001\"B\u0011\f\u0001\u0004\u0019\u0003\"B\u0019\f\u0001\u0004\u0019\u0004\"B\u001c\f\u0001\u0004I\u0004\"B%\f\u0001\u0004Y\u0005\"B(\f\u0001\u0004Y\u0015AD4fi\u001a+Go\u00195PM\u001a\u001cX\r\u001e\u000b\u00037\u0006\u00042\u0001\u0007/_\u0013\ti\u0016D\u0001\u0004PaRLwN\u001c\t\u00031}K!\u0001Y\r\u0003\t1{gn\u001a\u0005\u0006E2\u0001\r!Q\u0001\u0005a\u0006\u0014H/\u0001\tg_J,\u0017m\u00195QCJ$\u0018\u000e^5p]R\u0011Q\r\u001b\t\u00031\u0019L!aZ\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006S6\u0001\rA[\u0001\u0004MVt\u0007#\u0002\rl\u0003\u0016+\u0017B\u00017\u001a\u0005%1UO\\2uS>t''A\bhKR\u0014Vm\u001d9p]N,7+\u001b>f)\ry'o\u001f\t\u00031AL!!]\r\u0003\u0007%sG\u000fC\u0003t\u001d\u0001\u0007A/A\u0004va\u0012\fG/Z:\u0011\u0005UDhB\u0001\u0010w\u0013\t9\u0018#\u0001\u0007GKR\u001c\u0007nU3tg&|g.\u0003\u0002zu\nA!+R*Q?6\u000b\u0005K\u0003\u0002x#!)AP\u0004a\u0001{\u0006Ia/\u001a:tS>t\u0017\n\u001a\t\u00031yL!a`\r\u0003\u000bMCwN\u001d;\u0002;U\u0004H-\u0019;f\u0003:$w)\u001a8fe\u0006$XMU3ta>t7/\u001a#bi\u0006$B!!\u0002\u0002\u0012A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f\u001d\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u001f\tIAA\u0007GKR\u001c\u0007NU3ta>t7/\u001a\u0005\u0006g>\u0001\r\u0001\u001e")
public class FullFetchContext
implements FetchContext {
    private final Time time;
    private final FetchSessionCache cache;
    private final Map<TopicIdPartition, PartitionFetchMetadata> fetchData;
    private final boolean usesTopicIds;
    private final boolean isFromFollower;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        return FetchContext.getThrottledResponse$(this, throttleTimeMs);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    private Map<TopicIdPartition, PartitionFetchMetadata> fetchData() {
        return this.fetchData;
    }

    private boolean usesTopicIds() {
        return this.usesTopicIds;
    }

    private boolean isFromFollower() {
        return this.isFromFollower;
    }

    @Override
    public Option<Object> getFetchOffset(TopicIdPartition part) {
        return Option$.MODULE$.apply((Object)this.fetchData().get(part)).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.fetchOffset()));
    }

    @Override
    public void foreachPartition(Function2<TopicIdPartition, PartitionFetchMetadata, BoxedUnit> fun) {
        this.fetchData().forEach((topicPartition, partition) -> fun.apply(topicPartition, partition));
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, short versionId) {
        return FetchResponse.sizeOf((short)versionId, updates.entrySet().iterator());
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates) {
        int responseSessionId = this.cache().maybeCreateSession(this.time().milliseconds(), this.isFromFollower(), updates.size(), this.usesTopicIds(), (Function0<ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata>>)(Function0 & Serializable)() -> this.createNewSession$1(updates));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Full fetch context with session id ").append(responseSessionId).append(" returning ").append(this.partitionsToLogString(updates.keySet())).toString());
        return FetchResponse.of((Errors)Errors.NONE, (int)0, (int)responseSessionId, updates);
    }

    private final ImplicitLinkedHashCollection createNewSession$1(LinkedHashMap updates$2) {
        ImplicitLinkedHashCollection cachedPartitions = new ImplicitLinkedHashCollection(updates$2.size());
        updates$2.forEach((part, respData) -> {
            PartitionFetchMetadata reqData = this.fetchData().get(part);
            IncrementalPartitionFetchMetadata cachedPartition = new IncrementalPartitionFetchMetadata((TopicIdPartition)part, reqData);
            cachedPartition.maybeUpdateResponseData((FetchResponseData.PartitionData)respData, true);
            cachedPartitions.mustAdd((ImplicitLinkedHashCollection.Element)cachedPartition);
        });
        return cachedPartitions;
    }

    public FullFetchContext(Time time, FetchSessionCache cache, Map<TopicIdPartition, PartitionFetchMetadata> fetchData, boolean usesTopicIds, boolean isFromFollower) {
        this.time = time;
        this.cache = cache;
        this.fetchData = fetchData;
        this.usesTopicIds = usesTopicIds;
        this.isFromFollower = isFromFollower;
    }
}

