/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import kafka.server.link.ClusterLinkClearLinkReference$;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001B\u0016-\u0001MB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"Ia\u000b\u0001B\u0001B\u0003%qK\u0017\u0005\t7\u0002\u0011\t\u0011)A\u00059\"Aq\f\u0001B\u0001B\u0003%\u0001\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003l\u0011!\u0019\bA!A!\u0002\u0013!\b\u0002\u0003>\u0001\u0005\u0003\u0005\u000b\u0011B>\t\u0013y\u0004!\u0011!Q\u0001\nm|\b\"CA\u0002\u0001\t\u0005\t\u0015!\u0003|\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fA\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005=\u0002\u0001)A\u0005\u0003GA\u0011\"!\r\u0001\u0001\u0004%I!a\r\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005u\u0002\u0002CA\"\u0001\u0001\u0006K!!\u000e\t\u0013\u0005\u0015\u0003\u00011A\u0005\n\u0005M\u0002\"CA$\u0001\u0001\u0007I\u0011BA%\u0011!\ti\u0005\u0001Q!\n\u0005U\u0002bCA(\u0001\u0001\u0007\t\u0019!C\u0005\u0003#B1\"a\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002n!Y\u0011\u0011\u000f\u0001A\u0002\u0003\u0005\u000b\u0015BA*\u0011\u001d\t\u0019\b\u0001C)\u0003kBq!a\u001e\u0001\t\u0013\t)\bC\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005e\u0004\u0001\"\u0003\u0002\b\"9\u00111\u0013\u0001\u0005\n\u0005U\u0004bBAK\u0001\u0011%\u0011Q\u000f\u0005\b\u0003/\u0003A\u0011BAM\u0011\u001d\ty\n\u0001C\u0005\u0003CCq!!3\u0001\t\u0013\t)\bC\u0004\u0002L\u0002!I!!\u001e\t\u000f\u00055\u0007\u0001\"\u0001\u00024\u001d9\u0011q\u001a\u0017\t\u0002\u0005EgAB\u0016-\u0011\u0003\t\u0019\u000eC\u0004\u0002\u0006\r\"\t!a:\t\u0011\u0005%8\u0005\"\u0001-\u0003WD\u0001\"a=$\t\u0003a\u0013Q\u001f\u0005\t\u0003s\u001cC\u0011\u0001\u0017\u0002|\"I!QA\u0012\u0012\u0002\u0013\u0005!q\u0001\u0005\n\u0005;\u0019\u0013\u0013!C\u0001\u0005\u000fA\u0011Ba\b$#\u0003%\tAa\u0002\u0003;\rcWo\u001d;fe2Kgn[\"mK\u0006\u0014H*\u001b8l%\u00164WM]3oG\u0016T!!\f\u0018\u0002\t1Lgn\u001b\u0006\u0003_A\naa]3sm\u0016\u0014(\"A\u0019\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u000e\t\u0003ker!AN\u001c\u000e\u00031J!\u0001\u000f\u0017\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\tQ4H\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u00029Y\u00051A.\u001b8l\u0013\u0012\u0004\"A\u0010$\u000e\u0003}R!\u0001Q!\u0002\r\r|W.\\8o\u0015\t\t$I\u0003\u0002D\t\u00061\u0011\r]1dQ\u0016T\u0011!R\u0001\u0004_J<\u0017BA$@\u0005\u0011)V/\u001b3\u0002\u00111Lgn\u001b(b[\u0016\u0004\"AS*\u000f\u0005-\u000b\u0006C\u0001'P\u001b\u0005i%B\u0001(3\u0003\u0019a$o\\8u})\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\u00061\u0001K]3eK\u001aL!\u0001V+\u0003\rM#(/\u001b8h\u0015\t\u0011v*A\u0005tG\",G-\u001e7feB\u0011a\u0007W\u0005\u000332\u0012Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018B\u0001,:\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014\bC\u0001\u001c^\u0013\tqFF\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\u0006bkRDwN]5{KJ\u00042!\u00192e\u001b\u0005y\u0015BA2P\u0005\u0019y\u0005\u000f^5p]B\u0011Q\r[\u0007\u0002M*\u0011ql\u001a\u0006\u0003_\u0005K!!\u001b4\u0003\u0015\u0005+H\u000f[8sSj,'/\u0001\u0006m_\u000e\fG.\u00113nS:\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\u000b\u0005$W.\u001b8\u000b\u0005A\f\u0015aB2mS\u0016tGo]\u0005\u0003e6\u0014abQ8oM2,XM\u001c;BI6Lg.\u0001\nd_6\u0004H.\u001a;j_:\u001c\u0015\r\u001c7cC\u000e\\\u0007cA1vo&\u0011ao\u0014\u0002\n\rVt7\r^5p]B\u0002\"!\u0019=\n\u0005e|%\u0001B+oSR\fa\u0002^8qS\u000e<%o\\;q'&TX\r\u0005\u0002by&\u0011Qp\u0014\u0002\u0004\u0013:$\u0018AC5oi\u0016\u0014h/\u00197Ng&\u0019\u0011\u0011A\u001d\u0002#I,7o\u00195fIVdW\rR3mCfl5/\u0001\u0007sKR\u0014\u0018\u0010R3mCfl5/\u0001\u0004=S:LGO\u0010\u000b\u0017\u0003\u0013\tY!!\u0004\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001eA\u0011a\u0007\u0001\u0005\u0006y-\u0001\r!\u0010\u0005\u0006\u0011.\u0001\r!\u0013\u0005\u0006-.\u0001\ra\u0016\u0005\u00067.\u0001\r\u0001\u0018\u0005\u0006?.\u0001\r\u0001\u0019\u0005\u0006U.\u0001\ra\u001b\u0005\u0006g.\u0001\r\u0001\u001e\u0005\bu.\u0001\n\u00111\u0001|\u0011\u001dq8\u0002%AA\u0002mD\u0001\"a\u0001\f!\u0003\u0005\ra_\u0001\u000bY&t7NR5mi\u0016\u0014XCAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015\u007f\u0005\u0019\u0011m\u00197\n\t\u00055\u0012q\u0005\u0002\u0019\u0003\u000e\u001cWm]:D_:$(o\u001c7F]R\u0014\u0018PR5mi\u0016\u0014\u0018a\u00037j].4\u0015\u000e\u001c;fe\u0002\n1\"\u001e9eCR,G-Q2mgV\u0011\u0011Q\u0007\t\u0004C\u0006]\u0012bAA\u001d\u001f\n9!i\\8mK\u0006t\u0017aD;qI\u0006$X\rZ!dYN|F%Z9\u0015\u0007]\fy\u0004C\u0005\u0002B=\t\t\u00111\u0001\u00026\u0005\u0019\u0001\u0010J\u0019\u0002\u0019U\u0004H-\u0019;fI\u0006\u001bGn\u001d\u0011\u0002\u001bU\u0004H-\u0019;fIR{\u0007/[2t\u0003E)\b\u000fZ1uK\u0012$v\u000e]5dg~#S-\u001d\u000b\u0004o\u0006-\u0003\"CA!%\u0005\u0005\t\u0019AA\u001b\u00039)\b\u000fZ1uK\u0012$v\u000e]5dg\u0002\n1\u0002^8qS\u000e<%o\\;qgV\u0011\u00111\u000b\t\u0007\u0003+\ny&!\u001a\u000f\t\u0005]\u00131\f\b\u0004\u0019\u0006e\u0013\"\u0001)\n\u0007\u0005us*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00141\r\u0002\u0005\u0019&\u001cHOC\u0002\u0002^=\u0003BASA4\u0013&\u0019\u0011\u0011N+\u0003\u0007M+G/A\bu_BL7m\u0012:pkB\u001cx\fJ3r)\r9\u0018q\u000e\u0005\n\u0003\u0003*\u0012\u0011!a\u0001\u0003'\nA\u0002^8qS\u000e<%o\\;qg\u0002\n1A];o)\t\t)$A\u0006qe>\u001cWm]:BG2\u001c\u0018!F2mK\u0006\u0014H*\u001b8l\u0003\u000ed7oQ8na2,G/\u001a\u000b\u0005\u0003k\ti\bC\u0004\u0002\u0000e\u0001\r!!!\u0002!\r\u0014X-\u0019;f\u0003\u000ed7OU3tk2$\bc\u00017\u0002\u0004&\u0019\u0011QQ7\u0003!\r\u0013X-\u0019;f\u0003\u000ed7OU3tk2$H\u0003BA\u001b\u0003\u0013Cq!a#\u001b\u0001\u0004\ti)\u0001\teK2,G/Z!dYN\u0014Vm];miB\u0019A.a$\n\u0007\u0005EUN\u0001\tEK2,G/Z!dYN\u0014Vm];mi\u0006i\u0001O]8dKN\u001cHk\u001c9jGN\f\u0011\u0003\u001d:pG\u0016\u001c8\u000fV8qS\u000e\u001cxJ\\2f\u0003E\u0019G.Z1s\u001b&\u0014(o\u001c:U_BL7m\u001d\u000b\u0005\u0003k\tY\nC\u0004\u0002\u001ev\u0001\r!!\u001a\u0002\rQ|\u0007/[2t\u0003e\u0019G.Z1s\u001b&\u0014(o\u001c:U_BL7m]\"p[BdW\r^3\u0015\t\u0005U\u00121\u0015\u0005\b\u0003Ks\u0002\u0019AAT\u0003\u001d\u0011Xm];miN\u0004r!!+\u00024&\u000b9,\u0004\u0002\u0002,*!\u0011QVAX\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0016\u0001\u00026bm\u0006LA!!.\u0002,\n\u0019Q*\u00199\u0011\u000by\nI,!0\n\u0007\u0005mvHA\u0006LC\u001a\\\u0017MR;ukJ,\u0007\u0003BA`\u0003\u000bl!!!1\u000b\t\u0005\r\u0017qV\u0001\u0005Y\u0006tw-\u0003\u0003\u0002H\u0006\u0005'\u0001\u0002,pS\u0012\f\u0011\u0004Z3mKR,7\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC\u0006aqN\\\"p[BdW\r^5p]\u0006qq-\u001a;Va\u0012\fG/\u001a3BG2\u001c\u0018!H\"mkN$XM\u001d'j].\u001cE.Z1s\u0019&t7NU3gKJ,gnY3\u0011\u0005Y\u001a3#B\u0012\u0002V\u0006m\u0007cA1\u0002X&\u0019\u0011\u0011\\(\u0003\r\u0005s\u0017PU3g!\u0011\ti.a9\u000e\u0005\u0005}'bAAqa\u0005)Q\u000f^5mg&!\u0011Q]Ap\u0005\u001daunZ4j]\u001e$\"!!5\u00021MDw.\u001e7e\u00072,\u0017M\u001d'j].\u0014VMZ3sK:\u001cW\r\u0006\u0004\u00026\u00055\u0018q\u001e\u0005\u0006y\u0015\u0002\r!\u0010\u0005\u0007\u0003c,\u0003\u0019\u0001/\u0002\u000f5\fg.Y4fe\u00061\u0002.\u00198eY\u0016$U\r\\3uK\u0006\u001bGn\u001d*fgVdG\u000f\u0006\u0003\u00026\u0005]\bbBAFM\u0001\u0007\u0011QR\u0001\u0017Q\u0006tG\r\\3De\u0016\fG/Z!dYN\u0014Vm];miR!\u0011Q B\u0002!\u0019\t\u0017q`A\u001bw&\u0019!\u0011A(\u0003\rQ+\b\u000f\\33\u0011\u001d\tyh\na\u0001\u0003\u0003\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012BTC\u0001B\u0005U\rY(1B\u0016\u0003\u0005\u001b\u0001BAa\u0004\u0003\u001a5\u0011!\u0011\u0003\u0006\u0005\u0005'\u0011)\"A\u0005v]\u000eDWmY6fI*\u0019!qC(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u001c\tE!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe\nA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004\u0007")
public class ClusterLinkClearLinkReference
extends ClusterLinkScheduler.PeriodicTask {
    private final Uuid linkId;
    private final String linkName;
    private final ClusterLinkMetadataManager metadataManager;
    private final Option<Authorizer> authorizer;
    private final ConfluentAdmin localAdmin;
    private final Function0<BoxedUnit> completionCallback;
    private final int topicGroupSize;
    private final int retryDelayMs;
    private final AccessControlEntryFilter linkFilter;
    private boolean updatedAcls;
    private boolean updatedTopics;
    private List<Set<String>> topicGroups;

    public static int $lessinit$greater$default$10() {
        return 1000;
    }

    public static int $lessinit$greater$default$9() {
        return 5000;
    }

    public static int $lessinit$greater$default$8() {
        return 100;
    }

    private AccessControlEntryFilter linkFilter() {
        return this.linkFilter;
    }

    private boolean updatedAcls() {
        return this.updatedAcls;
    }

    private void updatedAcls_$eq(boolean x$1) {
        this.updatedAcls = x$1;
    }

    private boolean updatedTopics() {
        return this.updatedTopics;
    }

    private void updatedTopics_$eq(boolean x$1) {
        this.updatedTopics = x$1;
    }

    private List<Set<String>> topicGroups() {
        return this.topicGroups;
    }

    private void topicGroups_$eq(List<Set<String>> x$1) {
        this.topicGroups = x$1;
    }

    @Override
    public boolean run() {
        if (!ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId, this.metadataManager)) {
            return this.onCompletion();
        }
        if (!this.updatedAcls() && this.authorizer.nonEmpty()) {
            return this.processAcls();
        }
        if (!this.updatedTopics()) {
            return this.processTopics();
        }
        ClusterLinkMetadataManager clusterLinkMetadataManager = this.metadataManager;
        if (clusterLinkMetadataManager instanceof ClusterLinkMetadataManagerWithZkSupport) {
            return this.deleteClusterLinkMetadata();
        }
        if (clusterLinkMetadataManager instanceof ClusterLinkMetadataManagerWithKRaftSupport) {
            return this.onCompletion();
        }
        if (clusterLinkMetadataManager != null) {
            throw new IllegalStateException("Unsupported type of ClusterLinkMetadataManager");
        }
        throw new MatchError(null);
    }

    private boolean processAcls() {
        this.authorizer.foreach((Function1 & Serializable)authz -> {
            Iterable linkAcls = CollectionConverters$.MODULE$.IterableHasAsScala(authz.acls(new AclBindingFilter(ResourcePatternFilter.ANY, this.linkFilter()))).asScala();
            Iterable aclsToAdd = (Iterable)linkAcls.filterNot((Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$processAcls$2(acl)));
            if (linkAcls.isEmpty()) {
                this.updatedAcls_$eq(true);
                return BoxesRunTime.boxToBoolean((boolean)this.processTopics());
            }
            if (aclsToAdd.nonEmpty()) {
                java.util.List localAcls = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)aclsToAdd.map((Function1 & Serializable)acl -> {
                    AccessControlEntry ace = new AccessControlEntry(acl.entry().principal(), acl.entry().host(), acl.entry().operation(), acl.entry().permissionType());
                    return new AclBinding(acl.pattern(), ace);
                })).toList()).asJava();
                CreateAclsResult createAclResult = $this.localAdmin.createAcls((Collection)localAcls);
                Iterable createAclsFuture = CollectionConverters$.MODULE$.MapHasAsScala(createAclResult.values()).asScala().values();
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAclsFuture.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.clearLinkAclsComplete(createAclResult));
                return BoxedUnit.UNIT;
            }
            java.util.List aclsToRemove = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)linkAcls.map((Function1 & Serializable)acl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, (Collection)this.linkFilter().clusterLinkIds()).toFilter())).toList()).asJava();
            DeleteAclsResult deleteAclsResult = $this.localAdmin.deleteAcls((Collection)aclsToRemove);
            Iterable deleteAclsResultFutures = CollectionConverters$.MODULE$.MapHasAsScala(deleteAclsResult.values()).asScala().values();
            this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.clearLinkAclsComplete(deleteAclsResult));
            return BoxedUnit.UNIT;
        });
        return this.updatedAcls();
    }

    private boolean clearLinkAclsComplete(CreateAclsResult createAclsResult) {
        boolean success = ClusterLinkClearLinkReference$.MODULE$.handleCreateAclsResult(createAclsResult)._1$mcZ$sp();
        this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processAcls(), success ? 0L : (long)this.retryDelayMs);
        return false;
    }

    private boolean clearLinkAclsComplete(DeleteAclsResult deleteAclsResult) {
        boolean success = ClusterLinkClearLinkReference$.MODULE$.handleDeleteAclsResult(deleteAclsResult);
        this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processAcls(), success ? 0L : (long)this.retryDelayMs);
        return false;
    }

    private boolean processTopics() {
        Set<String> topicSet = this.metadataManager.getAllTopicsInCluster();
        this.topicGroups_$eq((List<Set<String>>)topicSet.grouped(this.topicGroupSize).toList());
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Processing ").append(topicSet.size()).append(" topics for cluster link removal for cluster link id ").append($this.linkId).toString());
        return this.processTopicsOnce();
    }

    private boolean processTopicsOnce() {
        if (this.topicGroups().isEmpty()) {
            this.updatedTopics_$eq(true);
            return this.deleteClusterLinkMetadata();
        }
        Map mirrorTopics = (Map)this.metadataManager.mirrorTopicStatesFromMetadataStore((Set<String>)((Set)this.topicGroups().head())).filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$processTopicsOnce$1(this, entry)));
        if (mirrorTopics.nonEmpty()) {
            return this.clearMirrorTopics((Set<String>)mirrorTopics.keys().toSet());
        }
        this.topicGroups_$eq((List<Set<String>>)((List)this.topicGroups().drop(1)));
        this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processTopicsOnce(), this.scheduleOnce$default$2());
        return false;
    }

    private boolean clearMirrorTopics(Set<String> topics) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Clearing mirror topics for topics '").append(topics).append("' for cluster link id ").append($this.linkId).toString());
        try {
            scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)AlterMirrorOp.CLEAR))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            AlterMirrorsOptions options = new AlterMirrorsOptions();
            AlterMirrorsResult result = this.localAdmin.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava(), options);
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.clearMirrorTopicsComplete(result.values()));
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Encountered error while clearing mirror topics. Will try again in ").append($this.retryDelayMs).append(" ms").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processTopicsOnce(), this.retryDelayMs);
        }
        return false;
    }

    private boolean clearMirrorTopicsComplete(java.util.Map<String, KafkaFuture<Void>> results) {
        if (CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$clearMirrorTopicsComplete$1(this, x0$1)))) {
            this.topicGroups_$eq((List<Set<String>>)((List)this.topicGroups().drop(1)));
            this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processTopicsOnce(), this.scheduleOnce$default$2());
        } else {
            this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processTopicsOnce(), this.retryDelayMs);
        }
        return false;
    }

    private boolean deleteClusterLinkMetadata() {
        boolean bl;
        try {
            if (this.metadataManager.isLinkCoordinatorEnabled()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Deleting the metadata for link ").append($this.linkName).toString());
                DeleteClusterLinksResult result = this.localAdmin.deleteClusterLinks(Collections.singletonList(this.linkName), new DeleteClusterLinksOptions().deleteMetadata(true));
                this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> {
                    try {
                        result.all().get();
                        return this.onCompletion();
                    }
                    catch (Throwable ex) {
                        throw this.handleException$1(ex);
                    }
                });
                return false;
            }
            bl = this.onCompletion();
        }
        catch (Throwable ex) {
            throw this.handleException$1(ex);
        }
        return bl;
    }

    private boolean onCompletion() {
        this.shutdown();
        super.scheduler().scheduleOnce("ClearLinkReferenceCompleted", () -> $this.completionCallback.apply$mcV$sp());
        return true;
    }

    public boolean getUpdatedAcls() {
        return this.updatedAcls();
    }

    public static final /* synthetic */ boolean $anonfun$processAcls$2(AclBinding acl) {
        return acl.entry().clusterLinkIds().contains(Uuid.ZERO_UUID);
    }

    public static final /* synthetic */ boolean $anonfun$processTopicsOnce$1(ClusterLinkClearLinkReference $this, Tuple2 entry) {
        Uuid uuid = ((ClusterLinkTopicState)entry._2()).linkId();
        Uuid uuid2 = $this.linkId;
        return !(uuid != null ? !uuid.equals(uuid2) : uuid2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$clearMirrorTopicsComplete$1(ClusterLinkClearLinkReference $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            try {
                ((KafkaFuture)x0$1._2()).get();
                return true;
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof UnknownTopicOrPartitionException) {
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(103).append("Encountered UnknownTopicOrPartitionException while clearing mirror topic '").append(topic).append("'.").append(" Mirror topic may not exist").toString());
                    return true;
                }
                if (throwable != null) {
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Encountered error while clearing mirror topic '").append(topic).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                    return false;
                }
                throw new MatchError(null);
            }
            catch (Throwable e) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Encountered error while clearing mirror topic '").append(topic).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return false;
            }
        }
        throw new MatchError(null);
    }

    private final Nothing$ handleException$1(Throwable ex) {
        ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, new StringBuilder(43).append("Failed to remove metadata for deleted link ").append(this.linkName).toString());
        this.warn((Function0<String>)(Function0 & Serializable)() -> "Failed to remove metadata for deleted link", (Function0<Throwable>)(Function0 & Serializable)() -> e);
        throw e;
    }

    public ClusterLinkClearLinkReference(Uuid linkId, String linkName, ClusterLinkScheduler scheduler, ClusterLinkMetadataManager metadataManager, Option<Authorizer> authorizer, ConfluentAdmin localAdmin, Function0<BoxedUnit> completionCallback, int topicGroupSize, int intervalMs, int retryDelayMs) {
        this.linkId = linkId;
        this.linkName = linkName;
        this.metadataManager = metadataManager;
        this.authorizer = authorizer;
        this.localAdmin = localAdmin;
        this.completionCallback = completionCallback;
        this.topicGroupSize = topicGroupSize;
        this.retryDelayMs = retryDelayMs;
        super(scheduler, "ClearLinkReference", intervalMs);
        this.linkFilter = new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY, Collections.singleton(linkId));
        this.updatedAcls = false;
        this.updatedTopics = false;
    }
}

