/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001\u0002\f\u0018\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ts\u0001\u0011\t\u0011)A\u0005u!Aq\t\u0001B\u0001B\u0003%\u0001\nC\u0005P\u0001\t\u0005\t\u0015!\u0003Q'\"AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011!\u0011\u0007A!A!\u0002\u0013\u0019\u0007\"\u00034\u0001\u0005\u0003\u0005\u000b\u0011B2h\u0011!I\u0007A!A!\u0002\u0013\u0019\u0007\"\u00026\u0001\t\u0003Y\u0007\"\u0002<\u0001\t#:\b\"\u0002=\u0001\t\u0013I\b\"\u0002?\u0001\t\u0013i\bbBA\u000b\u0001\u0011%\u0011q\u0003\u0005\b\u0003\u0003\u0002A\u0011BA\"\u000f%\t9eFA\u0001\u0012\u0003\tIE\u0002\u0005\u0017/\u0005\u0005\t\u0012AA&\u0011\u0019Q\u0017\u0003\"\u0001\u0002T!I\u0011QK\t\u0012\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003[\n\u0012\u0013!C\u0001\u0003/B\u0011\"a\u001c\u0012#\u0003%\t!a\u0016\u00039\rcWo\u001d;fe2Kgn\u001b)bkN,W*\u001b:s_J$v\u000e]5dg*\u0011\u0001$G\u0001\u0005Y&t7N\u0003\u0002\u001b7\u000511/\u001a:wKJT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001qd\n\t\u0003A\u0011r!!\t\u0012\u000e\u0003]I!aI\f\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\t)cE\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u0002$/A\u0011\u0001fK\u0007\u0002S)\u0011!fG\u0001\u0006kRLGn]\u0005\u0003Y%\u0012q\u0001T8hO&tw-\u0001\u0004mS:\\\u0017\n\u001a\t\u0003_]j\u0011\u0001\r\u0006\u0003cI\naaY8n[>t'B\u0001\u000f4\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005a\u0002$\u0001B+vS\u0012\f\u0001\u0002\\5oW:\u000bW.\u001a\t\u0003w\u0011s!\u0001\u0010\"\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}j\u0012A\u0002\u001fs_>$hHC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013aa\u0015;sS:<'BA\"A\u00031a\u0017N\\6JgB\u000bWo]3e!\rI%\nT\u0007\u0002\u0001&\u00111\n\u0011\u0002\n\rVt7\r^5p]B\u0002\"!S'\n\u00059\u0003%a\u0002\"p_2,\u0017M\\\u0001\ng\u000eDW\rZ;mKJ\u0004\"!I)\n\u0005I;\"\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u0002PI\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000f\u0005\u0002\"-&\u0011qk\u0006\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u000bY>\u001c\u0017\r\\!e[&t\u0007cA%K5B\u00111\fY\u0007\u00029*\u0011QLX\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003?J\nqa\u00197jK:$8/\u0003\u0002b9\nq1i\u001c8gYV,g\u000e^!e[&t\u0017!F7bqR{\u0007/[2t!\u0016\u0014\u0018\n^3sCRLwN\u001c\t\u0003\u0013\u0012L!!\u001a!\u0003\u0007%sG/\u0001\u0006j]R,'O^1m\u001bNL!\u0001\u001b\u0013\u0002#I,7o\u00195fIVdW\rR3mCfl5/\u0001\u0007sKR\u0014\u0018\u0010R3mCfl5/\u0001\u0004=S:LGO\u0010\u000b\u000bY6tw\u000e]9sgR,\bCA\u0011\u0001\u0011\u0015i#\u00021\u0001/\u0011\u0015I$\u00021\u0001;\u0011\u00159%\u00021\u0001I\u0011\u0015y%\u00021\u0001Q\u0011\u0015!&\u00021\u0001V\u0011\u0015A&\u00021\u0001Z\u0011\u001d\u0011'\u0002%AA\u0002\rDqA\u001a\u0006\u0011\u0002\u0003\u00071\rC\u0004j\u0015A\u0005\t\u0019A2\u0002\u0007I,h\u000eF\u0001M\u00035\u0011Xm]8mm\u0016$v\u000e]5dgR\u0011AJ\u001f\u0005\u0006w2\u0001\r\u0001T\u0001\tSN\u0004\u0016-^:fI\u0006i\u0001O]8dKN\u001cHk\u001c9jGN$2\u0001\u0014@\u0000\u0011\u0015YX\u00021\u0001M\u0011\u001d\t\t!\u0004a\u0001\u0003\u0007\ta\u0001^8qS\u000e\u001c\b#BA\u0003\u0003\u001fQd\u0002BA\u0004\u0003\u0017q1!PA\u0005\u0013\u0005\t\u0015bAA\u0007\u0001\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\t\u0003'\u00111aU3r\u0015\r\ti\u0001Q\u0001\u0016aJ|7-Z:t)>\u0004\u0018nY:D_6\u0004H.\u001a;f)\u0015a\u0015\u0011DA\u000e\u0011\u0015Yh\u00021\u0001M\u0011\u001d\tiB\u0004a\u0001\u0003?\tqA]3tk2$8\u000fE\u0004\u0002\"\u0005-\"(a\f\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\tA!\u001e;jY*\u0011\u0011\u0011F\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002.\u0005\r\"aA'baB)q&!\r\u00026%\u0019\u00111\u0007\u0019\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0005\u0003o\ti$\u0004\u0002\u0002:)!\u00111HA\u0014\u0003\u0011a\u0017M\\4\n\t\u0005}\u0012\u0011\b\u0002\u0005->LG-\u0001\u0004bGRLwN\u001c\u000b\u0004u\u0005\u0015\u0003\"B>\u0010\u0001\u0004a\u0015\u0001H\"mkN$XM\u001d'j].\u0004\u0016-^:f\u001b&\u0014(o\u001c:U_BL7m\u001d\t\u0003CE\u00192!EA'!\rI\u0015qJ\u0005\u0004\u0003#\u0002%AB!osJ+g\r\u0006\u0002\u0002J\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"!!\u0017+\u0007\r\fYf\u000b\u0002\u0002^A!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014!C;oG\",7m[3e\u0015\r\t9\u0007Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA6\u0003C\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%q\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe\u0002")
public class ClusterLinkPauseMirrorTopics
extends ClusterLinkScheduler.PeriodicTask {
    private final Uuid linkId;
    private final String linkName;
    private final Function0<Object> linkIsPaused;
    private final ClusterLinkMetadataManager metadataManager;
    private final Function0<ConfluentAdmin> localAdmin;
    private final int maxTopicsPerIteration;
    private final int retryDelayMs;

    public static int $lessinit$greater$default$9() {
        return 1000;
    }

    public static int $lessinit$greater$default$8() {
        return 5000;
    }

    public static int $lessinit$greater$default$7() {
        return 20;
    }

    @Override
    public boolean run() {
        if (this.metadataManager.isLinkCoordinator(this.linkName)) {
            return this.resolveTopics(this.linkIsPaused.apply$mcZ$sp());
        }
        return true;
    }

    private boolean resolveTopics(boolean isPaused) {
        Seq process = ((MapOps)this.metadataManager.mirrorTopicStatesFromMetadataCache(this.linkId).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkPauseMirrorTopics.$anonfun$resolveTopics$1(this, isPaused, x0$1)))).keys().toSeq();
        if (process.nonEmpty()) {
            Seq trimmed = process.size() > this.maxTopicsPerIteration ? (Seq)process.drop(process.size() - this.maxTopicsPerIteration) : process;
            return this.processTopics(isPaused, (Seq<String>)trimmed);
        }
        return true;
    }

    private boolean processTopics(boolean isPaused, Seq<String> topics) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Starting ").append(this.action(isPaused)).append(" mirror topics for topics '").append(topics).append("'").toString());
        try {
            scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)(isPaused ? AlterMirrorOp.PAUSE_LINK : AlterMirrorOp.RESUME_LINK)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            AlterMirrorsOptions options = new AlterMirrorsOptions();
            AlterMirrorsResult result = ((ConfluentAdmin)this.localAdmin.apply()).alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava(), options);
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.processTopicsComplete(isPaused, result.values()));
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Encountered error while ").append(this.action(isPaused)).append(" mirror topics").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.run(), this.retryDelayMs);
        }
        return false;
    }

    private boolean processTopicsComplete(boolean isPaused, java.util.Map<String, KafkaFuture<Void>> results) {
        if (CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkPauseMirrorTopics.$anonfun$processTopicsComplete$3(this, isPaused, x0$1)))) {
            if (isPaused == this.linkIsPaused.apply$mcZ$sp()) {
                return this.resolveTopics(isPaused);
            }
            return true;
        }
        this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.run(), this.retryDelayMs);
        return false;
    }

    private String action(boolean isPaused) {
        if (isPaused) {
            return "pausing";
        }
        return "unpausing";
    }

    public static final /* synthetic */ boolean $anonfun$resolveTopics$1(ClusterLinkPauseMirrorTopics $this, boolean isPaused$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            boolean bl;
            ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
            Uuid uuid = state.linkId();
            Uuid uuid2 = $this.linkId;
            if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
                return false;
            }
            try {
                if (!isPaused$1) {
                    return state.toUnpausedState(true).nonEmpty();
                }
                bl = state.toPausedState(true).nonEmpty();
            }
            catch (Throwable throwable) {
                bl = false;
            }
            return bl;
        }
        throw new MatchError(null);
    }

    private final boolean onError$1(Throwable e, boolean isPaused$3) {
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Encountered error while ").append(this.action(isPaused$3)).append(" mirror topics").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$processTopicsComplete$3(ClusterLinkPauseMirrorTopics $this, boolean isPaused$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            try {
                ((KafkaFuture)x0$1._2()).get();
                return true;
            }
            catch (ExecutionException e) {
                return $this.onError$1(e.getCause(), isPaused$3);
            }
            catch (Throwable e) {
                return $this.onError$1(e, isPaused$3);
            }
        }
        throw new MatchError(null);
    }

    public ClusterLinkPauseMirrorTopics(Uuid linkId, String linkName, Function0<Object> linkIsPaused, ClusterLinkScheduler scheduler, ClusterLinkMetadataManager metadataManager, Function0<ConfluentAdmin> localAdmin, int maxTopicsPerIteration, int intervalMs, int retryDelayMs) {
        this.linkId = linkId;
        this.linkName = linkName;
        this.linkIsPaused = linkIsPaused;
        this.metadataManager = metadataManager;
        this.localAdmin = localAdmin;
        this.maxTopicsPerIteration = maxTopicsPerIteration;
        this.retryDelayMs = retryDelayMs;
        super(scheduler, "PauseMirrorTopics", intervalMs);
    }
}

