/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.CancellationException;
import kafka.cluster.Partition;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.ValidateLogResult$;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreLinearRetry;
import kafka.tier.tasks.CompactionTasksConfig;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.compaction.CompactionTask$;
import kafka.tier.tasks.compaction.OffsetMapSupplier;
import kafka.tier.tasks.compaction.TierCleaner;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.ExtendedOffsetMap;
import org.apache.kafka.storage.internals.log.OffsetMap;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\ruf\u0001B#G\u0005=C\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t%\u0018\u0005\tI\u0002\u0011\t\u0011)A\u0005=\"AQ\r\u0001BC\u0002\u0013\u0005c\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003h\u0011!a\u0007A!b\u0001\n\u0003i\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011I\u0004!\u00111A\u0005\u0002MD!ba\u001a\u0001\u0005\u0003\u0007I\u0011AB5\u0011%\u0019i\u0007\u0001B\u0001B\u0003&A\u000f\u0003\u0006\u0002R\u0002\u0011)\u0019!C\u0001\u0007_B!b!\u001d\u0001\u0005\u0003\u0005\u000b\u0011BAj\u0011)\tY\u000e\u0001B\u0001B\u0003%\u0011Q\u001c\u0005\b\u0003+\u0001A\u0011AB:\u0011\u001d\tI\u0002\u0001C!\u00037A\u0011b!!\u0001\u0005\u0004%\taa!\t\u0011\r\u0015\u0005\u0001)A\u0005\u0005\u0013C\u0011ba\"\u0001\u0001\u0004%\ta!#\t\u0013\r5\u0005\u00011A\u0005\u0002\r=\u0005\u0002CBJ\u0001\u0001\u0006Kaa#\t\u000f\ru\u0005\u0001\"\u0001\u0004 \"9\u00111\u000e\u0001\u0005B\r\u001d\u0006b\u0002BL\u0001\u0011\u00053qE\u0004\b\u0003\u00071\u0005\u0012AA\u0003\r\u0019)e\t#\u0001\u0002\b!9\u0011Q\u0003\r\u0005\u0002\u0005]\u0001bBA\r1\u0011E\u00131\u0004\u0005\n\u0003[A\"\u0019!C\u0001\u0003_A\u0001\"a\u000e\u0019A\u0003%\u0011\u0011\u0007\u0005\n\u0003sA\"\u0019!C\u0001\u0003_A\u0001\"a\u000f\u0019A\u0003%\u0011\u0011\u0007\u0005\n\u0003{A\"\u0019!C\u0001\u0003\u007fA\u0001\"!\u0014\u0019A\u0003%\u0011\u0011\t\u0004\u000b\u0003\u001fB\u0002\u0013aI\u0011\r\u0006E\u0003bBA*C\u0019\u0005\u0011q\u0006\u0005\b\u0003+\nc\u0011AA,\u0011\u001d\tY'\tD\u0001\u0003[2a!a>\u0019\u0001\u0006e\bBCA*K\tU\r\u0011\"\u0001\u00020!Q!1C\u0013\u0003\u0012\u0003\u0006I!!\r\t\u0015\tUQE!f\u0001\n\u0003\u00119\u0002\u0003\u0006\u0003\u001a\u0015\u0012\t\u0012)A\u0005\u00033Bq!!\u0006&\t\u0003\u0011Y\u0002C\u0004\u0002V\u0015\"\t%a\u0016\t\u000f\u0005-T\u0005\"\u0011\u0003$!9!QH\u0013\u0005\u0002\t}\u0002b\u0002B1K\u0011%!1\r\u0005\b\u0005k*C\u0011\u0001B<\u0011\u001d\u00119*\nC!\u00053C\u0011Ba'&\u0003\u0003%\tA!(\t\u0013\t\rV%%A\u0005\u0002\t\u0015\u0006\"\u0003B^KE\u0005I\u0011\u0001B_\u0011%\u0011\t-JA\u0001\n\u0003\u0012\u0019\rC\u0005\u0003T\u0016\n\t\u0011\"\u0001\u00020!I!Q[\u0013\u0002\u0002\u0013\u0005!q\u001b\u0005\n\u0005G,\u0013\u0011!C!\u0005KD\u0011Ba=&\u0003\u0003%\tA!>\t\u0013\teX%!A\u0005B\tm\b\"\u0003B\u0000K\u0005\u0005I\u0011IB\u0001\u0011%\u0019\u0019!JA\u0001\n\u0003\u001a)aB\u0005\u0004\na\t\t\u0011#\u0001\u0004\f\u0019I\u0011q\u001f\r\u0002\u0002#\u00051Q\u0002\u0005\b\u0003+iD\u0011AB\u0013\u0011%\u00119*PA\u0001\n\u000b\u001a9\u0003C\u0005\u0004*u\n\t\u0011\"!\u0004,!I1\u0011G\u001f\u0002\u0002\u0013\u000551\u0007\u0005\n\u0007\u0003j\u0014\u0011!C\u0005\u0007\u0007Bqaa\u0013\u0019\t\u0003\u0019i\u0005C\u0004\u0004^a!Iaa\u0018\u0003\u001d\r{W\u000e]1di&|g\u000eV1tW*\u0011q\tS\u0001\u000bG>l\u0007/Y2uS>t'BA%K\u0003\u0015!\u0018m]6t\u0015\tYE*\u0001\u0003uS\u0016\u0014(\"A'\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0015,\u0011\u0007E\u0013F+D\u0001I\u0013\t\u0019\u0006J\u0001\u0005US\u0016\u0014H+Y:l!\t)\u0006!D\u0001G!\t9&,D\u0001Y\u0015\tIF*A\u0003vi&d7/\u0003\u0002\\1\n9Aj\\4hS:<\u0017aA2uqV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002b\u0015\u00069a-\u001a;dQ\u0016\u0014\u0018BA2a\u0005M\u0019\u0015M\\2fY2\fG/[8o\u0007>tG/\u001a=u\u0003\u0011\u0019G\u000f\u001f\u0011\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>tW#A4\u0011\u0005!LW\"\u0001&\n\u0005)T%\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003E!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0012_\u001a47/\u001a;NCB\u001cV\u000f\u001d9mS\u0016\u0014X#\u00018\u0011\u0005U{\u0017B\u00019G\u0005EyeMZ:fi6\u000b\u0007oU;qa2LWM]\u0001\u0013_\u001a47/\u001a;NCB\u001cV\u000f\u001d9mS\u0016\u0014\b%A\u0003ti\u0006$X-F\u0001u!\t)\u0018E\u0004\u0002w/9\u0019q/!\u0001\u000f\u0005a|hBA=\u007f\u001d\tQX0D\u0001|\u0015\tah*\u0001\u0004=e>|GOP\u0005\u0002\u001b&\u00111\nT\u0005\u0003\u0013*K!a\u0012%\u0002\u001d\r{W\u000e]1di&|g\u000eV1tWB\u0011Q\u000bG\n\u00051\u0005%a\u000b\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\t\ty!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0014\u00055!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u000b\t!\u0002\\8hO\u0016\u0014h*Y7f+\t\ti\u0002\u0005\u0003\u0002 \u0005\u001db\u0002BA\u0011\u0003G\u00012A_A\u0007\u0013\u0011\t)#!\u0004\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\u0011\t)#!\u0004\u0002)\u0011+g-Y;mi6\u000b\u0007PU3uef\u001cu.\u001e8u+\t\t\t\u0004\u0005\u0003\u0002\f\u0005M\u0012\u0002BA\u001b\u0003\u001b\u00111!\u00138u\u0003U!UMZ1vYRl\u0015\r\u001f*fiJL8i\\;oi\u0002\n\u0001\u0004R3gCVdGOU3uefLe\u000e^3sm\u0006d\u0017J\\'t\u0003e!UMZ1vYR\u0014V\r\u001e:z\u0013:$XM\u001d<bY&sWj\u001d\u0011\u0002%\u0011+g-Y;miJ+GO]=Q_2L7-_\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000fR\u0015!B:u_J,\u0017\u0002BA&\u0003\u000b\u0012!\u0004V5fe>\u0013'.Z2u'R|'/\u001a'j]\u0016\f'OU3uef\f1\u0003R3gCVdGOU3uef\u0004v\u000e\\5ds\u0002\u00121cQ8na\u0006\u001cG/[8o)\u0006\u001c8n\u0015;bi\u0016\u001c2!IA\u0005\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0002\u0019\rdW-\u00198feN#\u0018\r^:\u0015\u0005\u0005e\u0003CBA\u0006\u00037\ny&\u0003\u0003\u0002^\u00055!AB(qi&|g\u000e\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)\u0007T\u0001\u0004Y><\u0017\u0002BA5\u0003G\u0012Ab\u00117fC:,'o\u0015;biN\f!\u0002\u001e:b]NLG/[8o)Y\ty'a#\u0002\u000e\u0006=\u0015qTAX\u0003s\u000b\u0019-!4\u0002P\u0006eG\u0003BA9\u0003\u0003\u0003b!a\u001d\u0002z\u0005uTBAA;\u0015\u0011\t9(!\u0004\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002|\u0005U$A\u0002$viV\u0014X\rE\u0002\u0002\u0000\u0005j\u0011\u0001\u0007\u0005\b\u0003\u0007#\u00039AAC\u0003\t)7\r\u0005\u0003\u0002t\u0005\u001d\u0015\u0002BAE\u0003k\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000bq#\u0003\u0019\u00010\t\u000b\u0015$\u0003\u0019A4\t\u000f\u0005EE\u00051\u0001\u0002\u0014\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0003BAK\u00037k!!a&\u000b\u0007\u0005eE*\u0001\u0004tKJ4XM]\u0005\u0005\u0003;\u000b9J\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000f\u0005\u0005F\u00051\u0001\u0002$\u0006\tB/[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OS1!!+K\u0003\u0015!x\u000e]5d\u0013\u0011\ti+a*\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000fC\u0004\u00022\u0012\u0002\r!a-\u0002\u001fQLWM](cU\u0016\u001cGo\u0015;pe\u0016\u0004B!a\u0011\u00026&!\u0011qWA#\u0005=!\u0016.\u001a:PE*,7\r^*u_J,\u0007bBA^I\u0001\u0007\u0011QX\u0001\u0007G>tg-[4\u0011\u0007E\u000by,C\u0002\u0002B\"\u0013q\u0002V5feR\u000b7o[:D_:4\u0017n\u001a\u0005\b\u0003\u000b$\u0003\u0019AAd\u0003%!\bN]8ui2,'\u000fE\u0002X\u0003\u0013L1!a3Y\u0005%!\u0006N]8ui2,'\u000fC\u0003mI\u0001\u0007a\u000eC\u0004\u0002R\u0012\u0002\r!a5\u0002+QLWM]\"p[B\f7\r^5p]6+GO]5dgB\u0019Q+!6\n\u0007\u0005]gIA\u000bUS\u0016\u00148i\\7qC\u000e$\u0018n\u001c8NKR\u0014\u0018nY:\t\u000f\u0005mG\u00051\u0001\u0002^\u0006!A/[7f!\u0011\ty.!=\u000e\u0005\u0005\u0005(bA-\u0002d*!\u0011Q]At\u0003\u0019\u0019w.\\7p]*\u0019Q*!;\u000b\t\u0005-\u0018Q^\u0001\u0007CB\f7\r[3\u000b\u0005\u0005=\u0018aA8sO&!\u00111_Aq\u0005\u0011!\u0016.\\3*\u0005\u0005*#\u0001C\"mK\u0006tGj\\4\u0014\u0013\u0015\nI!! \u0002|\n\u0005\u0001\u0003BA\u0006\u0003{LA!a@\u0002\u000e\t9\u0001K]8ek\u000e$\b\u0003\u0002B\u0002\u0005\u001bqAA!\u0002\u0003\n9\u0019!Pa\u0002\n\u0005\u0005=\u0011\u0002\u0002B\u0006\u0003\u001b\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0010\tE!\u0001D*fe&\fG.\u001b>bE2,'\u0002\u0002B\u0006\u0003\u001b\tA\u0002\\3bI\u0016\u0014X\t]8dQ\u0002\n\u0011\u0002\\1tiN#\u0018\r^:\u0016\u0005\u0005e\u0013A\u00037bgR\u001cF/\u0019;tAQ1!Q\u0004B\u0010\u0005C\u00012!a &\u0011\u001d\t\u0019F\u000ba\u0001\u0003cAqA!\u0006+\u0001\u0004\tI\u0006\u0006\f\u0003&\t%\"1\u0006B\u0017\u0005_\u0011\tDa\r\u00036\t]\"\u0011\bB\u001e)\u0011\t\tHa\n\t\u000f\u0005\rE\u0006q\u0001\u0002\u0006\")A\f\fa\u0001=\")Q\r\fa\u0001O\"9\u0011\u0011\u0013\u0017A\u0002\u0005M\u0005bBAQY\u0001\u0007\u00111\u0015\u0005\b\u0003cc\u0003\u0019AAZ\u0011\u001d\tY\f\fa\u0001\u0003{Cq!!2-\u0001\u0004\t9\rC\u0003mY\u0001\u0007a\u000eC\u0004\u0002R2\u0002\r!a5\t\u000f\u0005mG\u00061\u0001\u0002^\u0006QAm\\\"mK\u0006tGj\\4\u00151\t\u0005#Q\tB$\u0005\u0013\u0012YE!\u0014\u0003P\tE#\u0011\fB.\u0005;\u0012y\u0006\u0006\u0003\u0002r\t\r\u0003bBAB[\u0001\u000f\u0011Q\u0011\u0005\u000696\u0002\rA\u0018\u0005\b\u0003Ck\u0003\u0019AAR\u0011\u001d\t\u0019&\fa\u0001\u0003cAQ!Z\u0017A\u0002\u001dDq!!%.\u0001\u0004\t\u0019\nC\u0003m[\u0001\u0007a\u000eC\u0004\u0002<6\u0002\rAa\u0015\u0011\u0007E\u0013)&C\u0002\u0003X!\u0013QcQ8na\u0006\u001cG/[8o)\u0006\u001c8n]\"p]\u001aLw\rC\u0004\u000226\u0002\r!a-\t\u000f\u0005EW\u00061\u0001\u0002T\"9\u0011QY\u0017A\u0002\u0005\u001d\u0007bBAn[\u0001\u0007\u0011Q\\\u0001!g\"|W\u000f\u001c3E_\u0012+\u0018\r\\\"p[B\f7\r^5p]Z\u000bG.\u001b3bi&|g\u000e\u0006\u0004\u0003f\t-$1\u000f\t\u0005\u0003\u0017\u00119'\u0003\u0003\u0003j\u00055!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003Kr\u0003\u0019\u0001B7!\u0011\t\tGa\u001c\n\t\tE\u00141\r\u0002\f\u0003\n\u001cHO]1di2{w\rC\u0004\u0002<:\u0002\rAa\u0015\u0002\u0017I,7m\u001c:e'R\fGo\u001d\u000b\r\u0005s\u0012yHa!\u0003\u0006\n=%1\u0013\t\u0005\u0003\u0017\u0011Y(\u0003\u0003\u0003~\u00055!\u0001B+oSRDqA!!0\u0001\u0004\ti\"\u0001\u0003uCN\\\u0007\"B30\u0001\u00049\u0007b\u0002BD_\u0001\u0007!\u0011R\u0001\u0005MJ|W\u000e\u0005\u0003\u0002\f\t-\u0015\u0002\u0002BG\u0003\u001b\u0011A\u0001T8oO\"9!\u0011S\u0018A\u0002\t%\u0015A\u0001;p\u0011\u001d\u0011)j\fa\u0001\u0003?\nQa\u001d;biN\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003;\tAaY8qsR1!Q\u0004BP\u0005CC\u0011\"a\u00152!\u0003\u0005\r!!\r\t\u0013\tU\u0011\u0007%AA\u0002\u0005e\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005OSC!!\r\u0003*.\u0012!1\u0016\t\u0005\u0005[\u00139,\u0004\u0002\u00030*!!\u0011\u0017BZ\u0003%)hn\u00195fG.,GM\u0003\u0003\u00036\u00065\u0011AC1o]>$\u0018\r^5p]&!!\u0011\u0018BX\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yL\u000b\u0003\u0002Z\t%\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003FB!!q\u0019Bi\u001b\t\u0011IM\u0003\u0003\u0003L\n5\u0017\u0001\u00027b]\u001eT!Aa4\u0002\t)\fg/Y\u0005\u0005\u0003S\u0011I-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\te'q\u001c\t\u0005\u0003\u0017\u0011Y.\u0003\u0003\u0003^\u00065!aA!os\"I!\u0011\u001d\u001c\u0002\u0002\u0003\u0007\u0011\u0011G\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u001d\bC\u0002Bu\u0005_\u0014I.\u0004\u0002\u0003l*!!Q^A\u0007\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005c\u0014YO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B3\u0005oD\u0011B!99\u0003\u0003\u0005\rA!7\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005\u000b\u0014i\u0010C\u0005\u0003bf\n\t\u00111\u0001\u00022\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00022\u00051Q-];bYN$BA!\u001a\u0004\b!I!\u0011]\u001e\u0002\u0002\u0003\u0007!\u0011\\\u0001\t\u00072,\u0017M\u001c'pOB\u0019\u0011qP\u001f\u0014\u000bu\u001ayaa\u0007\u0011\u0015\rE1qCA\u0019\u00033\u0012i\"\u0004\u0002\u0004\u0014)!1QCA\u0007\u0003\u001d\u0011XO\u001c;j[\u0016LAa!\u0007\u0004\u0014\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\ru11E\u0007\u0003\u0007?QAa!\t\u0003N\u0006\u0011\u0011n\\\u0005\u0005\u0005\u001f\u0019y\u0002\u0006\u0002\u0004\fQ\u0011!QY\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005;\u0019ica\f\t\u000f\u0005M\u0003\t1\u0001\u00022!9!Q\u0003!A\u0002\u0005e\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0007k\u0019i\u0004\u0005\u0004\u0002\f\u0005m3q\u0007\t\t\u0003\u0017\u0019I$!\r\u0002Z%!11HA\u0007\u0005\u0019!V\u000f\u001d7fe!I1qH!\u0002\u0002\u0003\u0007!QD\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAB#!\u0011\u00119ma\u0012\n\t\r%#\u0011\u001a\u0002\u0007\u001f\nTWm\u0019;\u0002#\u001d,G\u000fV5fe2{w\rV8DY\u0016\fg\u000e\u0006\u0005\u0004P\rU3qKB-!\r)6\u0011K\u0005\u0004\u0007'2%A\u0004+jKJdun\u001a+p\u00072,\u0017M\u001c\u0005\b\u0003K\u001a\u0005\u0019\u0001B7\u0011\u001d\tYn\u0011a\u0001\u0003;Dqaa\u0017D\u0001\u0004\u0011I)A\u0002o_^\f!\u0002Z5sif\u0014\u0016M\\4f)\u0019\u0019\tga\u0019\u0004fAA\u00111BB\u001d\u0005\u0013\u0013I\tC\u0004\u0002f\u0011\u0003\rA!\u001c\t\u000f\rmC\t1\u0001\u0003\n\u0006I1\u000f^1uK~#S-\u001d\u000b\u0005\u0005s\u001aY\u0007\u0003\u0005\u0003b\"\t\t\u00111\u0001u\u0003\u0019\u0019H/\u0019;fAU\u0011\u00111[\u0001\u0017i&,'oQ8na\u0006\u001cG/[8o\u001b\u0016$(/[2tAQiAk!\u001e\u0004x\re41PB?\u0007\u007fBQ\u0001X\u0007A\u0002yCQ!Z\u0007A\u0002\u001dDQ\u0001\\\u0007A\u00029DQA]\u0007A\u0002QDq!!5\u000e\u0001\u0004\t\u0019\u000eC\u0004\u0002\\6\u0001\r!!8\u0002!Q\f7o[\"sK\u0006$\u0018n\u001c8US6,WC\u0001BE\u0003E!\u0018m]6De\u0016\fG/[8o)&lW\rI\u0001\u000bY><Gk\\\"mK\u0006tWCABF!\u0019\tY!a\u0017\u0004P\u0005qAn\\4U_\u000ecW-\u00198`I\u0015\fH\u0003\u0002B=\u0007#C\u0011B!9\u0013\u0003\u0003\u0005\raa#\u0002\u00171|w\rV8DY\u0016\fg\u000e\t\u0015\u0004'\r]\u0005\u0003BA\u0006\u00073KAaa'\u0002\u000e\tAao\u001c7bi&dW-A\u000bnCf\u0014W-\u00169eCR,Gj\\4U_\u000ecW-\u00198\u0015\r\r-5\u0011UBR\u0011\u001d\t\t\n\u0006a\u0001\u0003'Cqa!*\u0015\u0001\u0004\u0011I)A\u0005o_^l\u0015\u000e\u001c7jgRq1\u0011VBX\u0007c\u001b\u0019l!.\u00048\u000eeF\u0003BBV\u0007[\u0003R!a\u001d\u0002zQCq!a!\u0016\u0001\b\t)\tC\u0004\u0002\\V\u0001\r!!8\t\u000f\u0005\u0005V\u00031\u0001\u0002$\"9\u0011\u0011W\u000bA\u0002\u0005M\u0006bBAI+\u0001\u0007\u00111\u0013\u0005\b\u0003w+\u0002\u0019AA_\u0011\u001d\t)-\u0006a\u0001\u0007w\u0003b!a\u0003\u0002\\\u0005\u001d\u0007")
public final class CompactionTask
extends TierTask<CompactionTask> {
    private final CancellationContext ctx;
    private final TopicIdPartition topicIdPartition;
    private final OffsetMapSupplier offsetMapSupplier;
    private CompactionTaskState state;
    private final TierCompactionMetrics tierCompactionMetrics;
    private final Time time;
    private final long taskCreationTime;
    private volatile Option<TierLogToClean> logToClean;

    public static TierLogToClean getTierLogToClean(AbstractLog log, Time time, long now) {
        return CompactionTask$.MODULE$.getTierLogToClean(log, time, now);
    }

    public static TierObjectStoreLinearRetry DefaultRetryPolicy() {
        return CompactionTask$.MODULE$.DefaultRetryPolicy();
    }

    public static int DefaultRetryIntervalInMs() {
        return CompactionTask$.MODULE$.DefaultRetryIntervalInMs();
    }

    public static int DefaultMaxRetryCount() {
        return CompactionTask$.MODULE$.DefaultMaxRetryCount();
    }

    @Override
    public CancellationContext ctx() {
        return this.ctx;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public OffsetMapSupplier offsetMapSupplier() {
        return this.offsetMapSupplier;
    }

    public CompactionTaskState state() {
        return this.state;
    }

    public void state_$eq(CompactionTaskState x$1) {
        this.state = x$1;
    }

    public TierCompactionMetrics tierCompactionMetrics() {
        return this.tierCompactionMetrics;
    }

    @Override
    public String loggerName() {
        return CompactionTask.class.getName();
    }

    public long taskCreationTime() {
        return this.taskCreationTime;
    }

    public Option<TierLogToClean> logToClean() {
        return this.logToClean;
    }

    public void logToClean_$eq(Option<TierLogToClean> x$1) {
        this.logToClean = x$1;
    }

    public Option<TierLogToClean> maybeUpdateLogToClean(ReplicaManager replicaManager, long nowMillis) {
        Option updatedNextLogToClean = (this.state() instanceof CleanLog ? replicaManager.getLog(this.topicPartition()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isTierCompactable())) : None$.MODULE$).flatMap((Function1 & Serializable)log -> {
            if (this.logToClean().isEmpty() || this.logToClean().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.stale(log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch())))) {
                return new Some((Object)CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, $this.time, nowMillis));
            }
            return this.logToClean();
        });
        this.logToClean_$eq((Option<TierLogToClean>)updatedNextLogToClean);
        return updatedNextLogToClean;
    }

    @Override
    public Future<CompactionTask> transition(Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, TierTasksConfig config, Option<Throttler> throttler, ExecutionContext ec) {
        return (this.ctx().isCancelled() ? Future$.MODULE$.successful((Object)this.state()) : this.state().transition(this.ctx(), this.topicIdPartition(), replicaManager, tierTopicAppender, tierObjectStore, config, (Throttler)throttler.get(), this.offsetMapSupplier(), this.tierCompactionMetrics(), time, ec)).map((Function1 & Serializable)result -> {
            this.onSuccessfulTransition();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(CompactionTask.$anonfun$transition$2(this, result)));
            }
            this.state_$eq((CompactionTaskState)result);
            return this;
        }, ec).recover((PartialFunction)new Serializable(this, config, time){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactionTask $outer;
            private final TierTasksConfig config$1;
            private final Time time$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof TierMetadataRetriableException) {
                    TierMetadataRetriableException tierMetadataRetriableException = (TierMetadataRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierMetadataRetriableException));
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierObjectStoreRetriableException) {
                    TierObjectStoreRetriableException tierObjectStoreRetriableException = (TierObjectStoreRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(this.config$1.maxRetryBackoffMs(), this.time$1.hiResClockMs(), (Throwable)((Object)tierObjectStoreRetriableException));
                    return (B1)this.$outer;
                }
                if (x1 instanceof LogCleaningAbortedException) {
                    LogCleaningAbortedException logCleaningAbortedException = (LogCleaningAbortedException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$1(this)), (Throwable)logCleaningAbortedException);
                    }
                    return (B1)this.$outer;
                }
                if (x1 instanceof TierLogCompactionFencedException) {
                    TierLogCompactionFencedException tierLogCompactionFencedException = (TierLogCompactionFencedException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$3(this)), (Throwable)tierLogCompactionFencedException);
                    }
                    Object var10_8 = null;
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 instanceof CancellationException) {
                    CancellationException cancellationException = (CancellationException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$5(this)), (Throwable)cancellationException);
                    }
                    Object var11_10 = null;
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 instanceof NotTierablePartitionException) {
                    NotTierablePartitionException notTierablePartitionException = (NotTierablePartitionException)x1;
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask info_this = compactionTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$7(this)), (Throwable)notTierablePartitionException);
                    }
                    Object var12_12 = null;
                    this.$outer.ctx().cancel();
                    return (B1)this.$outer;
                }
                if (x1 != null) {
                    CompactionTask compactionTask = this.$outer;
                    if (compactionTask == null) {
                        throw null;
                    }
                    CompactionTask error_this = compactionTask;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        error_this.logger().underlying().error(error_this.msgWithLogIdent($anonfun$transition$3.$anonfun$applyOrElse$9(this)), x1);
                    }
                    Object var13_13 = null;
                    this.$outer.cancelAndSetErrorState(x1);
                    return (B1)this.$outer;
                }
                return (B1)function1.apply(null);
            }

            public final boolean isDefinedAt(Throwable x1) {
                if (x1 instanceof TierMetadataRetriableException) {
                    return true;
                }
                if (x1 instanceof TierObjectStoreRetriableException) {
                    return true;
                }
                if (x1 instanceof LogCleaningAbortedException) {
                    return true;
                }
                if (x1 instanceof TierLogCompactionFencedException) {
                    return true;
                }
                if (x1 instanceof CancellationException) {
                    return true;
                }
                if (x1 instanceof NotTierablePartitionException) {
                    return true;
                }
                return x1 != null;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$1($anonfun$transition$3 $this) {
                return new StringBuilder(35).append($this.$outer.topicIdPartition()).append(": compaction operation was aborted.").toString();
            }

            public static final /* synthetic */ LogCleaningAbortedException $anonfun$applyOrElse$2(LogCleaningAbortedException x4$1) {
                return x4$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$3($anonfun$transition$3 $this) {
                return new StringBuilder(40).append($this.$outer.topicIdPartition()).append(" was fenced, stopping compaction process").toString();
            }

            public static final /* synthetic */ TierLogCompactionFencedException $anonfun$applyOrElse$4(TierLogCompactionFencedException x5$1) {
                return x5$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$5($anonfun$transition$3 $this) {
                return new StringBuilder(64).append($this.$outer.topicIdPartition()).append(" was fenced by cancellation context, stopping compaction process").toString();
            }

            public static final /* synthetic */ CancellationException $anonfun$applyOrElse$6(CancellationException x6$1) {
                return x6$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$7($anonfun$transition$3 $this) {
                return new StringBuilder(47).append($this.$outer.topicIdPartition()).append(" is not tierable and cannot use tier compaction").toString();
            }

            public static final /* synthetic */ NotTierablePartitionException $anonfun$applyOrElse$8(NotTierablePartitionException x7$1) {
                return x7$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$9($anonfun$transition$3 $this) {
                return new StringBuilder(67).append($this.$outer.topicIdPartition()).append(": unhandled exception in CompactionTask. Moving task to error state").toString();
            }

            public static final /* synthetic */ Throwable $anonfun$applyOrElse$10(Throwable x8$1) {
                return x8$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.time$1 = time$1;
            }
        }, ec);
    }

    public String toString() {
        return new StringBuilder(36).append("CompactionTask(").append(this.topicIdPartition()).append(", state=").append(this.state().getClass().getName()).append(", cancelled=").append(this.ctx().isCancelled()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$transition$2(CompactionTask $this, CompactionTaskState result$1) {
        return new StringBuilder(23).append("Transitioned ").append($this.topicIdPartition()).append(" from ").append($this.state()).append(" to ").append(result$1).toString();
    }

    public CompactionTask(CancellationContext ctx, TopicIdPartition topicIdPartition, OffsetMapSupplier offsetMapSupplier, CompactionTaskState state, TierCompactionMetrics tierCompactionMetrics, Time time) {
        this.ctx = ctx;
        this.topicIdPartition = topicIdPartition;
        this.offsetMapSupplier = offsetMapSupplier;
        this.state = state;
        this.tierCompactionMetrics = tierCompactionMetrics;
        this.time = time;
        super(tierCompactionMetrics.retryRateOpt());
        this.taskCreationTime = time.milliseconds();
        this.logToClean = None$.MODULE$;
    }

    public static class CleanLog
    implements CompactionTaskState,
    Product,
    Serializable {
        private final int leaderEpoch;
        private final Option<CleanerStats> lastStats;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public Option<CleanerStats> lastStats() {
            return this.lastStats;
        }

        @Override
        public Option<CleanerStats> cleanerStats() {
            return this.lastStats();
        }

        @Override
        public Future<CompactionTaskState> transition(CancellationContext ctx, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, TierTasksConfig config, Throttler throttler, OffsetMapSupplier offsetMapSupplier, TierCompactionMetrics tierCompactionMetrics, Time time, ExecutionContext ec) {
            CompactionTask$ info_this = CompactionTask$.MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = CleanLog.$anonfun$transition$4(topicIdPartition);
                Object var13_13 = null;
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            }
            Object var12_12 = null;
            if (config.compactionTaskConfig().isEmpty()) {
                throw new IllegalArgumentException("Compaction task config was unexpectedly empty");
            }
            return this.doCleanLog(ctx, tierTopicAppender, this.leaderEpoch(), topicIdPartition, replicaManager, offsetMapSupplier, (CompactionTasksConfig)config.compactionTaskConfig().get(), tierObjectStore, tierCompactionMetrics, throttler, time, ec).map((Function1 & Serializable)state -> {
                CompactionTask$ info_this = CompactionTask$.MODULE$;
                if (info_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = CleanLog.$anonfun$transition$6(topicIdPartition);
                    Object var3_3 = null;
                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                }
                return state;
            }, ec);
        }

        public Future<CompactionTaskState> doCleanLog(CancellationContext ctx, TierTopicAppender tierTopicAppender, int leaderEpoch, TopicIdPartition topicIdPartition, ReplicaManager replicaManager, OffsetMapSupplier offsetMapSupplier, CompactionTasksConfig config, TierObjectStore tierObjectStore, TierCompactionMetrics tierCompactionMetrics, Throttler throttler, Time time, ExecutionContext ec) {
            return Future$.MODULE$.apply((Function0 & Serializable)() -> {
                Either<Errors, Partition> either = replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
                if (either instanceof Left) {
                    Errors error = (Errors)((Left)either).value();
                    throw new TierLogCompactionFencedException(topicIdPartition, (Throwable)error.exception());
                }
                if (either instanceof Right) {
                    Partition partition = (Partition)((Right)either).value();
                    return (CompactionTaskState)partition.log().map((Function1 & Serializable)log -> {
                        Some stats;
                        block38: {
                            int tierEpoch = log.tierPartitionState().tierEpoch();
                            if (tierEpoch > leaderEpoch) {
                                throw new TierLogCompactionFencedException(topicIdPartition, null);
                            }
                            if (tierEpoch < leaderEpoch) {
                                throw new TierMetadataRetriableException(new StringBuilder(45).append("Leadership not established for ").append(topicIdPartition).append(". Backing off.").toString());
                            }
                            if (partition.isUncleanLeader()) {
                                throw new TierMetadataRetriableException(new StringBuilder(49).append(topicIdPartition).append(" undergoing unclean leader recovery. Backing off.").toString());
                            }
                            if (log.isTierMetadataStateRecovering()) {
                                throw new TierMetadataRetriableException(new StringBuilder(48).append(topicIdPartition).append(" undergoing tier metadata recovery. Backing off.").toString());
                            }
                            if (log.isFrozenLogStartOffsetState()) {
                                throw new TierMetadataRetriableException(new StringBuilder(46).append(topicIdPartition).append(" undergoing tiered data recovery. Backing off.").toString());
                            }
                            OffsetMap offsetMap = offsetMapSupplier.getOffsetMap();
                            stats = this.lastStats();
                            try {
                                void var36_52;
                                void var34_51;
                                Tuple2<Object, CleanerStats> tuple2;
                                if (!log.isTierCompactable()) {
                                    CompactionTask$ warn_this = CompactionTask$.MODULE$;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$3(topicIdPartition);
                                        Object var47_17 = null;
                                        warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                    }
                                    Object var38_16 = null;
                                    break block38;
                                }
                                if (log.tieredLogSegments().isEmpty()) {
                                    CompactionTask$ warn_this = CompactionTask$.MODULE$;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$4(topicIdPartition);
                                        Object var48_19 = null;
                                        warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                    }
                                    Object var39_18 = null;
                                    throw new TierMetadataRetriableException(new StringBuilder(60).append("Log for ").append(topicIdPartition).append(" has no eligible tiered segments for tier compaction").toString());
                                }
                                TierLogToClean cleanable = CompactionTask$.MODULE$.getTierLogToClean((AbstractLog)log, time, time.milliseconds());
                                Function1 & Serializable checkDone = (Function1 & Serializable)x$3 -> {
                                    CleanLog.$anonfun$doCleanLog$5(ctx, x$3);
                                    return BoxedUnit.UNIT;
                                };
                                TierObjectStoreLinearRetry retryPolicy = CompactionTask$.MODULE$.DefaultRetryPolicy();
                                TierCleaner cleaner = new TierCleaner(offsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, tierCompactionMetrics, time, tierObjectStore, tierTopicAppender, leaderEpoch, ctx, (Function1<TopicPartition, BoxedUnit>)checkDone, retryPolicy);
                                Option<Object> lockedOffset = log.lockOffsetFromDeletion();
                                if (lockedOffset.isEmpty()) {
                                    CompactionTask$ warn_this = CompactionTask$.MODULE$;
                                    if (warn_this.logger().underlying().isWarnEnabled()) {
                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$6(topicIdPartition);
                                        Object var49_26 = null;
                                        warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                    }
                                    Object var40_25 = null;
                                    throw new LogCleaningAbortedException();
                                }
                                cleanable.firstCleanableOffset_$eq(BoxesRunTime.unboxToLong((Object)lockedOffset.get()));
                                try {
                                    block39: {
                                        long tierEndOffset = log.tierPartitionState().endOffset();
                                        if (this.shouldDoDualCompactionValidation((AbstractLog)log, config) && cleanable.firstCleanableOffset() >= log.localLogStartOffset() && cleanable.firstCleanableOffset() <= tierEndOffset && log.tierableLogSegments().isEmpty()) {
                                            OffsetMap localOffsetMap = offsetMapSupplier.getOffsetMap();
                                            try {
                                                CompactionTask$ warn_this;
                                                void var29_35;
                                                CleanerStats stats2;
                                                CompactionTask$ info_this = CompactionTask$.MODULE$;
                                                if (info_this.logger().underlying().isInfoEnabled()) {
                                                    String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$7(topicIdPartition, cleanable, tierEndOffset);
                                                    Object var50_30 = null;
                                                    info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                                                }
                                                Object var41_29 = null;
                                                ExtendedOffsetMap baseOffsetMap = new ExtendedOffsetMap(localOffsetMap);
                                                Cleaner localCleaner = new Cleaner(-1, localOffsetMap, config.ioBufferSize(), config.maxIoBufferSize(), config.skimpyOffsetMapLoadFactor(), throttler, time, (Function1<TopicPartition, BoxedUnit>)checkDone, tierCompactionMetrics.cleanerMetrics());
                                                Tuple2 tuple22 = CleanLog.liftedTree1$1(localCleaner, log, cleanable, tierEndOffset, baseOffsetMap, stats2 = new CleanerStats(time, tierCompactionMetrics.cleanerMetrics()), offsetMapSupplier, localOffsetMap);
                                                if (tuple22 == null) {
                                                    throw new MatchError(null);
                                                }
                                                boolean offsetMapSuccess = tuple22._1$mcZ$sp();
                                                String failReason = (String)tuple22._2();
                                                if (var29_35 == false) {
                                                    CompactionTask$ warn_this2 = CompactionTask$.MODULE$;
                                                    if (warn_this2.logger().underlying().isWarnEnabled()) {
                                                        void var30_36;
                                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$8(log, (String)var30_36);
                                                        Object var51_38 = null;
                                                        warn_this2.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this2, msgWithLogIdent_msg));
                                                    }
                                                    Object var42_37 = null;
                                                    stats2.validationAborted();
                                                    break block39;
                                                }
                                                if (log.tierPartitionState().endOffset() != tierEndOffset) {
                                                    CompactionTask$ warn_this3 = CompactionTask$.MODULE$;
                                                    if (warn_this3.logger().underlying().isWarnEnabled()) {
                                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$9(log, tierEndOffset);
                                                        Object var52_40 = null;
                                                        warn_this3.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this3, msgWithLogIdent_msg));
                                                    }
                                                    Object var43_39 = null;
                                                    stats2.validationAborted();
                                                    break block39;
                                                }
                                                Enumeration.Value value = cleaner.validateLog((AbstractLog)log, cleanable.firstCleanableOffset(), tierEndOffset + 1L, baseOffsetMap, stats2);
                                                Enumeration.Value value2 = ValidateLogResult$.MODULE$.Passed();
                                                if (!(value2 != null ? !value2.equals(value) : value != null)) {
                                                    CompactionTask$ info_this2 = CompactionTask$.MODULE$;
                                                    if (info_this2.logger().underlying().isInfoEnabled()) {
                                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$10(topicIdPartition);
                                                        Object var53_43 = null;
                                                        info_this2.logger().underlying().info(Logging.msgWithLogIdent$(info_this2, msgWithLogIdent_msg));
                                                    }
                                                    Object var44_42 = null;
                                                    stats2.validationPassed();
                                                    break block39;
                                                }
                                                Enumeration.Value value3 = ValidateLogResult$.MODULE$.Failed();
                                                if (!(value3 != null ? !value3.equals(value) : value != null)) {
                                                    CompactionTask$ warn_this4 = CompactionTask$.MODULE$;
                                                    if (warn_this4.logger().underlying().isWarnEnabled()) {
                                                        String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$11(log);
                                                        Object var54_45 = null;
                                                        warn_this4.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this4, msgWithLogIdent_msg));
                                                    }
                                                    Object var45_44 = null;
                                                    stats2.validationFailed();
                                                    break block39;
                                                }
                                                Enumeration.Value value4 = ValidateLogResult$.MODULE$.Aborted();
                                                if (value4 == null) {
                                                    if (value != null) {
                                                        break block39;
                                                    }
                                                } else if (!value4.equals(value)) break block39;
                                                if ((warn_this = CompactionTask$.MODULE$).logger().underlying().isWarnEnabled()) {
                                                    String msgWithLogIdent_msg = CleanLog.$anonfun$doCleanLog$12(log);
                                                    Object var55_47 = null;
                                                    warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                                                }
                                                Object var46_46 = null;
                                                stats2.validationAborted();
                                            }
                                            finally {
                                                offsetMapSupplier.reclaimOffsetMap(localOffsetMap);
                                            }
                                        }
                                    }
                                    tuple2 = cleaner.clean(cleanable);
                                }
                                finally {
                                    log.unlockOffsetFromDeletion(cleanable.firstCleanableOffset());
                                }
                                Tuple2<Object, CleanerStats> tuple23 = tuple2;
                                if (tuple23 == null) {
                                    throw new MatchError(null);
                                }
                                long nextDirtyOffset = tuple23._1$mcJ$sp();
                                CleanerStats cleanerStats = (CleanerStats)tuple23._2();
                                if (var34_51 != -1L) {
                                    this.recordStats(this.toString(), topicIdPartition, cleanable.firstDirtyOffset(), (long)var34_51, (CleanerStats)var36_52);
                                }
                                stats = new Some((Object)var36_52);
                            }
                            finally {
                                offsetMapSupplier.reclaimOffsetMap(offsetMap);
                            }
                        }
                        return new CleanLog(leaderEpoch, (Option<CleanerStats>)stats);
                    }).getOrElse((Function0 & Serializable)() -> this);
                }
                throw new MatchError(either);
            }, ec);
        }

        private boolean shouldDoDualCompactionValidation(AbstractLog log, CompactionTasksConfig config) {
            return log.config().confluentLogConfig().tierCleanerDualCompaction && config.dualCompactionValidationPercent() > 0 && log.tierPartitionState().totalSize() <= config.dualCompactionValidationMaxBytes() && new Random().nextInt(100) < config.dualCompactionValidationPercent();
        }

        public void recordStats(String task, TopicIdPartition topicIdPartition, long from, long to, CleanerStats stats) {
            String message = new StringBuilder(0).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Tier Compaction Task: %s cleaned log %s (dirty section = [%d, %d))%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{task, topicIdPartition.toString(), BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tAverage key size for records observed during this compaction run is %.2f bytes%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.keyBytesRead() / (double)stats.messagesRead()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tThrottled time: %,.1f seconds (%.1f%% of total time)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)stats.throttledSecs()), BoxesRunTime.boxToDouble((double)((double)100 * stats.throttledSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesWritten() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            CompactionTask$ info_this = CompactionTask$.MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, message));
            }
            Object var9_7 = null;
            if (stats.invalidMessagesRead() > 0L) {
                CompactionTask$ warn_this = CompactionTask$.MODULE$;
                if (warn_this.logger().underlying().isWarnEnabled()) {
                    String msgWithLogIdent_msg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())}));
                    Object var11_9 = null;
                    warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
                    return;
                }
                return;
            }
        }

        public String toString() {
            return new StringBuilder(22).append("CleanLog(leaderEpoch=").append(this.leaderEpoch()).append(")").toString();
        }

        public CleanLog copy(int leaderEpoch, Option<CleanerStats> lastStats) {
            return new CleanLog(leaderEpoch, lastStats);
        }

        public int copy$default$1() {
            return this.leaderEpoch();
        }

        public Option<CleanerStats> copy$default$2() {
            return this.lastStats();
        }

        public String productPrefix() {
            return "CleanLog";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.leaderEpoch());
                }
                case 1: {
                    return this.lastStats();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CleanLog;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "leaderEpoch";
                }
                case 1: {
                    return "lastStats";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)this.leaderEpoch()), (int)Statics.anyHash(this.lastStats())), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof CleanLog)) break block3;
                    CleanLog cleanLog = (CleanLog)x$1;
                    if (this.leaderEpoch() != cleanLog.leaderEpoch()) break block3;
                    Option<CleanerStats> option = this.lastStats();
                    Option<CleanerStats> option2 = cleanLog.lastStats();
                    if ((option != null ? !option.equals(option2) : option2 != null) || !cleanLog.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public static final /* synthetic */ String $anonfun$transition$4(TopicIdPartition topicIdPartition$1) {
            return new StringBuilder(33).append("Starting tier log compaction for ").append(topicIdPartition$1).toString();
        }

        public static final /* synthetic */ String $anonfun$transition$6(TopicIdPartition topicIdPartition$1) {
            return new StringBuilder(34).append("Completed tier log compaction for ").append(topicIdPartition$1).toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$3(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(80).append("Log for ").append(topicIdPartition$2).append(" is not tier compact enabled, but is attempting to clean tiered segments").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$4(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(96).append("Log for ").append(topicIdPartition$2).append(" was scheduled in tier CompactionTask but has no eligible tiered segments for compaction").toString();
        }

        public static final /* synthetic */ void $anonfun$doCleanLog$5(CancellationContext ctx$1, TopicPartition x$3) {
            if (ctx$1.isCancelled()) {
                throw new CancellationException("Operation cancelled");
            }
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$6(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(99).append("Log for ").append(topicIdPartition$2).append(" is still locked by previous compaction round. Abort current operation and will be retried.").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$7(TopicIdPartition topicIdPartition$2, TierLogToClean cleanable$1, long tierEndOffset$1) {
            return new StringBuilder(73).append("Starting dual compaction validation for ").append(topicIdPartition$2).append(" for offset range [").append(cleanable$1.firstCleanableOffset()).append(", end offset=").append(tierEndOffset$1).append("]").toString();
        }

        private static final /* synthetic */ Tuple2 liftedTree1$1(Cleaner localCleaner$1, AbstractLog log$2, TierLogToClean cleanable$1, long tierEndOffset$1, ExtendedOffsetMap baseOffsetMap$1, CleanerStats stats$1, OffsetMapSupplier offsetMapSupplier$1, OffsetMap localOffsetMap$1) {
            Tuple2 tuple2;
            try {
                if (!localCleaner$1.buildOffsetMap(log$2, cleanable$1.firstCleanableOffset(), tierEndOffset$1 + 1L, (OffsetMap)baseOffsetMap$1, stats$1)) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
                }
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(96).append("offset map is too small for storing all keys in offset range [").append(cleanable$1.firstCleanableOffset()).append(", ").append(tierEndOffset$1).append("]. ").append("Offset map memory: ").append(offsetMapSupplier$1.offsetMapMemory()).append(", slots: ").append(localOffsetMap$1.slots()).append(".").toString());
            }
            catch (Throwable e) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringBuilder(84).append("exception encountered when building offset map for local data in offset range [").append(cleanable$1.firstCleanableOffset()).append(", ").append(tierEndOffset$1).append("]. ").append(e).toString());
            }
            return tuple2;
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$8(AbstractLog log$2, String failReason$1) {
            return new StringBuilder(39).append("Abort dual compaction validation for ").append(log$2).append(". ").append(failReason$1).toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$9(AbstractLog log$2, long tierEndOffset$1) {
            return new StringBuilder(110).append("Abort dual compaction validation for ").append(log$2).append(" because tierEndOffset changed. old tierEndOffset: ").append(tierEndOffset$1).append(", new tierEndOffset: ").append(log$2.tierPartitionState().endOffset()).append(".").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$10(TopicIdPartition topicIdPartition$2) {
            return new StringBuilder(38).append("Dual compaction validation for ").append(topicIdPartition$2).append(" passed").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$11(AbstractLog log$2) {
            return new StringBuilder(38).append("Dual compaction validation for ").append(log$2).append(" failed").toString();
        }

        public static final /* synthetic */ String $anonfun$doCleanLog$12(AbstractLog log$2) {
            return new StringBuilder(56).append("Dual compaction validation is not able to complete for ").append(log$2).append(".").toString();
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public static final /* synthetic */ String $anonfun$recordStats$1(String message$1) {
            return message$1;
        }

        public CleanLog(int leaderEpoch, Option<CleanerStats> lastStats) {
            this.leaderEpoch = leaderEpoch;
            this.lastStats = lastStats;
            Product.$init$((Product)this);
        }
    }

    public static interface CompactionTaskState {
        public int leaderEpoch();

        public Option<CleanerStats> cleanerStats();

        public Future<CompactionTaskState> transition(CancellationContext var1, TopicIdPartition var2, ReplicaManager var3, TierTopicAppender var4, TierObjectStore var5, TierTasksConfig var6, Throttler var7, OffsetMapSupplier var8, TierCompactionMetrics var9, Time var10, ExecutionContext var11);
    }
}

