/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTransactionMetadata;
import kafka.log.AbstractLog;
import kafka.log.CleanParams;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.LocalLog$;
import kafka.log.LogSegment;
import kafka.log.LogSegmentReadAdapter;
import kafka.log.MergedLog$;
import kafka.log.TierLogSegment;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierCompactionCommitAndSwap;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.CompactStats;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreRetryPolicy;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogCompactionUtils$;
import kafka.tier.tasks.compaction.TierLogSegmentReadAdapter;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.LastRecord;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tub\u0001B\f\u0019\u0001\u0005B\u0011\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u001c\t\u0011a\u0002!\u0011!Q\u0001\neB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011}\u0003!\u0011!Q\u0001\n\u0001D\u0001B\u001a\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\"Aa\u000e\u0001B\u0001B\u0003%q\u000e\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003{\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\tY\u0002\u0001C)\u0003;Aq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u00111\u000f\u0001\u0005\n\u0005U\u0004\u0002CAc\u0001\u0011\u0005\u0001$a2\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\u0004!9!q\u0003\u0001\u0005B\te!a\u0003+jKJ\u001cE.Z1oKJT!!\u0007\u000e\u0002\u0015\r|W\u000e]1di&|gN\u0003\u0002\u001c9\u0005)A/Y:lg*\u0011QDH\u0001\u0005i&,'OC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015r\u0012a\u00017pO&\u0011q\u0005\n\u0002\b\u00072,\u0017M\\3s\u0003%ygMZ:fi6\u000b\u0007\u000f\u0005\u0002+k5\t1F\u0003\u0002&Y)\u0011QFL\u0001\nS:$XM\u001d8bYNT!a\f\u0019\u0002\u000fM$xN]1hK*\u0011q$\r\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014x-\u0003\u00027W\tIqJ\u001a4tKRl\u0015\r]\u0005\u0003Q\u0019\nA\"[8Ck\u001a4WM]*ju\u0016\u0004\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u00121!\u00138u\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0017a\u00053va\n+hMZ3s\u0019>\fGMR1di>\u0014\bC\u0001\u001eC\u0013\t\u00195H\u0001\u0004E_V\u0014G.Z\u0001\ni\"\u0014x\u000e\u001e;mKJ\u0004\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0010\u0002\u000bU$\u0018\u000e\\:\n\u0005);%!\u0003+ie>$H\u000f\\3s\u0003U!\u0018.\u001a:D_6\u0004\u0018m\u0019;j_:lU\r\u001e:jGN\u0004\"!\u0014(\u000e\u0003aI!a\u0014\r\u0003+QKWM]\"p[B\f7\r^5p]6+GO]5dg\u0006!A/[7f!\t\u0011f+D\u0001T\u0015\tAEK\u0003\u0002Va\u000511m\\7n_:L!aV*\u0003\tQKW.Z\u0001\u0010i&,'o\u00142kK\u000e$8\u000b^8sKB\u0011!,X\u0007\u00027*\u0011A\fH\u0001\u0006gR|'/Z\u0005\u0003=n\u0013q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\u0012i&,'\u000fV8qS\u000e\f\u0005\u000f]3oI\u0016\u0014\bCA1e\u001b\u0005\u0011'BA2\u001d\u0003\u0015!x\u000e]5d\u0013\t)'MA\tUS\u0016\u0014Hk\u001c9jG\u0006\u0003\b/\u001a8eKJ\f1\u0002\\3bI\u0016\u0014X\t]8dQ\u0006\u00191\r\u001e=\u0011\u0005%dW\"\u00016\u000b\u0005-d\u0012a\u00024fi\u000eDWM]\u0005\u0003[*\u00141cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqR\f\u0011b\u00195fG.$uN\\3\u0011\ti\u0002(O^\u0005\u0003cn\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005M$X\"\u0001+\n\u0005U$&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003u]L!\u0001_\u001e\u0003\tUs\u0017\u000e^\u0001\fe\u0016$(/\u001f)pY&\u001c\u0017\u0010\u0005\u0002[w&\u0011Ap\u0017\u0002\u001b)&,'o\u00142kK\u000e$8\u000b^8sKJ+GO]=Q_2L7-_\u0001\u0007y%t\u0017\u000e\u001e \u00157}\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0011qCA\r!\ti\u0005\u0001C\u0003)\u001d\u0001\u0007\u0011\u0006C\u00039\u001d\u0001\u0007\u0011\bC\u0003@\u001d\u0001\u0007\u0011\bC\u0003A\u001d\u0001\u0007\u0011\tC\u0003E\u001d\u0001\u0007Q\tC\u0003L\u001d\u0001\u0007A\nC\u0003Q\u001d\u0001\u0007\u0011\u000bC\u0003Y\u001d\u0001\u0007\u0011\fC\u0003`\u001d\u0001\u0007\u0001\rC\u0003g\u001d\u0001\u0007\u0011\bC\u0003h\u001d\u0001\u0007\u0001\u000eC\u0003o\u001d\u0001\u0007q\u000eC\u0003z\u001d\u0001\u0007!0\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!a\b\u0011\t\u0005\u0005\u0012q\u0006\b\u0005\u0003G\tY\u0003E\u0002\u0002&mj!!a\n\u000b\u0007\u0005%\u0002%\u0001\u0004=e>|GOP\u0005\u0004\u0003[Y\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00022\u0005M\"AB*ue&twMC\u0002\u0002.m\nQa\u00197fC:$B!!\u000f\u0002LA9!(a\u000f\u0002@\u0005\u0015\u0013bAA\u001fw\t1A+\u001e9mKJ\u00022AOA!\u0013\r\t\u0019e\u000f\u0002\u0005\u0019>tw\rE\u0002$\u0003\u000fJ1!!\u0013%\u00051\u0019E.Z1oKJ\u001cF/\u0019;t\u0011\u001d\ti\u0005\u0005a\u0001\u0003\u001f\n\u0011b\u00197fC:\f'\r\\3\u0011\u0007\r\n\t&C\u0002\u0002T\u0011\u00121b\u00117fC:\u0004\u0016M]1ng\u0006YAm\u001c+jKJ\u001cE.Z1o)\u0019\tI$!\u0017\u0002^!9\u00111L\tA\u0002\u0005=\u0013aC2mK\u0006t\u0007+\u0019:b[NDq!a\u0018\u0012\u0001\u0004\ty$A\u0006dkJ\u0014XM\u001c;US6,\u0017AF;qI\u0006$X\r\u001a'bgR\u001cE.Z1o\u001f\u001a47/\u001a;\u0015\r\u0005}\u0012QMA5\u0011\u001d\t9G\u0005a\u0001\u0003\u007f\ta\u0002\u001d:pa>\u001cX\rZ(gMN,G\u000fC\u0004\u0002lI\u0001\r!!\u001c\u0002!\r|W\u000e]1di\u000e{W\u000e\u001d7fi\u0016$\u0007c\u0001\u001e\u0002p%\u0019\u0011\u0011O\u001e\u0003\u000f\t{w\u000e\\3b]\u0006Y2M]3bi\u0016\fe\u000eZ,sSR,7i\\7nSR\fe\u000eZ*xCB$\u0012C^A<\u0003\u007f\nY)a$\u0002\u0014\u0006U\u00151VAa\u0011\u0019)3\u00031\u0001\u0002zA\u00191%a\u001f\n\u0007\u0005uDEA\u0006BEN$(/Y2u\u0019><\u0007bBAA'\u0001\u0007\u00111Q\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004B!!\"\u0002\b6\tA$C\u0002\u0002\nr\u0011\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\t\r\u000555\u00031\u0001:\u0003%!\u0018.\u001a:Fa>\u001c\u0007\u000eC\u0004\u0002\u0012N\u0001\r!!\u0012\u0002\u000bM$\u0018\r^:\t\u000f\u0005-4\u00031\u0001\u0002n!9\u0011qS\nA\u0002\u0005e\u0015AD:pkJ\u001cWmU3h[\u0016tGo\u001d\t\u0007\u00037\u000b\t+!*\u000e\u0005\u0005u%bAAPw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0016Q\u0014\u0002\t\u0013R,'/\u00192mKB\u00191%a*\n\u0007\u0005%FE\u0001\bUS\u0016\u0014Hj\\4TK\u001elWM\u001c;\t\u000f\u000556\u00031\u0001\u00020\u0006!B-Z:uS:\fG/[8o\u001f\nTWm\u0019;JIN\u0004b!a'\u0002\"\u0006E\u0006\u0003BAZ\u0003{k!!!.\u000b\t\u0005]\u0016\u0011X\u0001\u0005kRLGN\u0003\u0002\u0002<\u0006!!.\u0019<b\u0013\u0011\ty,!.\u0003\tU+\u0016\n\u0012\u0005\b\u0003\u0007\u001c\u0002\u0019AA \u0003=a\u0017m\u001d;DY\u0016\fgn\u00144gg\u0016$\u0018!D2mK\u0006t7+Z4nK:$8\u000f\u0006\n\u0002J\u0006u\u0017q\\Au\u0003[\fy/!=\u0002|\u0006}\bc\u0002\u001e\u0002<\u0005-\u0017q\u001b\t\u0007\u0003\u001b\f\u0019.!*\u000e\u0005\u0005='\u0002BAi\u0003;\u000bq!\\;uC\ndW-\u0003\u0003\u0002V\u0006='A\u0003'jgR\u0014UO\u001a4feB\u00191%!7\n\u0007\u0005mGE\u0001\u0006M_\u001e\u001cVmZ7f]RDa!\n\u000bA\u0002\u0005e\u0004bBAq)\u0001\u0007\u00111]\u0001\tg\u0016<W.\u001a8ugB1\u0011QZAs\u0003KKA!a:\u0002P\n)\u0011+^3vK\"1\u00111\u001e\u000bA\u0002%\n1!\\1q\u0011\u001d\ty\u0006\u0006a\u0001\u0003\u007fAq!!%\u0015\u0001\u0004\t)\u0005C\u0004\u0002tR\u0001\r!!>\u0002'Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0011\u0007\r\n90C\u0002\u0002z\u0012\u0012!d\u00117fC:,G\r\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006Dq!!@\u0015\u0001\u0004\ty$A\u000bmK\u001e\f7-\u001f#fY\u0016$X\rS8sSj|g.T:\t\u000f\u0005\u0005E\u00031\u0001\u0002\u0004\u0006YAn\\4TK\u001elWM\u001c;t)!\u0011)A!\u0004\u0003\u0010\tM\u0001CBAN\u0003C\u00139\u0001E\u0002$\u0005\u0013I1Aa\u0003%\u0005UaunZ*fO6,g\u000e\u001e*fC\u0012\fE-\u00199uKJDa!J\u000bA\u0002\u0005e\u0004b\u0002B\t+\u0001\u0007\u0011qH\u0001\u0005MJ|W\u000eC\u0004\u0003\u0016U\u0001\r!a\u0010\u0002\u0005Q|\u0017AG2pY2,7\r^!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cH\u0003\u0003B\u000e\u0005g\u0011)D!\u000f\u0011\r\tu!q\u0005B\u0017\u001d\u0011\u0011yBa\t\u000f\t\u0005\u0015\"\u0011E\u0005\u0002y%\u0019!QE\u001e\u0002\u000fA\f7m[1hK&!!\u0011\u0006B\u0016\u0005\u0011a\u0015n\u001d;\u000b\u0007\t\u00152\bE\u0002+\u0005_I1A!\r,\u0005)\t%m\u001c:uK\u0012$\u0006P\u001c\u0005\u0007KY\u0001\r!!\u001f\t\u000f\t]b\u00031\u0001\u0002@\u0005)1\u000f^1si\"9!1\b\fA\u0002\u0005}\u0012aA3oI\u0002")
public class TierCleaner
extends Cleaner {
    private final TierCompactionMetrics tierCompactionMetrics;
    private final Time time;
    private final TierObjectStore tierObjectStore;
    private final TierTopicAppender tierTopicAppender;
    private final int leaderEpoch;
    private final CancellationContext ctx;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private final TierObjectStoreRetryPolicy retryPolicy;

    @Override
    public String loggerName() {
        return TierCleaner.class.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple2<Object, CleanerStats> clean(CleanParams cleanable) {
        void var3_3;
        void var5_4;
        this.checkDone.apply((Object)cleanable.log().topicPartition());
        Tuple2<Object, CleanerStats> tuple2 = this.doTierClean(cleanable, this.time.milliseconds());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        CleanerStats cleanerStats = (CleanerStats)tuple2._2();
        double bytesShrinkageRatio = 1.0 - (double)var5_4.bytesWritten() / (double)var5_4.bytesRead();
        cleanable.log().updateLastShrinkageRatio(bytesShrinkageRatio);
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)var3_3), (Object)var5_4);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Object, CleanerStats> doTierClean(CleanParams cleanParams, long currentTime) {
        long l;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Beginning cleaning of log ").append(cleanParams.log().name()).append(" with ").append(cleanParams).toString());
        Option option = cleanParams.log().localLogSegments(0L, cleanParams.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - cleanParams.log().config().deleteRetentionMs;
        } else {
            throw new MatchError((Object)option);
        }
        long legacyDeleteHorizonMs = l;
        if (cleanParams.topicIdPartition().isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(72).append("CleanParams for tiered compactions must have a valid topic id partition ").append(cleanParams).toString());
        }
        AbstractLog log = cleanParams.log();
        TopicIdPartition topicIdPartition = (TopicIdPartition)cleanParams.topicIdPartition().get();
        CleanerStats stats = new CleanerStats(this.time, this.tierCompactionMetrics.cleanerMetrics());
        long firstDirtyOffset = cleanParams.firstDirtyOffset();
        long upperBoundOffset = cleanParams.firstUncleanableOffset();
        boolean isOffsetMapFull = this.buildOffsetMap(log, firstDirtyOffset, upperBoundOffset, super.offsetMap(), stats);
        if (super.offsetMap().latestOffset() == -1L) {
            this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset map for %s has latest offset of -1, no offsets to compact"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)-1L), (Object)stats);
        }
        long endOffset = super.offsetMap().latestOffset() + 1L;
        stats.indexDone(isOffsetMapFull);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("CompactionTask for ").append(topicIdPartition).append(" endOffset: ").append(endOffset).append(" upperBoundOffset: ").append(upperBoundOffset).toString());
        Queue tieredSegments = (Queue)new Queue(Queue$.MODULE$.$lessinit$greater$default$1()).$plus$plus$eq(log.tieredLogSegments(cleanParams.startOffset(), endOffset));
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)tieredSegments.lastOption().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.maxTimestamp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to upper bound deletion horizon %s)..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(legacyDeleteHorizonMs)})));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Cleaning log tiered segments for cleaning ").append(tieredSegments.map((Function1 & Serializable)x$13 -> x$13.metadata())).append(" vs ").append(log.tieredLogSegments().toList()).toString());
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        while (tieredSegments.nonEmpty()) {
            void var23_17;
            void var22_16;
            Tuple2<ListBuffer<TierLogSegment>, LogSegment> tuple2 = this.cleanSegments(log, (Queue<TierLogSegment>)tieredSegments, super.offsetMap(), currentTime, stats, transactionMetadata, legacyDeleteHorizonMs, topicIdPartition);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            ListBuffer segmentsUsed = (ListBuffer)tuple2._1();
            LogSegment cleanedSegment = (LogSegment)tuple2._2();
            this.debug((Function0<String>)((Function0 & Serializable)() -> TierCleaner.$anonfun$doTierClean$9(topicIdPartition, (ListBuffer)var22_16, tieredSegments)));
            try {
                if (var22_16.isEmpty()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(114).append(topicIdPartition).append(": cleanSegments cleaned no segment because some source segments are deleted. ").append("Continue to clean next source segment").toString());
                    continue;
                }
                if (var23_17.size() == 0) {
                    boolean compactCompleted = true;
                    long lastCleanOffset = this.updatedLastCleanOffset(((TierLogSegment)var22_16.last()).endOffset(), compactCompleted);
                    this.info((Function0<String>)((Function0 & Serializable)() -> TierCleaner.$anonfun$doTierClean$11(topicIdPartition, (ListBuffer)var22_16)));
                    this.createAndWriteCommitAndSwap(log, topicIdPartition, this.leaderEpoch, stats, compactCompleted, (Iterable<TierLogSegment>)var22_16, (Iterable<UUID>)Nil$.MODULE$, lastCleanOffset);
                    continue;
                }
                Option<ByteBuffer> producerStateOpt = TierLogCompactionUtils$.MODULE$.fetchProducerState(this.tierObjectStore, (TierLogSegment)var22_16.last(), this.ctx, this.retryPolicy);
                Option<ByteBuffer> epochStateOpt = TierLogCompactionUtils$.MODULE$.fetchEpochState(this.tierObjectStore, (TierLogSegment)var22_16.last(), this.ctx, this.retryPolicy);
                long nextOffset = ((TierLogSegment)var22_16.last()).endOffset() + 1L;
                java.util.List completedAbortedTxns = var23_17.collectAbortedTxns((long)var23_17.baseOffset(), (long)nextOffset).abortedTransactions;
                java.util.List ongoingAbortedTxns = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)transactionMetadata.ongoingAbortedTxns().values().filter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TierCleaner.$anonfun$doTierClean$12(x$15)))).map((Function1 & Serializable)x$16 -> x$16.abortedTxn())).toList().sortBy((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.lastOffset()), (Ordering)Ordering.Long$.MODULE$)).asJava();
                ArrayList abortedTxns = new ArrayList(completedAbortedTxns.size() + ongoingAbortedTxns.size());
                abortedTxns.addAll(completedAbortedTxns);
                abortedTxns.addAll(ongoingAbortedTxns);
                Optional abortedTxnsBytes = AbortedTxn.serialize(abortedTxns);
                TierObjectStore.OpaqueData opaqueData = (TierObjectStore.OpaqueData)Option$.MODULE$.apply((Object)this.tierObjectStore.prepPutSegment()).getOrElse((Function0 & Serializable)() -> TierObjectStore.OpaqueData.ZEROED);
                TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, this.leaderEpoch, UUID.randomUUID(), var23_17.baseOffset(), var23_17.readNextOffset() - 1L, var23_17.largestTimestamp(), var23_17.getFirstBatchTimestamp(), var23_17.size(), epochStateOpt.isDefined(), abortedTxnsBytes.isPresent(), producerStateOpt.isDefined(), TierUploadType.Compaction, log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), opaqueData);
                TierLogCompactionUtils$.MODULE$.writeUploadInitiateMarker(uploadInitiate, topicIdPartition, this.time, this.tierTopicAppender);
                TierObjectStore.ObjectMetadata objectStoreMetadata = new TierObjectStore.ObjectMetadata(topicIdPartition, uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState(), uploadInitiate.hasEpochState(), opaqueData);
                this.tierObjectStore.putInMemorySegment(objectStoreMetadata, var23_17.log().file(), var23_17.offsetIndex().file(), var23_17.timeIndex().file(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(producerStateOpt)), abortedTxnsBytes, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(epochStateOpt)));
                boolean compactCompleted = tieredSegments.isEmpty();
                long lastCleanOffset = this.updatedLastCleanOffset(uploadInitiate.endOffset(), compactCompleted);
                this.createAndWriteCommitAndSwap(log, topicIdPartition, this.leaderEpoch, stats, compactCompleted, (Iterable<TierLogSegment>)var22_16, (Iterable<UUID>)new .colon.colon((Object)uploadInitiate.objectId(), (List)Nil$.MODULE$), lastCleanOffset);
            }
            finally {
                var23_17.deleteIfExists();
            }
        }
        stats.bufferUtilization_$eq(super.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    private long updatedLastCleanOffset(long proposedOffset, boolean compactCompleted) {
        if (proposedOffset >= super.offsetMap().latestOffset()) {
            return super.offsetMap().latestOffset();
        }
        if (compactCompleted) {
            return super.offsetMap().latestOffset();
        }
        return proposedOffset;
    }

    private void createAndWriteCommitAndSwap(AbstractLog log, TopicIdPartition topicIdPartition, int tierEpoch, CleanerStats stats, boolean compactCompleted, Iterable<TierLogSegment> sourceSegments, Iterable<UUID> destinationObjectIds, long lastCleanOffset) {
        java.util.Set sourceObjectIds = CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)sourceSegments.map((Function1 & Serializable)x$18 -> x$18.metadata().objectId())).toSet()).asJava();
        CompactStats compactStats = compactCompleted ? new CompactStats(stats.bytesRead(), stats.bytesWritten(), stats.mapBytesRead()) : CompactStats.EMPTY;
        TierCompactionCommitAndSwap commitAndSwap = new TierCompactionCommitAndSwap(topicIdPartition, tierEpoch, log.tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), UUID.randomUUID(), sourceObjectIds, (java.util.Set<UUID>)CollectionConverters$.MODULE$.SetHasAsJava((Set)destinationObjectIds.toSet()).asJava(), lastCleanOffset, compactStats);
        TierLogCompactionUtils$.MODULE$.writeCommitAndSwapMarker(commitAndSwap, topicIdPartition, this.time, this.tierTopicAppender);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<ListBuffer<TierLogSegment>, LogSegment> cleanSegments(AbstractLog log, Queue<TierLogSegment> segments, OffsetMap map, long currentTime, CleanerStats stats, CleanedTransactionMetadata transactionMetadata, long legacyDeleteHorizonMs, TopicIdPartition topicIdPartition) {
        void createNewCleanedSegment_fileSuffix;
        void createNewCleanedSegment_baseOffset;
        void createNewCleanedSegment_logConfig;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Cleaning log ").append(log.name()).append(" cleanSegments tiered segments ").append(segments).toString());
        ListBuffer segmentsUsed = new ListBuffer();
        String string = MergedLog$.MODULE$.TierCleanedFileSuffix();
        long l = ((TierLogSegment)segments.head()).baseOffset();
        LogConfig logConfig = log.config();
        File createNewCleanedSegment_dir = log.dir();
        Object var27_13 = null;
        logConfig = null;
        string = null;
        LogSegment cleanedSegment = LocalLog$.MODULE$.createNewCleanedSegment(createNewCleanedSegment_dir, (LogConfig)createNewCleanedSegment_logConfig, (long)createNewCleanedSegment_baseOffset, (String)createNewCleanedSegment_fileSuffix);
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleanedSegment.txnIndex()));
        Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
        boolean cleanedSegmentDone = false;
        int targetSegmentSize = log.config().segmentSize;
        int minSegmentSize = log.config().confluentLogConfig().tierCleanerCompactSegmentMinBytes;
        int maxSegmentSize = Integer.MAX_VALUE;
        while (segments.nonEmpty() && !cleanedSegmentDone) {
            TierLogSegment currentSegment = (TierLogSegment)segments.head();
            cleanedSegmentDone = !TierLogCompactionUtils$.MODULE$.shouldCompactNextSourceSegmentIntoDestSegment(topicIdPartition, cleanedSegment, currentSegment, targetSegmentSize, minSegmentSize, maxSegmentSize);
            if (cleanedSegmentDone) continue;
            List<AbortedTxn> abortedTransactions = TierLogCompactionUtils$.MODULE$.fetchAbortedTransactions(this.tierObjectStore, currentSegment, this.ctx, this.retryPolicy);
            transactionMetadata.addAbortedTransactions(abortedTransactions);
            boolean retainLegacyDeletesAndTxnMarkers = currentSegment.maxTimestamp() > legacyDeleteHorizonMs;
            try {
                void apply_retryPolicy;
                void apply_cancellationContext;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append(topicIdPartition).append(": cleaning ").append(currentSegment).append(" into ").append(cleanedSegment.baseOffset()).append(" ").append("with upper bound deleteHorizonMs=").append(legacyDeleteHorizonMs).append(", retainDeletesAndTxnMarkers=").append(retainLegacyDeletesAndTxnMarkers).append(".").toString());
                segments.dequeue();
                if (currentSegment.endOffset() < log.logStartOffset()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(119).append(topicIdPartition).append(": end offset of segment ").append(currentSegment).append(" is smaller than log start offset ").append(log.logStartOffset()).append(". ").append("Discard current result and continue to clean next segments.").toString());
                    segmentsUsed.clear();
                    cleanedSegmentDone = true;
                    continue;
                }
                segmentsUsed.$plus$eq((Object)currentSegment);
                TierObjectStoreRetryPolicy tierObjectStoreRetryPolicy = this.retryPolicy;
                CancellationContext cancellationContext = this.ctx;
                TierObjectStore apply_tierObjectStore = this.tierObjectStore;
                Object var24_24 = null;
                cancellationContext = null;
                tierObjectStoreRetryPolicy = null;
                TierLogSegmentReadAdapter segmentAdapter = new TierLogSegmentReadAdapter(currentSegment, apply_tierObjectStore, (CancellationContext)apply_cancellationContext, (TierObjectStoreRetryPolicy)apply_retryPolicy);
                this.cleanInto(log.topicPartition(), segmentAdapter, cleanedSegment, map, retainLegacyDeletesAndTxnMarkers, log.config().deleteRetentionMs, log.config().maxMessageSize(), transactionMetadata, lastOffsetOfActiveProducers, stats, currentTime);
            }
            catch (LogSegmentOffsetOverflowException e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append(topicIdPartition).append(": LogSegmentOffsetOverflowException cause to abort, ").append(e.getCause()).toString());
                try {
                    try {
                        cleanedSegment.deleteIfExists();
                    }
                    catch (Exception deleteException) {
                        e.addSuppressed(deleteException);
                    }
                }
                catch (Throwable throwable) {
                    throw new TierLogCompactionFencedException(topicIdPartition, e.getCause());
                }
                throw new TierLogCompactionFencedException(topicIdPartition, e.getCause());
            }
        }
        cleanedSegment.onBecomeInactiveSegment();
        return new Tuple2((Object)segmentsUsed, (Object)cleanedSegment);
    }

    @Override
    public Iterable<LogSegmentReadAdapter> logSegments(AbstractLog log, long from, long to) {
        return log.tieredLogSegments(from, to).map((Function1 & Serializable)x$19 -> {
            void apply_retryPolicy;
            TierObjectStoreRetryPolicy tierObjectStoreRetryPolicy = $this.retryPolicy;
            CancellationContext apply_cancellationContext = $this.ctx;
            TierObjectStore apply_tierObjectStore = $this.tierObjectStore;
            return new TierLogSegmentReadAdapter((TierLogSegment)x$19, apply_tierObjectStore, apply_cancellationContext, (TierObjectStoreRetryPolicy)apply_retryPolicy);
        }).dropWhile((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)TierCleaner.$anonfun$logSegments$2(from, x$20))).toList();
    }

    @Override
    public List<AbortedTxn> collectAbortedTransactions(AbstractLog log, long start, long end) {
        Iterator<TierLogSegment> tieredSegments = log.tieredLogSegments(start, end);
        HashSet abortedTxnSet = new HashSet();
        tieredSegments.foreach((Function1 & Serializable)segment -> {
            List<AbortedTxn> abortedTransactions = TierLogCompactionUtils$.MODULE$.fetchAbortedTransactions($this.tierObjectStore, (TierLogSegment)segment, $this.ctx, $this.retryPolicy);
            return (HashSet)abortedTxnSet.$plus$plus$eq(abortedTransactions);
        });
        return abortedTxnSet.toList();
    }

    public static final /* synthetic */ String $anonfun$doTierClean$9(TopicIdPartition topicIdPartition$6, ListBuffer segmentsUsed$1, Queue tieredSegments$1) {
        return new StringBuilder(55).append("Cleaning ").append(topicIdPartition$6).append(", after cleanSegments we have used ").append(segmentsUsed$1).append(" with ").append(tieredSegments$1).append(" left").toString();
    }

    public static final /* synthetic */ String $anonfun$doTierClean$11(TopicIdPartition topicIdPartition$6, ListBuffer segmentsUsed$1) {
        return new StringBuilder(87).append("Fully deleting all segments for ").append(topicIdPartition$6).append(" due to empty generated segment source source segments ").append(segmentsUsed$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$doTierClean$12(AbortedTransactionMetadata x$15) {
        return x$15.lastRetainedBatchOffset().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$logSegments$2(long from$1, TierLogSegmentReadAdapter x$20) {
        return x$20.endOffset() < from$1;
    }

    public TierCleaner(OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, TierCompactionMetrics tierCompactionMetrics, Time time, TierObjectStore tierObjectStore, TierTopicAppender tierTopicAppender, int leaderEpoch, CancellationContext ctx, Function1<TopicPartition, BoxedUnit> checkDone, TierObjectStoreRetryPolicy retryPolicy) {
        this.tierCompactionMetrics = tierCompactionMetrics;
        this.time = time;
        this.tierObjectStore = tierObjectStore;
        this.tierTopicAppender = tierTopicAppender;
        this.leaderEpoch = leaderEpoch;
        this.ctx = ctx;
        this.checkDone = checkDone;
        this.retryPolicy = retryPolicy;
        super(-1, offsetMap, ioBufferSize, maxIoBufferSize, dupBufferLoadFactor, throttler, time, checkDone, tierCompactionMetrics.cleanerMetrics());
        this.logIdent_$eq(new StringBuilder(14).append("TierCleaner ").append(this.id()).append(": ").toString());
    }
}

