/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.tenantplacementadvisor;

import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.clients.DescribeCellsResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.tools.tenantplacementadvisor.CellLoadResolver;
import org.apache.kafka.tools.tenantplacementadvisor.DefaultLoadMetric;
import org.apache.kafka.tools.tenantplacementadvisor.PerMetricCellLoadResolver;
import org.apache.kafka.tools.tenantplacementadvisor.TenantLoad;

public class DefaultCellLoadResolver
implements PerMetricCellLoadResolver {
    private final CloudAdmin admin;
    Map<Integer, Map<String, Double>> cellToMetricCapacities;

    public DefaultCellLoadResolver(CloudAdmin admin) {
        this.admin = admin;
    }

    @Override
    public void initialize(Collection<Integer> cellIds) {
        List cells;
        HashMap<Integer, Map<String, Double>> cellToMetricCapacities = new HashMap<Integer, Map<String, Double>>();
        DescribeCellsResult describeCellResult = this.admin.describeCells(cellIds);
        try {
            cells = ((DescribeCellsResponseData)describeCellResult.value().get()).cells();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(String.format("Call to DescribeCells API failed with %s", e.getMessage()));
        }
        for (DescribeCellsResponseData.Cell cell : cells) {
            Map<String, Double> cellCapacities = Arrays.stream(DefaultLoadMetric.values()).collect(Collectors.toMap(DefaultLoadMetric::getVal, loadMetric -> loadMetric.getPerBrokerCapacity() * (double)cell.brokers().size()));
            cellToMetricCapacities.put(cell.cellId(), cellCapacities);
        }
        this.cellToMetricCapacities = cellToMetricCapacities;
    }

    @Override
    public double resolveCellLoadFromTenants(int cellId, Collection<TenantLoad> tenantLoadsInCell) throws CellLoadResolver.MismatchedMetricsException {
        return this.resolvePerMetricCellLoadFromTenants(cellId, tenantLoadsInCell).values().stream().mapToDouble(x -> x).max().orElse(0.0);
    }

    @Override
    public Map<String, Double> resolvePerMetricCellLoadFromTenants(int cellId, Collection<TenantLoad> tenantLoadsInCell) throws CellLoadResolver.MismatchedMetricsException {
        if (tenantLoadsInCell.isEmpty()) {
            return Collections.emptyMap();
        }
        this.verifyTenantMetrics(tenantLoadsInCell);
        Map<String, Double> metricCapacitiesForCell = this.cellToMetricCapacities.get(cellId);
        HashMap<String, Double> relativeLoadsPerMetric = new HashMap<String, Double>();
        for (Map.Entry<String, Double> entry : metricCapacitiesForCell.entrySet()) {
            String metricName = entry.getKey();
            double metricCapacity = entry.getValue();
            double cellUsage = tenantLoadsInCell.stream().map(tenantLoad -> tenantLoad.getMetrics().get(metricName)).mapToDouble(Number::doubleValue).sum() / metricCapacity;
            relativeLoadsPerMetric.put(metricName, cellUsage);
        }
        return relativeLoadsPerMetric;
    }

    private void verifyTenantMetrics(Collection<TenantLoad> tenantLoadsInCell) throws CellLoadResolver.MismatchedMetricsException {
        if (this.cellToMetricCapacities == null) {
            throw new IllegalStateException("initialize should be called before invoking other methodsin a DefaultCellLoadResolver.");
        }
        Set<String> tenantMetrics = tenantLoadsInCell.iterator().next().getMetrics().keySet();
        boolean tenantLoadsHaveSameMetrics = tenantLoadsInCell.stream().map(TenantLoad::getMetrics).map(Map::keySet).allMatch(keySet -> keySet.equals(tenantMetrics));
        if (!tenantLoadsHaveSameMetrics) {
            throw new CellLoadResolver.MismatchedMetricsException("Provided TenantLoads do not all contain the same metric names.");
        }
        if (!tenantMetrics.equals(new HashSet(Arrays.stream(DefaultLoadMetric.values()).map(DefaultLoadMetric::getVal).collect(Collectors.toSet())))) {
            throw new CellLoadResolver.MismatchedMetricsException("Provided TenantLoad metric names do not map 1:1 with metric names known to DefaultCellLoadResolver.");
        }
    }
}

