/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.multibindings.Multibinder;
import com.netflix.governator.GovernatorFeature;
import com.netflix.governator.GovernatorFeatures;
import com.netflix.governator.LegacyScopesModule;
import com.netflix.governator.LifecycleInjector;
import com.netflix.governator.LifecycleListenerModule;
import com.netflix.governator.LifecycleManager;
import com.netflix.governator.LifecycleModule;
import com.netflix.governator.ProvisionMetricsModule;
import com.netflix.governator.annotations.SuppressLifecycleUninitialized;
import com.netflix.governator.annotations.binding.Arguments;
import com.netflix.governator.annotations.binding.Profiles;
import com.netflix.governator.internal.DefaultPropertySource;
import com.netflix.governator.internal.GovernatorFeatureSet;
import com.netflix.governator.spi.InjectorCreator;
import com.netflix.governator.spi.PropertySource;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleInjectorCreator
implements InjectorCreator<LifecycleInjector> {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleInjectorCreator.class);
    private String[] args = new String[0];
    private LinkedHashSet<String> profiles = new LinkedHashSet();
    private IdentityHashMap<GovernatorFeature<?>, Object> features = new IdentityHashMap();

    public LifecycleInjectorCreator withArguments(String[] args) {
        Preconditions.checkArgument((args != null ? 1 : 0) != 0, (Object)"Arg may not be null");
        this.args = args;
        return this;
    }

    public LifecycleInjectorCreator withProfiles(String ... profiles) {
        Preconditions.checkArgument((profiles != null ? 1 : 0) != 0, (Object)"Arg may not be null");
        this.profiles = new LinkedHashSet<String>(Arrays.asList(profiles));
        return this;
    }

    public LifecycleInjectorCreator withProfiles(Set<String> profiles) {
        Preconditions.checkArgument((profiles != null ? 1 : 0) != 0, (Object)"profiles may not be null");
        this.profiles = new LinkedHashSet<String>(profiles);
        return this;
    }

    public LifecycleInjectorCreator withFeatures(IdentityHashMap<GovernatorFeature<?>, Object> features) {
        Preconditions.checkArgument((features != null ? 1 : 0) != 0, (Object)"features may not be null");
        this.features = features;
        return this;
    }

    @Override
    public LifecycleInjector createInjector(Stage stage, Module module) {
        final GovernatorFeatureSetImpl featureSet = new GovernatorFeatureSetImpl(this.features);
        final LifecycleManager manager = new LifecycleManager();
        try {
            this.onBeforeInjectorCreate();
            Injector injector = Guice.createInjector((Stage)stage, (Module[])new Module[]{new ProvisionMetricsModule(), new LifecycleModule(), new LifecycleListenerModule(), new LegacyScopesModule(), new AbstractModule(){

                protected void configure() {
                    this.bind(GovernatorFeatureSet.class).toInstance((Object)featureSet);
                    this.bind(LifecycleManager.class).toInstance((Object)manager);
                    Multibinder profilesBinder = Multibinder.newSetBinder((Binder)this.binder(), (Key)Key.get(String.class, Profiles.class)).permitDuplicates();
                    LifecycleInjectorCreator.this.profiles.forEach(profile -> profilesBinder.addBinding().toInstance(profile));
                    this.bind(String[].class).annotatedWith(Arguments.class).toInstance((Object)LifecycleInjectorCreator.this.args);
                    this.requestInjection(LifecycleInjectorCreator.this);
                }
            }, module});
            manager.notifyStarted();
            LifecycleInjector lifecycleInjector = LifecycleInjector.wrapInjector(injector, manager);
            this.onSuccessfulInjectorCreate();
            LOG.info("Injector created successfully ");
            LifecycleInjector lifecycleInjector2 = lifecycleInjector;
            return lifecycleInjector2;
        }
        catch (Exception e) {
            LOG.error("Failed to create injector - {}@{}", new Object[]{e.getClass().getSimpleName(), System.identityHashCode(e), e});
            this.onFailedInjectorCreate(e);
            try {
                manager.notifyStartFailed(e);
            }
            catch (Exception e2) {
                LOG.error("Failed to notify injector creation failure", (Throwable)e2);
            }
            if (!featureSet.get(GovernatorFeatures.SHUTDOWN_ON_ERROR).booleanValue()) {
                LifecycleInjector lifecycleInjector = LifecycleInjector.createFailedInjector(manager);
                return lifecycleInjector;
            }
            throw e;
        }
        finally {
            this.onCompletedInjectorCreate();
        }
    }

    protected void onBeforeInjectorCreate() {
    }

    protected void onSuccessfulInjectorCreate() {
    }

    protected void onFailedInjectorCreate(Throwable error) {
    }

    protected void onCompletedInjectorCreate() {
    }

    public String toString() {
        return "LifecycleInjectorCreator[]";
    }

    @Singleton
    @SuppressLifecycleUninitialized
    class GovernatorFeatureSetImpl
    implements GovernatorFeatureSet {
        private final IdentityHashMap<GovernatorFeature<?>, Object> featureOverrides;
        @Inject
        private PropertySource properties = new DefaultPropertySource();

        @Inject
        public GovernatorFeatureSetImpl(IdentityHashMap<GovernatorFeature<?>, Object> featureOverrides) {
            this.featureOverrides = featureOverrides;
        }

        @Override
        public <T> T get(GovernatorFeature<T> feature) {
            return (T)(this.featureOverrides.containsKey(feature) ? this.featureOverrides.get(feature) : this.properties.get(feature.getKey(), feature.getType(), feature.getDefaultValue()));
        }
    }
}

