/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.governator.SafeLifecycleListener;
import com.netflix.governator.annotations.SuppressLifecycleUninitialized;
import com.netflix.governator.spi.LifecycleListener;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@SuppressLifecycleUninitialized
public final class LifecycleManager {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleManager.class);
    private final Set<SafeLifecycleListener> listeners = new LinkedHashSet<SafeLifecycleListener>();
    private final AtomicReference<State> state;
    private final ReferenceQueue<LifecycleListener> unreferencedListenersQueue = new ReferenceQueue();
    private volatile Throwable failureReason;
    private final ExecutorService reqQueueExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("lifecycle-listener-monitor-%d").build());
    private final AtomicBoolean running = new AtomicBoolean(true);

    public LifecycleManager() {
        LOG.info("Starting '{}'", (Object)this);
        this.state = new AtomicReference<State>(State.Starting);
        this.reqQueueExecutor.submit(new ListenerCleanupWorker());
    }

    private synchronized void removeListener(SafeLifecycleListener listenerRef) {
        this.listeners.remove(listenerRef);
    }

    public synchronized void addListener(LifecycleListener listener) {
        SafeLifecycleListener safeListener = SafeLifecycleListener.wrap(listener, this.unreferencedListenersQueue);
        if (!this.listeners.contains(safeListener) && this.listeners.add(safeListener)) {
            LOG.info("Adding listener '{}'", (Object)safeListener);
            switch (this.state.get()) {
                case Started: {
                    safeListener.onStarted();
                    break;
                }
                case Stopped: {
                    safeListener.onStopped(this.failureReason);
                    break;
                }
            }
        }
    }

    public synchronized void notifyStarted() {
        if (this.state.compareAndSet(State.Starting, State.Started)) {
            LOG.info("Started '{}'", (Object)this);
            for (LifecycleListener lifecycleListener : new ArrayList<SafeLifecycleListener>(this.listeners)) {
                lifecycleListener.onStarted();
            }
        }
    }

    public synchronized void notifyStartFailed(Throwable t) {
        if (this.state.compareAndSet(State.Starting, State.Stopped) || this.state.compareAndSet(State.Started, State.Stopped)) {
            LOG.info("Failed start of '{}'", (Object)this);
            if (this.running.compareAndSet(true, false)) {
                this.reqQueueExecutor.shutdown();
            }
            this.failureReason = t;
            Iterator<SafeLifecycleListener> shutdownIter = new LinkedList<SafeLifecycleListener>(this.listeners).descendingIterator();
            while (shutdownIter.hasNext()) {
                shutdownIter.next().onStopped(t);
            }
            this.listeners.clear();
        }
        this.state.set(State.Done);
    }

    public synchronized void notifyShutdown() {
        if (this.running.compareAndSet(true, false)) {
            this.reqQueueExecutor.shutdown();
        }
        if (this.state.compareAndSet(State.Started, State.Stopped)) {
            LOG.info("Stopping '{}'", (Object)this);
            Iterator<SafeLifecycleListener> shutdownIter = new LinkedList<SafeLifecycleListener>(this.listeners).descendingIterator();
            while (shutdownIter.hasNext()) {
                shutdownIter.next().onStopped(null);
            }
            this.listeners.clear();
        }
        this.state.set(State.Done);
    }

    public State getState() {
        return this.state.get();
    }

    public Throwable getFailureReason() {
        return this.failureReason;
    }

    public String toString() {
        return "LifecycleManager@" + System.identityHashCode(this);
    }

    public static enum State {
        Starting,
        Started,
        Stopped,
        Done;

    }

    private final class ListenerCleanupWorker
    implements Runnable {
        private ListenerCleanupWorker() {
        }

        @Override
        public void run() {
            try {
                while (LifecycleManager.this.running.get()) {
                    Reference ref = LifecycleManager.this.unreferencedListenersQueue.remove(1000L);
                    if (ref == null || !(ref instanceof SafeLifecycleListener)) continue;
                    LifecycleManager.this.removeListener((SafeLifecycleListener)ref);
                }
                LOG.info("LifecycleManager.ListenerCleanupWorker is exiting");
            }
            catch (InterruptedException e) {
                LOG.info("LifecycleManager.ListenerCleanupWorker is exiting due to thread interrupt");
            }
        }
    }
}

