/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.netflix.governator.AbstractPropertySource;
import com.netflix.governator.spi.PropertySource;
import java.util.Properties;

public final class PropertiesPropertySource
extends AbstractPropertySource
implements Module {
    private Properties props;

    public PropertiesPropertySource(Properties props) {
        this.props = new Properties(props);
    }

    public PropertiesPropertySource() {
        this(new Properties());
    }

    public static PropertiesPropertySource from(Properties props) {
        return new PropertiesPropertySource(props);
    }

    public PropertiesPropertySource setProperty(String key, String value) {
        this.props.setProperty(key, value);
        return this;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.props.containsKey(key);
    }

    @Override
    public String get(String key) {
        return this.props.getProperty(key);
    }

    @Override
    public String get(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public void configure(Binder binder) {
        binder.bind(PropertySource.class).toInstance((Object)this);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return "PropertiesPropertySource[count=" + this.props.size() + "]";
    }
}

