/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.netflix.governator.internal.scanner.ClasspathUrlDecoder;
import com.netflix.governator.spi.AnnotatedClassScanner;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanningModuleBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ScanningModuleBuilder.class);
    private Set<String> packages = new HashSet<String>();
    private List<AnnotatedClassScanner> scanners = new ArrayList<AnnotatedClassScanner>();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Predicate<Class<?>> excludeRule = cls -> false;

    public ScanningModuleBuilder usingClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ScanningModuleBuilder forPackages(String ... packages) {
        return this.forPackages(Arrays.asList(packages));
    }

    public ScanningModuleBuilder forPackages(Collection<String> packages) {
        this.packages = new HashSet<String>(packages);
        return this;
    }

    public ScanningModuleBuilder addScanner(AnnotatedClassScanner scanner) {
        this.scanners.add(scanner);
        return this;
    }

    private ScanningModuleBuilder excludeClassesWhen(Predicate<Class<?>> predicate) {
        this.excludeRule = this.excludeRule.or(predicate);
        return this;
    }

    public ScanningModuleBuilder excludeClasses(Class<?> ... classes) {
        return this.excludeClasses(new HashSet(Arrays.asList(classes)));
    }

    public ScanningModuleBuilder excludePackages(String ... packages) {
        return this.excludeClassesWhen(cls -> {
            for (String pkg : packages) {
                if (!cls.getPackage().getName().startsWith(pkg)) continue;
                return true;
            }
            return false;
        });
    }

    public ScanningModuleBuilder excludeClasses(Set<Class<?>> classes) {
        HashSet toTest = new HashSet(classes);
        return this.excludeClassesWhen(cls -> toTest.contains(cls));
    }

    public Module build() {
        final Predicate<Class<?>> includeRule = this.excludeRule.negate();
        final ArrayList consumers = new ArrayList();
        ScannerContext scanner = new ScannerContext();
        for (String basePackage : this.packages) {
            scanner.doScan(basePackage, new Consumer<String>(){

                @Override
                public void accept(String className) {
                    try {
                        Class<?> cls = Class.forName(className, false, ScanningModuleBuilder.this.classLoader);
                        if (includeRule.test(cls)) {
                            for (AnnotatedClassScanner scanner : ScanningModuleBuilder.this.scanners) {
                                if (!cls.isAnnotationPresent(scanner.annotationClass())) continue;
                                consumers.add(binder -> scanner.applyTo((Binder)binder, cls.getAnnotation(scanner.annotationClass()), Key.get((Class)cls)));
                            }
                        }
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        LOG.debug("Error scanning class {}", (Object)className, (Object)e);
                    }
                    catch (Error e) {
                        throw new RuntimeException("Error scanning class " + className, e);
                    }
                }
            });
        }
        return binder -> consumers.forEach(consumer -> consumer.accept(binder));
    }

    private class ScannerContext {
        private final Set<URL> foundUrls = new HashSet<URL>();

        private ScannerContext() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void doScan(String basePackage, Consumer<String> consumer) {
            LOG.debug("Scanning package {}", (Object)basePackage);
            try {
                String basePackageWithSlashes = basePackage.replace(".", "/");
                for (URL url : Collections.list(ScanningModuleBuilder.this.classLoader.getResources(basePackageWithSlashes))) {
                    LOG.debug("Scanning url {}", (Object)url);
                    if (this.foundUrls.contains(url)) continue;
                    this.foundUrls.add(url);
                    try {
                        if (this.isJarURL(url)) {
                            String jarPath = url.getFile();
                            if (jarPath.contains("!")) {
                                jarPath = jarPath.substring(0, jarPath.indexOf("!"));
                                url = new URL(jarPath);
                            }
                            File file = ClasspathUrlDecoder.toFile(url);
                            try {
                                JarFile jar = new JarFile(file);
                                Throwable throwable = null;
                                try {
                                    for (JarEntry entry : Collections.list(jar.entries())) {
                                        try {
                                            int pos = entry.getName().indexOf(".class");
                                            if (pos == -1) continue;
                                            consumer.accept(entry.getName().substring(0, pos).replace('/', '.'));
                                        }
                                        catch (Exception e) {
                                            throw new Exception(String.format("Unable to scan JarEntry '%s' in '%s'. %s", entry.getName(), file.getCanonicalPath(), e.getMessage()));
                                        }
                                    }
                                    continue;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (jar == null) continue;
                                    if (throwable != null) {
                                        try {
                                            jar.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    jar.close();
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                throw new Exception(String.format("Unable to scan '%s'. %s", file.getCanonicalPath(), e.getMessage()));
                            }
                        }
                        this.scanPackage(url, basePackage, consumer);
                    }
                    catch (Exception e) {
                        throw new Exception(String.format("Unable to scan jar '%s'. %s ", url, e.getMessage()));
                        return;
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Classpath scanning failed for package '{}'", (Object)basePackage, (Object)e);
            }
        }

        private boolean isJarURL(URL url) {
            String protocol = url.getProtocol();
            return "zip".equals(protocol) || "jar".equals(protocol) || "file".equals(protocol) && url.getPath().endsWith(".jar");
        }

        private void scanPackage(URL url, String basePackage, Consumer<String> consumer) {
            File dir = ClasspathUrlDecoder.toFile(url);
            if (dir.isDirectory()) {
                this.scanDir(dir, basePackage.length() > 0 ? basePackage + "." : "", consumer);
            }
        }

        private void scanDir(File dir, String packageName, Consumer<String> consumer) {
            File[] files;
            LOG.debug("Scanning dir {}", (Object)packageName);
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) {
                    this.scanDir(file, packageName + file.getName() + ".", consumer);
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                String name = file.getName();
                if ((name = name.replaceFirst(".class$", "")).contains(".")) continue;
                consumer.accept(packageName + name);
            }
        }
    }
}

