/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.internal;

import com.google.common.base.Supplier;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class TypeInspector {
    public static <R, V extends Supplier<R> & TypeVisitor> R accept(Class<?> type, V visitor) {
        TypeInspector.accept(type, (TypeVisitor)visitor);
        return (R)visitor.get();
    }

    public static void accept(Class<?> type, TypeVisitor visitor) {
        if (TypeInspector._accept(type, visitor)) {
            for (Class<?> iface : type.getInterfaces()) {
                if (!TypeInspector._accept(iface, visitor)) break;
            }
        }
    }

    private static boolean _accept(Class<?> type, TypeVisitor visitor) {
        if (type == null) {
            return false;
        }
        boolean continueVisit = visitor.visit(type);
        if (continueVisit) {
            Field field;
            int n;
            AccessibleObject[] accessibleObjectArray = type.getDeclaredFields();
            int n2 = accessibleObjectArray.length;
            for (n = 0; n < n2 && (continueVisit = visitor.visit(field = accessibleObjectArray[n])); ++n) {
            }
            if (continueVisit) {
                AccessibleObject method;
                accessibleObjectArray = type.getDeclaredMethods();
                n2 = accessibleObjectArray.length;
                for (n = 0; n < n2 && (continueVisit = visitor.visit((Method)(method = accessibleObjectArray[n]))); ++n) {
                }
                if (continueVisit) {
                    continueVisit = TypeInspector._accept(type.getSuperclass(), visitor);
                }
            }
        }
        return continueVisit;
    }

    public static interface TypeVisitor {
        public boolean visit(Field var1);

        public boolean visit(Method var1);

        public boolean visit(Class<?> var1);
    }
}

