/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.ParseResult;
import com.github.rvesse.airline.parser.command.CliParser;
import java.util.Arrays;
import org.apache.commons.collections4.ListUtils;

public class Cli<C> {
    private final GlobalMetadata<C> metadata;

    public static <T> CliBuilder<T> builder(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        return new CliBuilder(name);
    }

    public Cli(Class<?> cliClass) {
        this(MetadataLoader.loadGlobal(cliClass));
    }

    public Cli(Class<?> cliClass, ParserMetadata<C> parserConfig) {
        this(MetadataLoader.loadGlobal(cliClass, parserConfig));
    }

    public Cli(GlobalMetadata<C> metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata cannot be null");
        }
        this.metadata = metadata;
    }

    public GlobalMetadata<C> getMetadata() {
        return this.metadata;
    }

    public C parse(String ... args) {
        return this.parse(ListUtils.unmodifiableList(Arrays.asList(args)));
    }

    private C parse(Iterable<String> args) {
        CliParser<C> parser = new CliParser<C>();
        return (C)parser.parse(this.metadata, args);
    }

    public ParseResult<C> parseWithResult(String ... args) {
        return this.parseWithResult(Arrays.asList(args));
    }

    public ParseResult<C> parseWithResult(Iterable<String> args) {
        CliParser<C> parser = new CliParser<C>();
        return parser.parseWithResult(this.metadata, args);
    }
}

