/*
 * Decompiled with CFR 0.152.
 */
package io.confluent;

import com.google.common.util.concurrent.RateLimiter;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jRateFilter
extends Filter {
    private Priority level;
    private RateLimiter rateLimiter;

    public void setLevel(String level) {
        this.level = Level.toLevel((String)level);
    }

    public void setRate(int rate) {
        this.rateLimiter = RateLimiter.create((double)rate);
    }

    public int decide(LoggingEvent loggingEvent) {
        if (this.rateLimiter.tryAcquire() || loggingEvent.getLevel().isGreaterOrEqual(this.level)) {
            return 0;
        }
        return -1;
    }
}

