/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.google.common.collect.Maps;
import io.confluent.C3Version;
import io.confluent.controlcenter.util.ConfigUtils;
import io.confluent.controlcenter.validators.StringNotPrefixValidator;
import io.confluent.controlcenter.validators.WarningValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.streams.StreamsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlCenterConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(ControlCenterConfig.class);
    private static final int NUM_DEFAULT_PARTITIONS = 12;
    public static final String CONFLUENT_CONTROLCENTER_PREFIX = "confluent.controlcenter.";
    public static final String CONFLUENT_CONTROLCENTER_KSTREAMS_PREFIX = "confluent.controlcenter.streams.";
    public static final String CONFLUENT_CONTROLCENTER_REST_PREFIX = "confluent.controlcenter.rest.";
    public static final String CONFLUENT_CONTROLCENTER_EMAIL_PREFIX = "confluent.controlcenter.mail.";
    public static final String CONFLUENT_CONTROLCENTER_WEBHOOK_PREFIX = "confluent.controlcenter.webhook.";
    public static final String CONFLUENT_CONTROLCENTER_ALERT_PREFIX = "confluent.controlcenter.alert.";
    public static final String CONFLUENT_CONTROLCENTER_CONNECT_PREFIX = "confluent.controlcenter.connect.";
    public static final String CONFLUENT_MONITORING_INTERCEPTOR_PREFIX = "confluent.monitoring.interceptor.";
    public static final String CONFLUENT_CONTROLCENTER_KSQL_PREFIX = "confluent.controlcenter.ksql.";
    public static final String CONFLUENT_CONTROLCENTER_KSQL_SSL_ALIAS_NAME = "confluent.controlcenter.ksql.ksql.alias.name";
    public static final String CONFLUENT_CONTROLCENTER_KAFKA_PREFIX = "confluent.controlcenter.kafka.";
    public static final String CONFLUENT_METADATA_PREFIX = "confluent.metadata.";
    public static final String CONFLUENT_CONTROLCENTER_UI_PREFIX = "confluent.controlcenter.ui.";
    public static final String CONFLUENT_CONTROLCENTER_MDS_CLIENT_PREFIX = "confluent.controlcenter.mds.client.";
    public static final String CONFLUENT_CONTROLCENTER_PRIVATE_PREFIX = "confluent.controlcenter.private.";
    public static final String CONTROL_CENTER_ARMERIA_HEALTHCHECK_FORCE_HTTP1 = "confluent.controlcenter.armeria.healthcheck.force.http1";
    public static final String CONFLUENT_CONTROLCENTER_REST_PROXY_PREFIX = "confluent.controlcenter.rest.proxy.";
    public static final String CONFLUENT_CONTROLCENTER_REST_PROXY_SSL_ALIAS_NAME = "confluent.controlcenter.rest.proxy.alias.name";
    public static final int DEFAULT_CONTROL_CENTER_INPUT_TOPIC_PARTITIONS = 12;
    public static final short DEFAULT_CONTROL_CENTER_INPUT_TOPIC_REPLICATION = 3;
    public static final long DEFAULT_CONTROL_CENTER_INPUT_TOPIC_RETENTION_MS = TimeUnit.DAYS.toMillis(3L);
    public static final int DEFAULT_CONTROL_CENTER_INPUT_TOPIC_RETENTION_BYTES = -1;
    public static final long DEFAULT_CONTROL_CENTER_INPUT_TOPIC_SKIP_BACKLOG_MIN = 15L;
    public static final String CONNECT_HEALTHCHECK_PATH = "confluent.controlcenter.connect.healthcheck.endpoint";
    public static final String DEFAULT_CONNECT_HEALTHCHECK_PATH = "/v1/metadata/id";
    public static final boolean DEFAULT_CONTROL_CENTER_ARMERIA_HEALTHCHECK_FORCE_HTTP1 = false;
    protected static final String CONNECT_HEALTHCHECK_DOC = "Connect Cluster healthcheck endpoint.";
    public static final String CONTROL_CENTER_NAME_CONFIG = "confluent.controlcenter.name";
    public static final String DEFAULT_CONTROL_CENTER_NAME = "_confluent-controlcenter";
    public static final String CONTROL_CENTER_VERSION = C3Version.getVersion().getMajorVersion() + "-" + C3Version.getVersion().getMinorVersion() + "-" + C3Version.getVersion().getPatchVersion();
    protected static final String CONTROL_CENTER_NAME_DOC = "Control Center Name. All internal Topics will be prepended with this value.";
    public static final String CONTROL_CENTER_ID_CONFIG = "confluent.controlcenter.id";
    public static final String DEFAULT_CONTROL_CENTER_ID = "1";
    protected static final String CONTROL_CENTER_ID_DOC = "Control Center ID";
    public static final String CONTROL_CENTER_MODE_ENABLED = "confluent.controlcenter.mode.enable";
    public static final String CONTROL_CENTER_MODE_ALL = "all";
    public static final String CONTROL_CENTER_MODE_MANAGEMENT = "management";
    public static final String DEFAULT_CONTROL_CENTER_MODE_ENABLED = "all";
    protected static final String CONTROL_CENTER_MODE_ENABLED_DOC = "The Control Center mode. The valid values are \"all\" for enabling both management and monitoring features, and \"management\" for enabling only management.";
    public static final String CONTROL_CENTER_TOPIC_CONFIG = "confluent.monitoring.interceptor.topic";
    public static final String DEFAULT_CONTROL_CENTER_TOPIC = "_confluent-monitoring";
    protected static final String CONTROL_CENTER_TOPIC_DOC = "The Kafka topic that stores monitoring interceptor data. This setting must match the ``confluent.monitoring.interceptor.topic`` configuration used by the interceptors in your application. Usually you should not change this setting unless you are running multiple instances of Control Center with client monitoring interceptor data being reported to the same Kafka cluster.";
    public static final String CONFLUENT_METRICS_PREFIX = "confluent.metrics.";
    public static final String CONTROL_CENTER_METRICS_TOPIC_CONFIG = "confluent.metrics.topic";
    public static final String DEFAULT_CONTROL_CENTER_METRICS_TOPIC = "_confluent-metrics";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_DOC = "The topic the metrics reporter publishes its metrics to";
    public static final String CONTROL_CENTER_METRICS_BROKER_COUNT_STALENESS_THRESHOLD_MS = "confluent.metrics.broker.count.staleness.threshold.ms";
    public static final long DEFAULT_CONTROL_CENTER_METRICS_BROKER_COUNT_STALENESS_THRESHOLD_MS = TimeUnit.SECONDS.toMillis(120L);
    protected static final String CONTROL_CENTER_METRICS_BROKER_COUNT_STALENESS_THRESHOLD_MS_DOC = "The maximum of time to wait for new metrics from broker before dropping the broker. This value has to modified in scenarios where Confluent.metrics.reporter.publish.ms in kafka server properties the default value of 15s is overridden. The minimum value is 120 seconds.";
    public static final String CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT = "confluent.controlcenter.internal.streams.start.timeout";
    public static final long DEFAULT_CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT = TimeUnit.HOURS.toMillis(6L);
    protected static final String CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT_DOC = "Timeout when starting internal streams job in ms";
    public static final String CONTROL_CENTER_INTERNAL_PARTITIONS_CONFIG = "confluent.controlcenter.internal.topics.partitions";
    public static final int DEFAULT_CONTROL_CENTER_INTERNAL_PARTITIONS = 12;
    protected static final String CONTROL_CENTER_INTERNAL_PARTITIONS_DOC = "Partition count for internal topics";
    public static final String CONTROL_CENTER_INTERNAL_REPLICATION_CONFIG = "confluent.controlcenter.internal.topics.replication";
    public static final short DEFAULT_CONTROL_CENTER_INTERNAL_REPLICATION = 3;
    protected static final String CONTROL_CENTER_INTERNAL_REPLICATION_DOC = "Replication factor used internally by Control Center. It is not recommended to reduce this value except in a development environment.";
    public static final String CONTROL_CENTER_INTERNAL_RETENTION_MS_CONFIG = "confluent.controlcenter.internal.topics.retention.ms";
    public static final long DEFAULT_CONTROL_CENTER_INTERNAL_RETENTION_MS = TimeUnit.DAYS.toMillis(7L);
    protected static final String CONTROL_CENTER_INTERNAL_RETENTION_MS_DOC = "Retention ms for internal topics";
    public static final String CONTROL_CENTER_INTERNAL_RETENTION_BYTES_CONFIG = "confluent.controlcenter.internal.topics.retention.bytes";
    public static final int DEFAULT_CONTROL_CENTER_INTERNAL_RETENTION_BYTES = -1;
    protected static final String CONTROL_CENTER_INTERNAL_RETENTION_BYTES_DOC = "Retention bytes for internal topics";
    public static final String CONTROL_CENTER_INTERNAL_CHANGELOG_SEGMENT_BYTES_CONFIG = "confluent.controlcenter.internal.topics.changelog.segment.bytes";
    public static final int DEFAULT_CONTROL_CENTER_INTERNAL_CHANGELOG_SEGMENT_BYTES = 0x8000000;
    protected static final String CONTROL_CENTER_INTERNAL_CHANGELOG_SEGMENT_BYTES_DOC = "Segment size in bytes for internal changelog topics";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_PARTITIONS_CONFIG = "confluent.monitoring.interceptor.topic.partitions";
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_PARTITIONS_DOC = "Number of partitions for the monitoring interceptor data topic";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_REPLICATION_CONFIG = "confluent.monitoring.interceptor.topic.replication";
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_REPLICATION_DOC = "Replication factor for monitoring topic. It is not recommended to reduce this value except in a development environment.";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_RETENTION_MS_CONFIG = "confluent.monitoring.interceptor.topic.retention.ms";
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_RETENTION_MS_DOC = "Retention ms for monitoring topic";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_RETENTION_BYTES_CONFIG = "confluent.monitoring.interceptor.topic.retention.bytes";
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_RETENTION_BYTES_DOC = "Retention bytes for monitoring topic";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_SKIP_BACKLOG_MIN_CONFIG = "confluent.monitoring.interceptor.topic.skip.backlog.minutes";
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_SKIP_BACKLOG_MIN_DOC = "Start processing backlog from minutes ago and skip older data";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_VALIDATE_CONFIG = "confluent.monitoring.interceptor.topic.config.validate";
    public static final boolean DEFAULT_CONTROL_CENTER_MONITORING_TOPIC_VALIDATE = false;
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_VALIDATE_DOC = "Enforces partitions and replication factor settings on the monitoring topic";
    public static final String CONTROL_CENTER_METRICS_TOPIC_PARTITIONS_CONFIG = "confluent.metrics.topic.partitions";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_PARTITIONS_DOC = "Partition count for metrics topic";
    public static final String CONTROL_CENTER_METRICS_TOPIC_REPLICATION_CONFIG = "confluent.metrics.topic.replication";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_REPLICATION_DOC = "Replication factor for metrics topic. It is not recommended to reduce this value except in a development environment.";
    public static final String CONTROL_CENTER_METRICS_TOPIC_RETENTION_MS_CONFIG = "confluent.metrics.topic.retention.ms";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_RETENTION_MS_DOC = "Retention ms for metrics topic";
    public static final String CONTROL_CENTER_METRICS_TOPIC_RETENTION_BYTES_CONFIG = "confluent.metrics.topic.retention.bytes";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_RETENTION_BYTES_DOC = "Retention bytes for metrics topic";
    public static final String CONTROL_CENTER_METRICS_STORE_RETENTION_DAYS_CONFIG = "confluent.metrics.store.retention.days";
    protected static final String CONTROL_CENTER_METRICS_STORE_RETENTION_DAYS_DOC = "Retention in days for metrics aggregate state store";
    public static final int DEFAULT_CONTROL_CENTER_METRICS_STORE_RETENTION_DAYS = 7;
    public static final String CONTROL_CENTER_METRICS_TOPIC_MAX_MESSAGE_BYTES_CONFIG = "confluent.metrics.topic.max.message.bytes";
    public static final int DEFAULT_CONTROL_CENTER_METRICS_TOPIC_MAX_MESSAGE_BYTES = 0xA00000;
    protected static final String CONTROL_CENTER_METRICS_TOPIC_MAX_MESSAGE_BYTES_DOC = "Maximum message size for metrics topic";
    public static final String CONTROL_CENTER_METRICS_TOPIC_SKIP_BACKLOG_MIN_CONFIG = "confluent.metrics.topic.skip.backlog.minutes";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_SKIP_BACKLOG_MIN_DOC = "Start processing backlog from minutes ago and skip older data";
    public static final String CONTROL_CENTER_METRICS_TOPIC_VALIDATE_CONFIG = "confluent.metrics.topic.config.validate";
    public static final boolean DEFAULT_CONTROL_CENTER_METRICS_TOPIC_VALIDATE = false;
    protected static final String CONTROL_CENTER_METRICS_TOPIC_VALIDATE_DOC = "Enforces partitions and replication factor settings on the metrics topic";
    public static final String CONTROL_CENTER_LICENSE_CONFIG = "confluent.license";
    protected static final String CONTROL_CENTER_LICENSE_DOC = "License";
    public static final String CONTROL_CENTER_BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String DEFAULT_CONTROL_CENTER_BOOTSTRAP_SERVERS_CONFIG = "localhost:9092";
    public static final String CONTROL_CENTER_BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).";
    public static final String CONTROL_CENTER_DATA_DIR = "confluent.controlcenter.data.dir";
    public static final String DEFAULT_CONTROL_CENTER_DATA_DIR = "/var/lib/confluent-control-center";
    protected static final String CONTROL_CENTER_DATA_DIR_DOC = "Location for Control Center specific data";
    public static final String CONTROL_CENTER_SESSION_TIMEOUT_MS_CONFIG = "confluent.controlcenter.streams." + StreamsConfig.consumerPrefix((String)"session.timeout.ms");
    public static final int DEFAULT_CONTROL_CENTER_SESSION_TIMEOUT_MS_CONFIG = 60000;
    protected static final String CONTROL_CENTER_SESSION_TIMEOUT_MS_DOC = "The timeout used to detect a consumer failure";
    public static final String CONTROL_CENTER_CACHE_MAX_BYTES_BUFFERING_CONFIG = "confluent.controlcenter.streams.cache.max.bytes.buffering";
    public static final long DEFAULT_CONTROL_CENTER_CACHE_MAX_BYTES_BUFFERING_CONFIG = 0x40000000L;
    protected static final String CONTROL_CENTER_CACHE_MAX_BYTES_BUFFERING_CONFIG_DOC = "Maximum number of memory bytes to be used for buffering across all threads";
    public static final String CONTROL_CENTER_STREAMS_UPGRADE_FROM_CONFIG = "confluent.controlcenter.streams.upgrade.from";
    public static final String DEFAULT_CONTROL_CENTER_STREAMS_UPGRADE_FROM = StreamsConfig.UPGRADE_FROM_23;
    protected static final String CONTROL_CENTER_STREAMS_UPGRADE_FROM_CONFIG_DOC = "Allows upgrading from older KafkaStreams versions to newer versions in a backwards compatible way.";
    protected static final String CONTROL_CENTER_ARMERIA_HEALTHCHECK_FORCE_HTTP1_DOC = "flag to force armeria health check to use HTTP1";
    @Deprecated
    public static final String CONTROL_CENTER_STREAMS_RETRIES_CONFIG = "confluent.controlcenter.streams.retries";
    @Deprecated
    public static final int DEFAULT_CONTROL_CENTER_STREAMS_RETRIES_CONFIG = Integer.MAX_VALUE;
    @Deprecated
    protected static final String CONTROL_CENTER_RETRIES_DOC = "(Deprecated) Number of retries in case of streams metadata request failure";
    public static final String CONTROL_CENTER_STREAMS_TASK_TIMEOUT_MS_CONFIG = "confluent.controlcenter.streams.task.timeout.ms";
    public static final int DEFAULT_CONTROL_CENTER_STREAMS_TASK_TIMEOUT_MS_CONFIG = 0;
    protected static final String CONTROL_CENTER_TASK_TIMEOUT_MS_DOC = "The maximum amount of time in milliseconds a task might stall due to internal errors and retries until an error is raised. For a timeout of 0ms, a task would raise an error for the first internal error. For any timeout larger than 0ms, a task will retry at least once before an error is raised.";
    public static final String CONTROL_CENTER_PRODUCER_RETRIES_CONFIG = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"retries");
    public static final int DEFAULT_CONTROL_CENTER_PRODUCER_RETRIES_CONFIG = Integer.MAX_VALUE;
    protected static final String CONTROL_CENTER_PRODUCER_RETRIES_DOC = "Number of retries in case of production failure";
    public static final String CONTROL_CENTER_PRODUCER_RETRY_BACKOFF_MS_CONFIG = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"retry.backoff.ms");
    public static final long DEFAULT_CONTROL_CENTER_PRODUCER_RETRY_BACKOFF_MS_CONFIG = 100L;
    protected static final String CONTROL_CENTER_PRODUCER_RETRY_BACKOFF_MS_DOC = "Time to wait before retrying in case of production failure";
    public static final String CONTROL_CENTER_COMPRESSION_TYPE_CONFIG = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"compression.type");
    public static final String DEFAULT_CONTROL_CENTER_COMPRESSION_TYPE_CONFIG = "lz4";
    protected static final String CONTROL_CENTER_COMPRESSION_TYPE_DOC = "Compression type to use for internal topics";
    public static final String CONTROL_CENTER_PRODUCER_LINGER_MS = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"linger.ms");
    public static final int DEFAULT_CONTROL_CENTER_PRODUCER_LINGER_MS = 500;
    protected static final String CONTROL_CENTER_PRODUCER_LINGER_MS_DOC = "linger.ms used for internal producers.";
    public static final String CONTROL_CENTER_PRODUCER_MAX_BLOCK_MS = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"max.block.ms");
    public static final long DEFAULT_CONTROL_CENTER_PRODUCER_MAX_BLOCK_MS = Long.MAX_VALUE;
    protected static final String CONTROL_CENTER_PRODUCER_MAX_BLOCK_MS_DOC = "max.block.ms used for internal producers.";
    public static final String CONTROL_CENTER_PRODUCER_DELIVERY_TIMEOUT_MS = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"delivery.timeout.ms");
    public static final int DEFAULT_CONTROL_CENTER_PRODUCER_DELIVERY_TIMEOUT_MS = Integer.MAX_VALUE;
    protected static final String CONTROL_CENTER_PRODUCER_DELIVERY_TIMEOUT_MS_DOC = "delivery.timeout.ms used for internal producers.";
    public static final String CONTROL_CENTER_PARALLELISM = "confluent.controlcenter.streams.num.stream.threads";
    public static final Integer DEFAULT_CONTROL_CENTER_PARALLELISM = 12;
    protected static final String CONTROL_CENTER_PARALLELISM_DOC = "The number of threads to execute stream processing";
    public static final String CONTROL_CENTER_REST_PORT = "confluent.controlcenter.rest.port";
    public static final Integer DEFAULT_CONTROL_CENTER_REST_PORT = 9021;
    protected static final String CONTROL_CENTER_REST_PORT_DOC = "DEPRECATED: port to listen on for new HTTP connections. Use listeners instead.";
    public static final String CONTROL_CENTER_REST_RESPONSE_HEADERS = "confluent.controlcenter.rest.response.http.headers.config";
    public static final String DEFAULT_CONTROL_CENTER_REST_RESPONSE_HEADERS = "";
    protected static final String CONTROL_CENTER_REST_RESPONSE_HEADERS_DOC = "Use to select which HTTP headers are returned in the HTTP response for Confluent Platform components.";
    public static final String CONTROL_CENTER_DISPLAY_HOST_PREFIX = "confluent.controlcenter.rest.advertised.url";
    public static final String DEFAULT_CONTROL_CENTER_DISPLAY_HOST_PREFIX = "";
    protected static final String CONTROL_CENTER_DISPLAY_HOST_PREFIX_DOC = "Externally visible host. C3 uses this as an override to rest.listeners when generating urls for external communications, e.g. emails.";
    public static final String CONTROL_CENTER_REST_COMPRESSION = "confluent.controlcenter.rest.compression.enable";
    public static final String DEFAULT_CONTROL_CENTER_REST_COMPRESSION = "true";
    protected static final String CONTROL_CENTER_REST_COMPRESSION_DOC = "Enable HTTP compression";
    public static final String CONTROL_CENTER_USE_DEFAULT_JVM_TRUSTSTORE = "confluent.controlcenter.use.default.jvm.truststore";
    public static final String DEFAULT_CONTROL_CENTER_USE_DEFAULT_JVM_TRUSTSTORE = "false";
    protected static final String CONTROL_CENTER_USE_DEFAULT_JVM_TRUSTSTORE_DOC = "Enable C3 to fallback to default JVM trust store.";
    public static final String CONTROL_CENTER_USE_DEFAULT_OS_TRUSTSTORE = "confluent.controlcenter.use.default.os.truststore";
    public static final String DEFAULT_CONTROL_CENTER_USE_DEFAULT_OS_TRUSTSTORE = "false";
    protected static final String CONTROL_CENTER_USE_DEFAULT_OS_TRUSTSTORE_DOC = "Enable C3 to fallback to default OS trust store.";
    public static final String CONFLUENT_METADATA_BASIC_AUTH_USER_INFO = "confluent.metadata.basic.auth.user.info";
    protected static final String CONFLUENT_METADATA_BASIC_AUTH_USER_INFO_DOC = "Formatted as 'USERNAME:PASSWORD', the credentials of RBAC user for C3 to act on behalf of.This includes running KafkaStreams, authorizing requests, and interacting with other CP services. This config is required to run inside a RBAC environment.";
    public static final String CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS = "confluent.controlcenter.auth.session.expiration.ms";
    public static final long DEFAULT_CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS = TimeUnit.MINUTES.toMillis(0L);
    protected static final String CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS_DOC = "Timeout in milliseconds after which a user session will have to be re-authenticated with the authentication service (e.g. LDAP). Defaults to 0, which means authentication is done for every request. Increase this value to avoid calling the LDAP service for  each request.";
    public static final String CONTROL_CENTER_AUTH_BEARER_ISSUER = "confluent.controlcenter.auth.bearer.issuer";
    public static final String DEFAULT_CONTROL_CENTER_AUTH_BEARER_ISSUER = "Confluent";
    public static final String CONTROL_CENTER_AUTH_BEARER_ISSUER_DOC = "JWT token issuer.";
    public static final String CONTROL_CENTER_AUTH_BEARER_TOKEN_MAX_LIFE = "confluent.controlcenter.auth.bearer.token.max.lifetime.ms";
    public static final long DEFAULT_CONTROL_CENTER_AUTH_BEARER_TOKEN_MAX_LIFE = TimeUnit.HOURS.toMillis(6L);
    public static final String CONTROL_CENTER_AUTH_BEARER_TOKEN_MAX_LIFE_DOC = "Bearer token issued during login cannot renew itself beyond this duration. The max value can be 86400000(24 hours), If this value is set to more than 24 hours, it will be overridden to 24 hours.";
    public static final String PUBLIC_KEY_PATH = "public.key.path";
    public static final String PUBLIC_KEY_PATH_DOC = "Path to public key for authenticating JWT tokens.";
    public static final String CONTROL_CENTER_AUTH_BEARER_ROLES_CLAIM = "confluent.controlcenter.auth.bearer.roles.claim";
    public static final String DEFAULT_CONTROL_CENTER_AUTH_BEARER_ROLES_CLAIM = "";
    public static final String CONTROL_CENTER_AUTH_BEARER_ROLES_CLAIM_DOC = "JWT roles claim.";
    public static final String CONTROL_CENTER_HSTS_ENABLE = "confluent.controlcenter.rest.hsts.enable";
    public static final boolean DEFAULT_CONTROL_CENTER_HSTS_ENABLE = true;
    protected static final String CONTROL_CENTER_HSTS_ENABLE_DOC = "Enable HTTP Strict Transport Security.";
    public static final String CONTROL_CENTER_EMAIL_ENABLE = "confluent.controlcenter.mail.enabled";
    public static final boolean DEFAULT_CONTROL_CENTER_EMAIL_ENABLE = false;
    protected static final String CONTROL_CENTER_EMAIL_ENABLE_DOC = "Enable email alerts. If this setting is false you will not be able to add email alert actions in the web user interface.";
    public static final String CONTROL_CENTER_EMAIL_HOST_NAME = "confluent.controlcenter.mail.host.name";
    public static final String DEFAULT_CONTROL_CENTER_EMAIL_HOST_NAME = "localhost";
    protected static final String CONTROL_CENTER_EMAIL_HOST_NAME_DOC = "Hostname of outgoing SMTP server.";
    public static final String CONTROL_CENTER_EMAIL_PORT = "confluent.controlcenter.mail.port";
    public static final Integer DEFAULT_CONTROL_CENTER_EMAIL_PORT = 587;
    protected static final String CONTROL_CENTER_EMAIL_PORT_DOC = "SMTP port open on confluent.controlcenter.mail.host.name";
    public static final String CONTROL_CENTER_WEBHOOK_ENABLE = "confluent.controlcenter.webhook.enabled";
    public static final boolean DEFAULT_CONTROL_CENTER_WEBHOOK_ENABLE = true;
    protected static final String CONTROL_CENTER_WEBHOOK_ENABLE_DOC = "Enable webhook alerts. If this setting is false you will not be able to add webhook alert actions in the web user interface.";
    public static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_AUTOCREATE = "confluent.controlcenter.alert.cluster.down.autocreate";
    public static final boolean DEFAULT_CONTROL_CENTER_ALERT_CLUSTER_DOWN_AUTOCREATE = false;
    protected static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_AUTOCREATE_DOC = "Auto create trigger and email action for Control Center's cluster down alerts";
    public static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_EMAIL = "confluent.controlcenter.alert.cluster.down.to.email";
    protected static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_EMAIL_DOC = "The email address to send alerts to when Control Center's cluster is down";
    public static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_WEBHOOKURL_SLACK = "confluent.controlcenter.alert.cluster.down.to.webhookurl.slack";
    protected static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_WEBHOOKURL_SLACK_DOC = "The slack webhook url to post alerts to when Control Center's cluster is down";
    public static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_PAGERDUTY_INTEGRATION_KEY = "confluent.controlcenter.alert.cluster.down.to.pagerduty.integrationkey";
    protected static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_PAGERDUTY_INTEGRATION_KEY_DOC = "The pagerduty integration key to post alerts to certain service when Control Center's cluster is down";
    public static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE = "confluent.controlcenter.alert.cluster.down.send.rate";
    public static final Integer DEFAULT_CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE = 12;
    protected static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE_DOC = "Send rate per hour of cluster down email alerts";
    public static final String CONTROL_CENTER_EMAIL_FROM = "confluent.controlcenter.mail.from";
    public static final String DEFAULT_CONTROL_CENTER_EMAIL_FROM = "c3@confluent.io";
    protected static final String CONTROL_CENTER_EMAIL_FROM_DOC = "The 'from' address for emails sent from Control Center.";
    public static final String CONTROL_CENTER_EMAIL_BOUNCE_ADDRESS = "confluent.controlcenter.mail.bounce.address";
    protected static final String CONTROL_CENTER_EMAIL_BOUNCE_ADDRESS_DOC = "Override for confluent.controlcenter.mail.from config to send message bounce notifications.";
    public static final String CONTROL_CENTER_EMAIL_SSL_PORT = "confluent.controlcenter.mail.ssl.port";
    public static final String CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY = "confluent.controlcenter.mail.ssl.checkserveridentity";
    public static final Integer DEFAULT_CONTROL_CENTER_EMAIL_SSL_PORT = 465;
    protected static final String CONTROL_CENTER_EMAIL_SSL_PORT_DOC = "SSL-specific SMTP port open on confluent.controlcenter.mail.host.name. Setting confluent.controlcenter.mail.ssl.checkserveridentity will force the use of this port and not confluent.controlcenter.mail.port.";
    public static final Boolean DEFAULT_CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY = false;
    protected static final String CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY_DOC = "Forces the use of SSL as well as validation of server's certificate. Enabling this flag will also cause us to use the port set by confluent.controlcenter.mail.ssl.port not confluent.controlcenter.mail.port.";
    public static final String CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED = "confluent.controlcenter.mail.starttls.required";
    public static final Boolean DEFAULT_CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED = false;
    protected static final String CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED_DOC = "Forces using STARTTLS.";
    public static final String CONTROL_CENTER_EMAIL_USERNAME = "confluent.controlcenter.mail.username";
    public static final String DEFAULT_CONTROL_CENTER_EMAIL_USERNAME = "";
    protected static final String CONTROL_CENTER_EMAIL_USERNAME_DOC = "Username for username/password authentication. Authentication with your SMTP server will only be performed if this value is set.";
    public static final String CONTROL_CENTER_EMAIL_PASSWORD = "confluent.controlcenter.mail.password";
    public static final String DEFAULT_CONTROL_CENTER_EMAIL_PASSWORD = "";
    protected static final String CONTROL_CENTER_EMAIL_PASSWORD_DOC = "Password for username/password authentication.";
    public static final String CONTROL_CENTER_DISK_USAGE_SKEW_WARNING_MIN_BYTES_CONFIG = "confluent.controlcenter.disk.skew.warning.min.bytes";
    public static final long DEFAULT_CONTROL_CENTER_DISK_USAGE_SKEW_WARNING_MIN_BYTES = 0x40000000L;
    protected static final String CONTROL_CENTER_DISK_USAGE_SKEW_WARNING_MIN_BYTES_DOC = "Minimum bytes of disk usage skew across all brokers before warning";
    public static final String CONTROL_CENTER_MAX_TRIGGER_EVENTS_PER_ALERT_CONFIG = "confluent.controlcenter.alert.max.trigger.events";
    public static final int DEFAULT_CONTROL_CENTER_MAX_TRIGGER_EVENTS_PER_ALERT_CONFIG = 1000;
    protected static final String CONTROL_CENTER_MAX_TRIGGER_EVENTS_PER_ALERT_DOC = "The maximum number of trigger events in one alert";
    public static final String CONTROL_CENTER_COMMAND_TOPIC = "confluent.controlcenter.command.topic";
    public static final String DEFAULT_CONTROL_CENTER_COMMAND_TOPIC = "_confluent-command";
    protected static final String CONTROL_CENTER_COMMAND_TOPIC_DOC = "Topic used for CP configuration";
    public static final String CONTROL_CENTER_COMMAND_TOPIC_REPLICATION_CONFIG = "confluent.controlcenter.command.topic.replication";
    public static final String CONTROL_CENTER_RESPECT_MRC_CONFIG = "confluent.controlcenter.mrc.respect";
    public static final Boolean DEFAULT_CONTROL_CENTER_RESPECT_MRC_CONFIG = true;
    protected static final String CONTROL_CENTER_RESPECT_MRC_CONFIG_DOC = "Should Control Center Respect Log.Placement.Constraints given in MRC Kafka Cluster";
    public static final short DEFAULT_CONTROL_CENTER_COMMAND_TOPIC_REPLICATION = 3;
    protected static final String CONTROL_CENTER_COMMAND_TOPIC_REPLICATION_DOC = "Replication factor for command topic. It is not recommended to reduce this value except in a development environment.";
    public static final String CONTROL_CENTER_COMMAND_TOPIC_RETENTION_MS_CONFIG = "confluent.controlcenter.command.topic.retention.ms";
    public static final int DEFAULT_CONTROL_CENTER_COMMAND_TOPIC_RETENTION_MS = 86400000;
    protected static final String CONTROL_CENTER_COMMAND_TOPIC_RETENTION_MS_DOC = "Retention ms for command topic tombstone entries";
    public static final String CONTROL_CENTER_COMMAND_TOPIC_SEGMENT_BYTES_CONFIG = "confluent.controlcenter.command.topic.segment.bytes";
    public static final int DEFAULT_CONTROL_CENTER_COMMAND_TOPIC_SEGMENT_BYTES = 0x40000000;
    protected static final String CONTROL_CENTER_COMMAND_TOPIC_SEGMENT_BYTES_DOC = "The segment file size for the log for command topic.";
    public static final String CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT = "confluent.controlcenter.command.streams.start.timeout";
    public static final long DEFAULT_CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    protected static final String CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT_DOC = "Timeout when starting command streams in ms";
    public static final String RESTRICTED_ROLES_CONFIG = "confluent.controlcenter.auth.restricted.roles";
    public static final String PHONEHOME_ENABLED = "confluent.support.metrics.enable";
    public static final String PHONEHOME_CUSTOMER_ID = "confluent.support.metrics.customer.id";
    public static final String PHONEHOME_SEGMENT_ID = "confluent.support.metrics.segment.id";
    public static final String PHONEHOME_SEGMENT_ENDPOINT = "confluent.support.metrics.segment.endpoint";
    public static final String CONTROL_CENTER_CONSUMER_METADATA_TIMEOUT = "confluent.controlcenter.consumer.metadata.timeout.ms";
    public static final int DEFAULT_CONTROL_CENTER_CONSUMER_METADATA_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(15L);
    protected static final String CONTROL_CENTER_CONSUMER_METADATA_TIMEOUT_DOC = "Timeout for consumer group metadata requests when listing consumer group information in ms";
    public static final String CONTROL_CENTER_LAST_PRODUCE_TIME_CONSUMER_NAME = "_confluent-controlcenter-" + CONTROL_CENTER_VERSION + "-lastProduceTimeConsumer";
    private static final ConfigDef config;
    public static final String ZOOKEEPER_CONNECT_CONFIG = "zookeeper.connect";
    private static final String ZOOKEEPER_CONNECT_DOC = "Specifies the ZooKeeper connection string in the form ``hostname:port`` where host and port are the host and port of a ZooKeeper server. To allow connecting through other ZooKeeper nodes when that ZooKeeper machine is down you can also specify multiple hosts in the form ``hostname1:port1,hostname2:port2,hostname3:port3``.\n\nThe server may also have a ZooKeeper chroot path as part of it's ZooKeeper connection string which puts its data under some path in the global ZooKeeper namespace. If so the consumer should use the same chroot path in its connection string. For example to give a chroot path of /chroot/path you would give the connection string as ``hostname1:port1,hostname2:port2,hostname3:port3/chroot/path``.";
    public static final String ZOOKEEPER_CONNECT_DEFAULT = "localhost:2181";
    public static final String CONFLUENT_CONTROLCENTER_SCHEMA_REGISTRY_PREFIX = "confluent.controlcenter.schema.registry.";
    public static final String CONFLUENT_CONTROLCENTER_SCHEMA_REGISTRY_SSL_ALIAS_NAME = "confluent.controlcenter.schema.registry.schema.registry.alias.name";
    public static final String CONFLUENT_CONTROLCENTER_CONNECT_SSL_ALIAS_NAME = "confluent.controlcenter.connect.connect.alias.name";
    public static final String SCHEMA_REGISTRY_ENDPOINT_CONFIG = "confluent.controlcenter.schema.registry.url";
    public static final String KAFKA_REST_ENDPOINT_CONFIG = "cprest.url";
    public static final String CONFLUENT_METADATA_URLS_CONFIG = "confluent.metadata.bootstrap.server.urls";
    public static final String CONFLUENT_METADATA_URLS_CONFIG_DOC = "A list of valid URLs that specify where the RBAC metadata servers can be reached. This config is required to run inside a RBAC environment.";
    public static final String TOPIC_INSPECTION_ENABLED = "confluent.controlcenter.topic.inspection.enable";
    public static final String TOPIC_INSPECTION_MAX_MESSAGE_BYTES = "confluent.controlcenter.topic.inspection.message.max.bytes";
    public static final String KSQL_ENABLED = "confluent.controlcenter.ksql.enable";
    public static final String SCHEMA_REGISTRY_ENABLED = "confluent.controlcenter.schema.registry.enable";
    public static final String DEFAULT_SCHEMA_REGISTRY_DISABLED = "confluent.controlcenter.default.schema.registry.disable";
    protected static final String DEFAULT_SCHEMA_REGISTRY_DISABLED_DOC = "Disable the default schema registry for the control center.";
    public static final String USAGE_DATA_COLLECTION = "confluent.controlcenter.usage.data.collection.enable";
    public static final String BROKER_CONFIGS_EDIT_ENABLED = "confluent.controlcenter.broker.config.edit.enable";
    public static final String CONSUMERS_VIEW_ENABLED = "confluent.controlcenter.consumers.view.enable";
    public static final String DEPRECATED_VIEWS_ENABLED = "confluent.controlcenter.deprecated.views.enable";
    public static final String DATA_EXPIRED_THRESHOLD = "confluent.controlcenter.ui.data.expired.threshold";
    public static final String PROXY_REQUEST_BUFFER_SIZE = "confluent.controlcenter.request.buffer.size.bytes";
    public static final int DEFAULT_PROXY_REQUEST_BUFFER_SIZE = 10000;
    public static final String CONTROL_CENTER_LICENSE_MANAGER_CONFIG = "confluent.controlcenter.license.manager";
    public static final String UI_AUTOUPDATE_ENABLED = "confluent.controlcenter.ui.autoupdate.enable";
    public static final String DEFAULT_CONTROL_CENTER_LICENSE_MANAGER;
    protected static final String CONTROL_CENTER_LICENSE_MANAGER_DOC = "Control Center License Manager. Client id for Command topic configuration.";
    public static final String LICENSE_MANAGER_ENABLED = "confluent.controlcenter.license.manager.enable";
    protected static final String LICENSE_MANAGER_ENABLED_DOC = "Enable License Manager. (By disabling license manager, you have no access to license editor, notification and license string in rest endpoint.)";
    public static final Boolean DEFAULT_LICENSE_MANAGER_ENABLED;
    public static final String PROACTIVE_SUPPORT_PREFIX = "confluent.controlcenter.proactive.support.";
    public static final String PROACTIVE_SUPPORT_UI_CTA_ENABLED = "confluent.controlcenter.proactive.support.ui.cta.enable";
    public static final String REPLICATOR_MONITORING_ENABLED = "confluent.controlcenter.ui.replicator.monitoring.enable";
    public static final String SBK_PREFIX = "confluent.controlcenter.sbk.";
    public static final String SBK_UI_ENABLED = "confluent.controlcenter.sbk.ui.enable";
    public static final String HOSTED_MONITORING_PREFIX = "confluent.controlcenter.hostedmonitoring.";
    public static final String HOSTED_MONITORING_ENABLED = "confluent.controlcenter.hostedmonitoring.enable";
    public static final String CONTROL_CENTER_SERVICE_HEALTHCHECK_INTERVAL_SEC = "confluent.controlcenter.service.healthcheck.interval.sec";
    public static final int DEFAULT_CONTROL_CENTER_SERVICE_HEALTHCHECK_INTERVAL_SEC = 20;
    protected static final String CONTROL_CENTER_SERVICE_HEALTHCHECK_INTERVAL_DOC = "The interval (in seconds) used for health-checking KSQL/Connect/SchemaRegistry/MetadataService nodes.";
    public static final String CONTROLLER_CHART_UI_ENABLED = "confluent.controlcenter.ui.controller.chart.enable";
    public static final String ACTIVE_CONTROLLER_COUNT_TRIGGER_ENABLED = "confluent.controlcenter.trigger.active-controller-count.enable";
    public static final String CONFLUENT_CLUSTER_REGISTRY_ENABLED = "confluent.metadata.cluster.registry.enable";
    public static final boolean DEFAULT_CONFLUENT_CLUSTER_REGISTRY_ENABLED = false;
    protected static final String CONFLUENT_CLUSTER_REGISTRY_ENABLED_DOC = "True if Cluster Registry is enabled. When enabled, cluster information will be read from Cluster Registry.";
    public static final String CONFLUENT_CLUSTER_REGISTRY_MERGE_CONFIGS_ENABLED = "confluent.metadata.cluster.registry.merge.configuration.enable";
    public static final boolean DEFAULT_CONFLUENT_CLUSTER_REGISTRY_MERGE_CONFIGS_ENABLED = true;
    protected static final String CONFLUENT_CLUSTER_REGISTRY_MERGE_CONFIGS_ENABLED_DOC = "When enabled the configuration information for various clusters - kafka, ksql, connect -in properties file is merged with the one from Cluster Registry. This is so that userscan configure additional properties that cannot be added to Cluster Registry. Example -\tconfluent.controlcenter.kafka.<name>.ssl.keystore.location\n\tconfluent.controlcenter.kafka.<name>.ssl.keystore.password";
    public static final String PURGE_STALE_CLUSTERS_ENABLED = "confluent.controlcenter.purge.stale.cluster.enable";
    public static final boolean DEFAULT_PURGE_STALE_CLUSTERS_ENABLED = false;
    protected static final String PURGE_STALE_CLUSTERS_ENABLED_DOC = "When enabled, control-center will purge stale cluster information from command store";
    public static final String CONTROL_CENTER_REST_CSRF_ENABLED = "confluent.controlcenter.rest.csrf.prevention.enable";
    public static final boolean DEFAULT_CONTROL_CENTER_REST_CSRF_ENABLED = false;
    protected static final String CONTROL_CENTER_REST_CSRF_ENABLED_DOC = "Enables token based CSRF protection";
    public static final String CONTROL_CENTER_REST_CSRF_TOKEN_EXPIRATION_MINUTES = "confluent.controlcenter.rest.csrf.prevention.token.expiration.minutes";
    public static final int DEFAULT_CONTROL_CENTER_REST_CSRF_TOKEN_EXPIRATION_MINUTES = 30;
    protected static final String CONTROL_CENTER_REST_CSRF_TOKEN_EXPIRATION_MINUTES_DOC = "CSRF Token expiration period in minutes";
    public static final String CONTROL_CENTER_REST_CSRF_TOKEN_FETCH_ENDPOINT = "confluent.controlcenter.rest.csrf.prevention.token.endpoint";
    public static final String DEFAULT_CONTROL_CENTER_REST_CSRF_TOKEN_FETCH_ENDPOINT = "/csrf";
    protected static final String CONTROL_CENTER_REST_CSRF_TOKEN_FETCH_ENDPOINT_DOC = "Endpoint to fetch the CSRF token. Token will be set in the Response header";
    public static final String CONTROL_CENTER_EMBEDDED_KAFKA_REST_ENABLED = "confluent.controlcenter.embedded.kafkarest.enable";
    public static final boolean DEFAULT_CONTROL_CENTER_EMBEDDED_KAFKA_REST_ENABLED = true;
    protected static final String CONTROL_CENTER_EMBEDDED_KAFKA_REST_ENABLED_DOC = "Enables rest-proxy. Similar to Kafka brokers, the embedded rest-proxy is run within the context of C3 runtime";
    public static final String UI_BROKER_KAFKA_REST_ENABLED = "confluent.controlcenter.ui.broker.kafkarest.enable";
    public static final boolean DEFAULT_UI_BROKER_KAFKA_REST_ENABLED = false;
    protected static final String UI_BROKER_KAFKA_REST_ENABLED_DOC = "Enables broker features (excluding broker settings) to use embedded kafka rest-proxy";
    public static final String UI_BROKER_SETTINGS_KAFKA_REST_ENABLED = "confluent.controlcenter.ui.brokersettings.kafkarest.enable";
    public static final boolean DEFAULT_UI_BROKER_SETTINGS_KAFKA_REST_ENABLED = true;
    protected static final String UI_BROKER_SETTINGS_KAFKA_REST_ENABLED_DOC = "Enables broker settings feature to use embedded kafka rest-proxy";
    public static final String UI_TOPIC_KAFKA_REST_ENABLED = "confluent.controlcenter.ui.topic.kafkarest.enable";
    public static final boolean DEFAULT_UI_TOPIC_KAFKA_REST_ENABLED = false;
    protected static final String UI_TOPIC_KAFKA_REST_ENABLED_DOC = "Enables topic features to use embedded kafka rest-proxy";
    public static final String UI_ACL_KAFKA_REST_ENABLED = "confluent.controlcenter.ui.acl.kafkarest.enable";
    public static final boolean DEFAULT_UI_ACL_KAFKA_REST_ENABLED = false;
    protected static final String UI_ACL_KAFKA_REST_ENABLED_DOC = "Enables acl features to use embedded kafka rest-proxy";
    public static final String UI_CONSUMER_GROUP_KAFKA_REST_ENABLED = "confluent.controlcenter.ui.consumer.group.kafkarest.enable";
    public static final boolean DEFAULT_UI_CONSUMER_GROUP_KAFKA_REST_ENABLED = false;
    protected static final String UI_CONSUMER_GROUP_KAFKA_REST_ENABLED_DOC = "Enables consumer group features to use embedded kafka rest-proxy";
    public static final String UI_BASEPATH = "confluent.controlcenter.ui.basepath";
    protected static final String UI_BASEPATH_DOC = "Specifies the base URL to use for all relative URLs in the HTML document";
    public static final String UI_EXTERNAL_JS_FILES = "confluent.controlcenter.ui.external.js.files";
    protected static final String UI_EXTERNAL_JS_FILES_DOC = "Specifies a comma separated list of external JavaScript files to add in the HTML document";
    public static final String UI_EXTERNAL_CSS_FILES = "confluent.controlcenter.ui.external.css.files";
    protected static final String UI_EXTERNAL_CSS_FILES_DOC = "Specifies a comma separated list of external CSS files to add in the HTML document";
    public static final String CONTROL_CENTER_MDS_CLIENT_IDLE_TIMEOUT = "confluent.controlcenter.mds.client.idle.timeout";
    protected static final String CONTROL_CENTER_MDS_CLIENT_IDLE_TIMEOUT_DOC = "MDS client's idle timeout. Default value is the Jetty HttpClient's idle timeout, 30 seconds. See https://www.eclipse.org/jetty/javadoc/jetty-9/org/eclipse/jetty/client/HttpClient.html#getIdleTimeout().";
    public static final String CONTROL_CENTER_MDS_CLIENT_MAX_REQUESTS_QUEUED_PER_DESTINATION = "confluent.controlcenter.mds.client.max.requests.queued.per.destination";
    protected static final String CONTROL_CENTER_MDS_CLIENT_MAX_REQUESTS_QUEUED_PER_DESTINATION_DOC = "MDS client's request queue size. Default value is the Jetty HttpClient's queue size, 1024. See https://www.eclipse.org/jetty/javadoc/jetty-9/org/eclipse/jetty/client/HttpClient.html#getMaxRequestsQueuedPerDestination().";
    public static final String CONTROL_CENTER_INSTALLER_IDENTIFIER = "confluent.controlcenter.private.installer.id";
    protected static final String CONTROL_CENTER_INSTALLER_IDENTIFIER_DOC = "Identifies the framework used to install Control Center";
    public static final String CONTROL_CENTER_REST_NOSNIFF_PROTECTION_ENABLED = "confluent.controlcenter.rest.nosniff.prevention.enable";
    public static final boolean DEFAULT_CONTROL_CENTER_REST_NOSNIFF_PROTECTION_ENABLED = true;
    protected static final String CONTROL_CENTER_REST_NOSNIFF_PROTECTION_ENABLED_DOC = "Enable response to request be blocked due to nosniff. The header allows you to avoid MIME type sniffing by saying that the MIME types are deliberately configured.";
    public static final String CONTROL_CENTER_THREE_HOUR_ROLL_UP_RETENTION_MS = "confluent.controlcenter.three.hour.rollup.topics.retention.ms";
    public static final Long DEFAULT_CONTROL_CENTER_THREE_HOUR_ROLL_UP_RETENTION_MS;
    public static final String CONTROL_CENTER_THREE_HOUR_ROLL_UP_RETENTION_MS_DOC = "Retention ms for the topics that have rollup of type three hour";
    public static final String CONTROL_CENTER_ONE_MINUTE_ROLL_UP_RETENTION_MS = "confluent.controlcenter.one.minute.rollup.topics.retention.ms";
    public static final Long DEFAULT_CONTROL_CENTER_ONE_MINUTE_ROLL_UP_RETENTION_MS;
    public static final String CONTROL_CENTER_ONE_MINUTE_ROLL_UP_RETENTION_MS_DOC = "Retention ms for the topics that have rollup of type one minute";
    public static final String CONTROL_CENTER_SSO_MODE = "confluent.controlcenter.auth.sso.mode";
    public static final String DEFAULT_CONTROL_CENTER_SSO_MODE = "none";
    protected static final String CONTROL_CENTER_SSO_MODE_DOC = "Enable SSO login to C3 using the configured identity provider (IdP). The supported mode must be enabled in MDS e.g. when it's set to OIDC, OIDC must be enabled in metadata-server as a prerequisite.";

    public ControlCenterConfig(String propsFile) {
        this(ConfigUtils.getPropsFromFile(propsFile));
    }

    public ControlCenterConfig(Properties props) {
        super(config, (Map)props);
    }

    public ControlCenterConfig() {
        this(new Properties());
    }

    public static void main(String[] args) {
        System.out.println(config.toRst());
    }

    public Map<String, Object> originalsWithPrefix(String prefix) {
        return this.withPrefix(prefix, this.originals());
    }

    public Map<String, Object> valuesWithPrefix(String prefix) {
        return this.withPrefix(prefix, this.values());
    }

    protected Map<String, Object> withPrefix(String prefix, Map<String, ?> map) {
        HashMap result = Maps.newHashMap();
        for (String key : map.keySet()) {
            if (!key.startsWith(prefix) || key.length() <= prefix.length()) continue;
            result.put(key.substring(prefix.length()), map.get(key));
        }
        return result;
    }

    static {
        DEFAULT_CONTROL_CENTER_LICENSE_MANAGER = "_confluent-controlcenter-license-manager-" + CONTROL_CENTER_VERSION;
        DEFAULT_LICENSE_MANAGER_ENABLED = true;
        DEFAULT_CONTROL_CENTER_THREE_HOUR_ROLL_UP_RETENTION_MS = TimeUnit.DAYS.toMillis(701L);
        DEFAULT_CONTROL_CENTER_ONE_MINUTE_ROLL_UP_RETENTION_MS = TimeUnit.DAYS.toMillis(5L);
        config = new ConfigDef().define(CONTROL_CENTER_NAME_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_NAME, ConfigDef.Importance.HIGH, CONTROL_CENTER_NAME_DOC).define(CONTROL_CENTER_ID_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_ID, ConfigDef.Importance.HIGH, CONTROL_CENTER_ID_DOC).define(CONTROL_CENTER_MODE_ENABLED, ConfigDef.Type.STRING, (Object)"all", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"all", CONTROL_CENTER_MODE_MANAGEMENT}), ConfigDef.Importance.HIGH, CONTROL_CENTER_MODE_ENABLED_DOC).define(CONTROL_CENTER_PARALLELISM, ConfigDef.Type.INT, (Object)DEFAULT_CONTROL_CENTER_PARALLELISM, ConfigDef.Importance.HIGH, CONTROL_CENTER_PARALLELISM_DOC).define(CONTROL_CENTER_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_TOPIC, ConfigDef.Importance.HIGH, CONTROL_CENTER_TOPIC_DOC).define(CONTROL_CENTER_METRICS_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_METRICS_TOPIC, ConfigDef.Importance.HIGH, CONTROL_CENTER_METRICS_TOPIC_DOC).define(CONTROL_CENTER_METRICS_BROKER_COUNT_STALENESS_THRESHOLD_MS, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_METRICS_BROKER_COUNT_STALENESS_THRESHOLD_MS, (ConfigDef.Validator)new WarningValidator((ConfigDef.Validator)ConfigDef.Range.atLeast((Number)TimeUnit.SECONDS.toMillis(120L)), log), ConfigDef.Importance.HIGH, CONTROL_CENTER_METRICS_BROKER_COUNT_STALENESS_THRESHOLD_MS_DOC).define(CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT, ConfigDef.Importance.HIGH, CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT_DOC).define(ZOOKEEPER_CONNECT_CONFIG, ConfigDef.Type.STRING, (Object)ZOOKEEPER_CONNECT_DEFAULT, ConfigDef.Importance.HIGH, ZOOKEEPER_CONNECT_DOC).define(CONTROL_CENTER_LICENSE_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, CONTROL_CENTER_LICENSE_DOC).define(CONTROL_CENTER_BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, (Object)DEFAULT_CONTROL_CENTER_BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Importance.HIGH, CONTROL_CENTER_BOOTSTRAP_SERVERS_DOC).define(CONTROL_CENTER_DATA_DIR, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_DATA_DIR, (ConfigDef.Validator)new WarningValidator((ConfigDef.Validator)new StringNotPrefixValidator("/tmp", "Running with data in /tmp is not suggested."), log), ConfigDef.Importance.HIGH, CONTROL_CENTER_DATA_DIR_DOC).define(CONTROL_CENTER_INTERNAL_REPLICATION_CONFIG, ConfigDef.Type.SHORT, (Object)3, (ConfigDef.Validator)new WarningValidator((ConfigDef.Validator)ConfigDef.Range.atLeast((Number)3), log), ConfigDef.Importance.LOW, CONTROL_CENTER_INTERNAL_REPLICATION_DOC).define(CONTROL_CENTER_INTERNAL_PARTITIONS_CONFIG, ConfigDef.Type.INT, (Object)12, ConfigDef.Importance.LOW, CONTROL_CENTER_INTERNAL_PARTITIONS_DOC).define(CONTROL_CENTER_INTERNAL_RETENTION_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_INTERNAL_RETENTION_MS, ConfigDef.Importance.LOW, CONTROL_CENTER_INTERNAL_RETENTION_MS_DOC).define(CONTROL_CENTER_INTERNAL_CHANGELOG_SEGMENT_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)0x8000000, ConfigDef.Importance.LOW, CONTROL_CENTER_INTERNAL_CHANGELOG_SEGMENT_BYTES_DOC).define(CONTROL_CENTER_INTERNAL_RETENTION_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)-1, ConfigDef.Importance.LOW, CONTROL_CENTER_INTERNAL_RETENTION_BYTES_DOC).define(CONTROL_CENTER_MONITORING_TOPIC_PARTITIONS_CONFIG, ConfigDef.Type.INT, (Object)12, ConfigDef.Importance.LOW, CONTROL_CENTER_MONITORING_TOPIC_PARTITIONS_DOC).define(CONTROL_CENTER_MONITORING_TOPIC_REPLICATION_CONFIG, ConfigDef.Type.SHORT, (Object)3, ConfigDef.Importance.LOW, CONTROL_CENTER_MONITORING_TOPIC_REPLICATION_DOC).define(CONTROL_CENTER_MONITORING_TOPIC_RETENTION_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_INPUT_TOPIC_RETENTION_MS, ConfigDef.Importance.LOW, CONTROL_CENTER_MONITORING_TOPIC_RETENTION_MS_DOC).define(CONTROL_CENTER_MONITORING_TOPIC_RETENTION_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)-1, ConfigDef.Importance.LOW, CONTROL_CENTER_MONITORING_TOPIC_RETENTION_BYTES_DOC).define(CONTROL_CENTER_MONITORING_TOPIC_SKIP_BACKLOG_MIN_CONFIG, ConfigDef.Type.LONG, (Object)15L, ConfigDef.Importance.LOW, "Start processing backlog from minutes ago and skip older data").define(CONTROL_CENTER_MONITORING_TOPIC_VALIDATE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONTROL_CENTER_MONITORING_TOPIC_VALIDATE_DOC).define(CONTROL_CENTER_METRICS_TOPIC_PARTITIONS_CONFIG, ConfigDef.Type.INT, (Object)12, ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_PARTITIONS_DOC).define(CONTROL_CENTER_METRICS_TOPIC_REPLICATION_CONFIG, ConfigDef.Type.SHORT, (Object)3, ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_REPLICATION_DOC).define(CONTROL_CENTER_METRICS_TOPIC_RETENTION_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_INPUT_TOPIC_RETENTION_MS, ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_RETENTION_MS_DOC).define(CONTROL_CENTER_METRICS_TOPIC_RETENTION_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)-1, ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_RETENTION_BYTES_DOC).define(CONTROL_CENTER_METRICS_STORE_RETENTION_DAYS_CONFIG, ConfigDef.Type.INT, (Object)7, ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_STORE_RETENTION_DAYS_DOC).define(CONTROL_CENTER_METRICS_TOPIC_MAX_MESSAGE_BYTES_CONFIG, ConfigDef.Type.INT, (Object)0xA00000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_MAX_MESSAGE_BYTES_DOC).define(CONTROL_CENTER_METRICS_TOPIC_SKIP_BACKLOG_MIN_CONFIG, ConfigDef.Type.LONG, (Object)15L, ConfigDef.Importance.LOW, "Start processing backlog from minutes ago and skip older data").define(CONTROL_CENTER_METRICS_TOPIC_VALIDATE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_VALIDATE_DOC).define(CONTROL_CENTER_SESSION_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)60000, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_SESSION_TIMEOUT_MS_DOC).define(CONTROL_CENTER_CACHE_MAX_BYTES_BUFFERING_CONFIG, ConfigDef.Type.LONG, (Object)0x40000000L, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_CACHE_MAX_BYTES_BUFFERING_CONFIG_DOC).define(CONTROL_CENTER_STREAMS_UPGRADE_FROM_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_STREAMS_UPGRADE_FROM, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_STREAMS_UPGRADE_FROM_CONFIG_DOC).define(CONTROL_CENTER_STREAMS_TASK_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_TASK_TIMEOUT_MS_DOC).define(CONTROL_CENTER_PRODUCER_RETRIES_CONFIG, ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_PRODUCER_RETRIES_DOC).define(CONTROL_CENTER_PRODUCER_RETRY_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, (Object)100L, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_PRODUCER_RETRY_BACKOFF_MS_DOC).define(CONTROL_CENTER_COMPRESSION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_COMPRESSION_TYPE_CONFIG, ConfigDef.Importance.LOW, CONTROL_CENTER_COMPRESSION_TYPE_DOC).define(CONTROL_CENTER_PRODUCER_LINGER_MS, ConfigDef.Type.INT, (Object)500, ConfigDef.Importance.LOW, CONTROL_CENTER_PRODUCER_LINGER_MS_DOC).define(CONTROL_CENTER_PRODUCER_MAX_BLOCK_MS, ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, ConfigDef.Importance.LOW, CONTROL_CENTER_PRODUCER_MAX_BLOCK_MS_DOC).define(CONTROL_CENTER_PRODUCER_DELIVERY_TIMEOUT_MS, ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.LOW, CONTROL_CENTER_PRODUCER_DELIVERY_TIMEOUT_MS_DOC).define(CONTROL_CENTER_REST_RESPONSE_HEADERS, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_REST_RESPONSE_HEADERS_DOC).define(CONTROL_CENTER_REST_PORT, ConfigDef.Type.INT, (Object)DEFAULT_CONTROL_CENTER_REST_PORT, ConfigDef.Importance.LOW, CONTROL_CENTER_REST_PORT_DOC).define(CONTROL_CENTER_REST_COMPRESSION, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_CONTROL_CENTER_REST_COMPRESSION, ConfigDef.Importance.LOW, CONTROL_CENTER_REST_COMPRESSION_DOC).define(CONTROL_CENTER_USE_DEFAULT_JVM_TRUSTSTORE, ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.LOW, CONTROL_CENTER_USE_DEFAULT_JVM_TRUSTSTORE_DOC).define(CONTROL_CENTER_USE_DEFAULT_OS_TRUSTSTORE, ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.LOW, CONTROL_CENTER_USE_DEFAULT_OS_TRUSTSTORE_DOC).define(CONFLUENT_METADATA_BASIC_AUTH_USER_INFO, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.LOW, CONFLUENT_METADATA_BASIC_AUTH_USER_INFO_DOC).define(CONTROL_CENTER_HSTS_ENABLE, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, CONTROL_CENTER_HSTS_ENABLE_DOC).define(CONTROL_CENTER_DISPLAY_HOST_PREFIX, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_DISPLAY_HOST_PREFIX_DOC).define(CONTROL_CENTER_EMAIL_ENABLE, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_ENABLE_DOC).define(CONTROL_CENTER_EMAIL_HOST_NAME, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_EMAIL_HOST_NAME, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_HOST_NAME_DOC).define(CONTROL_CENTER_EMAIL_PORT, ConfigDef.Type.INT, (Object)DEFAULT_CONTROL_CENTER_EMAIL_PORT, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_PORT_DOC).define(CONTROL_CENTER_EMAIL_SSL_PORT, ConfigDef.Type.INT, (Object)DEFAULT_CONTROL_CENTER_EMAIL_SSL_PORT, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_SSL_PORT_DOC).define(CONTROL_CENTER_EMAIL_FROM, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_EMAIL_FROM, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_FROM_DOC).define(CONTROL_CENTER_WEBHOOK_ENABLE, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, CONTROL_CENTER_WEBHOOK_ENABLE_DOC).define(CONTROL_CENTER_ALERT_CLUSTER_DOWN_AUTOCREATE, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONTROL_CENTER_ALERT_CLUSTER_DOWN_AUTOCREATE_DOC).define(CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_EMAIL, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_EMAIL_DOC).define(CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_WEBHOOKURL_SLACK, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_WEBHOOKURL_SLACK_DOC).define(CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_PAGERDUTY_INTEGRATION_KEY, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_PAGERDUTY_INTEGRATION_KEY_DOC).define(CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE, ConfigDef.Type.INT, (Object)DEFAULT_CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE, ConfigDef.Importance.LOW, CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE_DOC).define(CONTROL_CENTER_EMAIL_BOUNCE_ADDRESS, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_BOUNCE_ADDRESS_DOC).define(CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY_DOC).define(CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED_DOC).define(CONTROL_CENTER_EMAIL_USERNAME, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_USERNAME_DOC).define(CONTROL_CENTER_EMAIL_PASSWORD, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_PASSWORD_DOC).define(CONTROL_CENTER_DISK_USAGE_SKEW_WARNING_MIN_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)0x40000000L, ConfigDef.Importance.LOW, CONTROL_CENTER_DISK_USAGE_SKEW_WARNING_MIN_BYTES_DOC).define(CONTROL_CENTER_MAX_TRIGGER_EVENTS_PER_ALERT_CONFIG, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, CONTROL_CENTER_MAX_TRIGGER_EVENTS_PER_ALERT_DOC).define(CONTROL_CENTER_COMMAND_TOPIC, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_COMMAND_TOPIC, ConfigDef.Importance.LOW, CONTROL_CENTER_COMMAND_TOPIC_DOC).define(CONTROL_CENTER_COMMAND_TOPIC_REPLICATION_CONFIG, ConfigDef.Type.SHORT, (Object)3, ConfigDef.Importance.LOW, CONTROL_CENTER_COMMAND_TOPIC_REPLICATION_DOC).define(CONTROL_CENTER_COMMAND_TOPIC_RETENTION_MS_CONFIG, ConfigDef.Type.LONG, (Object)86400000, ConfigDef.Importance.LOW, CONTROL_CENTER_COMMAND_TOPIC_RETENTION_MS_DOC).define(CONTROL_CENTER_COMMAND_TOPIC_SEGMENT_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)0x40000000, ConfigDef.Importance.LOW, CONTROL_CENTER_COMMAND_TOPIC_SEGMENT_BYTES_DOC).define(CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT, ConfigDef.Importance.LOW, CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT_DOC).define(CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS, ConfigDef.Importance.LOW, CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS_DOC).define(CONTROL_CENTER_AUTH_BEARER_ISSUER, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_AUTH_BEARER_ISSUER, ConfigDef.Importance.LOW, CONTROL_CENTER_AUTH_BEARER_ISSUER_DOC).define(CONTROL_CENTER_AUTH_BEARER_TOKEN_MAX_LIFE, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_AUTH_BEARER_TOKEN_MAX_LIFE, ConfigDef.Importance.LOW, CONTROL_CENTER_AUTH_BEARER_TOKEN_MAX_LIFE_DOC).define(PUBLIC_KEY_PATH, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, PUBLIC_KEY_PATH_DOC).define(CONTROL_CENTER_AUTH_BEARER_ROLES_CLAIM, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_AUTH_BEARER_ROLES_CLAIM_DOC).define(RESTRICTED_ROLES_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.LOW, "List of roles with limited access. No editing or creating via UI").define(PHONEHOME_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable Confluent metrics collection").define(PHONEHOME_SEGMENT_ID, ConfigDef.Type.STRING, (Object)"MORqDG61F2eE5mfxAXVqpEblmFG18nbv", ConfigDef.Importance.LOW, "Segment ID").define(PHONEHOME_SEGMENT_ENDPOINT, ConfigDef.Type.STRING, (Object)"https://analytics-api.confluent.io", ConfigDef.Importance.LOW, "Segment Endpoint").define(SCHEMA_REGISTRY_ENDPOINT_CONFIG, ConfigDef.Type.LIST, (Object)"http://localhost:8081", ConfigDef.Importance.LOW, "Schema Registry Endpoint").define(CONFLUENT_METADATA_URLS_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, CONFLUENT_METADATA_URLS_CONFIG_DOC).define(TOPIC_INSPECTION_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable Topic Inspection in Control Center").define(TOPIC_INSPECTION_MAX_MESSAGE_BYTES, ConfigDef.Type.LONG, (Object)0x100000L, ConfigDef.Importance.LOW, "Max message size that can be displayed in Control Center").define(KSQL_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable KSQL in Control Center").define(SCHEMA_REGISTRY_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable Schema Registry in Control Center").define(USAGE_DATA_COLLECTION, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable usage data collection in Control Center").define(BROKER_CONFIGS_EDIT_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable Broker config edit").define(LICENSE_MANAGER_ENABLED, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_LICENSE_MANAGER_ENABLED, ConfigDef.Importance.LOW, LICENSE_MANAGER_ENABLED_DOC).define(CONTROL_CENTER_LICENSE_MANAGER_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_LICENSE_MANAGER, ConfigDef.Importance.LOW, CONTROL_CENTER_LICENSE_MANAGER_DOC).define(CONSUMERS_VIEW_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable consumers view in Control Center").define(DEPRECATED_VIEWS_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Enable deprecated Streams Monitoring and System Health views").define(UI_AUTOUPDATE_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable auto updating the Control Center UI.").define(DATA_EXPIRED_THRESHOLD, ConfigDef.Type.INT, (Object)120, ConfigDef.Importance.LOW, "Configure a threshold (in seconds) before data is considered out of date.").define(PROACTIVE_SUPPORT_UI_CTA_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable proactive support CTA in Control Center").define(REPLICATOR_MONITORING_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable Replicator monitoring in Control Center").define(SBK_UI_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable Self-Balancing Kafka features in Control Center").define(HOSTED_MONITORING_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Enable hosted monitoring features in Control Center").define(CONTROL_CENTER_SERVICE_HEALTHCHECK_INTERVAL_SEC, ConfigDef.Type.INT, (Object)20, ConfigDef.Importance.LOW, CONTROL_CENTER_SERVICE_HEALTHCHECK_INTERVAL_DOC).define(CONTROLLER_CHART_UI_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Enable Controller chart view in Control Center").define(CONTROL_CENTER_CONSUMER_METADATA_TIMEOUT, ConfigDef.Type.INT, (Object)DEFAULT_CONTROL_CENTER_CONSUMER_METADATA_TIMEOUT, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_CONSUMER_METADATA_TIMEOUT_DOC).define(ACTIVE_CONTROLLER_COUNT_TRIGGER_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Enable user to create Active-controller-count trigger").define(PROXY_REQUEST_BUFFER_SIZE, ConfigDef.Type.INT, (Object)10000, ConfigDef.Importance.LOW, "Configure size of request buffer for out going call via proxy servlets.").define(CONFLUENT_CLUSTER_REGISTRY_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONFLUENT_CLUSTER_REGISTRY_ENABLED_DOC).define(CONFLUENT_CLUSTER_REGISTRY_MERGE_CONFIGS_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, CONFLUENT_CLUSTER_REGISTRY_MERGE_CONFIGS_ENABLED_DOC).define(PURGE_STALE_CLUSTERS_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, PURGE_STALE_CLUSTERS_ENABLED_DOC).define(CONTROL_CENTER_REST_CSRF_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONTROL_CENTER_REST_CSRF_ENABLED_DOC).define(CONTROL_CENTER_REST_CSRF_TOKEN_EXPIRATION_MINUTES, ConfigDef.Type.INT, (Object)30, ConfigDef.Importance.LOW, CONTROL_CENTER_REST_CSRF_TOKEN_EXPIRATION_MINUTES_DOC).define(CONTROL_CENTER_REST_CSRF_TOKEN_FETCH_ENDPOINT, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_REST_CSRF_TOKEN_FETCH_ENDPOINT, ConfigDef.Importance.LOW, CONTROL_CENTER_REST_CSRF_TOKEN_FETCH_ENDPOINT_DOC).define(CONTROL_CENTER_EMBEDDED_KAFKA_REST_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, CONTROL_CENTER_EMBEDDED_KAFKA_REST_ENABLED_DOC).define(UI_BROKER_KAFKA_REST_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, UI_BROKER_KAFKA_REST_ENABLED_DOC).define(UI_BROKER_SETTINGS_KAFKA_REST_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, UI_BROKER_SETTINGS_KAFKA_REST_ENABLED_DOC).define(UI_TOPIC_KAFKA_REST_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, UI_TOPIC_KAFKA_REST_ENABLED_DOC).define(UI_ACL_KAFKA_REST_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, UI_ACL_KAFKA_REST_ENABLED_DOC).define(UI_CONSUMER_GROUP_KAFKA_REST_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, UI_CONSUMER_GROUP_KAFKA_REST_ENABLED_DOC).define(UI_BASEPATH, ConfigDef.Type.STRING, (Object)"/", (name, value) -> {
            if (!value.toString().startsWith("/") || !value.toString().endsWith("/")) {
                throw new ConfigException(name, value, "base path should start and end with '/'. For example '/contoso/'");
            }
        }, ConfigDef.Importance.LOW, UI_BASEPATH_DOC).define(UI_EXTERNAL_JS_FILES, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, UI_EXTERNAL_JS_FILES_DOC).define(UI_EXTERNAL_CSS_FILES, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, UI_EXTERNAL_CSS_FILES_DOC).define(CONTROL_CENTER_MDS_CLIENT_IDLE_TIMEOUT, ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, CONTROL_CENTER_MDS_CLIENT_IDLE_TIMEOUT_DOC).define(CONTROL_CENTER_MDS_CLIENT_MAX_REQUESTS_QUEUED_PER_DESTINATION, ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, CONTROL_CENTER_MDS_CLIENT_MAX_REQUESTS_QUEUED_PER_DESTINATION_DOC).define(CONTROL_CENTER_INSTALLER_IDENTIFIER, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_INSTALLER_IDENTIFIER_DOC).define(CONTROL_CENTER_REST_NOSNIFF_PROTECTION_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, CONTROL_CENTER_REST_NOSNIFF_PROTECTION_ENABLED_DOC).define(CONNECT_HEALTHCHECK_PATH, ConfigDef.Type.STRING, (Object)DEFAULT_CONNECT_HEALTHCHECK_PATH, ConfigDef.Importance.HIGH, CONNECT_HEALTHCHECK_DOC).define(CONFLUENT_CONTROLCENTER_SCHEMA_REGISTRY_SSL_ALIAS_NAME, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "").define(CONFLUENT_CONTROLCENTER_CONNECT_SSL_ALIAS_NAME, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "").define(CONFLUENT_CONTROLCENTER_REST_PROXY_SSL_ALIAS_NAME, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "").define(CONFLUENT_CONTROLCENTER_KSQL_SSL_ALIAS_NAME, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "").define(CONTROL_CENTER_ARMERIA_HEALTHCHECK_FORCE_HTTP1, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONTROL_CENTER_ARMERIA_HEALTHCHECK_FORCE_HTTP1_DOC).define(CONTROL_CENTER_ONE_MINUTE_ROLL_UP_RETENTION_MS, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_ONE_MINUTE_ROLL_UP_RETENTION_MS, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_ONE_MINUTE_ROLL_UP_RETENTION_MS_DOC).define(CONTROL_CENTER_THREE_HOUR_ROLL_UP_RETENTION_MS, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_THREE_HOUR_ROLL_UP_RETENTION_MS, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_THREE_HOUR_ROLL_UP_RETENTION_MS_DOC).define(DEFAULT_SCHEMA_REGISTRY_DISABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, DEFAULT_SCHEMA_REGISTRY_DISABLED_DOC).define(CONTROL_CENTER_SSO_MODE, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_SSO_MODE, ConfigDef.Importance.LOW, CONTROL_CENTER_SSO_MODE_DOC).define(CONTROL_CENTER_RESPECT_MRC_CONFIG, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_CONTROL_CENTER_RESPECT_MRC_CONFIG, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_RESPECT_MRC_CONFIG_DOC);
    }
}

