/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.github.zafarkhaja.semver.Version;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.C3Version;
import io.confluent.controlcenter.BootstrapClientConfigSupplier;
import io.confluent.controlcenter.BootstrapClientSupplier;
import io.confluent.controlcenter.BootstrapClusterIdSupplier;
import io.confluent.controlcenter.CachingBootstrapClientSupplier;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.FeatureFlags;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.connect.ConnectClusterMetadata;
import io.confluent.controlcenter.data.ConsumerOffsetsModule;
import io.confluent.controlcenter.healthcheck.HealthCheckModule;
import io.confluent.controlcenter.ksql.KsqlClusterMetadata;
import io.confluent.controlcenter.rest.CompoundClusterTokenCredential;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.controlcenter.rest.RestModule;
import io.confluent.controlcenter.schemaregistry.CachingSchemaRegistryClientSupplier;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientManager;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientSupplier;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClusterMetadata;
import io.confluent.controlcenter.ssl.SslHolder;
import io.confluent.rest.RestConfig;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlCenterConfigModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(ControlCenterConfigModule.class);
    private static final String TELEMETRY_REPORTER_CLASS = "io.confluent.telemetry.reporter.TelemetryReporter";
    private static final String CONTROL_CENTER_RESOURCE_TYPE = "controlcenter";
    private static final String RESOURCE_SESSION_ID = "resource.session.id";
    private static final String RESOURCE_BOOTSTRAP_CLUSTER_ID = "resource.bootstrap.cluster.id";
    private static final String KAFKA_NAME_PATTERN = ".bootstrap.servers";
    private static final String CONNECT_NAME_PATTERN = ".cluster";
    private static final String KSQL_NAME_PATTERN = ".url";
    private static final String SCHEMA_REGISTRY_NAME_PATTERN = ".url";
    private final ControlCenterConfig controlCenterConfig;
    private final boolean enableSubTopologies;
    private final ImmutableSet<String> subTopologyTopics;

    public ControlCenterConfigModule(ControlCenterConfig controlCenterConfig) {
        this(controlCenterConfig, false, null);
    }

    public ControlCenterConfigModule(ControlCenterConfig controlCenterConfig, boolean enableSubTopologies, ImmutableSet<String> subTopologyTopics) {
        this.controlCenterConfig = controlCenterConfig;
        this.enableSubTopologies = enableSubTopologies;
        this.subTopologyTopics = subTopologyTopics;
    }

    protected void configure() {
        this.bind(BootstrapClientSupplier.class).to(CachingBootstrapClientSupplier.class).in(Singleton.class);
        this.bind(Key.get(String.class, HealthCheckModule.SessionId.class)).toInstance((Object)UUID.randomUUID().toString());
    }

    @Provides
    protected ControlCenterConfig provideControlCenterConfig() {
        return this.controlCenterConfig;
    }

    @Provides
    @EnableSubTopologies
    protected boolean areSubTopologiesEnabled() {
        return this.enableSubTopologies;
    }

    @Provides
    @SubTopologyInputTopics
    protected ImmutableSet<String> provideSubTopologyTopics() {
        return this.subTopologyTopics;
    }

    @Provides
    @Inject
    @Singleton
    protected Version provideControlCenterVersion() throws IOException {
        return C3Version.getVersion();
    }

    @Provides
    @PhoneHomeEnabled
    @Inject
    protected boolean getPhoneHomeEnabled(ControlCenterConfig config) {
        return config.getBoolean("confluent.support.metrics.enable");
    }

    @Provides
    @ControlCenterMetricsBrokerCountStalenessThresholdMs
    @Inject
    protected long getControlCenterMetricsBrokerCountStalenessThresholdMs(ControlCenterConfig config) {
        return config.getLong("confluent.metrics.broker.count.staleness.threshold.ms");
    }

    @Provides
    @HealthCheckModule.PhoneHomeCustomerId
    @Inject
    protected String getPhoneHomeCustomerId(ControlCenterConfig config) {
        return config.getString("confluent.support.metrics.customer.id");
    }

    @Provides
    @HealthCheckModule.SegmentId
    @Inject
    protected String getPhoneHomeSegmentId(ControlCenterConfig config) {
        return config.getString("confluent.support.metrics.segment.id");
    }

    @Provides
    @HealthCheckModule.SegmentEndpoint
    @Inject
    protected String getPhoneHomeSegmentEndpoint(ControlCenterConfig config) {
        return config.getString("confluent.support.metrics.segment.endpoint");
    }

    @Provides
    @HealthCheckModule.ControlCenterInstance
    @Inject
    @Singleton
    protected String getControlCenterInstance(ControlCenterConfig config) {
        return Hashing.sha256().newHasher().putString((CharSequence)Joiner.on((char)'\u00ff').join((Object)config.getString("confluent.controlcenter.id"), (Object)config.getString("confluent.controlcenter.command.topic"), new Object[]{config.getString("confluent.metrics.topic"), config.getString("confluent.monitoring.interceptor.topic")}), Charsets.UTF_8).hash().toString();
    }

    @Provides
    @ControlCenterRestModule.DisplayHost
    @Inject
    protected String getDisplayHost(ControlCenterConfig config) {
        return config.getString("confluent.controlcenter.rest.advertised.url");
    }

    @Provides
    @ConsumerOffsetsModule.ConsumerMetadataTimeout
    @Inject
    protected int getConsumerMetadataTimeout(ControlCenterConfig config) {
        return config.getInt("confluent.controlcenter.consumer.metadata.timeout.ms");
    }

    @Provides
    @Inject
    @BearerTokenMaxLife
    Long getBearerTokenMaxLife(ControlCenterConfig config) {
        return config.getLong("confluent.controlcenter.auth.bearer.token.max.lifetime.ms");
    }

    @Provides
    @HealthCheckModule.BootstrapClusterId
    @Singleton
    @Inject
    protected String getResourceBootstrapClusterId(BootstrapClusterIdSupplier bootstrapClusterIdSupplier) {
        return bootstrapClusterIdSupplier.get();
    }

    @Provides
    @Inject
    @MaxTopicMessageSize
    Long maxTopicMessageSize(ControlCenterConfig config) {
        return config.getLong("confluent.controlcenter.topic.inspection.message.max.bytes");
    }

    @Provides
    @Inject
    protected RestConfig getRestConfig(ControlCenterConfig config, ControlCenterRbacConfig rbacConfig, @HealthCheckModule.BootstrapClusterId String bootstrapClusterId, @HealthCheckModule.ControlCenterInstance String controlCenterId, @HealthCheckModule.SessionId String sessionId) {
        HashMap props = Maps.newHashMap();
        props.putAll(config.valuesWithPrefix("confluent.controlcenter.rest."));
        props.putAll(config.originalsWithPrefix("confluent.controlcenter.rest."));
        this.addTelemetryConfig(config, controlCenterId, bootstrapClusterId, sessionId, props);
        if (rbacConfig.isRbacEnabled()) {
            props.put("authentication.roles", ImmutableList.of((Object)"**"));
        }
        if (!config.getString("confluent.controlcenter.ui.basepath").equals("/")) {
            props.put("websocket.path.prefix", config.getString("confluent.controlcenter.ui.basepath") + "ws");
        }
        return new RestConfig(RestConfig.baseConfigDef(), (Map)props);
    }

    private void addTelemetryConfig(ControlCenterConfig config, String controlCenterId, String bootstrapClusterId, String sessionId, Map<String, Object> props) {
        props.putAll(config.originalsWithPrefix("confluent.telemetry.", false));
        props.put("metrics.jmx.prefix", "confluent.controlcenter");
        props.put("metric.reporters", TELEMETRY_REPORTER_CLASS);
        props.put(KafkaConfig.LogDirProp(), config.getString("confluent.controlcenter.data.dir"));
        props.put("metrics.context.resource.type", CONTROL_CENTER_RESOURCE_TYPE);
        props.put("metrics.context.resource.version", C3Version.getVersionString());
        props.put("metrics.context.resource.cluster.id", controlCenterId);
        props.put("metrics.context.resource.session.id", sessionId);
        props.put("metrics.context.resource.bootstrap.cluster.id", bootstrapClusterId);
    }

    @Provides
    @Singleton
    @Inject
    BootstrapClientConfigSupplier adminClientConfig(ControlCenterConfig controlCenterConfig, ControlCenterRbacConfig rbacConfig) {
        final HashMap config = Maps.newHashMap();
        config.put("bootstrap.servers", controlCenterConfig.getList("bootstrap.servers"));
        rbacConfig.putAllIfAbsentRbacControlCenterConfigs(config);
        config.putAll(controlCenterConfig.valuesWithPrefix("confluent.controlcenter.streams."));
        config.putAll(controlCenterConfig.originalsWithPrefix("confluent.controlcenter.streams."));
        return new BootstrapClientConfigSupplier(){

            @Override
            public Map<String, Object> get() {
                return config;
            }
        };
    }

    @Provides
    @Inject
    @RestModule.BrokerConfigsEditEnabled
    boolean brokerConfigsEditEnabled(ControlCenterConfig config) {
        return config.getBoolean("confluent.controlcenter.broker.config.edit.enable");
    }

    @Provides
    @RestModule.FallbackTopicReplicationFactor
    short fallbackTopicReplicationFactor() {
        return 1;
    }

    @Provides
    @Inject
    @Singleton
    @ControlCenterRestModule.KafkaClusterConfigSupplier
    StaticClusterConfigSupplier provideKafkaClusterConfigSupplier(ControlCenterConfig config) {
        return new StaticClusterConfigSupplier(config, "confluent.controlcenter.kafka.", KAFKA_NAME_PATTERN);
    }

    @Provides
    @Inject
    @Singleton
    @ControlCenterRestModule.ConnectClusterConfigSupplier
    StaticClusterConfigSupplier provideConnectClusterConfigSupplier(ControlCenterConfig config) {
        return new StaticClusterConfigSupplier(config, "confluent.controlcenter.connect.", CONNECT_NAME_PATTERN);
    }

    @Provides
    @Inject
    @Singleton
    @ControlCenterRestModule.KsqlClusterConfigSupplier
    StaticClusterConfigSupplier provideKsqlClusterConfigSupplier(ControlCenterConfig config) {
        return new StaticClusterConfigSupplier(config, "confluent.controlcenter.ksql.", ".url", (ImmutableSet<String>)ImmutableSet.of((Object)"advertised.url"));
    }

    @Provides
    @Inject
    @Singleton
    protected KsqlClusterMetadata provideKsqlMetadata(@ControlCenterRestModule.KsqlClusterConfigSupplier StaticClusterConfigSupplier staticKsqlClusterConfigSupplier) {
        return new KsqlClusterMetadata(staticKsqlClusterConfigSupplier);
    }

    @Provides
    @Singleton
    @Inject
    @RestModule.SchemaRegistry
    List<String> getSchemaRegistryEndpoints(ControlCenterConfig config) {
        return config.getList("confluent.controlcenter.schema.registry.url");
    }

    @Provides
    @Inject
    @Singleton
    @ControlCenterRestModule.SchemaRegistryClusterConfigSupplier
    StaticClusterConfigSupplier provideSchemaRegistryClusterConfigSupplier(ControlCenterConfig config) {
        return new StaticClusterConfigSupplier(config, "confluent.controlcenter.schema.registry.", ".url");
    }

    @Provides
    @Singleton
    @Inject
    @RestModule.SchemaRegistry
    Map<String, Object> schemaRegistryClientConfig(ControlCenterConfig controlCenterConfig) {
        HashMap config = Maps.newHashMap();
        config.putAll(controlCenterConfig.valuesWithPrefix("confluent.controlcenter.schema.registry."));
        return config;
    }

    @Provides
    @Singleton
    @Inject
    SchemaRegistryClientManager getSchemaRegistryClientManager(SchemaRegistryClusterMetadata srClusterMetadata, ControlCenterRbacConfig rbacConfig) {
        return new SchemaRegistryClientManager(srClusterMetadata, rbacConfig);
    }

    @Provides
    @Singleton
    @Inject
    SchemaRegistryClientSupplier<CompoundClusterTokenCredential> getSchemaRegistryClientSupplier(SchemaRegistryClientManager schemaRegistryClientManager) {
        return new CachingSchemaRegistryClientSupplier<CompoundClusterTokenCredential>(schemaRegistryClientManager);
    }

    @Provides
    @ServiceHealthCheckInterval
    public Duration getHealthCheckInterval() {
        return Duration.ofSeconds(this.controlCenterConfig.getInt("confluent.controlcenter.service.healthcheck.interval.sec").intValue());
    }

    @Provides
    @Inject
    public FeatureFlags getFeaturFlags(ControlCenterRbacConfig rbacConfig, ControlCenterConfig config) {
        return new FeatureFlags(config.getBoolean("confluent.controlcenter.ksql.enable"), config.getBoolean("confluent.controlcenter.schema.registry.enable"), config.getBoolean("confluent.controlcenter.topic.inspection.enable"), config.getBoolean("confluent.controlcenter.broker.config.edit.enable"), config.getBoolean("confluent.controlcenter.license.manager.enable"), rbacConfig.isRbacEnabled(), config.getString("confluent.controlcenter.auth.sso.mode"), config.getBoolean("confluent.controlcenter.consumers.view.enable"), config.getBoolean("confluent.controlcenter.deprecated.views.enable"), config.getInt("confluent.controlcenter.ui.data.expired.threshold"), config.getBoolean("confluent.controlcenter.ui.autoupdate.enable"), config.getBoolean("confluent.controlcenter.usage.data.collection.enable"), config.getBoolean("confluent.controlcenter.proactive.support.ui.cta.enable"), config.getBoolean("confluent.controlcenter.ui.replicator.monitoring.enable"), config.getBoolean("confluent.controlcenter.sbk.ui.enable"), config.getBoolean("confluent.controlcenter.ui.controller.chart.enable"), config.getBoolean("confluent.controlcenter.hostedmonitoring.enable"), config.getBoolean("confluent.controlcenter.trigger.active-controller-count.enable"), config.getBoolean("confluent.metadata.cluster.registry.enable"), config.getBoolean("confluent.metadata.cluster.registry.merge.configuration.enable"), config.getBoolean("confluent.controlcenter.rest.csrf.prevention.enable"), config.getInt("confluent.controlcenter.rest.csrf.prevention.token.expiration.minutes"), config.getString("confluent.controlcenter.rest.csrf.prevention.token.endpoint"), config.getString("confluent.controlcenter.mode.enable"), config.getBoolean("confluent.controlcenter.embedded.kafkarest.enable"), config.getBoolean("confluent.controlcenter.ui.broker.kafkarest.enable"), config.getBoolean("confluent.controlcenter.ui.brokersettings.kafkarest.enable"), config.getBoolean("confluent.controlcenter.ui.topic.kafkarest.enable"), config.getBoolean("confluent.controlcenter.ui.acl.kafkarest.enable"), config.getBoolean("confluent.controlcenter.ui.consumer.group.kafkarest.enable"), config.getString("confluent.controlcenter.private.installer.id"), config.getBoolean("confluent.controlcenter.rest.nosniff.prevention.enable"));
    }

    private Map<String, List<String>> getClientAliasesToHosts(String prefix, ControlCenterConfig controlCenterConfig, List<Map<String, List<String>>> endpoints) {
        String preferredAlias = controlCenterConfig.getString(prefix + "alias.name");
        if (preferredAlias.isEmpty()) {
            return new HashMap<String, List<String>>();
        }
        List providedHosts = endpoints.stream().map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toList());
        return Collections.singletonMap(preferredAlias, providedHosts);
    }

    @Provides
    @ServerSslHolder
    @Inject
    @Singleton
    protected SslHolder getServerSslHolder(RestConfig restConfig) {
        return new SslHolder(restConfig.getBaseSslConfig(), new HashMap<String, List<String>>());
    }

    @Provides
    @SchemaRegistrySslHolder
    @Inject
    @Singleton
    protected SslHolder getSchemaRegistrySslHolder(ControlCenterConfig controlCenterConfig, SchemaRegistryClusterMetadata schemaRegistryClusterMetadata) {
        String prefix = "confluent.controlcenter.schema.registry.schema.registry.";
        return new SslHolder(prefix, controlCenterConfig, this.getClientAliasesToHosts(prefix, controlCenterConfig, Collections.singletonList(schemaRegistryClusterMetadata.getEndpoints())));
    }

    @Provides
    @ConnectSslHolder
    @Inject
    @Singleton
    protected SslHolder getConnectSslHolder(ControlCenterConfig controlCenterConfig, ConnectClusterMetadata connectClusterMetadata) {
        String prefix = "confluent.controlcenter.connect.connect.";
        return new SslHolder(prefix, controlCenterConfig, this.getClientAliasesToHosts(prefix, controlCenterConfig, Collections.singletonList(connectClusterMetadata.getEndpoints())));
    }

    @Provides
    @KsqlSslHolder
    @Inject
    @Singleton
    protected SslHolder getKsqlSslHolder(ControlCenterConfig controlCenterConfig, KsqlClusterMetadata ksqlClusterMetadata) {
        String prefix = "confluent.controlcenter.ksql.ksql.";
        return new SslHolder(prefix, controlCenterConfig, this.getClientAliasesToHosts(prefix, controlCenterConfig, Collections.singletonList(ksqlClusterMetadata.getEndpoints())));
    }

    @Provides
    @ProxySslHolder
    @Inject
    @Singleton
    protected SslHolder getProxySslHolder(ControlCenterConfig controlCenterConfig, SchemaRegistryClusterMetadata schemaRegistryClusterMetadata, ConnectClusterMetadata connectClusterMetadata, KsqlClusterMetadata ksqlClusterMetadata) {
        ArrayList<Map<String, List<String>>> endpoints = new ArrayList<Map<String, List<String>>>();
        endpoints.add(schemaRegistryClusterMetadata.getEndpoints());
        endpoints.add(connectClusterMetadata.getEndpoints());
        endpoints.add(ksqlClusterMetadata.getEndpoints());
        return new SslHolder("confluent.controlcenter.rest.proxy.", controlCenterConfig, this.getClientAliasesToHosts("confluent.controlcenter.rest.proxy.", controlCenterConfig, endpoints));
    }

    @Provides
    @Inject
    @Singleton
    public List<SslHolder> getAllProxySslHolders(@SchemaRegistrySslHolder SslHolder schemaRegistrySslHolder, @ConnectSslHolder SslHolder connectSslHolder, @KsqlSslHolder SslHolder ksqlSslHolder, @ProxySslHolder SslHolder proxySslHolder) {
        return ImmutableList.of((Object)schemaRegistrySslHolder, (Object)connectSslHolder, (Object)ksqlSslHolder, (Object)proxySslHolder);
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ProxySslHolder {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface KsqlSslHolder {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ConnectSslHolder {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SchemaRegistrySslHolder {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ServerSslHolder {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ServiceHealthCheckInterval {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MaxTopicMessageSize {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface BearerTokenMaxLife {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ControlCenterMetricsBrokerCountStalenessThresholdMs {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface PhoneHomeEnabled {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SubTopologyInputTopics {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface EnableSubTopologies {
    }
}

