/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.MetadataServiceConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@Singleton
public class ControlCenterRbacConfig
extends MetadataServiceConfig {
    @Inject
    public ControlCenterRbacConfig(ControlCenterConfig controlCenterConfig) {
        super(controlCenterConfig);
    }

    public static String createPlainLoginJaasConfig(String apiKey, String apiSecret) {
        return MetadataServiceConfig.createPlainLoginJaasConfig(apiKey, apiSecret);
    }

    public static ControlCenterRbacConfig rbacDisabledConfig() {
        return new ControlCenterRbacConfig(new ControlCenterConfig(new Properties()));
    }

    public Map<String, Object> getRbacUserConfigs() {
        return super.getSaslUserConfigs();
    }

    public Map<String, Object> getRbacTokenConfigs(String token) {
        return super.getSaslTokenConfigs(token);
    }

    public boolean isRbacEnabled() {
        return !super.getMetadataServiceUrls().isEmpty();
    }

    public void putAllIfAbsentRbacControlCenterConfigs(Map<String, Object> config) {
        super.putAllIfAbsentSaslControlCenterConfigs(config);
    }

    public void putAllIfAbsentRbacControlCenterConfigs(Properties props) {
        super.putAllIfAbsentSaslControlCenterConfigs(props);
    }

    public void putAllRbacTokenConfigs(Map<String, Object> config, String token) {
        super.putAllSaslTokenConfigs(config, token);
    }

    public Map<String, Object> injectRbacConfigs(Map<String, Object> configs) {
        return this.isRbacEnabled() ? this.injectRbacConfigsInternal(configs) : configs;
    }

    public Map<String, Object> injectRbacConfigs(Map<String, Object> configs, String token) {
        return this.isRbacEnabled() ? (token == null ? this.injectRbacConfigsInternal(configs) : this.injectRbacConfigsImpersonation(configs, token)) : configs;
    }

    private Map<String, Object> injectRbacConfigsInternal(Map<String, Object> configs) {
        HashMap<String, Object> updatedConfigs = new HashMap<String, Object>(configs);
        this.putAllIfAbsentRbacControlCenterConfigs(updatedConfigs);
        return updatedConfigs;
    }

    private Map<String, Object> injectRbacConfigsImpersonation(Map<String, Object> configs, String token) {
        HashMap<String, Object> updatedConfigs = new HashMap<String, Object>(configs);
        this.putAllRbacTokenConfigs(updatedConfigs, token);
        return updatedConfigs;
    }
}

