/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigException;

public abstract class MetadataServiceConfig {
    public static final String OAUTHBEARER_MECHANISM = "OAUTHBEARER";
    public static final String OAUTHBEARER_LOGIN_MODULE_CLASS = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule";
    public static final String PLAIN_LOGIN_MODULE_CLASS = "org.apache.kafka.common.security.plain.PlainLoginModule";
    public static final String JAAS_CONFIG_USERNAME_PASSWORD_FORMAT = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required username=\"%s\" password=\"%s\" metadataServerUrls=\"%s\";";
    public static final String USERNAME_PASSWORD_LOGIN_CALLBACK_HANDLER_CLASS = "io.confluent.kafka.clients.plugins.auth.token.TokenUserLoginCallbackHandler";
    public static final String JAAS_CONFIG_TOKEN_FORMAT = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required authenticationToken=\"%s\" metadataServerUrls=\"%s\";";
    public static final String TOKEN_LOGIN_CALLBACK_HANDLER_CLASS = "io.confluent.kafka.clients.plugins.auth.token.TokenBearerLoginCallbackHandler";
    public static final String JAAS_CONFIG_PLAIN_FORMAT = "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"%s\" password=\"%s\";";
    public static final Pattern JAAS_INPUT_PATTERN = Pattern.compile("(\"|\n|\r|\\$\\{)");
    private final List<String> metadataServiceUrls;
    private final String controlCenterUsername;
    private final String controlCenterPassword;
    protected final ControlCenterConfig controlCenterConfig;

    @Inject
    public MetadataServiceConfig(ControlCenterConfig controlCenterConfig) {
        this.controlCenterConfig = controlCenterConfig;
        List metadataServiceUrls = controlCenterConfig.getList("confluent.metadata.bootstrap.server.urls");
        String username = null;
        String password = null;
        if (!metadataServiceUrls.isEmpty()) {
            String usernamePassword = controlCenterConfig.getPassword("confluent.metadata.basic.auth.user.info").value();
            Matcher matcher = Pattern.compile("(.+):(.+)").matcher(usernamePassword);
            if (matcher.matches()) {
                username = matcher.group(1);
                password = matcher.group(2);
            } else {
                throw new ConfigException("You specified a metadata service but did not properly specify a username/password for using it. Please specify confluent.metadata.basic.auth.user.info in the format 'USERNAME:PASSWORD'.");
            }
        }
        this.metadataServiceUrls = metadataServiceUrls;
        this.controlCenterUsername = username;
        this.controlCenterPassword = password;
    }

    public static String createPlainLoginJaasConfig(String apiKey, String apiSecret) {
        return String.format(JAAS_CONFIG_PLAIN_FORMAT, JAAS_INPUT_PATTERN.matcher(apiKey).replaceAll(""), JAAS_INPUT_PATTERN.matcher(apiSecret).replaceAll(""));
    }

    public Map<String, Object> getSaslUserConfigs() {
        if (this.metadataServiceUrls.isEmpty()) {
            return ImmutableMap.of();
        }
        return ImmutableMap.of((Object)"sasl.mechanism", (Object)OAUTHBEARER_MECHANISM, (Object)"sasl.jaas.config", (Object)String.format(JAAS_CONFIG_USERNAME_PASSWORD_FORMAT, this.controlCenterUsername, this.controlCenterPassword, String.join((CharSequence)",", this.metadataServiceUrls)), (Object)"sasl.login.callback.handler.class", (Object)USERNAME_PASSWORD_LOGIN_CALLBACK_HANDLER_CLASS);
    }

    public Map<String, Object> getSaslTokenConfigs(String token) {
        if (this.metadataServiceUrls.isEmpty()) {
            return ImmutableMap.of();
        }
        return ImmutableMap.of((Object)"sasl.mechanism", (Object)OAUTHBEARER_MECHANISM, (Object)"sasl.jaas.config", (Object)String.format(JAAS_CONFIG_TOKEN_FORMAT, token, String.join((CharSequence)",", this.metadataServiceUrls)), (Object)"sasl.login.callback.handler.class", (Object)TOKEN_LOGIN_CALLBACK_HANDLER_CLASS);
    }

    public List<String> getMetadataServiceUrls() {
        return this.metadataServiceUrls;
    }

    public String getControlCenterUsername() {
        return this.controlCenterUsername;
    }

    public String getControlCenterPassword() {
        return this.controlCenterPassword;
    }

    public void putAllIfAbsentSaslControlCenterConfigs(Map<String, Object> config) {
        this.getSaslUserConfigs().forEach(config::putIfAbsent);
    }

    public void putAllIfAbsentSaslControlCenterConfigs(Properties props) {
        this.getSaslUserConfigs().forEach(props::putIfAbsent);
    }

    public void putAllSaslTokenConfigs(Map<String, Object> config, String token) {
        config.putAll(this.getSaslTokenConfigs(token));
    }

    public void putAllSaslTokenConfigs(Properties props, String token) {
        props.putAll(this.getSaslTokenConfigs(token));
    }
}

