/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.confluent.controlcenter.ControlCenterConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticClusterConfigSupplier {
    private static final Logger log = LoggerFactory.getLogger(StaticClusterConfigSupplier.class);
    private final String configPrefix;
    private final ControlCenterConfig config;
    private final String namePattern;
    private final ImmutableSet<String> exclusionList;

    public StaticClusterConfigSupplier(ControlCenterConfig config, String configPrefix, String namePattern) {
        this(config, configPrefix, namePattern, (ImmutableSet<String>)ImmutableSet.of());
    }

    public StaticClusterConfigSupplier(ControlCenterConfig config, String configPrefix, String namePattern, ImmutableSet<String> exclusionList) {
        this.config = config;
        this.configPrefix = configPrefix;
        this.namePattern = namePattern;
        this.exclusionList = exclusionList;
    }

    public Map<String, Map<String, Object>> getConfigurations() {
        LinkedHashMap clusters = Maps.newLinkedHashMap();
        LinkedHashMap clusterConfigs = Maps.newLinkedHashMap();
        clusterConfigs.putAll(this.config.originalsWithPrefix(this.configPrefix));
        clusterConfigs.putAll(this.config.valuesWithPrefix(this.configPrefix));
        for (String property : clusterConfigs.keySet()) {
            if (!property.endsWith(this.namePattern) || this.exclusionList.contains((Object)property)) continue;
            int nameLength = property.indexOf(".");
            String clusterName = property.substring(0, nameLength);
            clusters.putIfAbsent(clusterName, Maps.newHashMap());
        }
        for (String clusterName : clusters.keySet()) {
            log.debug("Reading static configuration for cluster {}", (Object)clusterName);
            String clusterPrefix = this.configPrefix + clusterName + ".";
            ((Map)clusters.get(clusterName)).putAll(this.config.originalsWithPrefix(clusterPrefix));
            ((Map)clusters.get(clusterName)).putAll(this.config.valuesWithPrefix(clusterPrefix));
        }
        return clusters;
    }
}

