/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.application;

import com.google.common.collect.ImmutableSet;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.application.ControlCenter;
import io.confluent.controlcenter.streams.KafkaStreamsManager;
import io.confluent.controlcenter.streams.verify.MonitoringHeartbeatSender;
import io.confluent.monitoring.common.TimeBucket;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllControlCenter
extends ControlCenter {
    private static final Logger log = LoggerFactory.getLogger(AllControlCenter.class);

    public AllControlCenter(ControlCenterConfig controlCenterConfig, String runTasksFor) {
        super(log, controlCenterConfig, runTasksFor);
    }

    @Override
    boolean getEnableSubTopologies() {
        return this.runTasksFor != null;
    }

    @Override
    ImmutableSet<String> getTopicsForTasks() {
        return this.runTasksFor != null ? ImmutableSet.copyOf((Object[])this.runTasksFor.trim().split(",")) : null;
    }

    @Override
    void shutdown() {
        this.shutdownTasksAndAwaitTermination(this.ses);
        this.monitoringHeartbeatSender.close();
        this.kafkaStreamsManager.close();
        this.commandStore.close();
    }

    @Override
    void setInstances() {
        super.setInstances();
        this.kafkaStreamsManager = (KafkaStreamsManager)this.injector.getInstance(KafkaStreamsManager.class);
        this.monitoringHeartbeatSender = (MonitoringHeartbeatSender)this.injector.getInstance(MonitoringHeartbeatSender.class);
    }

    @Override
    void startTopologies() throws Exception {
        super.startTopologies();
        log.info("action=starting topology=monitoring");
        this.kafkaStreamsManager.start(this.config.getLong("confluent.controlcenter.internal.streams.start.timeout"));
        log.info("action=started topology=monitoring");
    }

    @Override
    void startRunnable() {
        super.startRunnable();
        this.ses.scheduleWithFixedDelay(this.monitoringHeartbeatSender, 500L, TimeBucket.SIZE, TimeUnit.MILLISECONDS);
    }
}

