/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.application;

import com.github.zafarkhaja.semver.Version;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Injector;
import com.google.inject.Key;
import io.confluent.command.kafka.CommandStore;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.KafkaHelper;
import io.confluent.controlcenter.alert.AlertManager;
import io.confluent.controlcenter.command.CommandMigrator;
import io.confluent.controlcenter.data.ClusterMetadataInitializer;
import io.confluent.controlcenter.data.ConsumerOffsetsFetcher;
import io.confluent.controlcenter.healthcheck.HealthCheck;
import io.confluent.controlcenter.kafka.ClusterManagementModule;
import io.confluent.controlcenter.rest.ControlCenterApplication;
import io.confluent.controlcenter.rest.KafkaRestApplications;
import io.confluent.controlcenter.streams.KafkaStreamsManager;
import io.confluent.controlcenter.streams.verify.MonitoringHeartbeatSender;
import io.confluent.controlcenter.util.InjectorFactory;
import io.confluent.rest.Application;
import io.confluent.rest.ApplicationServer;
import io.confluent.rest.RestConfig;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;

public abstract class ControlCenter {
    @VisibleForTesting
    public static ApplicationServer<RestConfig> server;
    private final Logger log;
    final ControlCenterConfig config;
    final String runTasksFor;
    Injector injector;
    ScheduledExecutorService ses;
    private Version c3Version;
    private KafkaHelper.ControlCenterPreconditions ccp;
    CommandStore commandStore;
    private CommandMigrator commandMigrator;
    KafkaStreamsManager kafkaStreamsManager;
    private ClusterMetadataInitializer clusterMetadataInitializer;
    private HealthCheck healthCheck;
    private AlertManager alertManager;
    private ConsumerOffsetsFetcher consumerOffsetsFetcher;
    MonitoringHeartbeatSender monitoringHeartbeatSender;

    public ControlCenter(Logger log, ControlCenterConfig config, String runTasksFor) {
        this.log = log;
        this.config = config;
        this.runTasksFor = runTasksFor;
    }

    public final void run() {
        this.setInjector();
        this.setInstances();
        this.setScheduledExecutorService();
        this.addShutdownHook();
        try {
            this.checkPreConditions();
            this.startTopologies();
            this.startClusterMetadataInitializer();
            this.createClusterDownAlert();
            this.startRunnable();
            this.startApplicationServer();
        }
        catch (InterruptedException | TimeoutException e) {
            this.log.error("failed to start topology", (Throwable)e);
            this.commandStore.close();
        }
        catch (Exception e) {
            this.log.error("Unexpected error", (Throwable)e);
        }
        finally {
            this.shutdown();
        }
    }

    abstract boolean getEnableSubTopologies();

    abstract ImmutableSet<String> getTopicsForTasks();

    abstract void shutdown();

    void setInstances() {
        this.c3Version = (Version)this.injector.getInstance(Key.get(Version.class));
        this.ccp = (KafkaHelper.ControlCenterPreconditions)this.injector.getInstance(KafkaHelper.ControlCenterPreconditions.class);
        this.commandStore = (CommandStore)this.injector.getInstance(CommandStore.class);
        this.commandMigrator = (CommandMigrator)this.injector.getInstance(CommandMigrator.class);
        this.clusterMetadataInitializer = (ClusterMetadataInitializer)this.injector.getInstance(ClusterMetadataInitializer.class);
        this.healthCheck = (HealthCheck)this.injector.getInstance(HealthCheck.class);
        this.alertManager = (AlertManager)this.injector.getInstance(AlertManager.class);
        this.consumerOffsetsFetcher = (ConsumerOffsetsFetcher)this.injector.getInstance(ConsumerOffsetsFetcher.class);
    }

    void startTopologies() throws Exception {
        this.log.info("action=starting topology=command");
        this.commandStore.start(this.config.getLong("confluent.controlcenter.command.streams.start.timeout").longValue());
        this.log.info("action=started topology=command");
        if (!this.config.getBoolean("confluent.controlcenter.trigger.active-controller-count.enable").booleanValue()) {
            this.log.info("action=starting operation=command-migration ");
            this.commandMigrator.migrate();
            this.log.info("action=completed operation=command-migration");
        }
    }

    void startRunnable() {
        this.log.info("Starting Health Check");
        this.ses.scheduleAtFixedRate(this.healthCheck, 0L, 1L, TimeUnit.MINUTES);
        this.log.info("Starting Alert Manager");
        this.ses.scheduleAtFixedRate(this.alertManager, 0L, 1L, TimeUnit.MINUTES);
        this.log.info("Starting Consumer Offsets Fetch");
        this.ses.scheduleAtFixedRate(this.consumerOffsetsFetcher, 0L, 5L, TimeUnit.SECONDS);
    }

    private void setInjector() {
        this.injector = InjectorFactory.createInjectorForApplication(this.config, new ControlCenterConfigModule(this.config, this.getEnableSubTopologies(), this.getTopicsForTasks()));
    }

    private void setScheduledExecutorService() {
        this.ses = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("control-center-heartbeat-%d").build());
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("control-center-shutdown-hook"){

            @Override
            public void run() {
                ControlCenter.this.log.info("Shutting down due to shutdown hook signal");
                ControlCenter.this.shutdown();
            }
        });
    }

    private void checkPreConditions() throws Exception {
        this.log.info("Starting Control Center version={}", (Object)this.c3Version);
        if (!this.ccp.call().booleanValue()) {
            this.log.info("Shutting down due to unmet preconditions");
            Runtime.getRuntime().exit(1);
        }
    }

    private void startClusterMetadataInitializer() throws Exception {
        this.clusterMetadataInitializer.call();
    }

    private void createClusterDownAlert() {
        if (this.config.getBoolean("confluent.controlcenter.alert.cluster.down.autocreate").booleanValue()) {
            this.log.info("Auto creating trigger and action for cluster down alerts");
            this.alertManager.autoCreateClusterDownTriggerAndAction(this.clusterMetadataInitializer.getBootstrapClusterId());
        }
    }

    private void startApplicationServer() throws Exception {
        RestConfig restConfig = (RestConfig)this.injector.getInstance(RestConfig.class);
        ControlCenterApplication controlCenterApplication = (ControlCenterApplication)this.injector.getInstance(ControlCenterApplication.class);
        AtomicBoolean controlCenterStarted = (AtomicBoolean)this.injector.getInstance(Key.get(AtomicBoolean.class, ClusterManagementModule.ControlCenterStarted.class));
        server = new ApplicationServer(restConfig);
        if (this.config.getBoolean("confluent.controlcenter.embedded.kafkarest.enable").booleanValue()) {
            KafkaRestApplications kafkaRestApplications = (KafkaRestApplications)this.injector.getInstance(KafkaRestApplications.class);
            server.registerApplication((Application)kafkaRestApplications);
        }
        server.registerApplication((Application)controlCenterApplication);
        server.addLifeCycleListener((LifeCycle.Listener)new Listener(controlCenterStarted));
        server.start();
        server.join();
    }

    final void shutdownTasksAndAwaitTermination(ExecutorService es) {
        es.shutdown();
        try {
            if (!es.awaitTermination(10L, TimeUnit.SECONDS)) {
                es.shutdownNow();
                if (!es.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.log.warn("Failed to shutdown heartbeat sender");
                }
            }
        }
        catch (InterruptedException ie) {
            this.log.warn("Failed to cleanly shutdown heartbeat sender");
            es.shutdownNow();
        }
    }

    private static class Listener
    implements LifeCycle.Listener {
        AtomicBoolean controlCenterStarted;

        public Listener(AtomicBoolean controlCenterStarted) {
            this.controlCenterStarted = controlCenterStarted;
        }

        public void lifeCycleStarting(LifeCycle lifeCycle) {
        }

        public void lifeCycleStarted(LifeCycle lifeCycle) {
            this.controlCenterStarted.set(true);
        }

        public void lifeCycleFailure(LifeCycle lifeCycle, Throwable throwable) {
        }

        public void lifeCycleStopping(LifeCycle lifeCycle) {
        }

        public void lifeCycleStopped(LifeCycle lifeCycle) {
        }
    }
}

