/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ClusterRegistryConfig;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.client.MetadataServiceClient;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import io.confluent.controlcenter.servicehealthcheck.SingleServiceHealthCheck;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ClusterRegistryFeatures
extends MetadataServiceClient {
    private static final Logger log = LoggerFactory.getLogger(ClusterRegistryFeatures.class);
    private static final long DEFAULT_CACHE_EXPIRATION_MS = TimeUnit.MINUTES.toMillis(10L);
    private static final String CLUSTER_REGISTRY_CACHE_KEY = "cluster.registry";
    private static final String CLUSTER_REGISTRY_V2_FEATURE_KEY = "cluster.registry.nice.names.2.enabled";
    private final LoadingCache<String, Map<String, Boolean>> featureCache = CacheBuilder.newBuilder().expireAfterWrite(DEFAULT_CACHE_EXPIRATION_MS, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, Map<String, Boolean>>(){

        public Map<String, Boolean> load(String key) throws Exception {
            return ClusterRegistryFeatures.this.getMetadataServiceFeatures().getFeatures();
        }
    });

    @Inject
    public ClusterRegistryFeatures(ControlCenterConfig controlCenterConfig, ClusterRegistryConfig registryConfig, ObjectMapper objectMapper, @ServiceHealthCheckModule.MetadataServiceHealthCheck SingleServiceHealthCheck mdsHealthCheck) {
        super(controlCenterConfig, registryConfig, objectMapper, mdsHealthCheck);
    }

    public boolean unicodeInNameEnabled() {
        return this.getFeature(CLUSTER_REGISTRY_V2_FEATURE_KEY, false);
    }

    private boolean getFeature(String featureKey, boolean defaultValue) {
        try {
            return ((Map)this.featureCache.get((Object)CLUSTER_REGISTRY_CACHE_KEY)).getOrDefault(featureKey, defaultValue);
        }
        catch (ExecutionException e) {
            log.warn("Cannot check if {} is enabled", (Object)featureKey);
            if (log.isDebugEnabled()) {
                log.error("Exception", (Throwable)e);
            }
            return defaultValue;
        }
    }
}

