/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.util.JwtUtils;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.MetadataServiceConfig;
import io.confluent.controlcenter.client.ConfigurableClient;
import io.confluent.controlcenter.httpclient.BasicHttpCredential;
import io.confluent.controlcenter.httpclient.BearerTokenHttpCredential;
import io.confluent.controlcenter.httpclient.Client;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import io.confluent.controlcenter.servicehealthcheck.SingleServiceHealthCheck;
import io.confluent.rbacapi.entities.AuthorizeRequest;
import io.confluent.rbacapi.entities.FeaturesInfo;
import io.confluent.rbacapi.entities.VisibilityRequest;
import io.confluent.rbacapi.entities.VisibilityResponse;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataServiceClient
implements ConfigurableClient {
    private static final Logger log = LoggerFactory.getLogger(MetadataServiceClient.class);
    protected static final String ALLOWED = "ALLOWED";
    public static final String RBAC_VISIBILITY_FEATURE_KEY = "rbac.visibility.api.1.enabled";
    private static final long MDS_TIMEOUT_SEC = 15L;
    private static int MDS_RETRIES_EACH = 2;
    private static String MDS_ERROR_MESSAGE = "failed to connect to any MDS server";
    private final ControlCenterConfig controlCenterConfig;
    private final MetadataServiceConfig serviceConfig;
    private final ObjectMapper objectMapper;
    private SslContextFactory sslContextFactory;
    private SingleServiceHealthCheck mdsHealthCheck;
    private Client client;

    public MetadataServiceClient(ControlCenterConfig controlCenterConfig, MetadataServiceConfig serviceConfig, ObjectMapper objectMapper, @ServiceHealthCheckModule.MetadataServiceHealthCheck SingleServiceHealthCheck mdsHealthCheck) {
        this.controlCenterConfig = controlCenterConfig;
        this.serviceConfig = serviceConfig;
        this.objectMapper = objectMapper;
        this.mdsHealthCheck = mdsHealthCheck;
        this.sslContextFactory = null;
        this.client = null;
    }

    private synchronized void initClient() {
        if (this.client != null) {
            return;
        }
        this.client = new Client(this.sslContextFactory, this.objectMapper, 15L, this.controlCenterConfig);
    }

    protected Client getClient() {
        if (this.client == null) {
            this.initClient();
        }
        return this.client;
    }

    @Override
    public void setSslContextFactory(@NotNull SslContextFactory sslContextFactory) {
        if (this.client != null) {
            throw new IllegalStateException("trying to set SslContextFactory but Client is already built!");
        }
        Preconditions.checkNotNull((Object)sslContextFactory);
        this.sslContextFactory = sslContextFactory;
        this.initClient();
    }

    public String getMetadataServiceKafkaId() {
        return this.makeRequestWithRetries(baseUrl -> this.getClient().makeRequestNoBody(baseUrl + "/security/1.0/metadataClusterId", HttpMethod.GET, new BasicHttpCredential(this.serviceConfig.getControlCenterUsername(), this.serviceConfig.getControlCenterPassword()), new TypeReference<String>(){}));
    }

    public <T> Set<T> authorize(String subject, JwtPrincipal jwtPrincipal, Map<T, List<Action>> scopedOperations) {
        ArrayList keys = new ArrayList();
        ArrayList actions = new ArrayList();
        scopedOperations.forEach((k, v) -> {
            keys.add(k);
            Preconditions.checkArgument((v.size() > 0 ? 1 : 0) != 0);
            actions.addAll(v);
        });
        List response = this.makeRequestWithRetries(baseUrl -> this.getClient().makeRequestWithContent(baseUrl + "/security/1.0/authorize", HttpMethod.PUT, new BearerTokenHttpCredential(jwtPrincipal.getJwt()), MimeTypes.Type.APPLICATION_JSON, new AuthorizeRequest("User:" + subject, JwtUtils.getGroupsFromJwtPrincipal((JwtPrincipal)jwtPrincipal), "", actions), new TypeReference<List<String>>(){}));
        if (response.size() != actions.size()) {
            log.error("expected list size {}, actual, {}", (Object)actions.size(), (Object)response.size());
            throw new InternalServerErrorException();
        }
        HashMap<Object, List> keyResponseMap = new HashMap<Object, List>();
        int respCounter = 0;
        for (Object key2 : keys) {
            ArrayList<Boolean> respList2 = new ArrayList<Boolean>();
            for (int nestedResp = 0; nestedResp < scopedOperations.get(key2).size(); ++nestedResp) {
                respList2.add(((String)response.get(respCounter++)).equals(ALLOWED));
            }
            keyResponseMap.put(key2, respList2);
        }
        HashSet allowed = new HashSet();
        keyResponseMap.forEach((key, respList) -> {
            if (respList.stream().allMatch(aBoolean -> aBoolean)) {
                allowed.add(key);
            }
        });
        return allowed;
    }

    public <T> Set<T> visibility(String subject, String token, Map<T, Scope> scopeMap) {
        Preconditions.checkArgument((boolean)this.isRbacVisibilityFeatureEnabled());
        ArrayList keys = new ArrayList();
        ArrayList visibilityRequests = new ArrayList();
        scopeMap.forEach((k, v) -> {
            Preconditions.checkNotNull(v.clusters().get("kafka-cluster"));
            keys.add(k);
            visibilityRequests.add(new VisibilityRequest((String)v.clusters().get("kafka-cluster"), MetadataServiceClient.singletonListOrNull(nul -> (String)v.clusters().get("connect-cluster")), MetadataServiceClient.singletonListOrNull(nul -> (String)v.clusters().get("schema-registry-cluster")), MetadataServiceClient.singletonListOrNull(nul -> (String)v.clusters().get("ksql-cluster"))));
        });
        List response = this.makeRequestWithRetries(baseUrl -> this.getClient().makeRequestWithContent(baseUrl + "/security/1.0/lookup/principals/User:" + URIUtil.encodePath((String)subject) + "/visibility", HttpMethod.POST, new BearerTokenHttpCredential(token), MimeTypes.Type.APPLICATION_JSON, visibilityRequests, new TypeReference<List<VisibilityResponse>>(){}));
        if (response.size() != visibilityRequests.size()) {
            log.error("expected list size {}, actual, {}", (Object)visibilityRequests.size(), (Object)response.size());
            throw new InternalServerErrorException();
        }
        HashSet allowed = new HashSet();
        int i = 0;
        for (Object key : keys) {
            VisibilityResponse r = (VisibilityResponse)response.get(i++);
            if (!r.kafkaCluster.visible || !MetadataServiceClient.isNullEmptyOrAllVisible(r.connectClusters) || !MetadataServiceClient.isNullEmptyOrAllVisible(r.schemaRegistryClusters) || !MetadataServiceClient.isNullEmptyOrAllVisible(r.ksqlClusters)) continue;
            allowed.add(key);
        }
        return allowed;
    }

    protected <T> T makeRequestWithRetries(Function<String, T> makeRequest) {
        return Client.makeRequestWithRetries(makeRequest, this.mdsHealthCheck.getHealthyUrls(), MDS_RETRIES_EACH, MDS_ERROR_MESSAGE);
    }

    private static <T> List<T> singletonListOrNull(Function<Void, T> getValue) {
        T val = getValue.apply(null);
        return val == null ? null : Collections.singletonList(val);
    }

    private static boolean isNullEmptyOrAllVisible(List<VisibilityResponse.ClusterVisibility> clusters) {
        if (clusters == null || clusters.isEmpty()) {
            return true;
        }
        for (VisibilityResponse.ClusterVisibility c : clusters) {
            if (c.visible) continue;
            return false;
        }
        return true;
    }

    public boolean isRbacVisibilityFeatureEnabled() {
        try {
            return this.getMetadataServiceFeatures().getFeatures().getOrDefault(RBAC_VISIBILITY_FEATURE_KEY, false);
        }
        catch (WebApplicationException e) {
            log.error("Cannot check if RBAC Visibility Feature enabled: failed to fetch MDS features. please check if MDS cluster is up and running properly");
            if (log.isDebugEnabled()) {
                log.error("Exception", (Throwable)e);
            }
            return true;
        }
    }

    public FeaturesInfo getMetadataServiceFeatures() {
        return this.makeRequestWithRetries(baseUrl -> this.getClient().makeRequestNoBody(baseUrl + "/security/1.0/features", HttpMethod.GET, null, new TypeReference<FeaturesInfo>(){}));
    }
}

