/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.command;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.protobuf.ProtocolStringList;
import io.confluent.command.cluster_metadata.CommandClusterMetadata;
import io.confluent.command.kafka.CommandStore;
import io.confluent.command.record.Command;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.command.CommandModule;
import io.confluent.controlcenter.util.LruSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandMigrator {
    private static final Logger log = LoggerFactory.getLogger(CommandMigrator.class);
    private static final int COMMAND_TIMEOUT_SEC = 15;
    private final Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> clusterMetadataStore;
    private final CommandStore commandStore;
    private final LruSet<CommandClusterMetadata.KafkaClusterMetadata> clusters;

    @Inject
    public CommandMigrator(@CommandModule.ClusterMetadataStore Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> clusterMetadataStore, CommandStore commandStore, LruSet<CommandClusterMetadata.KafkaClusterMetadata> clusters) {
        this.clusterMetadataStore = clusterMetadataStore;
        this.commandStore = commandStore;
        this.clusters = clusters;
    }

    public void migrate() {
        this.disableActionsForActiveControllerCountTrigger();
    }

    public void purgeStaleEntries(Set<String> activeClusterIds) {
        ArrayList<KeyValue> entriesForDeletion = new ArrayList<KeyValue>();
        try (KeyValueIterator iter = ((ReadOnlyKeyValueStore)this.clusterMetadataStore.get()).all();){
            while (iter.hasNext()) {
                String clusterId;
                KeyValue entry = (KeyValue)iter.next();
                CommandClusterMetadata.ClusterMetadata clusterMetadata = ((Command.CommandMessage)entry.value).getClusterMetadata();
                if (!clusterMetadata.hasKafka() || activeClusterIds.contains(clusterId = ((Command.CommandKey)entry.key).getGuid())) continue;
                entriesForDeletion.add(entry);
            }
        }
        for (KeyValue entry : entriesForDeletion) {
            log.info("Purging stale cluster entry from CommandStore {}", (Object)((Command.CommandKey)entry.key).getGuid());
            try {
                this.commandStore.update((Command.CommandKey)entry.key, null);
                this.clusters.remove(((Command.CommandMessage)entry.value).getClusterMetadata().getKafka());
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.warn("failed to delete cluster entry from commandStore", (Throwable)e);
            }
        }
    }

    void disableActionsForActiveControllerCountTrigger() {
        List<String> activeControllerTriggers = this.getActiveControllerCountTriggers();
        ArrayList<Future> commandFutures = new ArrayList<Future>();
        if (!activeControllerTriggers.isEmpty()) {
            try (KeyValueIterator iterator = this.commandStore.getStore().all();){
                while (iterator.hasNext()) {
                    KeyValue keyValue = (KeyValue)iterator.next();
                    Command.CommandMessage replacementMessage = CommandMigrator.getReplacementMessage(activeControllerTriggers, (Command.CommandMessage)keyValue.value);
                    if (replacementMessage == null) continue;
                    commandFutures.add(this.commandStore.updateAsync((Command.CommandKey)keyValue.key, replacementMessage));
                }
            }
            for (Future future : commandFutures) {
                try {
                    future.get(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    log.warn("failed to disable all the actions", (Throwable)e);
                }
            }
        }
    }

    List<String> getActiveControllerCountTriggers() {
        ArrayList<String> activeControllerTriggers = new ArrayList<String>();
        try (KeyValueIterator iterator = this.commandStore.getStore().all();){
            while (iterator.hasNext()) {
                KeyValue keyValue = (KeyValue)iterator.next();
                Command.CommandKey commandKey = (Command.CommandKey)keyValue.key;
                Command.CommandMessage commandMessage = (Command.CommandMessage)keyValue.value;
                if (commandKey.getConfigType() != Command.CommandConfigType.MONITORING_TRIGGER_CONFIG || !commandMessage.hasMonitoringTriggerConfig() || commandMessage.getMonitoringTriggerConfig().getBrokerMetric() != CommandAlert.BrokerTriggerMetricType.ACTIVE_CONTROLLER_COUNT) continue;
                activeControllerTriggers.add(commandKey.getGuid());
            }
        }
        return activeControllerTriggers;
    }

    @VisibleForTesting
    static Command.CommandMessage getReplacementMessage(List<String> activeControllerTriggers, Command.CommandMessage message) {
        if (!message.getActionConfig().getEnabled()) {
            return null;
        }
        ProtocolStringList actionTriggerGuidList = message.getActionConfig().getTriggerGuidList();
        for (String triggerGuid : activeControllerTriggers) {
            if (!actionTriggerGuidList.contains((Object)triggerGuid)) continue;
            log.warn("disabling action={} with trigger={}", (Object)message.getActionConfig().getGuid(), (Object)triggerGuid);
            CommandAlert.ActionConfig.Builder acBuild = CommandAlert.ActionConfig.newBuilder((CommandAlert.ActionConfig)message.getActionConfig()).setEnabled(false);
            return Command.CommandMessage.newBuilder((Command.CommandMessage)message).setActionConfig(acBuild).build();
        }
        return null;
    }
}

